/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.codeInsight.actions.FileTreeIterator;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfigUtilKt;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierLanguageService;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.prettierjs.formatting.PrettierFormattingApplier;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReformatWithPrettierAction
extends AnAction
implements DumbAware {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ReformatWithPrettierAction.class);
    private static final long EDT_TIMEOUT_MS = 2000L;
    private final PrettierUtil.ErrorHandler myErrorHandler;

    public ReformatWithPrettierAction(@NotNull PrettierUtil.ErrorHandler errorHandler) {
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(0);
        }
        this.myErrorHandler = errorHandler;
    }

    public ReformatWithPrettierAction() {
        this(PrettierUtil.ErrorHandler.DEFAULT);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        NodePackage nodePackage = PrettierConfiguration.getInstance(project).getPackage((PsiElement)psiFile);
        e.getPresentation().setEnabledAndVisible(!nodePackage.isEmptyPath() && ReformatWithPrettierAction.isAcceptableFileContext(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static boolean isAcceptableFileContext(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(3);
        }
        if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
            return true;
        }
        Object[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        return !ArrayUtil.isEmpty((Object[])virtualFiles);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            ReformatWithPrettierAction.processFileInEditor(project, editor, this.myErrorHandler, null);
        } else {
            Object[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (!ArrayUtil.isEmpty((Object[])virtualFiles)) {
                ReformatWithPrettierAction.processVirtualFiles(project, Arrays.asList(virtualFiles), this.myErrorHandler);
            }
        }
    }

    public static boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PrettierUtil.ErrorHandler errorHandler) {
        PsiFile file;
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(6);
        }
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(7);
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == null) {
            return false;
        }
        return PrettierUtil.checkNodeAndPackage(file, editor, errorHandler);
    }

    public static void processFileInEditor(@NotNull Project project, @NotNull Editor editor, @NotNull PrettierUtil.ErrorHandler errorHandler, @Nullable TextRange targetRange) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(9);
        }
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(10);
        }
        if (!ReformatWithPrettierAction.isAvailable(project, editor, errorHandler)) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return;
        }
        if (!PrettierUtil.checkNodeAndPackage(file, editor, errorHandler)) {
            return;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(vFile)).hasReadonlyFiles()) {
            return;
        }
        TextRange range = targetRange != null ? targetRange : (editor.getSelectionModel().hasSelection() ? new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd()) : null);
        PrettierConfigUtilKt.ensureConfigsSaved(Collections.singletonList(vFile), project);
        ThrowableComputable computable = () -> ReformatWithPrettierAction.performRequestForFile(file, range, null);
        PrettierLanguageService.FormatResult result = (PrettierLanguageService.FormatResult)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, PrettierBundle.message("progress.title", new Object[0]), true, project);
        if (result == null) {
            return;
        }
        if (!StringUtil.isEmpty((String)result.error)) {
            errorHandler.showErrorWithDetails(project, editor, PrettierBundle.message("error.while.reformatting.message", new Object[0]), result.error);
        } else if (result.unsupported) {
            errorHandler.showError(project, editor, PrettierBundle.message("not.supported.file", file.getName()), null);
        } else if (result.ignored) {
            PrettierUtil.showHintLater(editor, PrettierBundle.message("file.was.ignored.hint", file.getName()), false, null);
        } else if (result.result != null) {
            Document document = editor.getDocument();
            CharSequence textBefore = document.getImmutableCharSequence();
            String newContent = result.result;
            Ref lineSeparatorUpdated = new Ref((Object)Boolean.FALSE);
            PrettierFormattingApplier strategy = PrettierFormattingApplier.Companion.from(document, file, newContent);
            EditorScrollingPositionKeeper.perform((Editor)editor, (boolean)true, () -> ReformatWithPrettierAction.runWriteCommandAction(project, () -> {
                boolean isLineSeparatorChanged = strategy.apply(project, file);
                lineSeparatorUpdated.set((Object)isLineSeparatorChanged);
            }));
            PrettierUtil.showHintLater(editor, ReformatWithPrettierAction.buildNotificationMessage(document, textBefore, (Boolean)lineSeparatorUpdated.get()), false, null);
        }
    }

    static TextRange processFileAsPostFormatProcessor(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(11);
        }
        if (range == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(12);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isWriteAccessAllowed());
        Project project = file.getProject();
        if (!PrettierUtil.checkNodeAndPackage(file, null, PrettierUtil.NOOP_ERROR_HANDLER)) {
            return range;
        }
        VirtualFile vFile = file.getVirtualFile();
        PrettierConfigUtilKt.ensureConfigsSaved(Collections.singletonList(vFile), project);
        PrettierLanguageService.FormatResult result = ReformatWithPrettierAction.performRequestForFile(file, range, null);
        if (result != null) {
            int delta = ReformatWithPrettierAction.applyFormatResult(project, file, result);
            if (delta < 0 && range.getLength() < Math.abs(delta)) {
                return TextRange.from((int)range.getStartOffset(), (int)0);
            }
            return range.grown(delta);
        }
        return range;
    }

    public static void processVirtualFiles(@NotNull Project project, @NotNull List<VirtualFile> virtualFiles, @NotNull PrettierUtil.ErrorHandler errorHandler) {
        ReadonlyStatusHandler.OperationStatus readonlyStatus;
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(13);
        }
        if (virtualFiles == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(14);
        }
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(15);
        }
        if ((readonlyStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(virtualFiles)).hasReadonlyFiles()) {
            return;
        }
        PrettierConfigUtilKt.ensureConfigsSaved(virtualFiles, project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (virtualFiles.size() == 1 && virtualFiles.get(0).isDirectory()) {
            PsiDirectory psiDirectory = psiManager.findDirectory(virtualFiles.get(0));
            if (psiDirectory == null) {
                return;
            }
            ReformatWithPrettierAction.processFileIterator(project, new FileTreeIterator(psiDirectory), false, errorHandler);
        } else {
            ReformatWithPrettierAction.processFileIterator(project, new FileTreeIterator(PsiUtilCore.toPsiFiles((PsiManager)psiManager, virtualFiles)), true, errorHandler);
        }
    }

    private static void processFileIterator(@NotNull Project project, @NotNull FileTreeIterator fileIterator, boolean reportSkippedFiles, @NotNull PrettierUtil.ErrorHandler errorHandler) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(16);
        }
        if (fileIterator == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(17);
        }
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(18);
        }
        Map results = (Map)ReformatWithPrettierAction.executeUnderProgress(project, indicator -> {
            HashMap<PsiFile, PrettierLanguageService.FormatResult> reformattedResults = new HashMap<PsiFile, PrettierLanguageService.FormatResult>();
            SmartList files = new SmartList();
            ReadAction.run(() -> ReformatWithPrettierAction.lambda$processFileIterator$3(fileIterator, (List)files));
            for (PsiFile currentFile : files) {
                PrettierLanguageService.FormatResult errorResult;
                indicator.setText(PrettierBundle.message("processing.0.progress", currentFile.getName()));
                if (!PrettierUtil.checkNodeAndPackage(currentFile, null, errorHandler)) {
                    return Collections.emptyMap();
                }
                PrettierLanguageService.FormatResult result = ReformatWithPrettierAction.performRequestForFile(currentFile, null, null);
                if (result == null) continue;
                if (result.unsupported && reportSkippedFiles) {
                    errorResult = PrettierLanguageService.FormatResult.error(PrettierBundle.message("not.supported.file", currentFile.getName()));
                    reformattedResults.put(currentFile, errorResult);
                }
                if (result.ignored) {
                    errorResult = PrettierLanguageService.FormatResult.error(PrettierBundle.message("file.was.ignored", currentFile.getName()));
                    reformattedResults.put(currentFile, errorResult);
                    continue;
                }
                reformattedResults.put(currentFile, result);
            }
            return reformattedResults;
        });
        ReformatWithPrettierAction.runWriteCommandAction(project, () -> {
            for (Map.Entry entry : results.entrySet()) {
                VirtualFile virtualFile = ((PsiFile)entry.getKey()).getVirtualFile();
                if (virtualFile == null) continue;
                ReformatWithPrettierAction.applyFormatResult(project, (PsiFile)entry.getKey(), (PrettierLanguageService.FormatResult)entry.getValue());
            }
        });
        List errors = ContainerUtil.mapNotNull(results.entrySet(), t -> ((PrettierLanguageService.FormatResult)t.getValue()).error);
        if (!errors.isEmpty()) {
            errorHandler.showErrorWithDetails(project, null, PrettierBundle.message("failed.to.reformat.0.files", errors.size()), StringUtil.join((Collection)errors, (String)"\n"));
        }
    }

    @Nullable
    static PrettierLanguageService.FormatResult processFileAsFormattingTask(@NotNull PsiFile psiFile, @NotNull String text, @NotNull TextRange range) {
        if (psiFile == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(19);
        }
        if (text == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(20);
        }
        if (range == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(21);
        }
        ProgressManager.checkCanceled();
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        Project project = psiFile.getProject();
        ApplicationManager.getApplication().invokeAndWait(() -> PrettierConfigUtilKt.ensureConfigsSaved(Collections.singletonList(vFile), project));
        return ReformatWithPrettierAction.performRequestForFile(psiFile, range, text);
    }

    static int applyFormatResult(@NotNull Project project, @NotNull PsiFile file, @NotNull PrettierLanguageService.FormatResult result) {
        Document document;
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(22);
        }
        if (file == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(23);
        }
        if (result == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(24);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile())) != null && StringUtil.isEmpty((String)result.error) && !result.ignored && !result.unsupported && result.result != null) {
            PrettierFormattingApplier strategy = PrettierFormattingApplier.Companion.from(document, file, result.result);
            int diff = result.result.length() - document.getTextLength();
            strategy.apply(project, file);
            return diff;
        }
        return 0;
    }

    @Nullable
    static PrettierLanguageService.FormatResult performRequestForFile(@NotNull PsiFile currentFile, @Nullable TextRange range, @Nullable String forcedInitialText) {
        boolean edt;
        if (currentFile == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(25);
        }
        if (!(edt = ApplicationManager.getApplication().isDispatchThread()) && ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("JSLanguageServiceUtil.awaitFuture() under read action may cause deadlock");
        }
        Project project = currentFile.getProject();
        Ref text = Ref.create();
        Ref filePath = Ref.create();
        Ref ignoreFilePath = Ref.create();
        Ref rangeForRequest = Ref.create((Object)range);
        ReadAction.run(() -> {
            CharSequence content;
            if (!currentFile.isValid()) {
                return;
            }
            VirtualFile currentVFile = currentFile.getVirtualFile();
            filePath.set((Object)LocalFilePath.asLocalFilePath((Path)currentVFile.toNioPath()));
            if (forcedInitialText != null) {
                content = forcedInitialText;
            } else {
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(currentFile);
                if (document == null) {
                    return;
                }
                content = document.getImmutableCharSequence();
            }
            if (range != null && range.getStartOffset() == 0 && range.getLength() == content.length()) {
                rangeForRequest.set(null);
            }
            int[] offsetsToKeep = null;
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor != null && !editor.isDisposed() && Objects.equals(editor.getVirtualFile(), currentVFile)) {
                offsetsToKeep = new int[]{editor.getCaretModel().getOffset()};
            }
            CharSequence convertedText = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal((Project)project, (CharSequence)content, (VirtualFile)currentVFile, offsetsToKeep);
            text.set((Object)convertedText.toString());
            VirtualFile ignoreVFile = PrettierUtil.findIgnoreFile(project, currentVFile);
            if (ignoreVFile != null) {
                ignoreFilePath.set((Object)ignoreVFile.getPath());
            }
        });
        if (text.isNull()) {
            return PrettierLanguageService.FormatResult.UNSUPPORTED;
        }
        NodePackage nodePackage = PrettierConfiguration.getInstance(project).getPackage((PsiElement)currentFile);
        PrettierLanguageService service = PrettierLanguageService.getInstance(project, currentFile.getVirtualFile(), nodePackage);
        CompletableFuture<PrettierLanguageService.FormatResult> formatFuture = service.format((String)filePath.get(), (String)ignoreFilePath.get(), (String)text.get(), nodePackage, (TextRange)rangeForRequest.get());
        long timeout = edt ? 2000L : JSLanguageServiceUtil.getTimeout();
        return (PrettierLanguageService.FormatResult)JSLanguageServiceUtil.awaitFuture(formatFuture, (long)timeout, (boolean)true, null, (boolean)edt);
    }

    private static <T> T executeUnderProgress(@NotNull Project project, @NotNull NullableFunction<ProgressIndicator, T> handler) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(26);
        }
        if (handler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(27);
        }
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> handler.fun((Object)ProgressManager.getInstance().getProgressIndicator()), PrettierBundle.message("progress.title", new Object[0]), true, project);
    }

    private static void runWriteCommandAction(@NotNull Project project, @NotNull Runnable runnable) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(28);
        }
        if (runnable == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(29);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)PrettierBundle.message("reformat.with.prettier.command.name", new Object[0]), null, (Runnable)runnable, (PsiFile[])new PsiFile[0]);
    }

    @NotNull
    @Nls
    private static String buildNotificationMessage(@NotNull Document document, @NotNull CharSequence textBefore, boolean lineSeparatorsUpdated) {
        int number;
        if (document == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(30);
        }
        if (textBefore == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(31);
        }
        if ((number = VcsFacade.getInstance().calculateChangedLinesNumber(document, textBefore)) == 0) {
            String string = lineSeparatorsUpdated ? PrettierBundle.message("line.endings.were.updated", new Object[0]) : PrettierBundle.message("no.lines.changed", new Object[0]);
            if (string == null) {
                ReformatWithPrettierAction.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = PrettierBundle.message("formatted.0.lines", number);
        if (string == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static /* synthetic */ void lambda$processFileIterator$3(FileTreeIterator fileIterator, List files) throws RuntimeException {
        while (fileIterator.hasNext()) {
            files.add(fileIterator.next());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/ReformatWithPrettierAction";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 22: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIterator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textBefore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/ReformatWithPrettierAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNotificationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 32: 
            case 33: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableFileContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processFileInEditor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processFileAsPostFormatProcessor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFiles";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processFileIterator";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processFileAsFormattingTask";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyFormatResult";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "performRequestForFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "executeUnderProgress";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "runWriteCommandAction";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "buildNotificationMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 32, 33 -> new IllegalStateException(string);
        };
    }
}

