/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public final class CssEnterHandler
extends EnterAfterUnmatchedBraceHandler {
    public boolean isApplicable(@NotNull PsiFile file, int caretOffset) {
        if (file == null) {
            CssEnterHandler.$$$reportNull$$$0(0);
        }
        return file instanceof StylesheetFile || CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file);
    }

    protected Pair<PsiElement, Integer> calculateOffsetToInsertClosingBrace(@NotNull PsiFile file, @NotNull CharSequence text, int offset) {
        PsiDocumentManager psiDocumentManager;
        Document document;
        if (file == null) {
            CssEnterHandler.$$$reportNull$$$0(1);
        }
        if (text == null) {
            CssEnterHandler.$$$reportNull$$$0(2);
        }
        if ((document = (psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject())).getDocument(file)) != null) {
            psiDocumentManager.commitDocument(document);
        }
        PsiElement element = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        ASTNode node = element.getNode();
        int endLineOffset = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)offset, (String)"\n");
        if (node != null && node.getElementType() == TokenType.WHITE_SPACE) {
            return Pair.create(null, (Object)endLineOffset);
        }
        CssBlock cssBlock = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class);
        if (cssBlock != null) {
            boolean isNestedBlock = PsiTreeUtil.getParentOfType((PsiElement)cssBlock, CssBlock.class) != null;
            int blockEndOffset = cssBlock.getTextRange().getEndOffset();
            return Pair.create(null, (Object)(isNestedBlock ? Math.min(endLineOffset, blockEndOffset) : blockEndOffset));
        }
        return super.calculateOffsetToInsertClosingBrace(file, text, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateOffsetToInsertClosingBrace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

