/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.css.util.CssConstants;
import com.intellij.lang.ASTNode;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.util.CssSuffixes;
import com.intellij.psi.css.util.CssTermTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xml.util.ColorMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssTermImpl
extends CssElementImpl
implements CssTerm,
PsiExternalReferenceHost {
    private static final Logger LOG = Logger.getInstance(CssTermImpl.class);
    @NonNls
    private static final Set<String> LENGTH_SUFFIXES = CssTermImpl.toLowerCase(CssSuffixes.LENGTH_SUFFIXES);
    @NonNls
    private static final Set<String> RESOLUTION_SUFFIXES = CssTermImpl.toLowerCase(CssSuffixes.RESOLUTION_SUFFIXES);
    @NonNls
    private static final Set<String> FREQUENCY_SUFFIXES = CssTermImpl.toLowerCase(CssSuffixes.FREQUENCY_SUFFIXES);
    @NonNls
    private static final Set<String> TIME_SUFFIXES = CssTermImpl.toLowerCase(CssSuffixes.TIME_SUFFIXES);
    @NonNls
    private static final Set<String> ANGLE_SUFFIXES = CssTermImpl.toLowerCase(CssSuffixes.ANGLE_SUFFIXES);
    private volatile CssTermType myTermType;

    public CssTermImpl() {
        super(CssElementTypes.CSS_TERM);
    }

    private static Set<String> toLowerCase(String ... strings) {
        HashSet<String> result = new HashSet<String>(strings.length);
        for (String str : strings) {
            result.add(StringUtil.toLowerCase((String)str));
        }
        return result;
    }

    @Override
    @NotNull
    public CssTermType getTermType() {
        CssTermType type = this.myTermType;
        if (type == null) {
            this.myTermType = type = this._calcTermType();
        }
        if (type == null) {
            LOG.info(String.format("Unknown CSS Term: %s", this.getText()));
            this.myTermType = type = CssTermTypes.IDENT;
        }
        CssTermType cssTermType = type;
        if (cssTermType == null) {
            CssTermImpl.$$$reportNull$$$0(0);
        }
        return cssTermType;
    }

    public void clearCaches() {
        this.myTermType = null;
        super.clearCaches();
    }

    private CssTermType _calcTermType() {
        ASTNode astNode;
        CssTerm term = (CssTerm)CompletionUtilCoreImpl.getOriginalElement((PsiElement)this);
        term = term == null ? this : term;
        PsiElement parent = term.getParent();
        PsiElement child = term.getFirstChild();
        if (child != null && child.getNode().getElementType() == CssElementTypes.CSS_PLUS) {
            child = child.getNextSibling();
        }
        if (child != null && (astNode = child.getNode()) != null) {
            boolean afterMinus;
            IElementType type = astNode.getElementType();
            ASTNode firstTreeChild = astNode.getFirstChildNode();
            ASTNode lastTreeChild = astNode.getLastChildNode();
            PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)child);
            boolean bl = afterMinus = parent instanceof CssTerm && prevLeaf != null && prevLeaf.getNode().getElementType() == CssElementTypes.CSS_MINUS;
            if (!afterMinus && CssElementTypes.CSS_NUMBER_TERM == type) {
                if (CssElementTypes.CSS_NUMBER == firstTreeChild.getElementType()) {
                    if (firstTreeChild == lastTreeChild) {
                        return CssTermTypes.NUMBER;
                    }
                    if (CssElementTypes.CSS_IDENT == lastTreeChild.getElementType()) {
                        CssTermType suffixType = CssTermImpl.getTypeBySuffix(lastTreeChild.getText());
                        return suffixType == CssTermType.UNKNOWN ? CssTermTypes.NUMBER_WITH_UNKNOWN_UNIT : suffixType;
                    }
                    if (CssElementTypes.CSS_PERCENT == lastTreeChild.getElementType()) {
                        return CssTermTypes.PERCENTAGE;
                    }
                }
            } else if (afterMinus || CssElementTypes.CSS_MINUS == type) {
                ASTNode lastNumberTermNode;
                ASTNode node;
                CssTermImpl numberTerm;
                CssTermImpl cssTermImpl = numberTerm = afterMinus ? this : child.getNextSibling();
                if (numberTerm instanceof CssTerm) {
                    numberTerm = numberTerm.getFirstChild();
                }
                if (numberTerm != null && (node = numberTerm.getNode()) != null && CssElementTypes.CSS_NUMBER_TERM == node.getElementType() && (lastNumberTermNode = node.getLastChildNode()) != null) {
                    if (CssElementTypes.CSS_IDENT == lastNumberTermNode.getElementType()) {
                        String lengthSuffixText = StringUtil.toLowerCase((String)lastNumberTermNode.getText());
                        if (LENGTH_SUFFIXES.contains(lengthSuffixText)) {
                            return CssTermTypes.NEGATIVE_LENGTH;
                        }
                        if (ANGLE_SUFFIXES.contains(lengthSuffixText)) {
                            return CssTermTypes.NEGATIVE_ANGLE;
                        }
                        String suffixText = StringUtil.toLowerCase((String)lastNumberTermNode.getText());
                        CssTermType suffixType = CssTermImpl.getTypeBySuffix(suffixText);
                        return suffixType == CssTermType.UNKNOWN ? CssTermTypes.NUMBER_WITH_UNKNOWN_UNIT : suffixType;
                    }
                    if (CssElementTypes.CSS_PERCENT == lastNumberTermNode.getElementType()) {
                        return CssTermTypes.NEGATIVE_PERCENTAGE;
                    }
                    if (CssElementTypes.CSS_NUMBER == lastNumberTermNode.getElementType()) {
                        return CssTermTypes.NEGATIVE_NUMBER;
                    }
                }
            } else {
                String colorName;
                if (CssElementTypes.CSS_HASH == type) {
                    return this.matchHashColor() ? CssTermTypes.COLOR : CssTermTypes.IDENT;
                }
                if (CssElementTypes.CSS_UNICODE_RANGE == type) {
                    return CssTermTypes.UNICODE_RANGE;
                }
                if (child instanceof CssFunction) {
                    if (CssElementTypes.CSS_FUNCTION_TOKEN == firstTreeChild.getElementType()) {
                        @NonNls String text = firstTreeChild.getText();
                        if (CssConstants.COLOR_FUNCTIONS.contains(StringUtil.toLowerCase((String)text))) {
                            return CssTermTypes.COLOR;
                        }
                        if ("rect".equalsIgnoreCase(text)) {
                            return CssTermTypes.RECT;
                        }
                        if ("counter".equalsIgnoreCase(text)) {
                            return CssTermTypes.COUNTER;
                        }
                        if ("var".equalsIgnoreCase(text)) {
                            return CssTermTypes.VAR;
                        }
                    }
                    return ((CssFunction)child).getType();
                }
                if (parent != null && parent.getNode().getElementType() == CssElementTypes.CSS_URI && type == CssElementTypes.CSS_STRING) {
                    return CssTermTypes.URI;
                }
                if (CssElementTypes.CSS_STRING == type) {
                    return CssTermTypes.STRING;
                }
                if (CssElementTypes.CSS_URI == type) {
                    return CssTermTypes.URI;
                }
                if (CssElementTypes.CSS_IDENT == type && (ColorMap.getHexCodeForColorName((String)(colorName = StringUtil.toLowerCase((String)this.getText()))) != null || ColorMap.isSystemColorName((String)colorName))) {
                    return CssTermTypes.COLOR;
                }
            }
        }
        return CssTermTypes.IDENT;
    }

    @Deprecated
    @NotNull
    public static CssTermType getTypeBySuffix(@NotNull String suffixText) {
        if (suffixText == null) {
            CssTermImpl.$$$reportNull$$$0(1);
        }
        CssTermType cssTermType = CssTermTypeUtil.getTypeBySuffix(suffixText);
        if (cssTermType == null) {
            CssTermImpl.$$$reportNull$$$0(2);
        }
        return cssTermType;
    }

    private boolean matchHashColor() {
        String s = StringUtil.toLowerCase((String)this.getText());
        return s.matches("#([0-9a-f]{3}|[0-9a-f]{4}|[0-9a-f]{6}|[0-9a-f]{8})$");
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssTermImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssTerm(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssTermImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTermType";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssTermImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeBySuffix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeBySuffix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

