/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.utils;

import com.intellij.clouds.docker.gateway.DockerGatewayBundle;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.rd.util.lifetime.Lifetime;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0005J\b\u0010\u000b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/clouds/docker/gateway/utils/ClientTracker;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "clientCount", "", "registerClient", "", "handle", "Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "getClientCount", "dispose", "Companion", "AppCloseListener", "AppStateListener", "intellij.clouds.docker.gateway"})
public final class ClientTracker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int clientCount;
    @NotNull
    private static final Lazy<ClientTracker> instance$delegate = LazyKt.lazy(ClientTracker::instance_delegate$lambda$1);

    public ClientTracker() {
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new AppCloseListener(), (Disposable)this);
    }

    public final void registerClient(@NotNull ThinClientHandle handle2) {
        Intrinsics.checkNotNullParameter((Object)handle2, (String)"handle");
        int n = this.clientCount;
        this.clientCount = n + 1;
        handle2.getClientClosed().advise(Lifetime.Companion.getEternal(), arg_0 -> ClientTracker.registerClient$lambda$0(this, arg_0));
    }

    public final int getClientCount() {
        return this.clientCount;
    }

    public void dispose() {
    }

    private static final Unit registerClient$lambda$0(ClientTracker this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int n = this$0.clientCount;
        this$0.clientCount = n + -1;
        return Unit.INSTANCE;
    }

    private static final ClientTracker instance_delegate$lambda$1() {
        return new ClientTracker();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/clouds/docker/gateway/utils/ClientTracker$AppCloseListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "<init>", "()V", "canExitApplication", "", "confirmExit", "ensureIdeFrameExists", "", "intellij.clouds.docker.gateway"})
    public static final class AppCloseListener
    implements ApplicationListener {
        public boolean canExitApplication() {
            Application app = ApplicationManager.getApplication();
            if (Companion.getInstance().clientCount > 0 && !app.isUnitTestMode() && !app.isHeadlessEnvironment()) {
                return this.confirmExit();
            }
            return true;
        }

        private final boolean confirmExit() {
            int result2 = Messages.showYesNoDialog((String)DockerGatewayBundle.message("devcontainer.confirm.exit.dialog.message", new Object[0]), (String)DockerGatewayBundle.message("devcontainer.confirm.exit.dialog.title", new Object[0]), (Icon)Messages.getWarningIcon());
            if (result2 == 1) {
                this.ensureIdeFrameExists();
            }
            return result2 == 0;
        }

        private final void ensureIdeFrameExists() {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            if (((Object[])projectArray).length == 0 && WelcomeFrame.Companion.getInstance() == null) {
                WelcomeFrame.Companion.showNow();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/clouds/docker/gateway/utils/ClientTracker$AppStateListener;", "Lcom/intellij/ide/AppLifecycleListener;", "<init>", "()V", "appWillBeClosed", "", "isRestart", "", "intellij.clouds.docker.gateway"})
    public static final class AppStateListener
    implements AppLifecycleListener {
        public void appWillBeClosed(boolean isRestart) {
            Disposer.dispose((Disposable)Companion.getInstance());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/clouds/docker/gateway/utils/ClientTracker$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/clouds/docker/gateway/utils/ClientTracker;", "getInstance", "()Lcom/intellij/clouds/docker/gateway/utils/ClientTracker;", "instance$delegate", "Lkotlin/Lazy;", "intellij.clouds.docker.gateway"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientTracker getInstance() {
            Lazy lazy = instance$delegate;
            return (ClientTracker)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

