/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.psi;

import com.intellij.jsonpath.psi.JsonPathElementGenerator;
import com.intellij.jsonpath.psi.JsonPathStringLiteral;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JsonPathStringManipulator
extends AbstractElementManipulator<JsonPathStringLiteral> {
    JsonPathStringManipulator() {
    }

    @Nullable
    public JsonPathStringLiteral handleContentChange(@NotNull JsonPathStringLiteral element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            JsonPathStringManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JsonPathStringManipulator.$$$reportNull$$$0(1);
        }
        String originalContent = element.getText();
        TextRange withoutQuotes = this.getRangeInElement(element);
        JsonPathElementGenerator generator = new JsonPathElementGenerator(element.getProject());
        String replacement = StringUtil.unescapeStringCharacters((String)originalContent.substring(withoutQuotes.getStartOffset(), range.getStartOffset())) + newContent + StringUtil.unescapeStringCharacters((String)originalContent.substring(range.getEndOffset(), withoutQuotes.getEndOffset()));
        return (JsonPathStringLiteral)element.replace(generator.createStringLiteral(replacement));
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull JsonPathStringLiteral element) {
        String content;
        if (element == null) {
            JsonPathStringManipulator.$$$reportNull$$$0(2);
        }
        int startOffset = (content = element.getText()).startsWith("'") || content.startsWith("\"") ? 1 : 0;
        int endOffset = content.length() > 1 && (content.endsWith("'") || content.endsWith("\"")) ? -1 : 0;
        return new TextRange(startOffset, content.length() + endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jsonpath/psi/JsonPathStringManipulator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRangeInElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

