/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

//
//Copyright 2020 The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// To regenerate api.pb.go run `hack/update-codegen.sh protobindings`

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v4.23.4
// source: staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto

package v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Protocol int32

const (
	Protocol_TCP  Protocol = 0
	Protocol_UDP  Protocol = 1
	Protocol_SCTP Protocol = 2
)

// Enum value maps for Protocol.
var (
	Protocol_name = map[int32]string{
		0: "TCP",
		1: "UDP",
		2: "SCTP",
	}
	Protocol_value = map[string]int32{
		"TCP":  0,
		"UDP":  1,
		"SCTP": 2,
	}
)

func (x Protocol) Enum() *Protocol {
	p := new(Protocol)
	*p = x
	return p
}

func (x Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[0].Descriptor()
}

func (Protocol) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[0]
}

func (x Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Protocol.Descriptor instead.
func (Protocol) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{0}
}

type MountPropagation int32

const (
	// No mount propagation ("rprivate" in Linux terminology).
	MountPropagation_PROPAGATION_PRIVATE MountPropagation = 0
	// Mounts get propagated from the host to the container ("rslave" in Linux).
	MountPropagation_PROPAGATION_HOST_TO_CONTAINER MountPropagation = 1
	// Mounts get propagated from the host to the container and from the
	// container to the host ("rshared" in Linux).
	MountPropagation_PROPAGATION_BIDIRECTIONAL MountPropagation = 2
)

// Enum value maps for MountPropagation.
var (
	MountPropagation_name = map[int32]string{
		0: "PROPAGATION_PRIVATE",
		1: "PROPAGATION_HOST_TO_CONTAINER",
		2: "PROPAGATION_BIDIRECTIONAL",
	}
	MountPropagation_value = map[string]int32{
		"PROPAGATION_PRIVATE":           0,
		"PROPAGATION_HOST_TO_CONTAINER": 1,
		"PROPAGATION_BIDIRECTIONAL":     2,
	}
)

func (x MountPropagation) Enum() *MountPropagation {
	p := new(MountPropagation)
	*p = x
	return p
}

func (x MountPropagation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MountPropagation) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[1].Descriptor()
}

func (MountPropagation) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[1]
}

func (x MountPropagation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MountPropagation.Descriptor instead.
func (MountPropagation) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{1}
}

// A NamespaceMode describes the intended namespace configuration for each
// of the namespaces (Network, PID, IPC) in NamespaceOption. Runtimes should
// map these modes as appropriate for the technology underlying the runtime.
type NamespaceMode int32

const (
	// A POD namespace is common to all containers in a pod.
	// For example, a container with a PID namespace of POD expects to view
	// all of the processes in all of the containers in the pod.
	NamespaceMode_POD NamespaceMode = 0
	// A CONTAINER namespace is restricted to a single container.
	// For example, a container with a PID namespace of CONTAINER expects to
	// view only the processes in that container.
	NamespaceMode_CONTAINER NamespaceMode = 1
	// A NODE namespace is the namespace of the Kubernetes node.
	// For example, a container with a PID namespace of NODE expects to view
	// all of the processes on the host running the kubelet.
	NamespaceMode_NODE NamespaceMode = 2
	// TARGET targets the namespace of another container. When this is specified,
	// a target_id must be specified in NamespaceOption and refer to a container
	// previously created with NamespaceMode CONTAINER. This containers namespace
	// will be made to match that of container target_id.
	// For example, a container with a PID namespace of TARGET expects to view
	// all of the processes that container target_id can view.
	NamespaceMode_TARGET NamespaceMode = 3
)

// Enum value maps for NamespaceMode.
var (
	NamespaceMode_name = map[int32]string{
		0: "POD",
		1: "CONTAINER",
		2: "NODE",
		3: "TARGET",
	}
	NamespaceMode_value = map[string]int32{
		"POD":       0,
		"CONTAINER": 1,
		"NODE":      2,
		"TARGET":    3,
	}
)

func (x NamespaceMode) Enum() *NamespaceMode {
	p := new(NamespaceMode)
	*p = x
	return p
}

func (x NamespaceMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NamespaceMode) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[2].Descriptor()
}

func (NamespaceMode) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[2]
}

func (x NamespaceMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NamespaceMode.Descriptor instead.
func (NamespaceMode) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{2}
}

// SupplementalGroupsPolicy defines how supplemental groups
// of the first container processes are calculated.
type SupplementalGroupsPolicy int32

const (
	// Merge means that the container's provided SupplementalGroups
	// and FsGroup (specified in SecurityContext) will be merged with
	// the primary user's groups as defined in the container image
	// (in /etc/group).
	SupplementalGroupsPolicy_Merge SupplementalGroupsPolicy = 0
	// Strict means that the container's provided SupplementalGroups
	// and FsGroup (specified in SecurityContext) will be used instead of
	// any groups defined in the container image.
	SupplementalGroupsPolicy_Strict SupplementalGroupsPolicy = 1
)

// Enum value maps for SupplementalGroupsPolicy.
var (
	SupplementalGroupsPolicy_name = map[int32]string{
		0: "Merge",
		1: "Strict",
	}
	SupplementalGroupsPolicy_value = map[string]int32{
		"Merge":  0,
		"Strict": 1,
	}
)

func (x SupplementalGroupsPolicy) Enum() *SupplementalGroupsPolicy {
	p := new(SupplementalGroupsPolicy)
	*p = x
	return p
}

func (x SupplementalGroupsPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SupplementalGroupsPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[3].Descriptor()
}

func (SupplementalGroupsPolicy) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[3]
}

func (x SupplementalGroupsPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SupplementalGroupsPolicy.Descriptor instead.
func (SupplementalGroupsPolicy) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{3}
}

type PodSandboxState int32

const (
	PodSandboxState_SANDBOX_READY    PodSandboxState = 0
	PodSandboxState_SANDBOX_NOTREADY PodSandboxState = 1
)

// Enum value maps for PodSandboxState.
var (
	PodSandboxState_name = map[int32]string{
		0: "SANDBOX_READY",
		1: "SANDBOX_NOTREADY",
	}
	PodSandboxState_value = map[string]int32{
		"SANDBOX_READY":    0,
		"SANDBOX_NOTREADY": 1,
	}
)

func (x PodSandboxState) Enum() *PodSandboxState {
	p := new(PodSandboxState)
	*p = x
	return p
}

func (x PodSandboxState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PodSandboxState) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[4].Descriptor()
}

func (PodSandboxState) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[4]
}

func (x PodSandboxState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PodSandboxState.Descriptor instead.
func (PodSandboxState) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{4}
}

type Signal int32

const (
	Signal_RUNTIME_DEFAULT Signal = 0
	Signal_SIGABRT         Signal = 1
	Signal_SIGALRM         Signal = 2
	Signal_SIGBUS          Signal = 3
	Signal_SIGCHLD         Signal = 4
	Signal_SIGCLD          Signal = 5
	Signal_SIGCONT         Signal = 6
	Signal_SIGFPE          Signal = 7
	Signal_SIGHUP          Signal = 8
	Signal_SIGILL          Signal = 9
	Signal_SIGINT          Signal = 10
	Signal_SIGIO           Signal = 11
	Signal_SIGIOT          Signal = 12
	Signal_SIGKILL         Signal = 13
	Signal_SIGPIPE         Signal = 14
	Signal_SIGPOLL         Signal = 15
	Signal_SIGPROF         Signal = 16
	Signal_SIGPWR          Signal = 17
	Signal_SIGQUIT         Signal = 18
	Signal_SIGSEGV         Signal = 19
	Signal_SIGSTKFLT       Signal = 20
	Signal_SIGSTOP         Signal = 21
	Signal_SIGSYS          Signal = 22
	Signal_SIGTERM         Signal = 23
	Signal_SIGTRAP         Signal = 24
	Signal_SIGTSTP         Signal = 25
	Signal_SIGTTIN         Signal = 26
	Signal_SIGTTOU         Signal = 27
	Signal_SIGURG          Signal = 28
	Signal_SIGUSR1         Signal = 29
	Signal_SIGUSR2         Signal = 30
	Signal_SIGVTALRM       Signal = 31
	Signal_SIGWINCH        Signal = 32
	Signal_SIGXCPU         Signal = 33
	Signal_SIGXFSZ         Signal = 34
	Signal_SIGRTMIN        Signal = 35
	Signal_SIGRTMINPLUS1   Signal = 36
	Signal_SIGRTMINPLUS2   Signal = 37
	Signal_SIGRTMINPLUS3   Signal = 38
	Signal_SIGRTMINPLUS4   Signal = 39
	Signal_SIGRTMINPLUS5   Signal = 40
	Signal_SIGRTMINPLUS6   Signal = 41
	Signal_SIGRTMINPLUS7   Signal = 42
	Signal_SIGRTMINPLUS8   Signal = 43
	Signal_SIGRTMINPLUS9   Signal = 44
	Signal_SIGRTMINPLUS10  Signal = 45
	Signal_SIGRTMINPLUS11  Signal = 46
	Signal_SIGRTMINPLUS12  Signal = 47
	Signal_SIGRTMINPLUS13  Signal = 48
	Signal_SIGRTMINPLUS14  Signal = 49
	Signal_SIGRTMINPLUS15  Signal = 50
	Signal_SIGRTMAXMINUS14 Signal = 51
	Signal_SIGRTMAXMINUS13 Signal = 52
	Signal_SIGRTMAXMINUS12 Signal = 53
	Signal_SIGRTMAXMINUS11 Signal = 54
	Signal_SIGRTMAXMINUS10 Signal = 55
	Signal_SIGRTMAXMINUS9  Signal = 56
	Signal_SIGRTMAXMINUS8  Signal = 57
	Signal_SIGRTMAXMINUS7  Signal = 58
	Signal_SIGRTMAXMINUS6  Signal = 59
	Signal_SIGRTMAXMINUS5  Signal = 60
	Signal_SIGRTMAXMINUS4  Signal = 61
	Signal_SIGRTMAXMINUS3  Signal = 62
	Signal_SIGRTMAXMINUS2  Signal = 63
	Signal_SIGRTMAXMINUS1  Signal = 64
	Signal_SIGRTMAX        Signal = 65
)

// Enum value maps for Signal.
var (
	Signal_name = map[int32]string{
		0:  "RUNTIME_DEFAULT",
		1:  "SIGABRT",
		2:  "SIGALRM",
		3:  "SIGBUS",
		4:  "SIGCHLD",
		5:  "SIGCLD",
		6:  "SIGCONT",
		7:  "SIGFPE",
		8:  "SIGHUP",
		9:  "SIGILL",
		10: "SIGINT",
		11: "SIGIO",
		12: "SIGIOT",
		13: "SIGKILL",
		14: "SIGPIPE",
		15: "SIGPOLL",
		16: "SIGPROF",
		17: "SIGPWR",
		18: "SIGQUIT",
		19: "SIGSEGV",
		20: "SIGSTKFLT",
		21: "SIGSTOP",
		22: "SIGSYS",
		23: "SIGTERM",
		24: "SIGTRAP",
		25: "SIGTSTP",
		26: "SIGTTIN",
		27: "SIGTTOU",
		28: "SIGURG",
		29: "SIGUSR1",
		30: "SIGUSR2",
		31: "SIGVTALRM",
		32: "SIGWINCH",
		33: "SIGXCPU",
		34: "SIGXFSZ",
		35: "SIGRTMIN",
		36: "SIGRTMINPLUS1",
		37: "SIGRTMINPLUS2",
		38: "SIGRTMINPLUS3",
		39: "SIGRTMINPLUS4",
		40: "SIGRTMINPLUS5",
		41: "SIGRTMINPLUS6",
		42: "SIGRTMINPLUS7",
		43: "SIGRTMINPLUS8",
		44: "SIGRTMINPLUS9",
		45: "SIGRTMINPLUS10",
		46: "SIGRTMINPLUS11",
		47: "SIGRTMINPLUS12",
		48: "SIGRTMINPLUS13",
		49: "SIGRTMINPLUS14",
		50: "SIGRTMINPLUS15",
		51: "SIGRTMAXMINUS14",
		52: "SIGRTMAXMINUS13",
		53: "SIGRTMAXMINUS12",
		54: "SIGRTMAXMINUS11",
		55: "SIGRTMAXMINUS10",
		56: "SIGRTMAXMINUS9",
		57: "SIGRTMAXMINUS8",
		58: "SIGRTMAXMINUS7",
		59: "SIGRTMAXMINUS6",
		60: "SIGRTMAXMINUS5",
		61: "SIGRTMAXMINUS4",
		62: "SIGRTMAXMINUS3",
		63: "SIGRTMAXMINUS2",
		64: "SIGRTMAXMINUS1",
		65: "SIGRTMAX",
	}
	Signal_value = map[string]int32{
		"RUNTIME_DEFAULT": 0,
		"SIGABRT":         1,
		"SIGALRM":         2,
		"SIGBUS":          3,
		"SIGCHLD":         4,
		"SIGCLD":          5,
		"SIGCONT":         6,
		"SIGFPE":          7,
		"SIGHUP":          8,
		"SIGILL":          9,
		"SIGINT":          10,
		"SIGIO":           11,
		"SIGIOT":          12,
		"SIGKILL":         13,
		"SIGPIPE":         14,
		"SIGPOLL":         15,
		"SIGPROF":         16,
		"SIGPWR":          17,
		"SIGQUIT":         18,
		"SIGSEGV":         19,
		"SIGSTKFLT":       20,
		"SIGSTOP":         21,
		"SIGSYS":          22,
		"SIGTERM":         23,
		"SIGTRAP":         24,
		"SIGTSTP":         25,
		"SIGTTIN":         26,
		"SIGTTOU":         27,
		"SIGURG":          28,
		"SIGUSR1":         29,
		"SIGUSR2":         30,
		"SIGVTALRM":       31,
		"SIGWINCH":        32,
		"SIGXCPU":         33,
		"SIGXFSZ":         34,
		"SIGRTMIN":        35,
		"SIGRTMINPLUS1":   36,
		"SIGRTMINPLUS2":   37,
		"SIGRTMINPLUS3":   38,
		"SIGRTMINPLUS4":   39,
		"SIGRTMINPLUS5":   40,
		"SIGRTMINPLUS6":   41,
		"SIGRTMINPLUS7":   42,
		"SIGRTMINPLUS8":   43,
		"SIGRTMINPLUS9":   44,
		"SIGRTMINPLUS10":  45,
		"SIGRTMINPLUS11":  46,
		"SIGRTMINPLUS12":  47,
		"SIGRTMINPLUS13":  48,
		"SIGRTMINPLUS14":  49,
		"SIGRTMINPLUS15":  50,
		"SIGRTMAXMINUS14": 51,
		"SIGRTMAXMINUS13": 52,
		"SIGRTMAXMINUS12": 53,
		"SIGRTMAXMINUS11": 54,
		"SIGRTMAXMINUS10": 55,
		"SIGRTMAXMINUS9":  56,
		"SIGRTMAXMINUS8":  57,
		"SIGRTMAXMINUS7":  58,
		"SIGRTMAXMINUS6":  59,
		"SIGRTMAXMINUS5":  60,
		"SIGRTMAXMINUS4":  61,
		"SIGRTMAXMINUS3":  62,
		"SIGRTMAXMINUS2":  63,
		"SIGRTMAXMINUS1":  64,
		"SIGRTMAX":        65,
	}
)

func (x Signal) Enum() *Signal {
	p := new(Signal)
	*p = x
	return p
}

func (x Signal) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Signal) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[5].Descriptor()
}

func (Signal) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[5]
}

func (x Signal) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Signal.Descriptor instead.
func (Signal) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{5}
}

type ContainerState int32

const (
	ContainerState_CONTAINER_CREATED ContainerState = 0
	ContainerState_CONTAINER_RUNNING ContainerState = 1
	ContainerState_CONTAINER_EXITED  ContainerState = 2
	ContainerState_CONTAINER_UNKNOWN ContainerState = 3
)

// Enum value maps for ContainerState.
var (
	ContainerState_name = map[int32]string{
		0: "CONTAINER_CREATED",
		1: "CONTAINER_RUNNING",
		2: "CONTAINER_EXITED",
		3: "CONTAINER_UNKNOWN",
	}
	ContainerState_value = map[string]int32{
		"CONTAINER_CREATED": 0,
		"CONTAINER_RUNNING": 1,
		"CONTAINER_EXITED":  2,
		"CONTAINER_UNKNOWN": 3,
	}
)

func (x ContainerState) Enum() *ContainerState {
	p := new(ContainerState)
	*p = x
	return p
}

func (x ContainerState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContainerState) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[6].Descriptor()
}

func (ContainerState) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[6]
}

func (x ContainerState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContainerState.Descriptor instead.
func (ContainerState) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{6}
}

type ContainerEventType int32

const (
	// Container created
	ContainerEventType_CONTAINER_CREATED_EVENT ContainerEventType = 0
	// Container started
	ContainerEventType_CONTAINER_STARTED_EVENT ContainerEventType = 1
	// Container stopped
	ContainerEventType_CONTAINER_STOPPED_EVENT ContainerEventType = 2
	// Container deleted
	ContainerEventType_CONTAINER_DELETED_EVENT ContainerEventType = 3
)

// Enum value maps for ContainerEventType.
var (
	ContainerEventType_name = map[int32]string{
		0: "CONTAINER_CREATED_EVENT",
		1: "CONTAINER_STARTED_EVENT",
		2: "CONTAINER_STOPPED_EVENT",
		3: "CONTAINER_DELETED_EVENT",
	}
	ContainerEventType_value = map[string]int32{
		"CONTAINER_CREATED_EVENT": 0,
		"CONTAINER_STARTED_EVENT": 1,
		"CONTAINER_STOPPED_EVENT": 2,
		"CONTAINER_DELETED_EVENT": 3,
	}
)

func (x ContainerEventType) Enum() *ContainerEventType {
	p := new(ContainerEventType)
	*p = x
	return p
}

func (x ContainerEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContainerEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[7].Descriptor()
}

func (ContainerEventType) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[7]
}

func (x ContainerEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContainerEventType.Descriptor instead.
func (ContainerEventType) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{7}
}

type MetricType int32

const (
	MetricType_COUNTER MetricType = 0
	MetricType_GAUGE   MetricType = 1
)

// Enum value maps for MetricType.
var (
	MetricType_name = map[int32]string{
		0: "COUNTER",
		1: "GAUGE",
	}
	MetricType_value = map[string]int32{
		"COUNTER": 0,
		"GAUGE":   1,
	}
)

func (x MetricType) Enum() *MetricType {
	p := new(MetricType)
	*p = x
	return p
}

func (x MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[8].Descriptor()
}

func (MetricType) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[8]
}

func (x MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricType.Descriptor instead.
func (MetricType) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{8}
}

type CgroupDriver int32

const (
	CgroupDriver_SYSTEMD  CgroupDriver = 0
	CgroupDriver_CGROUPFS CgroupDriver = 1
)

// Enum value maps for CgroupDriver.
var (
	CgroupDriver_name = map[int32]string{
		0: "SYSTEMD",
		1: "CGROUPFS",
	}
	CgroupDriver_value = map[string]int32{
		"SYSTEMD":  0,
		"CGROUPFS": 1,
	}
)

func (x CgroupDriver) Enum() *CgroupDriver {
	p := new(CgroupDriver)
	*p = x
	return p
}

func (x CgroupDriver) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CgroupDriver) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[9].Descriptor()
}

func (CgroupDriver) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[9]
}

func (x CgroupDriver) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CgroupDriver.Descriptor instead.
func (CgroupDriver) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{9}
}

// Available profile types.
type SecurityProfile_ProfileType int32

const (
	// The container runtime default profile should be used.
	SecurityProfile_RuntimeDefault SecurityProfile_ProfileType = 0
	// Disable the feature for the sandbox or the container.
	SecurityProfile_Unconfined SecurityProfile_ProfileType = 1
	// A pre-defined profile on the node should be used.
	SecurityProfile_Localhost SecurityProfile_ProfileType = 2
)

// Enum value maps for SecurityProfile_ProfileType.
var (
	SecurityProfile_ProfileType_name = map[int32]string{
		0: "RuntimeDefault",
		1: "Unconfined",
		2: "Localhost",
	}
	SecurityProfile_ProfileType_value = map[string]int32{
		"RuntimeDefault": 0,
		"Unconfined":     1,
		"Localhost":      2,
	}
)

func (x SecurityProfile_ProfileType) Enum() *SecurityProfile_ProfileType {
	p := new(SecurityProfile_ProfileType)
	*p = x
	return p
}

func (x SecurityProfile_ProfileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityProfile_ProfileType) Descriptor() protoreflect.EnumDescriptor {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[10].Descriptor()
}

func (SecurityProfile_ProfileType) Type() protoreflect.EnumType {
	return &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes[10]
}

func (x SecurityProfile_ProfileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityProfile_ProfileType.Descriptor instead.
func (SecurityProfile_ProfileType) EnumDescriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{10, 0}
}

type VersionRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version of the kubelet runtime API.
	Version       string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VersionRequest) Reset() {
	*x = VersionRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionRequest) ProtoMessage() {}

func (x *VersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionRequest.ProtoReflect.Descriptor instead.
func (*VersionRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{0}
}

func (x *VersionRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type VersionResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version of the kubelet runtime API.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Name of the container runtime.
	RuntimeName string `protobuf:"bytes,2,opt,name=runtime_name,json=runtimeName,proto3" json:"runtime_name,omitempty"`
	// Version of the container runtime. The string must be
	// semver-compatible.
	RuntimeVersion string `protobuf:"bytes,3,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
	// API version of the container runtime. The string must be
	// semver-compatible.
	RuntimeApiVersion string `protobuf:"bytes,4,opt,name=runtime_api_version,json=runtimeApiVersion,proto3" json:"runtime_api_version,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *VersionResponse) Reset() {
	*x = VersionResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionResponse) ProtoMessage() {}

func (x *VersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionResponse.ProtoReflect.Descriptor instead.
func (*VersionResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{1}
}

func (x *VersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *VersionResponse) GetRuntimeName() string {
	if x != nil {
		return x.RuntimeName
	}
	return ""
}

func (x *VersionResponse) GetRuntimeVersion() string {
	if x != nil {
		return x.RuntimeVersion
	}
	return ""
}

func (x *VersionResponse) GetRuntimeApiVersion() string {
	if x != nil {
		return x.RuntimeApiVersion
	}
	return ""
}

// DNSConfig specifies the DNS servers and search domains of a sandbox.
type DNSConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of DNS servers of the cluster.
	Servers []string `protobuf:"bytes,1,rep,name=servers,proto3" json:"servers,omitempty"`
	// List of DNS search domains of the cluster.
	Searches []string `protobuf:"bytes,2,rep,name=searches,proto3" json:"searches,omitempty"`
	// List of DNS options. See https://linux.die.net/man/5/resolv.conf
	// for all available options.
	Options       []string `protobuf:"bytes,3,rep,name=options,proto3" json:"options,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DNSConfig) Reset() {
	*x = DNSConfig{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DNSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DNSConfig) ProtoMessage() {}

func (x *DNSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DNSConfig.ProtoReflect.Descriptor instead.
func (*DNSConfig) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{2}
}

func (x *DNSConfig) GetServers() []string {
	if x != nil {
		return x.Servers
	}
	return nil
}

func (x *DNSConfig) GetSearches() []string {
	if x != nil {
		return x.Searches
	}
	return nil
}

func (x *DNSConfig) GetOptions() []string {
	if x != nil {
		return x.Options
	}
	return nil
}

// PortMapping specifies the port mapping configurations of a sandbox.
type PortMapping struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Protocol of the port mapping.
	Protocol Protocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=runtime.v1.Protocol" json:"protocol,omitempty"`
	// Port number within the container. Default: 0 (not specified).
	ContainerPort int32 `protobuf:"varint,2,opt,name=container_port,json=containerPort,proto3" json:"container_port,omitempty"`
	// Port number on the host to map the container port to.
	//
	//   - Valid host port range is 1-65535.
	//   - The value 0 has explicit semantic meaning: it indicates NO host port should be allocated.
	//   - The value 0 does NOT indicate dynamic port allocation. Future implementations
	//     of dynamic allocation will use different values/semantics.
	//   - Implementations MUST handle the case where this field is explicitly set to 0,
	//     This field SHOULD be omitted when no port is required.
	//
	// Default: If omitted, container port will not be exposed on the host.
	HostPort int32 `protobuf:"varint,3,opt,name=host_port,json=hostPort,proto3" json:"host_port,omitempty"`
	// Host IP.
	HostIp        string `protobuf:"bytes,4,opt,name=host_ip,json=hostIp,proto3" json:"host_ip,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PortMapping) Reset() {
	*x = PortMapping{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PortMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortMapping) ProtoMessage() {}

func (x *PortMapping) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortMapping.ProtoReflect.Descriptor instead.
func (*PortMapping) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{3}
}

func (x *PortMapping) GetProtocol() Protocol {
	if x != nil {
		return x.Protocol
	}
	return Protocol_TCP
}

func (x *PortMapping) GetContainerPort() int32 {
	if x != nil {
		return x.ContainerPort
	}
	return 0
}

func (x *PortMapping) GetHostPort() int32 {
	if x != nil {
		return x.HostPort
	}
	return 0
}

func (x *PortMapping) GetHostIp() string {
	if x != nil {
		return x.HostIp
	}
	return ""
}

// Mount specifies a host volume to mount into a container.
type Mount struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Path of the mount within the container.
	ContainerPath string `protobuf:"bytes,1,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Path of the mount on the host. Has to be empty if the image field below
	// is provided, because those fields are mutually exclusive. If the image
	// field below is nil and the host path doesn't exist, then runtimes should
	// report an error. If the hostpath is a symbolic link, runtimes should
	// follow the symlink and mount the real destination to container.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// If set, the mount is read-only.
	Readonly bool `protobuf:"varint,3,opt,name=readonly,proto3" json:"readonly,omitempty"`
	// If set, the mount needs SELinux relabeling.
	SelinuxRelabel bool `protobuf:"varint,4,opt,name=selinux_relabel,json=selinuxRelabel,proto3" json:"selinux_relabel,omitempty"`
	// Requested propagation mode.
	Propagation MountPropagation `protobuf:"varint,5,opt,name=propagation,proto3,enum=runtime.v1.MountPropagation" json:"propagation,omitempty"`
	// UidMappings specifies the runtime UID mappings for the mount.
	UidMappings []*IDMapping `protobuf:"bytes,6,rep,name=uidMappings,proto3" json:"uidMappings,omitempty"`
	// GidMappings specifies the runtime GID mappings for the mount.
	GidMappings []*IDMapping `protobuf:"bytes,7,rep,name=gidMappings,proto3" json:"gidMappings,omitempty"`
	// If set to true, the mount is made recursive read-only.
	// In this CRI API, recursive_read_only is a plain true/false boolean, although its equivalent
	// in the Kubernetes core API is a quaternary that can be nil, "Enabled", "IfPossible", or "Disabled".
	// kubelet translates that quaternary value in the core API into a boolean in this CRI API.
	// Remarks:
	// - nil is just treated as false
	// - when set to true, readonly must be explicitly set to true, and propagation must be PRIVATE (0).
	// - (readonly == false && recursive_read_only == false) does not make the mount read-only.
	RecursiveReadOnly bool `protobuf:"varint,8,opt,name=recursive_read_only,json=recursiveReadOnly,proto3" json:"recursive_read_only,omitempty"`
	// Mount an image reference (image ID, with or without digest), which is a
	// special use case for image volume mounts. If this field is set, then
	// host_path should be unset. All image mounts are per feature definition
	// readonly (noexec). The kubelet does an PullImage RPC and evaluates the returned
	// PullImageResponse.image_ref value, which is then set to the
	// ImageSpec.image field. Runtimes are expected to mount the image as
	// required.
	// Introduced in the Image Volume Source KEP: https://kep.k8s.io/4639
	Image *ImageSpec `protobuf:"bytes,9,opt,name=image,proto3" json:"image,omitempty"`
	// Specific image sub path to be used from inside the image instead of its
	// root, only necessary if the above image field is set. If the sub path is
	// not empty and does not exist in the image, then runtimes should fail and
	// return an error.
	// Introduced in the Image Volume Source KEP beta graduation: https://kep.k8s.io/4639
	ImageSubPath  string `protobuf:"bytes,10,opt,name=image_sub_path,json=imageSubPath,proto3" json:"image_sub_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mount) Reset() {
	*x = Mount{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mount) ProtoMessage() {}

func (x *Mount) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mount.ProtoReflect.Descriptor instead.
func (*Mount) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{4}
}

func (x *Mount) GetContainerPath() string {
	if x != nil {
		return x.ContainerPath
	}
	return ""
}

func (x *Mount) GetHostPath() string {
	if x != nil {
		return x.HostPath
	}
	return ""
}

func (x *Mount) GetReadonly() bool {
	if x != nil {
		return x.Readonly
	}
	return false
}

func (x *Mount) GetSelinuxRelabel() bool {
	if x != nil {
		return x.SelinuxRelabel
	}
	return false
}

func (x *Mount) GetPropagation() MountPropagation {
	if x != nil {
		return x.Propagation
	}
	return MountPropagation_PROPAGATION_PRIVATE
}

func (x *Mount) GetUidMappings() []*IDMapping {
	if x != nil {
		return x.UidMappings
	}
	return nil
}

func (x *Mount) GetGidMappings() []*IDMapping {
	if x != nil {
		return x.GidMappings
	}
	return nil
}

func (x *Mount) GetRecursiveReadOnly() bool {
	if x != nil {
		return x.RecursiveReadOnly
	}
	return false
}

func (x *Mount) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *Mount) GetImageSubPath() string {
	if x != nil {
		return x.ImageSubPath
	}
	return ""
}

// IDMapping describes host to container ID mappings for a pod sandbox.
type IDMapping struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// HostId is the id on the host.
	HostId uint32 `protobuf:"varint,1,opt,name=host_id,json=hostId,proto3" json:"host_id,omitempty"`
	// ContainerId is the id in the container.
	ContainerId uint32 `protobuf:"varint,2,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Length is the size of the range to map.
	Length        uint32 `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IDMapping) Reset() {
	*x = IDMapping{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IDMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IDMapping) ProtoMessage() {}

func (x *IDMapping) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IDMapping.ProtoReflect.Descriptor instead.
func (*IDMapping) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{5}
}

func (x *IDMapping) GetHostId() uint32 {
	if x != nil {
		return x.HostId
	}
	return 0
}

func (x *IDMapping) GetContainerId() uint32 {
	if x != nil {
		return x.ContainerId
	}
	return 0
}

func (x *IDMapping) GetLength() uint32 {
	if x != nil {
		return x.Length
	}
	return 0
}

// UserNamespace describes the intended user namespace configuration for a pod sandbox.
type UserNamespace struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Mode is the NamespaceMode for this UserNamespace.
	// Note: NamespaceMode for UserNamespace currently supports only POD and NODE, not CONTAINER OR TARGET.
	Mode NamespaceMode `protobuf:"varint,1,opt,name=mode,proto3,enum=runtime.v1.NamespaceMode" json:"mode,omitempty"`
	// Uids specifies the UID mappings for the user namespace.
	Uids []*IDMapping `protobuf:"bytes,2,rep,name=uids,proto3" json:"uids,omitempty"`
	// Gids specifies the GID mappings for the user namespace.
	Gids          []*IDMapping `protobuf:"bytes,3,rep,name=gids,proto3" json:"gids,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserNamespace) Reset() {
	*x = UserNamespace{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserNamespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserNamespace) ProtoMessage() {}

func (x *UserNamespace) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserNamespace.ProtoReflect.Descriptor instead.
func (*UserNamespace) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{6}
}

func (x *UserNamespace) GetMode() NamespaceMode {
	if x != nil {
		return x.Mode
	}
	return NamespaceMode_POD
}

func (x *UserNamespace) GetUids() []*IDMapping {
	if x != nil {
		return x.Uids
	}
	return nil
}

func (x *UserNamespace) GetGids() []*IDMapping {
	if x != nil {
		return x.Gids
	}
	return nil
}

// NamespaceOption provides options for Linux namespaces.
type NamespaceOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Network namespace for this container/sandbox.
	// Note: There is currently no way to set CONTAINER scoped network in the Kubernetes API.
	// Namespaces currently set by the kubelet: POD, NODE
	Network NamespaceMode `protobuf:"varint,1,opt,name=network,proto3,enum=runtime.v1.NamespaceMode" json:"network,omitempty"`
	// PID namespace for this container/sandbox.
	// Note: The CRI default is POD, but the v1.PodSpec default is CONTAINER.
	// The kubelet's runtime manager will set this to CONTAINER explicitly for v1 pods.
	// Namespaces currently set by the kubelet: POD, CONTAINER, NODE, TARGET
	Pid NamespaceMode `protobuf:"varint,2,opt,name=pid,proto3,enum=runtime.v1.NamespaceMode" json:"pid,omitempty"`
	// IPC namespace for this container/sandbox.
	// Note: There is currently no way to set CONTAINER scoped IPC in the Kubernetes API.
	// Namespaces currently set by the kubelet: POD, NODE
	Ipc NamespaceMode `protobuf:"varint,3,opt,name=ipc,proto3,enum=runtime.v1.NamespaceMode" json:"ipc,omitempty"`
	// Target Container ID for NamespaceMode of TARGET. This container must have been
	// previously created in the same pod. It is not possible to specify different targets
	// for each namespace.
	TargetId string `protobuf:"bytes,4,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// UsernsOptions for this pod sandbox.
	// The Kubelet picks the user namespace configuration to use for the pod sandbox.  The mappings
	// are specified as part of the UserNamespace struct.  If the struct is nil, then the POD mode
	// must be assumed.  This is done for backward compatibility with older Kubelet versions that
	// do not set a user namespace.
	UsernsOptions *UserNamespace `protobuf:"bytes,5,opt,name=userns_options,json=usernsOptions,proto3" json:"userns_options,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NamespaceOption) Reset() {
	*x = NamespaceOption{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NamespaceOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceOption) ProtoMessage() {}

func (x *NamespaceOption) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceOption.ProtoReflect.Descriptor instead.
func (*NamespaceOption) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{7}
}

func (x *NamespaceOption) GetNetwork() NamespaceMode {
	if x != nil {
		return x.Network
	}
	return NamespaceMode_POD
}

func (x *NamespaceOption) GetPid() NamespaceMode {
	if x != nil {
		return x.Pid
	}
	return NamespaceMode_POD
}

func (x *NamespaceOption) GetIpc() NamespaceMode {
	if x != nil {
		return x.Ipc
	}
	return NamespaceMode_POD
}

func (x *NamespaceOption) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *NamespaceOption) GetUsernsOptions() *UserNamespace {
	if x != nil {
		return x.UsernsOptions
	}
	return nil
}

// Int64Value is the wrapper of int64.
type Int64Value struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The value.
	Value         int64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Int64Value) Reset() {
	*x = Int64Value{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Int64Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Int64Value) ProtoMessage() {}

func (x *Int64Value) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Int64Value.ProtoReflect.Descriptor instead.
func (*Int64Value) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{8}
}

func (x *Int64Value) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// LinuxSandboxSecurityContext holds linux security configuration that will be
// applied to a sandbox. Note that:
//  1. It does not apply to containers in the pods.
//  2. It may not be applicable to a PodSandbox which does not contain any running
//     process.
type LinuxSandboxSecurityContext struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configurations for the sandbox's namespaces.
	// This will be used only if the PodSandbox uses namespace for isolation.
	NamespaceOptions *NamespaceOption `protobuf:"bytes,1,opt,name=namespace_options,json=namespaceOptions,proto3" json:"namespace_options,omitempty"`
	// Optional SELinux context to be applied.
	SelinuxOptions *SELinuxOption `protobuf:"bytes,2,opt,name=selinux_options,json=selinuxOptions,proto3" json:"selinux_options,omitempty"`
	// UID to run sandbox processes as, when applicable.
	RunAsUser *Int64Value `protobuf:"bytes,3,opt,name=run_as_user,json=runAsUser,proto3" json:"run_as_user,omitempty"`
	// GID to run sandbox processes as, when applicable. run_as_group should only
	// be specified when run_as_user is specified; otherwise, the runtime MUST error.
	RunAsGroup *Int64Value `protobuf:"bytes,8,opt,name=run_as_group,json=runAsGroup,proto3" json:"run_as_group,omitempty"`
	// If set, the root filesystem of the sandbox is read-only.
	ReadonlyRootfs bool `protobuf:"varint,4,opt,name=readonly_rootfs,json=readonlyRootfs,proto3" json:"readonly_rootfs,omitempty"`
	// List of groups applied to the first process run in each container.
	// supplemental_groups_policy can control how groups will be calculated.
	SupplementalGroups []int64 `protobuf:"varint,5,rep,packed,name=supplemental_groups,json=supplementalGroups,proto3" json:"supplemental_groups,omitempty"`
	// supplemental_groups_policy defines how supplemental groups of the first
	// container processes are calculated.
	// Valid values are "Merge" and "Strict".
	// If not specified, "Merge" is used.
	SupplementalGroupsPolicy SupplementalGroupsPolicy `protobuf:"varint,11,opt,name=supplemental_groups_policy,json=supplementalGroupsPolicy,proto3,enum=runtime.v1.SupplementalGroupsPolicy" json:"supplemental_groups_policy,omitempty"`
	// Indicates whether the sandbox will be asked to run a privileged
	// container. If a privileged container is to be executed within it, this
	// MUST be true.
	// This allows a sandbox to take additional security precautions if no
	// privileged containers are expected to be run.
	Privileged bool `protobuf:"varint,6,opt,name=privileged,proto3" json:"privileged,omitempty"`
	// Seccomp profile for the sandbox.
	Seccomp *SecurityProfile `protobuf:"bytes,9,opt,name=seccomp,proto3" json:"seccomp,omitempty"`
	// AppArmor profile for the sandbox.
	Apparmor *SecurityProfile `protobuf:"bytes,10,opt,name=apparmor,proto3" json:"apparmor,omitempty"`
	// Seccomp profile for the sandbox, candidate values are:
	//   - runtime/default: the default profile for the container runtime
	//   - unconfined: unconfined profile, ie, no seccomp sandboxing
	//   - localhost/<full-path-to-profile>: the profile installed on the node.
	//     <full-path-to-profile> is the full path of the profile.
	//
	// Default: "", which is identical with unconfined.
	//
	// Deprecated: Marked as deprecated in staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto.
	SeccompProfilePath string `protobuf:"bytes,7,opt,name=seccomp_profile_path,json=seccompProfilePath,proto3" json:"seccomp_profile_path,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *LinuxSandboxSecurityContext) Reset() {
	*x = LinuxSandboxSecurityContext{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxSandboxSecurityContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxSandboxSecurityContext) ProtoMessage() {}

func (x *LinuxSandboxSecurityContext) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxSandboxSecurityContext.ProtoReflect.Descriptor instead.
func (*LinuxSandboxSecurityContext) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{9}
}

func (x *LinuxSandboxSecurityContext) GetNamespaceOptions() *NamespaceOption {
	if x != nil {
		return x.NamespaceOptions
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetSelinuxOptions() *SELinuxOption {
	if x != nil {
		return x.SelinuxOptions
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetRunAsUser() *Int64Value {
	if x != nil {
		return x.RunAsUser
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetRunAsGroup() *Int64Value {
	if x != nil {
		return x.RunAsGroup
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetReadonlyRootfs() bool {
	if x != nil {
		return x.ReadonlyRootfs
	}
	return false
}

func (x *LinuxSandboxSecurityContext) GetSupplementalGroups() []int64 {
	if x != nil {
		return x.SupplementalGroups
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetSupplementalGroupsPolicy() SupplementalGroupsPolicy {
	if x != nil {
		return x.SupplementalGroupsPolicy
	}
	return SupplementalGroupsPolicy_Merge
}

func (x *LinuxSandboxSecurityContext) GetPrivileged() bool {
	if x != nil {
		return x.Privileged
	}
	return false
}

func (x *LinuxSandboxSecurityContext) GetSeccomp() *SecurityProfile {
	if x != nil {
		return x.Seccomp
	}
	return nil
}

func (x *LinuxSandboxSecurityContext) GetApparmor() *SecurityProfile {
	if x != nil {
		return x.Apparmor
	}
	return nil
}

// Deprecated: Marked as deprecated in staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto.
func (x *LinuxSandboxSecurityContext) GetSeccompProfilePath() string {
	if x != nil {
		return x.SeccompProfilePath
	}
	return ""
}

// A security profile which can be used for sandboxes and containers.
type SecurityProfile struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Indicator which `ProfileType` should be applied.
	ProfileType SecurityProfile_ProfileType `protobuf:"varint,1,opt,name=profile_type,json=profileType,proto3,enum=runtime.v1.SecurityProfile_ProfileType" json:"profile_type,omitempty"`
	// Indicates that a pre-defined profile on the node should be used.
	// Must only be set if `ProfileType` is `Localhost`.
	// For seccomp, it must be an absolute path to the seccomp profile.
	// For AppArmor, this field is the AppArmor `<profile name>/`
	LocalhostRef  string `protobuf:"bytes,2,opt,name=localhost_ref,json=localhostRef,proto3" json:"localhost_ref,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SecurityProfile) Reset() {
	*x = SecurityProfile{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecurityProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityProfile) ProtoMessage() {}

func (x *SecurityProfile) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityProfile.ProtoReflect.Descriptor instead.
func (*SecurityProfile) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{10}
}

func (x *SecurityProfile) GetProfileType() SecurityProfile_ProfileType {
	if x != nil {
		return x.ProfileType
	}
	return SecurityProfile_RuntimeDefault
}

func (x *SecurityProfile) GetLocalhostRef() string {
	if x != nil {
		return x.LocalhostRef
	}
	return ""
}

// LinuxPodSandboxConfig holds platform-specific configurations for Linux
// host platforms and Linux-based containers.
type LinuxPodSandboxConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Parent cgroup of the PodSandbox.
	// The cgroupfs style syntax will be used, but the container runtime can
	// convert it to systemd semantics if needed.
	CgroupParent string `protobuf:"bytes,1,opt,name=cgroup_parent,json=cgroupParent,proto3" json:"cgroup_parent,omitempty"`
	// LinuxSandboxSecurityContext holds sandbox security attributes.
	SecurityContext *LinuxSandboxSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	// Sysctls holds linux sysctls config for the sandbox.
	Sysctls map[string]string `protobuf:"bytes,3,rep,name=sysctls,proto3" json:"sysctls,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Optional overhead represents the overheads associated with this sandbox
	Overhead *LinuxContainerResources `protobuf:"bytes,4,opt,name=overhead,proto3" json:"overhead,omitempty"`
	// Optional resources represents the sum of container resources for this sandbox
	Resources     *LinuxContainerResources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LinuxPodSandboxConfig) Reset() {
	*x = LinuxPodSandboxConfig{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxPodSandboxConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxPodSandboxConfig) ProtoMessage() {}

func (x *LinuxPodSandboxConfig) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxPodSandboxConfig.ProtoReflect.Descriptor instead.
func (*LinuxPodSandboxConfig) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{11}
}

func (x *LinuxPodSandboxConfig) GetCgroupParent() string {
	if x != nil {
		return x.CgroupParent
	}
	return ""
}

func (x *LinuxPodSandboxConfig) GetSecurityContext() *LinuxSandboxSecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

func (x *LinuxPodSandboxConfig) GetSysctls() map[string]string {
	if x != nil {
		return x.Sysctls
	}
	return nil
}

func (x *LinuxPodSandboxConfig) GetOverhead() *LinuxContainerResources {
	if x != nil {
		return x.Overhead
	}
	return nil
}

func (x *LinuxPodSandboxConfig) GetResources() *LinuxContainerResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

// PodSandboxMetadata holds all necessary information for building the sandbox name.
// The container runtime is encouraged to expose the metadata associated with the
// PodSandbox in its user interface for better user experience. For example,
// the runtime can construct a unique PodSandboxName based on the metadata.
type PodSandboxMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Pod name of the sandbox. Same as the pod name in the Pod ObjectMeta.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Pod UID of the sandbox. Same as the pod UID in the Pod ObjectMeta.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Pod namespace of the sandbox. Same as the pod namespace in the Pod ObjectMeta.
	Namespace string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Attempt number of creating the sandbox. Default: 0.
	Attempt       uint32 `protobuf:"varint,4,opt,name=attempt,proto3" json:"attempt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxMetadata) Reset() {
	*x = PodSandboxMetadata{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxMetadata) ProtoMessage() {}

func (x *PodSandboxMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxMetadata.ProtoReflect.Descriptor instead.
func (*PodSandboxMetadata) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{12}
}

func (x *PodSandboxMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PodSandboxMetadata) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *PodSandboxMetadata) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *PodSandboxMetadata) GetAttempt() uint32 {
	if x != nil {
		return x.Attempt
	}
	return 0
}

// PodSandboxConfig holds all the required and optional fields for creating a
// sandbox.
type PodSandboxConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Metadata of the sandbox. This information will uniquely identify the
	// sandbox, and the runtime should leverage this to ensure correct
	// operation. The runtime may also use this information to improve UX, such
	// as by constructing a readable name.
	Metadata *PodSandboxMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Hostname of the sandbox. Hostname could only be empty when the pod
	// network namespace is NODE.
	Hostname string `protobuf:"bytes,2,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Path to the directory on the host in which container log files are
	// stored.
	// By default the log of a container going into the LogDirectory will be
	// hooked up to STDOUT and STDERR. However, the LogDirectory may contain
	// binary log files with structured logging data from the individual
	// containers. For example, the files might be newline separated JSON
	// structured logs, systemd-journald journal files, gRPC trace files, etc.
	// E.g.,
	//
	//	PodSandboxConfig.LogDirectory = `/var/log/pods/<NAMESPACE>_<NAME>_<UID>/`
	//	ContainerConfig.LogPath = `containerName/Instance#.log`
	LogDirectory string `protobuf:"bytes,3,opt,name=log_directory,json=logDirectory,proto3" json:"log_directory,omitempty"`
	// DNS config for the sandbox.
	DnsConfig *DNSConfig `protobuf:"bytes,4,opt,name=dns_config,json=dnsConfig,proto3" json:"dns_config,omitempty"`
	// Port mappings for the sandbox.
	PortMappings []*PortMapping `protobuf:"bytes,5,rep,name=port_mappings,json=portMappings,proto3" json:"port_mappings,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Unstructured key-value map that may be set by the kubelet to store and
	// retrieve arbitrary metadata. This will include any annotations set on a
	// pod through the Kubernetes API.
	//
	// Annotations MUST NOT be altered by the runtime; the annotations stored
	// here MUST be returned in the PodSandboxStatus associated with the pod
	// this PodSandboxConfig creates.
	//
	// In general, in order to preserve a well-defined interface between the
	// kubelet and the container runtime, annotations SHOULD NOT influence
	// runtime behaviour.
	//
	// Annotations can also be useful for runtime authors to experiment with
	// new features that are opaque to the Kubernetes APIs (both user-facing
	// and the CRI). Whenever possible, however, runtime authors SHOULD
	// consider proposing new typed fields for any new features instead.
	Annotations map[string]string `protobuf:"bytes,7,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Optional configurations specific to Linux hosts.
	Linux *LinuxPodSandboxConfig `protobuf:"bytes,8,opt,name=linux,proto3" json:"linux,omitempty"`
	// Optional configurations specific to Windows hosts.
	Windows       *WindowsPodSandboxConfig `protobuf:"bytes,9,opt,name=windows,proto3" json:"windows,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxConfig) Reset() {
	*x = PodSandboxConfig{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxConfig) ProtoMessage() {}

func (x *PodSandboxConfig) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxConfig.ProtoReflect.Descriptor instead.
func (*PodSandboxConfig) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{13}
}

func (x *PodSandboxConfig) GetMetadata() *PodSandboxMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PodSandboxConfig) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *PodSandboxConfig) GetLogDirectory() string {
	if x != nil {
		return x.LogDirectory
	}
	return ""
}

func (x *PodSandboxConfig) GetDnsConfig() *DNSConfig {
	if x != nil {
		return x.DnsConfig
	}
	return nil
}

func (x *PodSandboxConfig) GetPortMappings() []*PortMapping {
	if x != nil {
		return x.PortMappings
	}
	return nil
}

func (x *PodSandboxConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PodSandboxConfig) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PodSandboxConfig) GetLinux() *LinuxPodSandboxConfig {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *PodSandboxConfig) GetWindows() *WindowsPodSandboxConfig {
	if x != nil {
		return x.Windows
	}
	return nil
}

type RunPodSandboxRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for creating a PodSandbox.
	Config *PodSandboxConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Named runtime configuration to use for this PodSandbox.
	// If the runtime handler is unknown, this request should be rejected.  An
	// empty string should select the default handler, equivalent to the
	// behavior before this feature was added.
	// See https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class
	RuntimeHandler string `protobuf:"bytes,2,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *RunPodSandboxRequest) Reset() {
	*x = RunPodSandboxRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RunPodSandboxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPodSandboxRequest) ProtoMessage() {}

func (x *RunPodSandboxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPodSandboxRequest.ProtoReflect.Descriptor instead.
func (*RunPodSandboxRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{14}
}

func (x *RunPodSandboxRequest) GetConfig() *PodSandboxConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *RunPodSandboxRequest) GetRuntimeHandler() string {
	if x != nil {
		return x.RuntimeHandler
	}
	return ""
}

type RunPodSandboxResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the PodSandbox to run.
	PodSandboxId  string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RunPodSandboxResponse) Reset() {
	*x = RunPodSandboxResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RunPodSandboxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPodSandboxResponse) ProtoMessage() {}

func (x *RunPodSandboxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPodSandboxResponse.ProtoReflect.Descriptor instead.
func (*RunPodSandboxResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{15}
}

func (x *RunPodSandboxResponse) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

type StopPodSandboxRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the PodSandbox to stop.
	PodSandboxId  string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopPodSandboxRequest) Reset() {
	*x = StopPodSandboxRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopPodSandboxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopPodSandboxRequest) ProtoMessage() {}

func (x *StopPodSandboxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopPodSandboxRequest.ProtoReflect.Descriptor instead.
func (*StopPodSandboxRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{16}
}

func (x *StopPodSandboxRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

type StopPodSandboxResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopPodSandboxResponse) Reset() {
	*x = StopPodSandboxResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopPodSandboxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopPodSandboxResponse) ProtoMessage() {}

func (x *StopPodSandboxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopPodSandboxResponse.ProtoReflect.Descriptor instead.
func (*StopPodSandboxResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{17}
}

type RemovePodSandboxRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the PodSandbox to remove.
	PodSandboxId  string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemovePodSandboxRequest) Reset() {
	*x = RemovePodSandboxRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemovePodSandboxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemovePodSandboxRequest) ProtoMessage() {}

func (x *RemovePodSandboxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemovePodSandboxRequest.ProtoReflect.Descriptor instead.
func (*RemovePodSandboxRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{18}
}

func (x *RemovePodSandboxRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

type RemovePodSandboxResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemovePodSandboxResponse) Reset() {
	*x = RemovePodSandboxResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemovePodSandboxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemovePodSandboxResponse) ProtoMessage() {}

func (x *RemovePodSandboxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemovePodSandboxResponse.ProtoReflect.Descriptor instead.
func (*RemovePodSandboxResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{19}
}

type PodSandboxStatusRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the PodSandbox for which to retrieve status.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Verbose indicates whether to return extra information about the pod sandbox.
	Verbose       bool `protobuf:"varint,2,opt,name=verbose,proto3" json:"verbose,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxStatusRequest) Reset() {
	*x = PodSandboxStatusRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatusRequest) ProtoMessage() {}

func (x *PodSandboxStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatusRequest.ProtoReflect.Descriptor instead.
func (*PodSandboxStatusRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{20}
}

func (x *PodSandboxStatusRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *PodSandboxStatusRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

// PodIP represents an ip of a Pod
type PodIP struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// an ip is a string representation of an IPv4 or an IPv6
	Ip            string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodIP) Reset() {
	*x = PodIP{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodIP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodIP) ProtoMessage() {}

func (x *PodIP) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodIP.ProtoReflect.Descriptor instead.
func (*PodIP) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{21}
}

func (x *PodIP) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

// PodSandboxNetworkStatus is the status of the network for a PodSandbox.
// Currently ignored for pods sharing the host networking namespace.
type PodSandboxNetworkStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// IP address of the PodSandbox.
	Ip string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	// list of additional ips (not inclusive of PodSandboxNetworkStatus.Ip) of the PodSandBoxNetworkStatus
	AdditionalIps []*PodIP `protobuf:"bytes,2,rep,name=additional_ips,json=additionalIps,proto3" json:"additional_ips,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxNetworkStatus) Reset() {
	*x = PodSandboxNetworkStatus{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxNetworkStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxNetworkStatus) ProtoMessage() {}

func (x *PodSandboxNetworkStatus) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxNetworkStatus.ProtoReflect.Descriptor instead.
func (*PodSandboxNetworkStatus) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{22}
}

func (x *PodSandboxNetworkStatus) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *PodSandboxNetworkStatus) GetAdditionalIps() []*PodIP {
	if x != nil {
		return x.AdditionalIps
	}
	return nil
}

// Namespace contains paths to the namespaces.
type Namespace struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Namespace options for Linux namespaces.
	Options       *NamespaceOption `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Namespace) Reset() {
	*x = Namespace{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Namespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Namespace) ProtoMessage() {}

func (x *Namespace) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Namespace.ProtoReflect.Descriptor instead.
func (*Namespace) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{23}
}

func (x *Namespace) GetOptions() *NamespaceOption {
	if x != nil {
		return x.Options
	}
	return nil
}

// LinuxSandboxStatus contains status specific to Linux sandboxes.
type LinuxPodSandboxStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Paths to the sandbox's namespaces.
	Namespaces    *Namespace `protobuf:"bytes,1,opt,name=namespaces,proto3" json:"namespaces,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LinuxPodSandboxStatus) Reset() {
	*x = LinuxPodSandboxStatus{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxPodSandboxStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxPodSandboxStatus) ProtoMessage() {}

func (x *LinuxPodSandboxStatus) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxPodSandboxStatus.ProtoReflect.Descriptor instead.
func (*LinuxPodSandboxStatus) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{24}
}

func (x *LinuxPodSandboxStatus) GetNamespaces() *Namespace {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

// PodSandboxStatus contains the status of the PodSandbox.
type PodSandboxStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the sandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// State of the sandbox.
	State PodSandboxState `protobuf:"varint,3,opt,name=state,proto3,enum=runtime.v1.PodSandboxState" json:"state,omitempty"`
	// Creation timestamp of the sandbox in nanoseconds. Must be > 0.
	CreatedAt int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Network contains network status if network is handled by the runtime.
	Network *PodSandboxNetworkStatus `protobuf:"bytes,5,opt,name=network,proto3" json:"network,omitempty"`
	// Linux-specific status to a pod sandbox.
	Linux *LinuxPodSandboxStatus `protobuf:"bytes,6,opt,name=linux,proto3" json:"linux,omitempty"`
	// Labels are key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding PodSandboxConfig used to
	// instantiate the pod sandbox this status represents.
	Annotations map[string]string `protobuf:"bytes,8,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// runtime configuration used for this PodSandbox.
	RuntimeHandler string `protobuf:"bytes,9,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *PodSandboxStatus) Reset() {
	*x = PodSandboxStatus{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatus) ProtoMessage() {}

func (x *PodSandboxStatus) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatus.ProtoReflect.Descriptor instead.
func (*PodSandboxStatus) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{25}
}

func (x *PodSandboxStatus) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PodSandboxStatus) GetMetadata() *PodSandboxMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PodSandboxStatus) GetState() PodSandboxState {
	if x != nil {
		return x.State
	}
	return PodSandboxState_SANDBOX_READY
}

func (x *PodSandboxStatus) GetCreatedAt() int64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *PodSandboxStatus) GetNetwork() *PodSandboxNetworkStatus {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *PodSandboxStatus) GetLinux() *LinuxPodSandboxStatus {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *PodSandboxStatus) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PodSandboxStatus) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PodSandboxStatus) GetRuntimeHandler() string {
	if x != nil {
		return x.RuntimeHandler
	}
	return ""
}

type PodSandboxStatusResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Status of the PodSandbox.
	Status *PodSandboxStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Info is extra information of the PodSandbox. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful for
	// debug, e.g. network namespace for linux container based container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Container statuses
	ContainersStatuses []*ContainerStatus `protobuf:"bytes,3,rep,name=containers_statuses,json=containersStatuses,proto3" json:"containers_statuses,omitempty"`
	// Timestamp in nanoseconds at which container and pod statuses were recorded
	Timestamp     int64 `protobuf:"varint,4,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxStatusResponse) Reset() {
	*x = PodSandboxStatusResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatusResponse) ProtoMessage() {}

func (x *PodSandboxStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatusResponse.ProtoReflect.Descriptor instead.
func (*PodSandboxStatusResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{26}
}

func (x *PodSandboxStatusResponse) GetStatus() *PodSandboxStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *PodSandboxStatusResponse) GetInfo() map[string]string {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *PodSandboxStatusResponse) GetContainersStatuses() []*ContainerStatus {
	if x != nil {
		return x.ContainersStatuses
	}
	return nil
}

func (x *PodSandboxStatusResponse) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

// PodSandboxStateValue is the wrapper of PodSandboxState.
type PodSandboxStateValue struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// State of the sandbox.
	State         PodSandboxState `protobuf:"varint,1,opt,name=state,proto3,enum=runtime.v1.PodSandboxState" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxStateValue) Reset() {
	*x = PodSandboxStateValue{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxStateValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStateValue) ProtoMessage() {}

func (x *PodSandboxStateValue) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStateValue.ProtoReflect.Descriptor instead.
func (*PodSandboxStateValue) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{27}
}

func (x *PodSandboxStateValue) GetState() PodSandboxState {
	if x != nil {
		return x.State
	}
	return PodSandboxState_SANDBOX_READY
}

// PodSandboxFilter is used to filter a list of PodSandboxes.
// All those fields are combined with 'AND'
type PodSandboxFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// State of the sandbox.
	State *PodSandboxStateValue `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector map[string]string `protobuf:"bytes,3,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxFilter) Reset() {
	*x = PodSandboxFilter{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxFilter) ProtoMessage() {}

func (x *PodSandboxFilter) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxFilter.ProtoReflect.Descriptor instead.
func (*PodSandboxFilter) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{28}
}

func (x *PodSandboxFilter) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PodSandboxFilter) GetState() *PodSandboxStateValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *PodSandboxFilter) GetLabelSelector() map[string]string {
	if x != nil {
		return x.LabelSelector
	}
	return nil
}

type ListPodSandboxRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// PodSandboxFilter to filter a list of PodSandboxes.
	Filter        *PodSandboxFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPodSandboxRequest) Reset() {
	*x = ListPodSandboxRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPodSandboxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodSandboxRequest) ProtoMessage() {}

func (x *ListPodSandboxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodSandboxRequest.ProtoReflect.Descriptor instead.
func (*ListPodSandboxRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{29}
}

func (x *ListPodSandboxRequest) GetFilter() *PodSandboxFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// PodSandbox contains minimal information about a sandbox.
type PodSandbox struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the PodSandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the PodSandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// State of the PodSandbox.
	State PodSandboxState `protobuf:"varint,3,opt,name=state,proto3,enum=runtime.v1.PodSandboxState" json:"state,omitempty"`
	// Creation timestamps of the PodSandbox in nanoseconds. Must be > 0.
	CreatedAt int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Labels of the PodSandbox.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding PodSandboxConfig used to
	// instantiate this PodSandbox.
	Annotations map[string]string `protobuf:"bytes,6,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// runtime configuration used for this PodSandbox.
	RuntimeHandler string `protobuf:"bytes,7,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *PodSandbox) Reset() {
	*x = PodSandbox{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandbox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandbox) ProtoMessage() {}

func (x *PodSandbox) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandbox.ProtoReflect.Descriptor instead.
func (*PodSandbox) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{30}
}

func (x *PodSandbox) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PodSandbox) GetMetadata() *PodSandboxMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PodSandbox) GetState() PodSandboxState {
	if x != nil {
		return x.State
	}
	return PodSandboxState_SANDBOX_READY
}

func (x *PodSandbox) GetCreatedAt() int64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *PodSandbox) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PodSandbox) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PodSandbox) GetRuntimeHandler() string {
	if x != nil {
		return x.RuntimeHandler
	}
	return ""
}

type ListPodSandboxResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of PodSandboxes.
	Items         []*PodSandbox `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPodSandboxResponse) Reset() {
	*x = ListPodSandboxResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPodSandboxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodSandboxResponse) ProtoMessage() {}

func (x *ListPodSandboxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodSandboxResponse.ProtoReflect.Descriptor instead.
func (*ListPodSandboxResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{31}
}

func (x *ListPodSandboxResponse) GetItems() []*PodSandbox {
	if x != nil {
		return x.Items
	}
	return nil
}

type PodSandboxStatsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the pod sandbox for which to retrieve stats.
	PodSandboxId  string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxStatsRequest) Reset() {
	*x = PodSandboxStatsRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatsRequest) ProtoMessage() {}

func (x *PodSandboxStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatsRequest.ProtoReflect.Descriptor instead.
func (*PodSandboxStatsRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{32}
}

func (x *PodSandboxStatsRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

type PodSandboxStatsResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Stats         *PodSandboxStats       `protobuf:"bytes,1,opt,name=stats,proto3" json:"stats,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxStatsResponse) Reset() {
	*x = PodSandboxStatsResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatsResponse) ProtoMessage() {}

func (x *PodSandboxStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatsResponse.ProtoReflect.Descriptor instead.
func (*PodSandboxStatsResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{33}
}

func (x *PodSandboxStatsResponse) GetStats() *PodSandboxStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// PodSandboxStatsFilter is used to filter the list of pod sandboxes to retrieve stats for.
// All those fields are combined with 'AND'.
type PodSandboxStatsFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the pod sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector map[string]string `protobuf:"bytes,2,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxStatsFilter) Reset() {
	*x = PodSandboxStatsFilter{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxStatsFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStatsFilter) ProtoMessage() {}

func (x *PodSandboxStatsFilter) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStatsFilter.ProtoReflect.Descriptor instead.
func (*PodSandboxStatsFilter) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{34}
}

func (x *PodSandboxStatsFilter) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PodSandboxStatsFilter) GetLabelSelector() map[string]string {
	if x != nil {
		return x.LabelSelector
	}
	return nil
}

type ListPodSandboxStatsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Filter for the list request.
	Filter        *PodSandboxStatsFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPodSandboxStatsRequest) Reset() {
	*x = ListPodSandboxStatsRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPodSandboxStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodSandboxStatsRequest) ProtoMessage() {}

func (x *ListPodSandboxStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodSandboxStatsRequest.ProtoReflect.Descriptor instead.
func (*ListPodSandboxStatsRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{35}
}

func (x *ListPodSandboxStatsRequest) GetFilter() *PodSandboxStatsFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

type ListPodSandboxStatsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Stats of the pod sandbox.
	Stats         []*PodSandboxStats `protobuf:"bytes,1,rep,name=stats,proto3" json:"stats,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPodSandboxStatsResponse) Reset() {
	*x = ListPodSandboxStatsResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPodSandboxStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodSandboxStatsResponse) ProtoMessage() {}

func (x *ListPodSandboxStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodSandboxStatsResponse.ProtoReflect.Descriptor instead.
func (*ListPodSandboxStatsResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{36}
}

func (x *ListPodSandboxStatsResponse) GetStats() []*PodSandboxStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// PodSandboxAttributes provides basic information of the pod sandbox.
type PodSandboxAttributes struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the pod sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the pod sandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding PodSandboxStatus used to
	// instantiate the PodSandbox this status represents.
	Annotations   map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxAttributes) Reset() {
	*x = PodSandboxAttributes{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxAttributes) ProtoMessage() {}

func (x *PodSandboxAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxAttributes.ProtoReflect.Descriptor instead.
func (*PodSandboxAttributes) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{37}
}

func (x *PodSandboxAttributes) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PodSandboxAttributes) GetMetadata() *PodSandboxMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PodSandboxAttributes) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PodSandboxAttributes) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// PodSandboxStats provides the resource usage statistics for a pod.
// The linux or windows field will be populated depending on the platform.
type PodSandboxStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Information of the pod.
	Attributes *PodSandboxAttributes `protobuf:"bytes,1,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// Stats from linux.
	Linux *LinuxPodSandboxStats `protobuf:"bytes,2,opt,name=linux,proto3" json:"linux,omitempty"`
	// Stats from windows.
	Windows       *WindowsPodSandboxStats `protobuf:"bytes,3,opt,name=windows,proto3" json:"windows,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodSandboxStats) Reset() {
	*x = PodSandboxStats{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxStats) ProtoMessage() {}

func (x *PodSandboxStats) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxStats.ProtoReflect.Descriptor instead.
func (*PodSandboxStats) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{38}
}

func (x *PodSandboxStats) GetAttributes() *PodSandboxAttributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *PodSandboxStats) GetLinux() *LinuxPodSandboxStats {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *PodSandboxStats) GetWindows() *WindowsPodSandboxStats {
	if x != nil {
		return x.Windows
	}
	return nil
}

// LinuxPodSandboxStats provides the resource usage statistics for a pod sandbox on linux.
type LinuxPodSandboxStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// CPU usage gathered for the pod sandbox.
	Cpu *CpuUsage `protobuf:"bytes,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage gathered for the pod sandbox.
	Memory *MemoryUsage `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	// Network usage gathered for the pod sandbox
	Network *NetworkUsage `protobuf:"bytes,3,opt,name=network,proto3" json:"network,omitempty"`
	// Stats pertaining to processes in the pod sandbox.
	Process *ProcessUsage `protobuf:"bytes,4,opt,name=process,proto3" json:"process,omitempty"`
	// Stats of containers in the measured pod sandbox.
	Containers []*ContainerStats `protobuf:"bytes,5,rep,name=containers,proto3" json:"containers,omitempty"`
	// IO usage gathered for the pod sandbox.
	Io            *IoUsage `protobuf:"bytes,6,opt,name=io,proto3" json:"io,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LinuxPodSandboxStats) Reset() {
	*x = LinuxPodSandboxStats{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxPodSandboxStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxPodSandboxStats) ProtoMessage() {}

func (x *LinuxPodSandboxStats) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxPodSandboxStats.ProtoReflect.Descriptor instead.
func (*LinuxPodSandboxStats) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{39}
}

func (x *LinuxPodSandboxStats) GetCpu() *CpuUsage {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *LinuxPodSandboxStats) GetMemory() *MemoryUsage {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *LinuxPodSandboxStats) GetNetwork() *NetworkUsage {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *LinuxPodSandboxStats) GetProcess() *ProcessUsage {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *LinuxPodSandboxStats) GetContainers() []*ContainerStats {
	if x != nil {
		return x.Containers
	}
	return nil
}

func (x *LinuxPodSandboxStats) GetIo() *IoUsage {
	if x != nil {
		return x.Io
	}
	return nil
}

// WindowsPodSandboxStats provides the resource usage statistics for a pod sandbox on windows
type WindowsPodSandboxStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// CPU usage gathered for the pod sandbox.
	Cpu *WindowsCpuUsage `protobuf:"bytes,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage gathered for the pod sandbox.
	Memory *WindowsMemoryUsage `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	// Network usage gathered for the pod sandbox
	Network *WindowsNetworkUsage `protobuf:"bytes,3,opt,name=network,proto3" json:"network,omitempty"`
	// Stats pertaining to processes in the pod sandbox.
	Process *WindowsProcessUsage `protobuf:"bytes,4,opt,name=process,proto3" json:"process,omitempty"`
	// Stats of containers in the measured pod sandbox.
	Containers    []*WindowsContainerStats `protobuf:"bytes,5,rep,name=containers,proto3" json:"containers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WindowsPodSandboxStats) Reset() {
	*x = WindowsPodSandboxStats{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsPodSandboxStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsPodSandboxStats) ProtoMessage() {}

func (x *WindowsPodSandboxStats) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsPodSandboxStats.ProtoReflect.Descriptor instead.
func (*WindowsPodSandboxStats) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{40}
}

func (x *WindowsPodSandboxStats) GetCpu() *WindowsCpuUsage {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *WindowsPodSandboxStats) GetMemory() *WindowsMemoryUsage {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *WindowsPodSandboxStats) GetNetwork() *WindowsNetworkUsage {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *WindowsPodSandboxStats) GetProcess() *WindowsProcessUsage {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *WindowsPodSandboxStats) GetContainers() []*WindowsContainerStats {
	if x != nil {
		return x.Containers
	}
	return nil
}

// NetworkUsage contains data about network resources.
type NetworkUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Stats for the default network interface.
	DefaultInterface *NetworkInterfaceUsage `protobuf:"bytes,2,opt,name=default_interface,json=defaultInterface,proto3" json:"default_interface,omitempty"`
	// Stats for all found network interfaces, excluding the default.
	Interfaces    []*NetworkInterfaceUsage `protobuf:"bytes,3,rep,name=interfaces,proto3" json:"interfaces,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NetworkUsage) Reset() {
	*x = NetworkUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkUsage) ProtoMessage() {}

func (x *NetworkUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkUsage.ProtoReflect.Descriptor instead.
func (*NetworkUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{41}
}

func (x *NetworkUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *NetworkUsage) GetDefaultInterface() *NetworkInterfaceUsage {
	if x != nil {
		return x.DefaultInterface
	}
	return nil
}

func (x *NetworkUsage) GetInterfaces() []*NetworkInterfaceUsage {
	if x != nil {
		return x.Interfaces
	}
	return nil
}

// WindowsNetworkUsage contains data about network resources specific to Windows.
type WindowsNetworkUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Stats for the default network interface.
	DefaultInterface *WindowsNetworkInterfaceUsage `protobuf:"bytes,2,opt,name=default_interface,json=defaultInterface,proto3" json:"default_interface,omitempty"`
	// Stats for all found network interfaces, excluding the default.
	Interfaces    []*WindowsNetworkInterfaceUsage `protobuf:"bytes,3,rep,name=interfaces,proto3" json:"interfaces,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WindowsNetworkUsage) Reset() {
	*x = WindowsNetworkUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsNetworkUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsNetworkUsage) ProtoMessage() {}

func (x *WindowsNetworkUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsNetworkUsage.ProtoReflect.Descriptor instead.
func (*WindowsNetworkUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{42}
}

func (x *WindowsNetworkUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *WindowsNetworkUsage) GetDefaultInterface() *WindowsNetworkInterfaceUsage {
	if x != nil {
		return x.DefaultInterface
	}
	return nil
}

func (x *WindowsNetworkUsage) GetInterfaces() []*WindowsNetworkInterfaceUsage {
	if x != nil {
		return x.Interfaces
	}
	return nil
}

// NetworkInterfaceUsage contains resource value data about a network interface.
type NetworkInterfaceUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the network interface.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Cumulative count of bytes received.
	RxBytes *UInt64Value `protobuf:"bytes,2,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	// Cumulative count of receive errors encountered.
	RxErrors *UInt64Value `protobuf:"bytes,3,opt,name=rx_errors,json=rxErrors,proto3" json:"rx_errors,omitempty"`
	// Cumulative count of bytes transmitted.
	TxBytes *UInt64Value `protobuf:"bytes,4,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	// Cumulative count of transmit errors encountered.
	TxErrors      *UInt64Value `protobuf:"bytes,5,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NetworkInterfaceUsage) Reset() {
	*x = NetworkInterfaceUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkInterfaceUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkInterfaceUsage) ProtoMessage() {}

func (x *NetworkInterfaceUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkInterfaceUsage.ProtoReflect.Descriptor instead.
func (*NetworkInterfaceUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{43}
}

func (x *NetworkInterfaceUsage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NetworkInterfaceUsage) GetRxBytes() *UInt64Value {
	if x != nil {
		return x.RxBytes
	}
	return nil
}

func (x *NetworkInterfaceUsage) GetRxErrors() *UInt64Value {
	if x != nil {
		return x.RxErrors
	}
	return nil
}

func (x *NetworkInterfaceUsage) GetTxBytes() *UInt64Value {
	if x != nil {
		return x.TxBytes
	}
	return nil
}

func (x *NetworkInterfaceUsage) GetTxErrors() *UInt64Value {
	if x != nil {
		return x.TxErrors
	}
	return nil
}

// WindowsNetworkInterfaceUsage contains resource value data about a network interface specific for Windows.
type WindowsNetworkInterfaceUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the network interface.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Cumulative count of bytes received.
	RxBytes *UInt64Value `protobuf:"bytes,2,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	// Cumulative count of receive errors encountered.
	RxPacketsDropped *UInt64Value `protobuf:"bytes,3,opt,name=rx_packets_dropped,json=rxPacketsDropped,proto3" json:"rx_packets_dropped,omitempty"`
	// Cumulative count of bytes transmitted.
	TxBytes *UInt64Value `protobuf:"bytes,4,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	// Cumulative count of transmit errors encountered.
	TxPacketsDropped *UInt64Value `protobuf:"bytes,5,opt,name=tx_packets_dropped,json=txPacketsDropped,proto3" json:"tx_packets_dropped,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *WindowsNetworkInterfaceUsage) Reset() {
	*x = WindowsNetworkInterfaceUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsNetworkInterfaceUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsNetworkInterfaceUsage) ProtoMessage() {}

func (x *WindowsNetworkInterfaceUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsNetworkInterfaceUsage.ProtoReflect.Descriptor instead.
func (*WindowsNetworkInterfaceUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{44}
}

func (x *WindowsNetworkInterfaceUsage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WindowsNetworkInterfaceUsage) GetRxBytes() *UInt64Value {
	if x != nil {
		return x.RxBytes
	}
	return nil
}

func (x *WindowsNetworkInterfaceUsage) GetRxPacketsDropped() *UInt64Value {
	if x != nil {
		return x.RxPacketsDropped
	}
	return nil
}

func (x *WindowsNetworkInterfaceUsage) GetTxBytes() *UInt64Value {
	if x != nil {
		return x.TxBytes
	}
	return nil
}

func (x *WindowsNetworkInterfaceUsage) GetTxPacketsDropped() *UInt64Value {
	if x != nil {
		return x.TxPacketsDropped
	}
	return nil
}

// ProcessUsage are stats pertaining to processes.
type ProcessUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Number of processes.
	ProcessCount  *UInt64Value `protobuf:"bytes,2,opt,name=process_count,json=processCount,proto3" json:"process_count,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessUsage) Reset() {
	*x = ProcessUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessUsage) ProtoMessage() {}

func (x *ProcessUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessUsage.ProtoReflect.Descriptor instead.
func (*ProcessUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{45}
}

func (x *ProcessUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *ProcessUsage) GetProcessCount() *UInt64Value {
	if x != nil {
		return x.ProcessCount
	}
	return nil
}

// WindowsProcessUsage are stats pertaining to processes specific to Windows.
type WindowsProcessUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Number of processes.
	ProcessCount  *UInt64Value `protobuf:"bytes,2,opt,name=process_count,json=processCount,proto3" json:"process_count,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WindowsProcessUsage) Reset() {
	*x = WindowsProcessUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsProcessUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsProcessUsage) ProtoMessage() {}

func (x *WindowsProcessUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsProcessUsage.ProtoReflect.Descriptor instead.
func (*WindowsProcessUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{46}
}

func (x *WindowsProcessUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *WindowsProcessUsage) GetProcessCount() *UInt64Value {
	if x != nil {
		return x.ProcessCount
	}
	return nil
}

// ImageSpec is an internal representation of an image.
type ImageSpec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Container's Image field (e.g. imageID or imageDigest).
	Image string `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Unstructured key-value map holding arbitrary metadata.
	// ImageSpec Annotations can be used to help the runtime target specific
	// images in multi-arch images.
	Annotations map[string]string `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The container image reference specified by the user (e.g. image[:tag] or digest).
	// Only set if available within the RPC context.
	UserSpecifiedImage string `protobuf:"bytes,18,opt,name=user_specified_image,json=userSpecifiedImage,proto3" json:"user_specified_image,omitempty"`
	// Runtime handler to use for pulling the image.
	// If the runtime handler is unknown, the request should be rejected.
	// An empty string would select the default runtime handler.
	RuntimeHandler string `protobuf:"bytes,19,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ImageSpec) Reset() {
	*x = ImageSpec{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSpec) ProtoMessage() {}

func (x *ImageSpec) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSpec.ProtoReflect.Descriptor instead.
func (*ImageSpec) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{47}
}

func (x *ImageSpec) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *ImageSpec) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ImageSpec) GetUserSpecifiedImage() string {
	if x != nil {
		return x.UserSpecifiedImage
	}
	return ""
}

func (x *ImageSpec) GetRuntimeHandler() string {
	if x != nil {
		return x.RuntimeHandler
	}
	return ""
}

type KeyValue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value         string                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KeyValue) Reset() {
	*x = KeyValue{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyValue) ProtoMessage() {}

func (x *KeyValue) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyValue.ProtoReflect.Descriptor instead.
func (*KeyValue) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{48}
}

func (x *KeyValue) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *KeyValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// LinuxContainerResources specifies Linux specific configuration for
// resources.
type LinuxContainerResources struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// CPU CFS (Completely Fair Scheduler) period. Default: 0 (not specified).
	CpuPeriod int64 `protobuf:"varint,1,opt,name=cpu_period,json=cpuPeriod,proto3" json:"cpu_period,omitempty"`
	// CPU CFS (Completely Fair Scheduler) quota. Default: 0 (not specified).
	CpuQuota int64 `protobuf:"varint,2,opt,name=cpu_quota,json=cpuQuota,proto3" json:"cpu_quota,omitempty"`
	// CPU shares (relative weight vs. other containers). Default: 0 (not specified).
	CpuShares int64 `protobuf:"varint,3,opt,name=cpu_shares,json=cpuShares,proto3" json:"cpu_shares,omitempty"`
	// Memory limit in bytes. Default: 0 (not specified).
	MemoryLimitInBytes int64 `protobuf:"varint,4,opt,name=memory_limit_in_bytes,json=memoryLimitInBytes,proto3" json:"memory_limit_in_bytes,omitempty"`
	// OOMScoreAdj adjusts the oom-killer score. Default: 0 (not specified).
	OomScoreAdj int64 `protobuf:"varint,5,opt,name=oom_score_adj,json=oomScoreAdj,proto3" json:"oom_score_adj,omitempty"`
	// CpusetCpus constrains the allowed set of logical CPUs. Default: "" (not specified).
	CpusetCpus string `protobuf:"bytes,6,opt,name=cpuset_cpus,json=cpusetCpus,proto3" json:"cpuset_cpus,omitempty"`
	// CpusetMems constrains the allowed set of memory nodes. Default: "" (not specified).
	CpusetMems string `protobuf:"bytes,7,opt,name=cpuset_mems,json=cpusetMems,proto3" json:"cpuset_mems,omitempty"`
	// List of HugepageLimits to limit the HugeTLB usage of container per page size. Default: nil (not specified).
	HugepageLimits []*HugepageLimit `protobuf:"bytes,8,rep,name=hugepage_limits,json=hugepageLimits,proto3" json:"hugepage_limits,omitempty"`
	// Unified resources for cgroup v2. Default: nil (not specified).
	// Each key/value in the map refers to the cgroup v2.
	// e.g. "memory.max": "6937202688" or "io.weight": "default 100".
	Unified map[string]string `protobuf:"bytes,9,rep,name=unified,proto3" json:"unified,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Memory swap limit in bytes. Default 0 (not specified).
	MemorySwapLimitInBytes int64 `protobuf:"varint,10,opt,name=memory_swap_limit_in_bytes,json=memorySwapLimitInBytes,proto3" json:"memory_swap_limit_in_bytes,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *LinuxContainerResources) Reset() {
	*x = LinuxContainerResources{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxContainerResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxContainerResources) ProtoMessage() {}

func (x *LinuxContainerResources) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxContainerResources.ProtoReflect.Descriptor instead.
func (*LinuxContainerResources) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{49}
}

func (x *LinuxContainerResources) GetCpuPeriod() int64 {
	if x != nil {
		return x.CpuPeriod
	}
	return 0
}

func (x *LinuxContainerResources) GetCpuQuota() int64 {
	if x != nil {
		return x.CpuQuota
	}
	return 0
}

func (x *LinuxContainerResources) GetCpuShares() int64 {
	if x != nil {
		return x.CpuShares
	}
	return 0
}

func (x *LinuxContainerResources) GetMemoryLimitInBytes() int64 {
	if x != nil {
		return x.MemoryLimitInBytes
	}
	return 0
}

func (x *LinuxContainerResources) GetOomScoreAdj() int64 {
	if x != nil {
		return x.OomScoreAdj
	}
	return 0
}

func (x *LinuxContainerResources) GetCpusetCpus() string {
	if x != nil {
		return x.CpusetCpus
	}
	return ""
}

func (x *LinuxContainerResources) GetCpusetMems() string {
	if x != nil {
		return x.CpusetMems
	}
	return ""
}

func (x *LinuxContainerResources) GetHugepageLimits() []*HugepageLimit {
	if x != nil {
		return x.HugepageLimits
	}
	return nil
}

func (x *LinuxContainerResources) GetUnified() map[string]string {
	if x != nil {
		return x.Unified
	}
	return nil
}

func (x *LinuxContainerResources) GetMemorySwapLimitInBytes() int64 {
	if x != nil {
		return x.MemorySwapLimitInBytes
	}
	return 0
}

// HugepageLimit corresponds to the file`hugetlb.<hugepagesize>.limit_in_byte` in container level cgroup.
// For example, `PageSize=1GB`, `Limit=1073741824` means setting `1073741824` bytes to hugetlb.1GB.limit_in_bytes.
type HugepageLimit struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The value of PageSize has the format <size><unit-prefix>B (2MB, 1GB),
	// and must match the <hugepagesize> of the corresponding control file found in `hugetlb.<hugepagesize>.limit_in_bytes`.
	// The values of <unit-prefix> are intended to be parsed using base 1024("1KB" = 1024, "1MB" = 1048576, etc).
	PageSize string `protobuf:"bytes,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// limit in bytes of hugepagesize HugeTLB usage.
	Limit         uint64 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HugepageLimit) Reset() {
	*x = HugepageLimit{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HugepageLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HugepageLimit) ProtoMessage() {}

func (x *HugepageLimit) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HugepageLimit.ProtoReflect.Descriptor instead.
func (*HugepageLimit) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{50}
}

func (x *HugepageLimit) GetPageSize() string {
	if x != nil {
		return x.PageSize
	}
	return ""
}

func (x *HugepageLimit) GetLimit() uint64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

// SELinuxOption are the labels to be applied to the container.
type SELinuxOption struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	User          string                 `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	Role          string                 `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	Type          string                 `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	Level         string                 `protobuf:"bytes,4,opt,name=level,proto3" json:"level,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SELinuxOption) Reset() {
	*x = SELinuxOption{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SELinuxOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SELinuxOption) ProtoMessage() {}

func (x *SELinuxOption) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SELinuxOption.ProtoReflect.Descriptor instead.
func (*SELinuxOption) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{51}
}

func (x *SELinuxOption) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *SELinuxOption) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *SELinuxOption) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *SELinuxOption) GetLevel() string {
	if x != nil {
		return x.Level
	}
	return ""
}

// Capability contains the container capabilities to add or drop
// Dropping a capability will drop it from all sets.
// If a capability is added to only the add_capabilities list then it gets added to permitted,
// inheritable, effective and bounding sets, i.e. all sets except the ambient set.
// If a capability is added to only the add_ambient_capabilities list then it gets added to all sets, i.e permitted
// inheritable, effective, bounding and ambient sets.
// If a capability is added to add_capabilities and add_ambient_capabilities lists then it gets added to all sets, i.e.
// permitted, inheritable, effective, bounding and ambient sets.
type Capability struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of capabilities to add.
	AddCapabilities []string `protobuf:"bytes,1,rep,name=add_capabilities,json=addCapabilities,proto3" json:"add_capabilities,omitempty"`
	// List of capabilities to drop.
	DropCapabilities []string `protobuf:"bytes,2,rep,name=drop_capabilities,json=dropCapabilities,proto3" json:"drop_capabilities,omitempty"`
	// List of ambient capabilities to add.
	AddAmbientCapabilities []string `protobuf:"bytes,3,rep,name=add_ambient_capabilities,json=addAmbientCapabilities,proto3" json:"add_ambient_capabilities,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *Capability) Reset() {
	*x = Capability{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Capability) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Capability) ProtoMessage() {}

func (x *Capability) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Capability.ProtoReflect.Descriptor instead.
func (*Capability) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{52}
}

func (x *Capability) GetAddCapabilities() []string {
	if x != nil {
		return x.AddCapabilities
	}
	return nil
}

func (x *Capability) GetDropCapabilities() []string {
	if x != nil {
		return x.DropCapabilities
	}
	return nil
}

func (x *Capability) GetAddAmbientCapabilities() []string {
	if x != nil {
		return x.AddAmbientCapabilities
	}
	return nil
}

// LinuxContainerSecurityContext holds linux security configuration that will be applied to a container.
type LinuxContainerSecurityContext struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Capabilities to add or drop.
	Capabilities *Capability `protobuf:"bytes,1,opt,name=capabilities,proto3" json:"capabilities,omitempty"`
	// If set, run container in privileged mode.
	// Privileged mode is incompatible with the following options. If
	// privileged is set, the following features MAY have no effect:
	// 1. capabilities
	// 2. selinux_options
	// 4. seccomp
	// 5. apparmor
	//
	// Privileged mode implies the following specific options are applied:
	// 1. All capabilities are added.
	// 2. Sensitive paths, such as kernel module paths within sysfs, are not masked.
	// 3. Any sysfs and procfs mounts are mounted RW.
	// 4. AppArmor confinement is not applied.
	// 5. Seccomp restrictions are not applied.
	// 6. The device cgroup does not restrict access to any devices.
	// 7. All devices from the host's /dev are available within the container.
	// 8. SELinux restrictions are not applied (e.g. label=disabled).
	Privileged bool `protobuf:"varint,2,opt,name=privileged,proto3" json:"privileged,omitempty"`
	// Configurations for the container's namespaces.
	// Only used if the container uses namespace for isolation.
	NamespaceOptions *NamespaceOption `protobuf:"bytes,3,opt,name=namespace_options,json=namespaceOptions,proto3" json:"namespace_options,omitempty"`
	// SELinux context to be optionally applied.
	SelinuxOptions *SELinuxOption `protobuf:"bytes,4,opt,name=selinux_options,json=selinuxOptions,proto3" json:"selinux_options,omitempty"`
	// UID to run the container process as. Only one of run_as_user and
	// run_as_username can be specified at a time.
	RunAsUser *Int64Value `protobuf:"bytes,5,opt,name=run_as_user,json=runAsUser,proto3" json:"run_as_user,omitempty"`
	// GID to run the container process as. run_as_group should only be specified
	// when run_as_user or run_as_username is specified; otherwise, the runtime
	// MUST error.
	RunAsGroup *Int64Value `protobuf:"bytes,12,opt,name=run_as_group,json=runAsGroup,proto3" json:"run_as_group,omitempty"`
	// User name to run the container process as. If specified, the user MUST
	// exist in the container image (i.e. in the /etc/passwd inside the image),
	// and be resolved there by the runtime; otherwise, the runtime MUST error.
	RunAsUsername string `protobuf:"bytes,6,opt,name=run_as_username,json=runAsUsername,proto3" json:"run_as_username,omitempty"`
	// If set, the root filesystem of the container is read-only.
	ReadonlyRootfs bool `protobuf:"varint,7,opt,name=readonly_rootfs,json=readonlyRootfs,proto3" json:"readonly_rootfs,omitempty"`
	// List of groups applied to the first process run in each container.
	// supplemental_groups_policy can control how groups will be calculated.
	SupplementalGroups []int64 `protobuf:"varint,8,rep,packed,name=supplemental_groups,json=supplementalGroups,proto3" json:"supplemental_groups,omitempty"`
	// supplemental_groups_policy defines how supplemental groups of the first
	// container processes are calculated.
	// Valid values are "Merge" and "Strict".
	// If not specified, "Merge" is used.
	SupplementalGroupsPolicy SupplementalGroupsPolicy `protobuf:"varint,17,opt,name=supplemental_groups_policy,json=supplementalGroupsPolicy,proto3,enum=runtime.v1.SupplementalGroupsPolicy" json:"supplemental_groups_policy,omitempty"`
	// no_new_privs defines if the flag for no_new_privs should be set on the
	// container.
	NoNewPrivs bool `protobuf:"varint,11,opt,name=no_new_privs,json=noNewPrivs,proto3" json:"no_new_privs,omitempty"`
	// masked_paths is a slice of paths that should be masked by the container
	// runtime, this can be passed directly to the OCI spec.
	MaskedPaths []string `protobuf:"bytes,13,rep,name=masked_paths,json=maskedPaths,proto3" json:"masked_paths,omitempty"`
	// readonly_paths is a slice of paths that should be set as readonly by the
	// container runtime, this can be passed directly to the OCI spec.
	ReadonlyPaths []string `protobuf:"bytes,14,rep,name=readonly_paths,json=readonlyPaths,proto3" json:"readonly_paths,omitempty"`
	// Seccomp profile for the container.
	Seccomp *SecurityProfile `protobuf:"bytes,15,opt,name=seccomp,proto3" json:"seccomp,omitempty"`
	// AppArmor profile for the container.
	Apparmor *SecurityProfile `protobuf:"bytes,16,opt,name=apparmor,proto3" json:"apparmor,omitempty"`
	// AppArmor profile for the container, candidate values are:
	//   - runtime/default: equivalent to not specifying a profile.
	//   - unconfined: no profiles are loaded
	//   - localhost/<profile_name>: profile loaded on the node
	//     (localhost) by name. The possible profile names are detailed at
	//     https://gitlab.com/apparmor/apparmor/-/wikis/AppArmor_Core_Policy_Reference
	//
	// Deprecated: Marked as deprecated in staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto.
	ApparmorProfile string `protobuf:"bytes,9,opt,name=apparmor_profile,json=apparmorProfile,proto3" json:"apparmor_profile,omitempty"`
	// Seccomp profile for the container, candidate values are:
	//   - runtime/default: the default profile for the container runtime
	//   - unconfined: unconfined profile, ie, no seccomp sandboxing
	//   - localhost/<full-path-to-profile>: the profile installed on the node.
	//     <full-path-to-profile> is the full path of the profile.
	//
	// Default: "", which is identical with unconfined.
	//
	// Deprecated: Marked as deprecated in staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto.
	SeccompProfilePath string `protobuf:"bytes,10,opt,name=seccomp_profile_path,json=seccompProfilePath,proto3" json:"seccomp_profile_path,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *LinuxContainerSecurityContext) Reset() {
	*x = LinuxContainerSecurityContext{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxContainerSecurityContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxContainerSecurityContext) ProtoMessage() {}

func (x *LinuxContainerSecurityContext) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxContainerSecurityContext.ProtoReflect.Descriptor instead.
func (*LinuxContainerSecurityContext) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{53}
}

func (x *LinuxContainerSecurityContext) GetCapabilities() *Capability {
	if x != nil {
		return x.Capabilities
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetPrivileged() bool {
	if x != nil {
		return x.Privileged
	}
	return false
}

func (x *LinuxContainerSecurityContext) GetNamespaceOptions() *NamespaceOption {
	if x != nil {
		return x.NamespaceOptions
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetSelinuxOptions() *SELinuxOption {
	if x != nil {
		return x.SelinuxOptions
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetRunAsUser() *Int64Value {
	if x != nil {
		return x.RunAsUser
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetRunAsGroup() *Int64Value {
	if x != nil {
		return x.RunAsGroup
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetRunAsUsername() string {
	if x != nil {
		return x.RunAsUsername
	}
	return ""
}

func (x *LinuxContainerSecurityContext) GetReadonlyRootfs() bool {
	if x != nil {
		return x.ReadonlyRootfs
	}
	return false
}

func (x *LinuxContainerSecurityContext) GetSupplementalGroups() []int64 {
	if x != nil {
		return x.SupplementalGroups
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetSupplementalGroupsPolicy() SupplementalGroupsPolicy {
	if x != nil {
		return x.SupplementalGroupsPolicy
	}
	return SupplementalGroupsPolicy_Merge
}

func (x *LinuxContainerSecurityContext) GetNoNewPrivs() bool {
	if x != nil {
		return x.NoNewPrivs
	}
	return false
}

func (x *LinuxContainerSecurityContext) GetMaskedPaths() []string {
	if x != nil {
		return x.MaskedPaths
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetReadonlyPaths() []string {
	if x != nil {
		return x.ReadonlyPaths
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetSeccomp() *SecurityProfile {
	if x != nil {
		return x.Seccomp
	}
	return nil
}

func (x *LinuxContainerSecurityContext) GetApparmor() *SecurityProfile {
	if x != nil {
		return x.Apparmor
	}
	return nil
}

// Deprecated: Marked as deprecated in staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto.
func (x *LinuxContainerSecurityContext) GetApparmorProfile() string {
	if x != nil {
		return x.ApparmorProfile
	}
	return ""
}

// Deprecated: Marked as deprecated in staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto.
func (x *LinuxContainerSecurityContext) GetSeccompProfilePath() string {
	if x != nil {
		return x.SeccompProfilePath
	}
	return ""
}

// LinuxContainerConfig contains platform-specific configuration for
// Linux-based containers.
type LinuxContainerConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resources specification for the container.
	Resources *LinuxContainerResources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// LinuxContainerSecurityContext configuration for the container.
	SecurityContext *LinuxContainerSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *LinuxContainerConfig) Reset() {
	*x = LinuxContainerConfig{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxContainerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxContainerConfig) ProtoMessage() {}

func (x *LinuxContainerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxContainerConfig.ProtoReflect.Descriptor instead.
func (*LinuxContainerConfig) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{54}
}

func (x *LinuxContainerConfig) GetResources() *LinuxContainerResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *LinuxContainerConfig) GetSecurityContext() *LinuxContainerSecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

type LinuxContainerUser struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// uid is the primary uid initially attached to the first process in the container
	Uid int64 `protobuf:"varint,1,opt,name=uid,proto3" json:"uid,omitempty"`
	// gid is the primary gid initially attached to the first process in the container
	Gid int64 `protobuf:"varint,2,opt,name=gid,proto3" json:"gid,omitempty"`
	// supplemental_groups are the supplemental groups initially attached to the first process in the container
	SupplementalGroups []int64 `protobuf:"varint,3,rep,packed,name=supplemental_groups,json=supplementalGroups,proto3" json:"supplemental_groups,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *LinuxContainerUser) Reset() {
	*x = LinuxContainerUser{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxContainerUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxContainerUser) ProtoMessage() {}

func (x *LinuxContainerUser) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxContainerUser.ProtoReflect.Descriptor instead.
func (*LinuxContainerUser) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{55}
}

func (x *LinuxContainerUser) GetUid() int64 {
	if x != nil {
		return x.Uid
	}
	return 0
}

func (x *LinuxContainerUser) GetGid() int64 {
	if x != nil {
		return x.Gid
	}
	return 0
}

func (x *LinuxContainerUser) GetSupplementalGroups() []int64 {
	if x != nil {
		return x.SupplementalGroups
	}
	return nil
}

// WindowsNamespaceOption provides options for Windows namespaces.
type WindowsNamespaceOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Network namespace for this container/sandbox.
	// This is currently never set by the kubelet
	Network       NamespaceMode `protobuf:"varint,1,opt,name=network,proto3,enum=runtime.v1.NamespaceMode" json:"network,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WindowsNamespaceOption) Reset() {
	*x = WindowsNamespaceOption{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsNamespaceOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsNamespaceOption) ProtoMessage() {}

func (x *WindowsNamespaceOption) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsNamespaceOption.ProtoReflect.Descriptor instead.
func (*WindowsNamespaceOption) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{56}
}

func (x *WindowsNamespaceOption) GetNetwork() NamespaceMode {
	if x != nil {
		return x.Network
	}
	return NamespaceMode_POD
}

// WindowsSandboxSecurityContext holds platform-specific configurations that will be
// applied to a sandbox.
// These settings will only apply to the sandbox container.
type WindowsSandboxSecurityContext struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// User name to run the container process as. If specified, the user MUST
	// exist in the container image and be resolved there by the runtime;
	// otherwise, the runtime MUST return error.
	RunAsUsername string `protobuf:"bytes,1,opt,name=run_as_username,json=runAsUsername,proto3" json:"run_as_username,omitempty"`
	// The contents of the GMSA credential spec to use to run this container.
	CredentialSpec string `protobuf:"bytes,2,opt,name=credential_spec,json=credentialSpec,proto3" json:"credential_spec,omitempty"`
	// Indicates whether the container requested to run as a HostProcess container.
	HostProcess bool `protobuf:"varint,3,opt,name=host_process,json=hostProcess,proto3" json:"host_process,omitempty"`
	// Configuration for the sandbox's namespaces
	NamespaceOptions *WindowsNamespaceOption `protobuf:"bytes,4,opt,name=namespace_options,json=namespaceOptions,proto3" json:"namespace_options,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *WindowsSandboxSecurityContext) Reset() {
	*x = WindowsSandboxSecurityContext{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsSandboxSecurityContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsSandboxSecurityContext) ProtoMessage() {}

func (x *WindowsSandboxSecurityContext) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsSandboxSecurityContext.ProtoReflect.Descriptor instead.
func (*WindowsSandboxSecurityContext) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{57}
}

func (x *WindowsSandboxSecurityContext) GetRunAsUsername() string {
	if x != nil {
		return x.RunAsUsername
	}
	return ""
}

func (x *WindowsSandboxSecurityContext) GetCredentialSpec() string {
	if x != nil {
		return x.CredentialSpec
	}
	return ""
}

func (x *WindowsSandboxSecurityContext) GetHostProcess() bool {
	if x != nil {
		return x.HostProcess
	}
	return false
}

func (x *WindowsSandboxSecurityContext) GetNamespaceOptions() *WindowsNamespaceOption {
	if x != nil {
		return x.NamespaceOptions
	}
	return nil
}

// WindowsPodSandboxConfig holds platform-specific configurations for Windows
// host platforms and Windows-based containers.
type WindowsPodSandboxConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// WindowsSandboxSecurityContext holds sandbox security attributes.
	SecurityContext *WindowsSandboxSecurityContext `protobuf:"bytes,1,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *WindowsPodSandboxConfig) Reset() {
	*x = WindowsPodSandboxConfig{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsPodSandboxConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsPodSandboxConfig) ProtoMessage() {}

func (x *WindowsPodSandboxConfig) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsPodSandboxConfig.ProtoReflect.Descriptor instead.
func (*WindowsPodSandboxConfig) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{58}
}

func (x *WindowsPodSandboxConfig) GetSecurityContext() *WindowsSandboxSecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

// WindowsContainerSecurityContext holds windows security configuration that will be applied to a container.
type WindowsContainerSecurityContext struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// User name to run the container process as. If specified, the user MUST
	// exist in the container image and be resolved there by the runtime;
	// otherwise, the runtime MUST return error.
	RunAsUsername string `protobuf:"bytes,1,opt,name=run_as_username,json=runAsUsername,proto3" json:"run_as_username,omitempty"`
	// The contents of the GMSA credential spec to use to run this container.
	CredentialSpec string `protobuf:"bytes,2,opt,name=credential_spec,json=credentialSpec,proto3" json:"credential_spec,omitempty"`
	// Indicates whether a container is to be run as a HostProcess container.
	HostProcess   bool `protobuf:"varint,3,opt,name=host_process,json=hostProcess,proto3" json:"host_process,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WindowsContainerSecurityContext) Reset() {
	*x = WindowsContainerSecurityContext{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsContainerSecurityContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsContainerSecurityContext) ProtoMessage() {}

func (x *WindowsContainerSecurityContext) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsContainerSecurityContext.ProtoReflect.Descriptor instead.
func (*WindowsContainerSecurityContext) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{59}
}

func (x *WindowsContainerSecurityContext) GetRunAsUsername() string {
	if x != nil {
		return x.RunAsUsername
	}
	return ""
}

func (x *WindowsContainerSecurityContext) GetCredentialSpec() string {
	if x != nil {
		return x.CredentialSpec
	}
	return ""
}

func (x *WindowsContainerSecurityContext) GetHostProcess() bool {
	if x != nil {
		return x.HostProcess
	}
	return false
}

// WindowsContainerConfig contains platform-specific configuration for
// Windows-based containers.
type WindowsContainerConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resources specification for the container.
	Resources *WindowsContainerResources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// WindowsContainerSecurityContext configuration for the container.
	SecurityContext *WindowsContainerSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *WindowsContainerConfig) Reset() {
	*x = WindowsContainerConfig{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsContainerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsContainerConfig) ProtoMessage() {}

func (x *WindowsContainerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsContainerConfig.ProtoReflect.Descriptor instead.
func (*WindowsContainerConfig) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{60}
}

func (x *WindowsContainerConfig) GetResources() *WindowsContainerResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *WindowsContainerConfig) GetSecurityContext() *WindowsContainerSecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

// WindowsContainerResources specifies Windows specific configuration for
// resources.
type WindowsContainerResources struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// CPU shares (relative weight vs. other containers). Default: 0 (not specified).
	CpuShares int64 `protobuf:"varint,1,opt,name=cpu_shares,json=cpuShares,proto3" json:"cpu_shares,omitempty"`
	// Number of CPUs available to the container. Default: 0 (not specified).
	CpuCount int64 `protobuf:"varint,2,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
	// Specifies the portion of processor cycles that this container can use as a percentage times 100.
	CpuMaximum int64 `protobuf:"varint,3,opt,name=cpu_maximum,json=cpuMaximum,proto3" json:"cpu_maximum,omitempty"`
	// Memory limit in bytes. Default: 0 (not specified).
	MemoryLimitInBytes int64 `protobuf:"varint,4,opt,name=memory_limit_in_bytes,json=memoryLimitInBytes,proto3" json:"memory_limit_in_bytes,omitempty"`
	// Specifies the size of the rootfs / scratch space in bytes to be configured for this container. Default: 0 (not specified).
	RootfsSizeInBytes int64 `protobuf:"varint,5,opt,name=rootfs_size_in_bytes,json=rootfsSizeInBytes,proto3" json:"rootfs_size_in_bytes,omitempty"`
	// Optionally specifies the set of CPUs to affinitize for this container.
	AffinityCpus  []*WindowsCpuGroupAffinity `protobuf:"bytes,6,rep,name=affinity_cpus,json=affinityCpus,proto3" json:"affinity_cpus,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WindowsContainerResources) Reset() {
	*x = WindowsContainerResources{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsContainerResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsContainerResources) ProtoMessage() {}

func (x *WindowsContainerResources) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsContainerResources.ProtoReflect.Descriptor instead.
func (*WindowsContainerResources) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{61}
}

func (x *WindowsContainerResources) GetCpuShares() int64 {
	if x != nil {
		return x.CpuShares
	}
	return 0
}

func (x *WindowsContainerResources) GetCpuCount() int64 {
	if x != nil {
		return x.CpuCount
	}
	return 0
}

func (x *WindowsContainerResources) GetCpuMaximum() int64 {
	if x != nil {
		return x.CpuMaximum
	}
	return 0
}

func (x *WindowsContainerResources) GetMemoryLimitInBytes() int64 {
	if x != nil {
		return x.MemoryLimitInBytes
	}
	return 0
}

func (x *WindowsContainerResources) GetRootfsSizeInBytes() int64 {
	if x != nil {
		return x.RootfsSizeInBytes
	}
	return 0
}

func (x *WindowsContainerResources) GetAffinityCpus() []*WindowsCpuGroupAffinity {
	if x != nil {
		return x.AffinityCpus
	}
	return nil
}

// WindowsCpuGroupAffinity specifies the CPU mask and group to affinitize.
// This is similar to the following _GROUP_AFFINITY structure:
// https://learn.microsoft.com/en-us/windows-hardware/drivers/ddi/miniport/ns-miniport-_group_affinity
type WindowsCpuGroupAffinity struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// CPU mask relative to this CPU group.
	CpuMask uint64 `protobuf:"varint,1,opt,name=cpu_mask,json=cpuMask,proto3" json:"cpu_mask,omitempty"`
	// Processor group the mask refers to, as returned by
	// GetLogicalProcessorInformationEx.
	CpuGroup      uint32 `protobuf:"varint,2,opt,name=cpu_group,json=cpuGroup,proto3" json:"cpu_group,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WindowsCpuGroupAffinity) Reset() {
	*x = WindowsCpuGroupAffinity{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsCpuGroupAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsCpuGroupAffinity) ProtoMessage() {}

func (x *WindowsCpuGroupAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsCpuGroupAffinity.ProtoReflect.Descriptor instead.
func (*WindowsCpuGroupAffinity) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{62}
}

func (x *WindowsCpuGroupAffinity) GetCpuMask() uint64 {
	if x != nil {
		return x.CpuMask
	}
	return 0
}

func (x *WindowsCpuGroupAffinity) GetCpuGroup() uint32 {
	if x != nil {
		return x.CpuGroup
	}
	return 0
}

// ContainerMetadata holds all necessary information for building the container
// name. The container runtime is encouraged to expose the metadata in its user
// interface for better user experience. E.g., runtime can construct a unique
// container name based on the metadata. Note that (name, attempt) is unique
// within a sandbox for the entire lifetime of the sandbox.
type ContainerMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the container. Same as the container name in the PodSpec.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Attempt number of creating the container. Default: 0.
	Attempt       uint32 `protobuf:"varint,2,opt,name=attempt,proto3" json:"attempt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerMetadata) Reset() {
	*x = ContainerMetadata{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerMetadata) ProtoMessage() {}

func (x *ContainerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerMetadata.ProtoReflect.Descriptor instead.
func (*ContainerMetadata) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{63}
}

func (x *ContainerMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ContainerMetadata) GetAttempt() uint32 {
	if x != nil {
		return x.Attempt
	}
	return 0
}

// Device specifies a host device to mount into a container.
type Device struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Path of the device within the container.
	ContainerPath string `protobuf:"bytes,1,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Path of the device on the host.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// Cgroups permissions of the device, candidates are one or more of
	// * r - allows container to read from the specified device.
	// * w - allows container to write to the specified device.
	// * m - allows container to create device files that do not yet exist.
	Permissions   string `protobuf:"bytes,3,opt,name=permissions,proto3" json:"permissions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Device) Reset() {
	*x = Device{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Device) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Device) ProtoMessage() {}

func (x *Device) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Device.ProtoReflect.Descriptor instead.
func (*Device) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{64}
}

func (x *Device) GetContainerPath() string {
	if x != nil {
		return x.ContainerPath
	}
	return ""
}

func (x *Device) GetHostPath() string {
	if x != nil {
		return x.HostPath
	}
	return ""
}

func (x *Device) GetPermissions() string {
	if x != nil {
		return x.Permissions
	}
	return ""
}

// CDIDevice specifies a CDI device information.
type CDIDevice struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Fully qualified CDI device name
	// for example: vendor.com/gpu=gpudevice1
	// see more details in the CDI specification:
	// https://github.com/container-orchestrated-devices/container-device-interface/blob/main/SPEC.md
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CDIDevice) Reset() {
	*x = CDIDevice{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CDIDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CDIDevice) ProtoMessage() {}

func (x *CDIDevice) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CDIDevice.ProtoReflect.Descriptor instead.
func (*CDIDevice) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{65}
}

func (x *CDIDevice) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ContainerConfig holds all the required and optional fields for creating a
// container.
type ContainerConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Metadata of the container. This information will uniquely identify the
	// container, and the runtime should leverage this to ensure correct
	// operation. The runtime may also use this information to improve UX, such
	// as by constructing a readable name.
	Metadata *ContainerMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Image to use.
	Image *ImageSpec `protobuf:"bytes,2,opt,name=image,proto3" json:"image,omitempty"`
	// Command to execute (i.e., entrypoint for docker)
	Command []string `protobuf:"bytes,3,rep,name=command,proto3" json:"command,omitempty"`
	// Args for the Command (i.e., command for docker)
	Args []string `protobuf:"bytes,4,rep,name=args,proto3" json:"args,omitempty"`
	// Current working directory of the command.
	WorkingDir string `protobuf:"bytes,5,opt,name=working_dir,json=workingDir,proto3" json:"working_dir,omitempty"`
	// List of environment variable to set in the container.
	Envs []*KeyValue `protobuf:"bytes,6,rep,name=envs,proto3" json:"envs,omitempty"`
	// Mounts for the container.
	Mounts []*Mount `protobuf:"bytes,7,rep,name=mounts,proto3" json:"mounts,omitempty"`
	// Devices for the container.
	Devices []*Device `protobuf:"bytes,8,rep,name=devices,proto3" json:"devices,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	// Label keys are of the form:
	//
	//	label-key ::= prefixed-name | name
	//	prefixed-name ::= prefix '/' name
	//	prefix ::= DNS_SUBDOMAIN
	//	name ::= DNS_LABEL
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Unstructured key-value map that may be used by the kubelet to store and
	// retrieve arbitrary metadata.
	//
	// Annotations MUST NOT be altered by the runtime; the annotations stored
	// here MUST be returned in the ContainerStatus associated with the container
	// this ContainerConfig creates.
	//
	// In general, in order to preserve a well-defined interface between the
	// kubelet and the container runtime, annotations SHOULD NOT influence
	// runtime behaviour.
	Annotations map[string]string `protobuf:"bytes,10,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Path relative to PodSandboxConfig.LogDirectory for container to store
	// the log (STDOUT and STDERR) on the host.
	// E.g.,
	//
	//	PodSandboxConfig.LogDirectory = `/var/log/pods/<NAMESPACE>_<NAME>_<UID>/`
	//	ContainerConfig.LogPath = `containerName/Instance#.log`
	LogPath string `protobuf:"bytes,11,opt,name=log_path,json=logPath,proto3" json:"log_path,omitempty"`
	// Variables for interactive containers, these have very specialized
	// use-cases (e.g. debugging).
	Stdin     bool `protobuf:"varint,12,opt,name=stdin,proto3" json:"stdin,omitempty"`
	StdinOnce bool `protobuf:"varint,13,opt,name=stdin_once,json=stdinOnce,proto3" json:"stdin_once,omitempty"`
	Tty       bool `protobuf:"varint,14,opt,name=tty,proto3" json:"tty,omitempty"`
	// Configuration specific to Linux containers.
	Linux *LinuxContainerConfig `protobuf:"bytes,15,opt,name=linux,proto3" json:"linux,omitempty"`
	// Configuration specific to Windows containers.
	Windows *WindowsContainerConfig `protobuf:"bytes,16,opt,name=windows,proto3" json:"windows,omitempty"`
	// CDI devices for the container.
	CDIDevices []*CDIDevice `protobuf:"bytes,17,rep,name=CDI_devices,json=CDIDevices,proto3" json:"CDI_devices,omitempty"`
	// The custom stop signal for the container
	StopSignal    Signal `protobuf:"varint,18,opt,name=stop_signal,json=stopSignal,proto3,enum=runtime.v1.Signal" json:"stop_signal,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerConfig) Reset() {
	*x = ContainerConfig{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerConfig) ProtoMessage() {}

func (x *ContainerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerConfig.ProtoReflect.Descriptor instead.
func (*ContainerConfig) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{66}
}

func (x *ContainerConfig) GetMetadata() *ContainerMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ContainerConfig) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *ContainerConfig) GetCommand() []string {
	if x != nil {
		return x.Command
	}
	return nil
}

func (x *ContainerConfig) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ContainerConfig) GetWorkingDir() string {
	if x != nil {
		return x.WorkingDir
	}
	return ""
}

func (x *ContainerConfig) GetEnvs() []*KeyValue {
	if x != nil {
		return x.Envs
	}
	return nil
}

func (x *ContainerConfig) GetMounts() []*Mount {
	if x != nil {
		return x.Mounts
	}
	return nil
}

func (x *ContainerConfig) GetDevices() []*Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *ContainerConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ContainerConfig) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ContainerConfig) GetLogPath() string {
	if x != nil {
		return x.LogPath
	}
	return ""
}

func (x *ContainerConfig) GetStdin() bool {
	if x != nil {
		return x.Stdin
	}
	return false
}

func (x *ContainerConfig) GetStdinOnce() bool {
	if x != nil {
		return x.StdinOnce
	}
	return false
}

func (x *ContainerConfig) GetTty() bool {
	if x != nil {
		return x.Tty
	}
	return false
}

func (x *ContainerConfig) GetLinux() *LinuxContainerConfig {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *ContainerConfig) GetWindows() *WindowsContainerConfig {
	if x != nil {
		return x.Windows
	}
	return nil
}

func (x *ContainerConfig) GetCDIDevices() []*CDIDevice {
	if x != nil {
		return x.CDIDevices
	}
	return nil
}

func (x *ContainerConfig) GetStopSignal() Signal {
	if x != nil {
		return x.StopSignal
	}
	return Signal_RUNTIME_DEFAULT
}

type CreateContainerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the PodSandbox in which the container should be created.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Config of the container.
	Config *ContainerConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Config of the PodSandbox. This is the same config that was passed
	// to RunPodSandboxRequest to create the PodSandbox. It is passed again
	// here just for easy reference. The PodSandboxConfig is immutable and
	// remains the same throughout the lifetime of the pod.
	SandboxConfig *PodSandboxConfig `protobuf:"bytes,3,opt,name=sandbox_config,json=sandboxConfig,proto3" json:"sandbox_config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateContainerRequest) Reset() {
	*x = CreateContainerRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateContainerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateContainerRequest) ProtoMessage() {}

func (x *CreateContainerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateContainerRequest.ProtoReflect.Descriptor instead.
func (*CreateContainerRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{67}
}

func (x *CreateContainerRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *CreateContainerRequest) GetConfig() *ContainerConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *CreateContainerRequest) GetSandboxConfig() *PodSandboxConfig {
	if x != nil {
		return x.SandboxConfig
	}
	return nil
}

type CreateContainerResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the created container.
	ContainerId   string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateContainerResponse) Reset() {
	*x = CreateContainerResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateContainerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateContainerResponse) ProtoMessage() {}

func (x *CreateContainerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateContainerResponse.ProtoReflect.Descriptor instead.
func (*CreateContainerResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{68}
}

func (x *CreateContainerResponse) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type StartContainerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container to start.
	ContainerId   string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StartContainerRequest) Reset() {
	*x = StartContainerRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartContainerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartContainerRequest) ProtoMessage() {}

func (x *StartContainerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartContainerRequest.ProtoReflect.Descriptor instead.
func (*StartContainerRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{69}
}

func (x *StartContainerRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type StartContainerResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StartContainerResponse) Reset() {
	*x = StartContainerResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartContainerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartContainerResponse) ProtoMessage() {}

func (x *StartContainerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartContainerResponse.ProtoReflect.Descriptor instead.
func (*StartContainerResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{70}
}

type StopContainerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container to stop.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Timeout in seconds to wait for the container to stop before forcibly
	// terminating it. Default: 0 (forcibly terminate the container immediately)
	Timeout       int64 `protobuf:"varint,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopContainerRequest) Reset() {
	*x = StopContainerRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopContainerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopContainerRequest) ProtoMessage() {}

func (x *StopContainerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopContainerRequest.ProtoReflect.Descriptor instead.
func (*StopContainerRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{71}
}

func (x *StopContainerRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *StopContainerRequest) GetTimeout() int64 {
	if x != nil {
		return x.Timeout
	}
	return 0
}

type StopContainerResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopContainerResponse) Reset() {
	*x = StopContainerResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopContainerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopContainerResponse) ProtoMessage() {}

func (x *StopContainerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopContainerResponse.ProtoReflect.Descriptor instead.
func (*StopContainerResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{72}
}

type RemoveContainerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container to remove.
	ContainerId   string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemoveContainerRequest) Reset() {
	*x = RemoveContainerRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveContainerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveContainerRequest) ProtoMessage() {}

func (x *RemoveContainerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveContainerRequest.ProtoReflect.Descriptor instead.
func (*RemoveContainerRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{73}
}

func (x *RemoveContainerRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type RemoveContainerResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemoveContainerResponse) Reset() {
	*x = RemoveContainerResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveContainerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveContainerResponse) ProtoMessage() {}

func (x *RemoveContainerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveContainerResponse.ProtoReflect.Descriptor instead.
func (*RemoveContainerResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{74}
}

// ContainerStateValue is the wrapper of ContainerState.
type ContainerStateValue struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// State of the container.
	State         ContainerState `protobuf:"varint,1,opt,name=state,proto3,enum=runtime.v1.ContainerState" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerStateValue) Reset() {
	*x = ContainerStateValue{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerStateValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStateValue) ProtoMessage() {}

func (x *ContainerStateValue) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStateValue.ProtoReflect.Descriptor instead.
func (*ContainerStateValue) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{75}
}

func (x *ContainerStateValue) GetState() ContainerState {
	if x != nil {
		return x.State
	}
	return ContainerState_CONTAINER_CREATED
}

// ContainerFilter is used to filter containers.
// All those fields are combined with 'AND'
type ContainerFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// State of the container.
	State *ContainerStateValue `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// ID of the PodSandbox.
	PodSandboxId string `protobuf:"bytes,3,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector map[string]string `protobuf:"bytes,4,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerFilter) Reset() {
	*x = ContainerFilter{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerFilter) ProtoMessage() {}

func (x *ContainerFilter) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerFilter.ProtoReflect.Descriptor instead.
func (*ContainerFilter) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{76}
}

func (x *ContainerFilter) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ContainerFilter) GetState() *ContainerStateValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *ContainerFilter) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *ContainerFilter) GetLabelSelector() map[string]string {
	if x != nil {
		return x.LabelSelector
	}
	return nil
}

type ListContainersRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Filter        *ContainerFilter       `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListContainersRequest) Reset() {
	*x = ListContainersRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListContainersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListContainersRequest) ProtoMessage() {}

func (x *ListContainersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListContainersRequest.ProtoReflect.Descriptor instead.
func (*ListContainersRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{77}
}

func (x *ListContainersRequest) GetFilter() *ContainerFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// Container provides the runtime information for a container, such as ID, hash,
// state of the container.
type Container struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container, used by the container runtime to identify
	// a container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the sandbox to which this container belongs.
	PodSandboxId string `protobuf:"bytes,2,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// Digested reference to the image in use.
	ImageRef string `protobuf:"bytes,5,opt,name=image_ref,json=imageRef,proto3" json:"image_ref,omitempty"`
	// State of the container.
	State ContainerState `protobuf:"varint,6,opt,name=state,proto3,enum=runtime.v1.ContainerState" json:"state,omitempty"`
	// Creation time of the container in nanoseconds.
	CreatedAt int64 `protobuf:"varint,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding ContainerConfig used to
	// instantiate this Container.
	Annotations map[string]string `protobuf:"bytes,9,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Reference to the unique identifier of the image, on the node, as
	// returned in the image service apis.
	//
	// Note: The image_ref above has been historically used by container
	// runtimes to reference images by digest. The image_ref has been also used
	// in the kubelet image garbage collection, which does not work with
	// digests at all. To separate and avoid possible misusage, we now
	// introduce the image_id field, which should always refer to a unique
	// image identifier on the node.
	ImageId       string `protobuf:"bytes,10,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Container) Reset() {
	*x = Container{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Container) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Container) ProtoMessage() {}

func (x *Container) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Container.ProtoReflect.Descriptor instead.
func (*Container) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{78}
}

func (x *Container) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Container) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *Container) GetMetadata() *ContainerMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Container) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *Container) GetImageRef() string {
	if x != nil {
		return x.ImageRef
	}
	return ""
}

func (x *Container) GetState() ContainerState {
	if x != nil {
		return x.State
	}
	return ContainerState_CONTAINER_CREATED
}

func (x *Container) GetCreatedAt() int64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *Container) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Container) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Container) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

type ListContainersResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of containers.
	Containers    []*Container `protobuf:"bytes,1,rep,name=containers,proto3" json:"containers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListContainersResponse) Reset() {
	*x = ListContainersResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListContainersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListContainersResponse) ProtoMessage() {}

func (x *ListContainersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListContainersResponse.ProtoReflect.Descriptor instead.
func (*ListContainersResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{79}
}

func (x *ListContainersResponse) GetContainers() []*Container {
	if x != nil {
		return x.Containers
	}
	return nil
}

type ContainerStatusRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container for which to retrieve status.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Verbose indicates whether to return extra information about the container.
	Verbose       bool `protobuf:"varint,2,opt,name=verbose,proto3" json:"verbose,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerStatusRequest) Reset() {
	*x = ContainerStatusRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatusRequest) ProtoMessage() {}

func (x *ContainerStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatusRequest.ProtoReflect.Descriptor instead.
func (*ContainerStatusRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{80}
}

func (x *ContainerStatusRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *ContainerStatusRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

// ContainerStatus represents the status of a container.
type ContainerStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Status of the container.
	State ContainerState `protobuf:"varint,3,opt,name=state,proto3,enum=runtime.v1.ContainerState" json:"state,omitempty"`
	// Creation time of the container in nanoseconds.
	CreatedAt int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Start time of the container in nanoseconds. Default: 0 (not specified).
	StartedAt int64 `protobuf:"varint,5,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	// Finish time of the container in nanoseconds. Default: 0 (not specified).
	FinishedAt int64 `protobuf:"varint,6,opt,name=finished_at,json=finishedAt,proto3" json:"finished_at,omitempty"`
	// Exit code of the container. Only required when finished_at != 0. Default: 0.
	ExitCode int32 `protobuf:"varint,7,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,8,opt,name=image,proto3" json:"image,omitempty"`
	// Digested reference to the image in use.
	ImageRef string `protobuf:"bytes,9,opt,name=image_ref,json=imageRef,proto3" json:"image_ref,omitempty"`
	// Brief CamelCase string explaining why container is in its current state.
	// Must be set to "OOMKilled" for containers terminated by cgroup-based Out-of-Memory killer.
	Reason string `protobuf:"bytes,10,opt,name=reason,proto3" json:"reason,omitempty"`
	// Human-readable message indicating details about why container is in its
	// current state.
	Message string `protobuf:"bytes,11,opt,name=message,proto3" json:"message,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding ContainerConfig used to
	// instantiate the Container this status represents.
	Annotations map[string]string `protobuf:"bytes,13,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Mounts for the container.
	Mounts []*Mount `protobuf:"bytes,14,rep,name=mounts,proto3" json:"mounts,omitempty"`
	// Log path of container.
	LogPath string `protobuf:"bytes,15,opt,name=log_path,json=logPath,proto3" json:"log_path,omitempty"`
	// Resource limits configuration of the container.
	Resources *ContainerResources `protobuf:"bytes,16,opt,name=resources,proto3" json:"resources,omitempty"`
	// Reference to the unique identifier of the image, on the node, as
	// returned in the image service apis.
	//
	// Note: The image_ref above has been historically used by container
	// runtimes to reference images by digest. To separate and avoid possible
	// misusage, we now introduce the image_id field, which should always refer
	// to a unique image identifier on the node.
	ImageId string `protobuf:"bytes,17,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	// User identities initially attached to the container
	User *ContainerUser `protobuf:"bytes,18,opt,name=user,proto3" json:"user,omitempty"`
	// Returns the stop signal used by the container runtime to terminate the container
	StopSignal    Signal `protobuf:"varint,19,opt,name=stop_signal,json=stopSignal,proto3,enum=runtime.v1.Signal" json:"stop_signal,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerStatus) Reset() {
	*x = ContainerStatus{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatus) ProtoMessage() {}

func (x *ContainerStatus) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatus.ProtoReflect.Descriptor instead.
func (*ContainerStatus) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{81}
}

func (x *ContainerStatus) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ContainerStatus) GetMetadata() *ContainerMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ContainerStatus) GetState() ContainerState {
	if x != nil {
		return x.State
	}
	return ContainerState_CONTAINER_CREATED
}

func (x *ContainerStatus) GetCreatedAt() int64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *ContainerStatus) GetStartedAt() int64 {
	if x != nil {
		return x.StartedAt
	}
	return 0
}

func (x *ContainerStatus) GetFinishedAt() int64 {
	if x != nil {
		return x.FinishedAt
	}
	return 0
}

func (x *ContainerStatus) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

func (x *ContainerStatus) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *ContainerStatus) GetImageRef() string {
	if x != nil {
		return x.ImageRef
	}
	return ""
}

func (x *ContainerStatus) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *ContainerStatus) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ContainerStatus) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ContainerStatus) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ContainerStatus) GetMounts() []*Mount {
	if x != nil {
		return x.Mounts
	}
	return nil
}

func (x *ContainerStatus) GetLogPath() string {
	if x != nil {
		return x.LogPath
	}
	return ""
}

func (x *ContainerStatus) GetResources() *ContainerResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ContainerStatus) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

func (x *ContainerStatus) GetUser() *ContainerUser {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *ContainerStatus) GetStopSignal() Signal {
	if x != nil {
		return x.StopSignal
	}
	return Signal_RUNTIME_DEFAULT
}

type ContainerStatusResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Status of the container.
	Status *ContainerStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Info is extra information of the Container. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful for
	// debug, e.g. pid for linux container based container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info          map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerStatusResponse) Reset() {
	*x = ContainerStatusResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatusResponse) ProtoMessage() {}

func (x *ContainerStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatusResponse.ProtoReflect.Descriptor instead.
func (*ContainerStatusResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{82}
}

func (x *ContainerStatusResponse) GetStatus() *ContainerStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ContainerStatusResponse) GetInfo() map[string]string {
	if x != nil {
		return x.Info
	}
	return nil
}

// ContainerResources holds resource limits configuration for a container.
type ContainerResources struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resource limits configuration specific to Linux container.
	Linux *LinuxContainerResources `protobuf:"bytes,1,opt,name=linux,proto3" json:"linux,omitempty"`
	// Resource limits configuration specific to Windows container.
	Windows       *WindowsContainerResources `protobuf:"bytes,2,opt,name=windows,proto3" json:"windows,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerResources) Reset() {
	*x = ContainerResources{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerResources) ProtoMessage() {}

func (x *ContainerResources) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerResources.ProtoReflect.Descriptor instead.
func (*ContainerResources) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{83}
}

func (x *ContainerResources) GetLinux() *LinuxContainerResources {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *ContainerResources) GetWindows() *WindowsContainerResources {
	if x != nil {
		return x.Windows
	}
	return nil
}

type ContainerUser struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// User identities initially attached to first process in the Linux container.
	// Note that the actual running identity can be changed if the process has enough privilege to do so.
	Linux         *LinuxContainerUser `protobuf:"bytes,1,opt,name=linux,proto3" json:"linux,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerUser) Reset() {
	*x = ContainerUser{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerUser) ProtoMessage() {}

func (x *ContainerUser) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerUser.ProtoReflect.Descriptor instead.
func (*ContainerUser) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{84}
}

func (x *ContainerUser) GetLinux() *LinuxContainerUser {
	if x != nil {
		return x.Linux
	}
	return nil
}

type UpdateContainerResourcesRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container to update.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Resource configuration specific to Linux containers.
	Linux *LinuxContainerResources `protobuf:"bytes,2,opt,name=linux,proto3" json:"linux,omitempty"`
	// Resource configuration specific to Windows containers.
	Windows *WindowsContainerResources `protobuf:"bytes,3,opt,name=windows,proto3" json:"windows,omitempty"`
	// Unstructured key-value map holding arbitrary additional information for
	// container resources updating. This can be used for specifying experimental
	// resources to update or other options to use when updating the container.
	Annotations   map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateContainerResourcesRequest) Reset() {
	*x = UpdateContainerResourcesRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateContainerResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateContainerResourcesRequest) ProtoMessage() {}

func (x *UpdateContainerResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateContainerResourcesRequest.ProtoReflect.Descriptor instead.
func (*UpdateContainerResourcesRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{85}
}

func (x *UpdateContainerResourcesRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *UpdateContainerResourcesRequest) GetLinux() *LinuxContainerResources {
	if x != nil {
		return x.Linux
	}
	return nil
}

func (x *UpdateContainerResourcesRequest) GetWindows() *WindowsContainerResources {
	if x != nil {
		return x.Windows
	}
	return nil
}

func (x *UpdateContainerResourcesRequest) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

type UpdateContainerResourcesResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateContainerResourcesResponse) Reset() {
	*x = UpdateContainerResourcesResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateContainerResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateContainerResourcesResponse) ProtoMessage() {}

func (x *UpdateContainerResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateContainerResourcesResponse.ProtoReflect.Descriptor instead.
func (*UpdateContainerResourcesResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{86}
}

type ExecSyncRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Command to execute.
	Cmd []string `protobuf:"bytes,2,rep,name=cmd,proto3" json:"cmd,omitempty"`
	// Timeout in seconds to stop the command. Default: 0 (run forever).
	Timeout       int64 `protobuf:"varint,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExecSyncRequest) Reset() {
	*x = ExecSyncRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecSyncRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecSyncRequest) ProtoMessage() {}

func (x *ExecSyncRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecSyncRequest.ProtoReflect.Descriptor instead.
func (*ExecSyncRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{87}
}

func (x *ExecSyncRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *ExecSyncRequest) GetCmd() []string {
	if x != nil {
		return x.Cmd
	}
	return nil
}

func (x *ExecSyncRequest) GetTimeout() int64 {
	if x != nil {
		return x.Timeout
	}
	return 0
}

type ExecSyncResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Captured command stdout output.
	// The runtime should cap the output of this response to 16MB.
	// If the stdout of the command produces more than 16MB, the remaining output
	// should be discarded, and the command should proceed with no error.
	// See CVE-2022-1708 and CVE-2022-31030 for more information.
	Stdout []byte `protobuf:"bytes,1,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Captured command stderr output.
	// The runtime should cap the output of this response to 16MB.
	// If the stderr of the command produces more than 16MB, the remaining output
	// should be discarded, and the command should proceed with no error.
	// See CVE-2022-1708 and CVE-2022-31030 for more information.
	Stderr []byte `protobuf:"bytes,2,opt,name=stderr,proto3" json:"stderr,omitempty"`
	// Exit code the command finished with. Default: 0 (success).
	ExitCode      int32 `protobuf:"varint,3,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExecSyncResponse) Reset() {
	*x = ExecSyncResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[88]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecSyncResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecSyncResponse) ProtoMessage() {}

func (x *ExecSyncResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[88]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecSyncResponse.ProtoReflect.Descriptor instead.
func (*ExecSyncResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{88}
}

func (x *ExecSyncResponse) GetStdout() []byte {
	if x != nil {
		return x.Stdout
	}
	return nil
}

func (x *ExecSyncResponse) GetStderr() []byte {
	if x != nil {
		return x.Stderr
	}
	return nil
}

func (x *ExecSyncResponse) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

type ExecRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container in which to execute the command.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Command to execute.
	Cmd []string `protobuf:"bytes,2,rep,name=cmd,proto3" json:"cmd,omitempty"`
	// Whether to exec the command in a TTY.
	Tty bool `protobuf:"varint,3,opt,name=tty,proto3" json:"tty,omitempty"`
	// Whether to stream stdin.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdin bool `protobuf:"varint,4,opt,name=stdin,proto3" json:"stdin,omitempty"`
	// Whether to stream stdout.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdout bool `protobuf:"varint,5,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Whether to stream stderr.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	// If `tty` is true, `stderr` MUST be false. Multiplexing is not supported
	// in this case. The output of stdout and stderr will be combined to a
	// single stream.
	Stderr        bool `protobuf:"varint,6,opt,name=stderr,proto3" json:"stderr,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExecRequest) Reset() {
	*x = ExecRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[89]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecRequest) ProtoMessage() {}

func (x *ExecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[89]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecRequest.ProtoReflect.Descriptor instead.
func (*ExecRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{89}
}

func (x *ExecRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *ExecRequest) GetCmd() []string {
	if x != nil {
		return x.Cmd
	}
	return nil
}

func (x *ExecRequest) GetTty() bool {
	if x != nil {
		return x.Tty
	}
	return false
}

func (x *ExecRequest) GetStdin() bool {
	if x != nil {
		return x.Stdin
	}
	return false
}

func (x *ExecRequest) GetStdout() bool {
	if x != nil {
		return x.Stdout
	}
	return false
}

func (x *ExecRequest) GetStderr() bool {
	if x != nil {
		return x.Stderr
	}
	return false
}

type ExecResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Fully qualified URL of the exec streaming server.
	Url           string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExecResponse) Reset() {
	*x = ExecResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[90]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecResponse) ProtoMessage() {}

func (x *ExecResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[90]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecResponse.ProtoReflect.Descriptor instead.
func (*ExecResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{90}
}

func (x *ExecResponse) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type AttachRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container to which to attach.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Whether to stream stdin.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdin bool `protobuf:"varint,2,opt,name=stdin,proto3" json:"stdin,omitempty"`
	// Whether the process being attached is running in a TTY.
	// This must match the TTY setting in the ContainerConfig.
	Tty bool `protobuf:"varint,3,opt,name=tty,proto3" json:"tty,omitempty"`
	// Whether to stream stdout.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdout bool `protobuf:"varint,4,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Whether to stream stderr.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	// If `tty` is true, `stderr` MUST be false. Multiplexing is not supported
	// in this case. The output of stdout and stderr will be combined to a
	// single stream.
	Stderr        bool `protobuf:"varint,5,opt,name=stderr,proto3" json:"stderr,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttachRequest) Reset() {
	*x = AttachRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[91]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachRequest) ProtoMessage() {}

func (x *AttachRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[91]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachRequest.ProtoReflect.Descriptor instead.
func (*AttachRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{91}
}

func (x *AttachRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *AttachRequest) GetStdin() bool {
	if x != nil {
		return x.Stdin
	}
	return false
}

func (x *AttachRequest) GetTty() bool {
	if x != nil {
		return x.Tty
	}
	return false
}

func (x *AttachRequest) GetStdout() bool {
	if x != nil {
		return x.Stdout
	}
	return false
}

func (x *AttachRequest) GetStderr() bool {
	if x != nil {
		return x.Stderr
	}
	return false
}

type AttachResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Fully qualified URL of the attach streaming server.
	Url           string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttachResponse) Reset() {
	*x = AttachResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[92]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachResponse) ProtoMessage() {}

func (x *AttachResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[92]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachResponse.ProtoReflect.Descriptor instead.
func (*AttachResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{92}
}

func (x *AttachResponse) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type PortForwardRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container to which to forward the port.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Port to forward.
	Port          []int32 `protobuf:"varint,2,rep,packed,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PortForwardRequest) Reset() {
	*x = PortForwardRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[93]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PortForwardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortForwardRequest) ProtoMessage() {}

func (x *PortForwardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[93]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortForwardRequest.ProtoReflect.Descriptor instead.
func (*PortForwardRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{93}
}

func (x *PortForwardRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *PortForwardRequest) GetPort() []int32 {
	if x != nil {
		return x.Port
	}
	return nil
}

type PortForwardResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Fully qualified URL of the port-forward streaming server.
	Url           string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PortForwardResponse) Reset() {
	*x = PortForwardResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[94]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PortForwardResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortForwardResponse) ProtoMessage() {}

func (x *PortForwardResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[94]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortForwardResponse.ProtoReflect.Descriptor instead.
func (*PortForwardResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{94}
}

func (x *PortForwardResponse) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type ImageFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Spec of the image.
	Image         *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImageFilter) Reset() {
	*x = ImageFilter{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[95]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageFilter) ProtoMessage() {}

func (x *ImageFilter) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[95]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageFilter.ProtoReflect.Descriptor instead.
func (*ImageFilter) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{95}
}

func (x *ImageFilter) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

type ListImagesRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Filter to list images.
	Filter        *ImageFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListImagesRequest) Reset() {
	*x = ListImagesRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[96]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListImagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImagesRequest) ProtoMessage() {}

func (x *ListImagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[96]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImagesRequest.ProtoReflect.Descriptor instead.
func (*ListImagesRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{96}
}

func (x *ListImagesRequest) GetFilter() *ImageFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// Basic information about a container image.
type Image struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the image.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Other names by which this image is known.
	RepoTags []string `protobuf:"bytes,2,rep,name=repo_tags,json=repoTags,proto3" json:"repo_tags,omitempty"`
	// Digests by which this image is known.
	RepoDigests []string `protobuf:"bytes,3,rep,name=repo_digests,json=repoDigests,proto3" json:"repo_digests,omitempty"`
	// Size of the image in bytes. Must be > 0.
	Size uint64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	// UID that will run the command(s). This is used as a default if no user is
	// specified when creating the container. UID and the following user name
	// are mutually exclusive.
	Uid *Int64Value `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
	// User name that will run the command(s). This is used if UID is not set
	// and no user is specified when creating container.
	Username string `protobuf:"bytes,6,opt,name=username,proto3" json:"username,omitempty"`
	// ImageSpec for image which includes annotations
	Spec *ImageSpec `protobuf:"bytes,7,opt,name=spec,proto3" json:"spec,omitempty"`
	// Recommendation on whether this image should be exempt from garbage collection.
	// It must only be treated as a recommendation -- the client can still request that the image be deleted,
	// and the runtime must oblige.
	Pinned        bool `protobuf:"varint,8,opt,name=pinned,proto3" json:"pinned,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Image) Reset() {
	*x = Image{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[97]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Image) ProtoMessage() {}

func (x *Image) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[97]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Image.ProtoReflect.Descriptor instead.
func (*Image) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{97}
}

func (x *Image) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Image) GetRepoTags() []string {
	if x != nil {
		return x.RepoTags
	}
	return nil
}

func (x *Image) GetRepoDigests() []string {
	if x != nil {
		return x.RepoDigests
	}
	return nil
}

func (x *Image) GetSize() uint64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Image) GetUid() *Int64Value {
	if x != nil {
		return x.Uid
	}
	return nil
}

func (x *Image) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *Image) GetSpec() *ImageSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *Image) GetPinned() bool {
	if x != nil {
		return x.Pinned
	}
	return false
}

type ListImagesResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of images.
	Images        []*Image `protobuf:"bytes,1,rep,name=images,proto3" json:"images,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListImagesResponse) Reset() {
	*x = ListImagesResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[98]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListImagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImagesResponse) ProtoMessage() {}

func (x *ListImagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[98]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImagesResponse.ProtoReflect.Descriptor instead.
func (*ListImagesResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{98}
}

func (x *ListImagesResponse) GetImages() []*Image {
	if x != nil {
		return x.Images
	}
	return nil
}

type ImageStatusRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Verbose indicates whether to return extra information about the image.
	Verbose       bool `protobuf:"varint,2,opt,name=verbose,proto3" json:"verbose,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImageStatusRequest) Reset() {
	*x = ImageStatusRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[99]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageStatusRequest) ProtoMessage() {}

func (x *ImageStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[99]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageStatusRequest.ProtoReflect.Descriptor instead.
func (*ImageStatusRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{99}
}

func (x *ImageStatusRequest) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *ImageStatusRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

type ImageStatusResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Status of the image.
	Image *Image `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Info is extra information of the Image. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful
	// for debug, e.g. image config for oci image based container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info          map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImageStatusResponse) Reset() {
	*x = ImageStatusResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[100]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageStatusResponse) ProtoMessage() {}

func (x *ImageStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[100]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageStatusResponse.ProtoReflect.Descriptor instead.
func (*ImageStatusResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{100}
}

func (x *ImageStatusResponse) GetImage() *Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *ImageStatusResponse) GetInfo() map[string]string {
	if x != nil {
		return x.Info
	}
	return nil
}

// AuthConfig contains authorization information for connecting to a registry.
type AuthConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Username      string                 `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	Password      string                 `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	Auth          string                 `protobuf:"bytes,3,opt,name=auth,proto3" json:"auth,omitempty"`
	ServerAddress string                 `protobuf:"bytes,4,opt,name=server_address,json=serverAddress,proto3" json:"server_address,omitempty"`
	// IdentityToken is used to authenticate the user and get
	// an access token for the registry.
	IdentityToken string `protobuf:"bytes,5,opt,name=identity_token,json=identityToken,proto3" json:"identity_token,omitempty"`
	// RegistryToken is a bearer token to be sent to a registry
	RegistryToken string `protobuf:"bytes,6,opt,name=registry_token,json=registryToken,proto3" json:"registry_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AuthConfig) Reset() {
	*x = AuthConfig{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[101]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig) ProtoMessage() {}

func (x *AuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[101]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig.ProtoReflect.Descriptor instead.
func (*AuthConfig) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{101}
}

func (x *AuthConfig) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *AuthConfig) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *AuthConfig) GetAuth() string {
	if x != nil {
		return x.Auth
	}
	return ""
}

func (x *AuthConfig) GetServerAddress() string {
	if x != nil {
		return x.ServerAddress
	}
	return ""
}

func (x *AuthConfig) GetIdentityToken() string {
	if x != nil {
		return x.IdentityToken
	}
	return ""
}

func (x *AuthConfig) GetRegistryToken() string {
	if x != nil {
		return x.RegistryToken
	}
	return ""
}

type PullImageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Authentication configuration for pulling the image.
	Auth *AuthConfig `protobuf:"bytes,2,opt,name=auth,proto3" json:"auth,omitempty"`
	// Config of the PodSandbox, which is used to pull image in PodSandbox context.
	SandboxConfig *PodSandboxConfig `protobuf:"bytes,3,opt,name=sandbox_config,json=sandboxConfig,proto3" json:"sandbox_config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PullImageRequest) Reset() {
	*x = PullImageRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[102]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PullImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullImageRequest) ProtoMessage() {}

func (x *PullImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[102]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullImageRequest.ProtoReflect.Descriptor instead.
func (*PullImageRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{102}
}

func (x *PullImageRequest) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *PullImageRequest) GetAuth() *AuthConfig {
	if x != nil {
		return x.Auth
	}
	return nil
}

func (x *PullImageRequest) GetSandboxConfig() *PodSandboxConfig {
	if x != nil {
		return x.SandboxConfig
	}
	return nil
}

type PullImageResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Reference to the image in use. For most runtimes, this should be an
	// image ID or digest.
	ImageRef      string `protobuf:"bytes,1,opt,name=image_ref,json=imageRef,proto3" json:"image_ref,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PullImageResponse) Reset() {
	*x = PullImageResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[103]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PullImageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullImageResponse) ProtoMessage() {}

func (x *PullImageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[103]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullImageResponse.ProtoReflect.Descriptor instead.
func (*PullImageResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{103}
}

func (x *PullImageResponse) GetImageRef() string {
	if x != nil {
		return x.ImageRef
	}
	return ""
}

type RemoveImageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Spec of the image to remove.
	Image         *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemoveImageRequest) Reset() {
	*x = RemoveImageRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[104]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveImageRequest) ProtoMessage() {}

func (x *RemoveImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[104]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveImageRequest.ProtoReflect.Descriptor instead.
func (*RemoveImageRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{104}
}

func (x *RemoveImageRequest) GetImage() *ImageSpec {
	if x != nil {
		return x.Image
	}
	return nil
}

type RemoveImageResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemoveImageResponse) Reset() {
	*x = RemoveImageResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[105]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveImageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveImageResponse) ProtoMessage() {}

func (x *RemoveImageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[105]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveImageResponse.ProtoReflect.Descriptor instead.
func (*RemoveImageResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{105}
}

type NetworkConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// CIDR to use for pod IP addresses. If the CIDR is empty, runtimes
	// should omit it.
	PodCidr       string `protobuf:"bytes,1,opt,name=pod_cidr,json=podCidr,proto3" json:"pod_cidr,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[106]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[106]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{106}
}

func (x *NetworkConfig) GetPodCidr() string {
	if x != nil {
		return x.PodCidr
	}
	return ""
}

type RuntimeConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NetworkConfig *NetworkConfig         `protobuf:"bytes,1,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RuntimeConfig) Reset() {
	*x = RuntimeConfig{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[107]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfig) ProtoMessage() {}

func (x *RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[107]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfig.ProtoReflect.Descriptor instead.
func (*RuntimeConfig) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{107}
}

func (x *RuntimeConfig) GetNetworkConfig() *NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

type UpdateRuntimeConfigRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RuntimeConfig *RuntimeConfig         `protobuf:"bytes,1,opt,name=runtime_config,json=runtimeConfig,proto3" json:"runtime_config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateRuntimeConfigRequest) Reset() {
	*x = UpdateRuntimeConfigRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[108]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRuntimeConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRuntimeConfigRequest) ProtoMessage() {}

func (x *UpdateRuntimeConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[108]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRuntimeConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateRuntimeConfigRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{108}
}

func (x *UpdateRuntimeConfigRequest) GetRuntimeConfig() *RuntimeConfig {
	if x != nil {
		return x.RuntimeConfig
	}
	return nil
}

type UpdateRuntimeConfigResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateRuntimeConfigResponse) Reset() {
	*x = UpdateRuntimeConfigResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[109]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRuntimeConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRuntimeConfigResponse) ProtoMessage() {}

func (x *UpdateRuntimeConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[109]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRuntimeConfigResponse.ProtoReflect.Descriptor instead.
func (*UpdateRuntimeConfigResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{109}
}

// RuntimeCondition contains condition information for the runtime.
// There are 2 kinds of runtime conditions:
// 1. Required conditions: Conditions are required for kubelet to work
// properly. If any required condition is unmet, the node will be not ready.
// The required conditions include:
//   - RuntimeReady: RuntimeReady means the runtime is up and ready to accept
//     basic containers e.g. container only needs host network.
//   - NetworkReady: NetworkReady means the runtime network is up and ready to
//     accept containers which require container network.
//
// 2. Optional conditions: Conditions are informative to the user, but kubelet
// will not rely on. Since condition type is an arbitrary string, all conditions
// not required are optional. These conditions will be exposed to users to help
// them understand the status of the system.
type RuntimeCondition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of runtime condition.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Status of the condition, one of true/false. Default: false.
	Status bool `protobuf:"varint,2,opt,name=status,proto3" json:"status,omitempty"`
	// Brief CamelCase string containing reason for the condition's last transition.
	Reason string `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
	// Human-readable message indicating details about last transition.
	Message       string `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RuntimeCondition) Reset() {
	*x = RuntimeCondition{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[110]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeCondition) ProtoMessage() {}

func (x *RuntimeCondition) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[110]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeCondition.ProtoReflect.Descriptor instead.
func (*RuntimeCondition) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{110}
}

func (x *RuntimeCondition) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *RuntimeCondition) GetStatus() bool {
	if x != nil {
		return x.Status
	}
	return false
}

func (x *RuntimeCondition) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *RuntimeCondition) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// RuntimeStatus is information about the current status of the runtime.
type RuntimeStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of current observed runtime conditions.
	Conditions    []*RuntimeCondition `protobuf:"bytes,1,rep,name=conditions,proto3" json:"conditions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RuntimeStatus) Reset() {
	*x = RuntimeStatus{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[111]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeStatus) ProtoMessage() {}

func (x *RuntimeStatus) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[111]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeStatus.ProtoReflect.Descriptor instead.
func (*RuntimeStatus) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{111}
}

func (x *RuntimeStatus) GetConditions() []*RuntimeCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

type StatusRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Verbose indicates whether to return extra information about the runtime.
	Verbose       bool `protobuf:"varint,1,opt,name=verbose,proto3" json:"verbose,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StatusRequest) Reset() {
	*x = StatusRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[112]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusRequest) ProtoMessage() {}

func (x *StatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[112]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusRequest.ProtoReflect.Descriptor instead.
func (*StatusRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{112}
}

func (x *StatusRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

// RuntimeHandlerFeatures is a set of features implemented by the runtime handler.
type RuntimeHandlerFeatures struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// recursive_read_only_mounts is set to true if the runtime handler supports
	// recursive read-only mounts.
	// For runc-compatible runtimes, availability of this feature can be detected by checking whether
	// the Linux kernel version is >= 5.12, and,  `runc features | jq .mountOptions` contains "rro".
	RecursiveReadOnlyMounts bool `protobuf:"varint,1,opt,name=recursive_read_only_mounts,json=recursiveReadOnlyMounts,proto3" json:"recursive_read_only_mounts,omitempty"`
	// user_namespaces is set to true if the runtime handler supports user namespaces as implemented
	// in Kubernetes. This means support for both, user namespaces and idmap mounts.
	UserNamespaces bool `protobuf:"varint,2,opt,name=user_namespaces,json=userNamespaces,proto3" json:"user_namespaces,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *RuntimeHandlerFeatures) Reset() {
	*x = RuntimeHandlerFeatures{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[113]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeHandlerFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeHandlerFeatures) ProtoMessage() {}

func (x *RuntimeHandlerFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[113]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeHandlerFeatures.ProtoReflect.Descriptor instead.
func (*RuntimeHandlerFeatures) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{113}
}

func (x *RuntimeHandlerFeatures) GetRecursiveReadOnlyMounts() bool {
	if x != nil {
		return x.RecursiveReadOnlyMounts
	}
	return false
}

func (x *RuntimeHandlerFeatures) GetUserNamespaces() bool {
	if x != nil {
		return x.UserNamespaces
	}
	return false
}

type RuntimeHandler struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name must be unique in StatusResponse.
	// An empty string denotes the default handler.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Supported features.
	Features      *RuntimeHandlerFeatures `protobuf:"bytes,2,opt,name=features,proto3" json:"features,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RuntimeHandler) Reset() {
	*x = RuntimeHandler{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[114]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeHandler) ProtoMessage() {}

func (x *RuntimeHandler) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[114]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeHandler.ProtoReflect.Descriptor instead.
func (*RuntimeHandler) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{114}
}

func (x *RuntimeHandler) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RuntimeHandler) GetFeatures() *RuntimeHandlerFeatures {
	if x != nil {
		return x.Features
	}
	return nil
}

// RuntimeFeatures describes the set of features implemented by the CRI implementation.
// The features contained in the RuntimeFeatures should depend only on the cri implementation
// independent of runtime handlers.
type RuntimeFeatures struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// supplemental_groups_policy is set to true if the runtime supports SupplementalGroupsPolicy and ContainerUser.
	SupplementalGroupsPolicy bool `protobuf:"varint,1,opt,name=supplemental_groups_policy,json=supplementalGroupsPolicy,proto3" json:"supplemental_groups_policy,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *RuntimeFeatures) Reset() {
	*x = RuntimeFeatures{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[115]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeFeatures) ProtoMessage() {}

func (x *RuntimeFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[115]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeFeatures.ProtoReflect.Descriptor instead.
func (*RuntimeFeatures) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{115}
}

func (x *RuntimeFeatures) GetSupplementalGroupsPolicy() bool {
	if x != nil {
		return x.SupplementalGroupsPolicy
	}
	return false
}

type StatusResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Status of the Runtime.
	Status *RuntimeStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Info is extra information of the Runtime. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful for
	// debug, e.g. plugins used by the container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Runtime handlers.
	RuntimeHandlers []*RuntimeHandler `protobuf:"bytes,3,rep,name=runtime_handlers,json=runtimeHandlers,proto3" json:"runtime_handlers,omitempty"`
	// features describes the set of features implemented by the CRI implementation.
	// This field is supposed to propagate to NodeFeatures in Kubernetes API.
	Features      *RuntimeFeatures `protobuf:"bytes,4,opt,name=features,proto3" json:"features,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StatusResponse) Reset() {
	*x = StatusResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[116]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusResponse) ProtoMessage() {}

func (x *StatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[116]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusResponse.ProtoReflect.Descriptor instead.
func (*StatusResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{116}
}

func (x *StatusResponse) GetStatus() *RuntimeStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *StatusResponse) GetInfo() map[string]string {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *StatusResponse) GetRuntimeHandlers() []*RuntimeHandler {
	if x != nil {
		return x.RuntimeHandlers
	}
	return nil
}

func (x *StatusResponse) GetFeatures() *RuntimeFeatures {
	if x != nil {
		return x.Features
	}
	return nil
}

type ImageFsInfoRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImageFsInfoRequest) Reset() {
	*x = ImageFsInfoRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[117]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageFsInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageFsInfoRequest) ProtoMessage() {}

func (x *ImageFsInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[117]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageFsInfoRequest.ProtoReflect.Descriptor instead.
func (*ImageFsInfoRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{117}
}

// UInt64Value is the wrapper of uint64.
type UInt64Value struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The value.
	Value         uint64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UInt64Value) Reset() {
	*x = UInt64Value{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[118]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UInt64Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UInt64Value) ProtoMessage() {}

func (x *UInt64Value) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[118]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UInt64Value.ProtoReflect.Descriptor instead.
func (*UInt64Value) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{118}
}

func (x *UInt64Value) GetValue() uint64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// FilesystemIdentifier uniquely identify the filesystem.
type FilesystemIdentifier struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Mountpoint of a filesystem.
	Mountpoint    string `protobuf:"bytes,1,opt,name=mountpoint,proto3" json:"mountpoint,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FilesystemIdentifier) Reset() {
	*x = FilesystemIdentifier{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[119]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FilesystemIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilesystemIdentifier) ProtoMessage() {}

func (x *FilesystemIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[119]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilesystemIdentifier.ProtoReflect.Descriptor instead.
func (*FilesystemIdentifier) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{119}
}

func (x *FilesystemIdentifier) GetMountpoint() string {
	if x != nil {
		return x.Mountpoint
	}
	return ""
}

// FilesystemUsage provides the filesystem usage information.
type FilesystemUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The unique identifier of the filesystem.
	FsId *FilesystemIdentifier `protobuf:"bytes,2,opt,name=fs_id,json=fsId,proto3" json:"fs_id,omitempty"`
	// UsedBytes represents the bytes used for images on the filesystem.
	// This may differ from the total bytes used on the filesystem and may not
	// equal CapacityBytes - AvailableBytes.
	UsedBytes *UInt64Value `protobuf:"bytes,3,opt,name=used_bytes,json=usedBytes,proto3" json:"used_bytes,omitempty"`
	// InodesUsed represents the inodes used by the images.
	// This may not equal InodesCapacity - InodesAvailable because the underlying
	// filesystem may also be used for purposes other than storing images.
	InodesUsed    *UInt64Value `protobuf:"bytes,4,opt,name=inodes_used,json=inodesUsed,proto3" json:"inodes_used,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FilesystemUsage) Reset() {
	*x = FilesystemUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[120]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FilesystemUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilesystemUsage) ProtoMessage() {}

func (x *FilesystemUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[120]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilesystemUsage.ProtoReflect.Descriptor instead.
func (*FilesystemUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{120}
}

func (x *FilesystemUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *FilesystemUsage) GetFsId() *FilesystemIdentifier {
	if x != nil {
		return x.FsId
	}
	return nil
}

func (x *FilesystemUsage) GetUsedBytes() *UInt64Value {
	if x != nil {
		return x.UsedBytes
	}
	return nil
}

func (x *FilesystemUsage) GetInodesUsed() *UInt64Value {
	if x != nil {
		return x.InodesUsed
	}
	return nil
}

// WindowsFilesystemUsage provides the filesystem usage information specific to Windows.
type WindowsFilesystemUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The unique identifier of the filesystem.
	FsId *FilesystemIdentifier `protobuf:"bytes,2,opt,name=fs_id,json=fsId,proto3" json:"fs_id,omitempty"`
	// UsedBytes represents the bytes used for images on the filesystem.
	// This may differ from the total bytes used on the filesystem and may not
	// equal CapacityBytes - AvailableBytes.
	UsedBytes     *UInt64Value `protobuf:"bytes,3,opt,name=used_bytes,json=usedBytes,proto3" json:"used_bytes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WindowsFilesystemUsage) Reset() {
	*x = WindowsFilesystemUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[121]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsFilesystemUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsFilesystemUsage) ProtoMessage() {}

func (x *WindowsFilesystemUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[121]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsFilesystemUsage.ProtoReflect.Descriptor instead.
func (*WindowsFilesystemUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{121}
}

func (x *WindowsFilesystemUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *WindowsFilesystemUsage) GetFsId() *FilesystemIdentifier {
	if x != nil {
		return x.FsId
	}
	return nil
}

func (x *WindowsFilesystemUsage) GetUsedBytes() *UInt64Value {
	if x != nil {
		return x.UsedBytes
	}
	return nil
}

type ImageFsInfoResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Information of image filesystem(s).
	ImageFilesystems []*FilesystemUsage `protobuf:"bytes,1,rep,name=image_filesystems,json=imageFilesystems,proto3" json:"image_filesystems,omitempty"`
	// Information of container filesystem(s).
	// This is an optional field, may be used for example if container and image
	// storage are separated.
	// Default will be to return this as empty.
	ContainerFilesystems []*FilesystemUsage `protobuf:"bytes,2,rep,name=container_filesystems,json=containerFilesystems,proto3" json:"container_filesystems,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ImageFsInfoResponse) Reset() {
	*x = ImageFsInfoResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[122]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageFsInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageFsInfoResponse) ProtoMessage() {}

func (x *ImageFsInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[122]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageFsInfoResponse.ProtoReflect.Descriptor instead.
func (*ImageFsInfoResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{122}
}

func (x *ImageFsInfoResponse) GetImageFilesystems() []*FilesystemUsage {
	if x != nil {
		return x.ImageFilesystems
	}
	return nil
}

func (x *ImageFsInfoResponse) GetContainerFilesystems() []*FilesystemUsage {
	if x != nil {
		return x.ContainerFilesystems
	}
	return nil
}

type ContainerStatsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container for which to retrieve stats.
	ContainerId   string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerStatsRequest) Reset() {
	*x = ContainerStatsRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[123]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatsRequest) ProtoMessage() {}

func (x *ContainerStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[123]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatsRequest.ProtoReflect.Descriptor instead.
func (*ContainerStatsRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{123}
}

func (x *ContainerStatsRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type ContainerStatsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Stats of the container.
	Stats         *ContainerStats `protobuf:"bytes,1,opt,name=stats,proto3" json:"stats,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerStatsResponse) Reset() {
	*x = ContainerStatsResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[124]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatsResponse) ProtoMessage() {}

func (x *ContainerStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[124]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatsResponse.ProtoReflect.Descriptor instead.
func (*ContainerStatsResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{124}
}

func (x *ContainerStatsResponse) GetStats() *ContainerStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

type ListContainerStatsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Filter for the list request.
	Filter        *ContainerStatsFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListContainerStatsRequest) Reset() {
	*x = ListContainerStatsRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[125]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListContainerStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListContainerStatsRequest) ProtoMessage() {}

func (x *ListContainerStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[125]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListContainerStatsRequest.ProtoReflect.Descriptor instead.
func (*ListContainerStatsRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{125}
}

func (x *ListContainerStatsRequest) GetFilter() *ContainerStatsFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// ContainerStatsFilter is used to filter containers.
// All those fields are combined with 'AND'
type ContainerStatsFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the PodSandbox.
	PodSandboxId string `protobuf:"bytes,2,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector map[string]string `protobuf:"bytes,3,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerStatsFilter) Reset() {
	*x = ContainerStatsFilter{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[126]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerStatsFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStatsFilter) ProtoMessage() {}

func (x *ContainerStatsFilter) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[126]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStatsFilter.ProtoReflect.Descriptor instead.
func (*ContainerStatsFilter) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{126}
}

func (x *ContainerStatsFilter) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ContainerStatsFilter) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *ContainerStatsFilter) GetLabelSelector() map[string]string {
	if x != nil {
		return x.LabelSelector
	}
	return nil
}

type ListContainerStatsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Stats of the container.
	Stats         []*ContainerStats `protobuf:"bytes,1,rep,name=stats,proto3" json:"stats,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListContainerStatsResponse) Reset() {
	*x = ListContainerStatsResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[127]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListContainerStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListContainerStatsResponse) ProtoMessage() {}

func (x *ListContainerStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[127]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListContainerStatsResponse.ProtoReflect.Descriptor instead.
func (*ListContainerStatsResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{127}
}

func (x *ListContainerStatsResponse) GetStats() []*ContainerStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// ContainerAttributes provides basic information of the container.
type ContainerAttributes struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding ContainerConfig used to
	// instantiate the Container this status represents.
	Annotations   map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerAttributes) Reset() {
	*x = ContainerAttributes{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[128]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerAttributes) ProtoMessage() {}

func (x *ContainerAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[128]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerAttributes.ProtoReflect.Descriptor instead.
func (*ContainerAttributes) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{128}
}

func (x *ContainerAttributes) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ContainerAttributes) GetMetadata() *ContainerMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ContainerAttributes) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ContainerAttributes) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// ContainerStats provides the resource usage statistics for a container.
type ContainerStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Information of the container.
	Attributes *ContainerAttributes `protobuf:"bytes,1,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// CPU usage gathered from the container.
	Cpu *CpuUsage `protobuf:"bytes,2,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage gathered from the container.
	Memory *MemoryUsage `protobuf:"bytes,3,opt,name=memory,proto3" json:"memory,omitempty"`
	// Usage of the writable layer.
	WritableLayer *FilesystemUsage `protobuf:"bytes,4,opt,name=writable_layer,json=writableLayer,proto3" json:"writable_layer,omitempty"`
	// Swap usage gathered from the container.
	Swap *SwapUsage `protobuf:"bytes,5,opt,name=swap,proto3" json:"swap,omitempty"`
	// IO usage gathered from the container.
	Io            *IoUsage `protobuf:"bytes,6,opt,name=io,proto3" json:"io,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerStats) Reset() {
	*x = ContainerStats{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[129]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerStats) ProtoMessage() {}

func (x *ContainerStats) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[129]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerStats.ProtoReflect.Descriptor instead.
func (*ContainerStats) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{129}
}

func (x *ContainerStats) GetAttributes() *ContainerAttributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *ContainerStats) GetCpu() *CpuUsage {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *ContainerStats) GetMemory() *MemoryUsage {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *ContainerStats) GetWritableLayer() *FilesystemUsage {
	if x != nil {
		return x.WritableLayer
	}
	return nil
}

func (x *ContainerStats) GetSwap() *SwapUsage {
	if x != nil {
		return x.Swap
	}
	return nil
}

func (x *ContainerStats) GetIo() *IoUsage {
	if x != nil {
		return x.Io
	}
	return nil
}

// WindowsContainerStats provides the resource usage statistics for a container specific for Windows
type WindowsContainerStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Information of the container.
	Attributes *ContainerAttributes `protobuf:"bytes,1,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// CPU usage gathered from the container.
	Cpu *WindowsCpuUsage `protobuf:"bytes,2,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage gathered from the container.
	Memory *WindowsMemoryUsage `protobuf:"bytes,3,opt,name=memory,proto3" json:"memory,omitempty"`
	// Usage of the writable layer.
	WritableLayer *WindowsFilesystemUsage `protobuf:"bytes,4,opt,name=writable_layer,json=writableLayer,proto3" json:"writable_layer,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WindowsContainerStats) Reset() {
	*x = WindowsContainerStats{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[130]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsContainerStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsContainerStats) ProtoMessage() {}

func (x *WindowsContainerStats) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[130]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsContainerStats.ProtoReflect.Descriptor instead.
func (*WindowsContainerStats) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{130}
}

func (x *WindowsContainerStats) GetAttributes() *ContainerAttributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *WindowsContainerStats) GetCpu() *WindowsCpuUsage {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *WindowsContainerStats) GetMemory() *WindowsMemoryUsage {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *WindowsContainerStats) GetWritableLayer() *WindowsFilesystemUsage {
	if x != nil {
		return x.WritableLayer
	}
	return nil
}

// PSI statistics for an individual resource.
type PsiStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// PSI data for all tasks in the cgroup.
	Full *PsiData `protobuf:"bytes,1,opt,name=Full,proto3" json:"Full,omitempty"`
	// PSI data for some tasks in the cgroup.
	Some          *PsiData `protobuf:"bytes,2,opt,name=Some,proto3" json:"Some,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PsiStats) Reset() {
	*x = PsiStats{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[131]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PsiStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PsiStats) ProtoMessage() {}

func (x *PsiStats) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[131]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PsiStats.ProtoReflect.Descriptor instead.
func (*PsiStats) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{131}
}

func (x *PsiStats) GetFull() *PsiData {
	if x != nil {
		return x.Full
	}
	return nil
}

func (x *PsiStats) GetSome() *PsiData {
	if x != nil {
		return x.Some
	}
	return nil
}

// PSI data for an individual resource.
type PsiData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Total time duration for tasks in the cgroup have waited due to congestion.
	// Unit: nanoseconds.
	Total uint64 `protobuf:"varint,1,opt,name=Total,proto3" json:"Total,omitempty"`
	// The average (in %) tasks have waited due to congestion over a 10 second window.
	Avg10 float64 `protobuf:"fixed64,2,opt,name=Avg10,proto3" json:"Avg10,omitempty"`
	// The average (in %) tasks have waited due to congestion over a 60 second window.
	Avg60 float64 `protobuf:"fixed64,3,opt,name=Avg60,proto3" json:"Avg60,omitempty"`
	// The average (in %) tasks have waited due to congestion over a 300 second window.
	Avg300        float64 `protobuf:"fixed64,4,opt,name=Avg300,proto3" json:"Avg300,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PsiData) Reset() {
	*x = PsiData{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[132]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PsiData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PsiData) ProtoMessage() {}

func (x *PsiData) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[132]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PsiData.ProtoReflect.Descriptor instead.
func (*PsiData) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{132}
}

func (x *PsiData) GetTotal() uint64 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *PsiData) GetAvg10() float64 {
	if x != nil {
		return x.Avg10
	}
	return 0
}

func (x *PsiData) GetAvg60() float64 {
	if x != nil {
		return x.Avg60
	}
	return 0
}

func (x *PsiData) GetAvg300() float64 {
	if x != nil {
		return x.Avg300
	}
	return 0
}

// CpuUsage provides the CPU usage information.
type CpuUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Cumulative CPU usage (sum across all cores) since object creation.
	UsageCoreNanoSeconds *UInt64Value `protobuf:"bytes,2,opt,name=usage_core_nano_seconds,json=usageCoreNanoSeconds,proto3" json:"usage_core_nano_seconds,omitempty"`
	// Total CPU usage (sum of all cores) averaged over the sample window.
	// The "core" unit can be interpreted as CPU core-nanoseconds per second.
	UsageNanoCores *UInt64Value `protobuf:"bytes,3,opt,name=usage_nano_cores,json=usageNanoCores,proto3" json:"usage_nano_cores,omitempty"`
	// CPU PSI statistics.
	Psi           *PsiStats `protobuf:"bytes,4,opt,name=psi,proto3" json:"psi,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CpuUsage) Reset() {
	*x = CpuUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[133]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CpuUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpuUsage) ProtoMessage() {}

func (x *CpuUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[133]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpuUsage.ProtoReflect.Descriptor instead.
func (*CpuUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{133}
}

func (x *CpuUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *CpuUsage) GetUsageCoreNanoSeconds() *UInt64Value {
	if x != nil {
		return x.UsageCoreNanoSeconds
	}
	return nil
}

func (x *CpuUsage) GetUsageNanoCores() *UInt64Value {
	if x != nil {
		return x.UsageNanoCores
	}
	return nil
}

func (x *CpuUsage) GetPsi() *PsiStats {
	if x != nil {
		return x.Psi
	}
	return nil
}

// WindowsCpuUsage provides the CPU usage information specific to Windows
type WindowsCpuUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Cumulative CPU usage (sum across all cores) since object creation.
	UsageCoreNanoSeconds *UInt64Value `protobuf:"bytes,2,opt,name=usage_core_nano_seconds,json=usageCoreNanoSeconds,proto3" json:"usage_core_nano_seconds,omitempty"`
	// Total CPU usage (sum of all cores) averaged over the sample window.
	// The "core" unit can be interpreted as CPU core-nanoseconds per second.
	UsageNanoCores *UInt64Value `protobuf:"bytes,3,opt,name=usage_nano_cores,json=usageNanoCores,proto3" json:"usage_nano_cores,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *WindowsCpuUsage) Reset() {
	*x = WindowsCpuUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[134]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsCpuUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsCpuUsage) ProtoMessage() {}

func (x *WindowsCpuUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[134]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsCpuUsage.ProtoReflect.Descriptor instead.
func (*WindowsCpuUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{134}
}

func (x *WindowsCpuUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *WindowsCpuUsage) GetUsageCoreNanoSeconds() *UInt64Value {
	if x != nil {
		return x.UsageCoreNanoSeconds
	}
	return nil
}

func (x *WindowsCpuUsage) GetUsageNanoCores() *UInt64Value {
	if x != nil {
		return x.UsageNanoCores
	}
	return nil
}

// MemoryUsage provides the memory usage information.
type MemoryUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The amount of working set memory in bytes.
	WorkingSetBytes *UInt64Value `protobuf:"bytes,2,opt,name=working_set_bytes,json=workingSetBytes,proto3" json:"working_set_bytes,omitempty"`
	// Available memory for use. This is defined as the memory limit - workingSetBytes.
	AvailableBytes *UInt64Value `protobuf:"bytes,3,opt,name=available_bytes,json=availableBytes,proto3" json:"available_bytes,omitempty"`
	// Total memory in use. This includes all memory regardless of when it was accessed.
	UsageBytes *UInt64Value `protobuf:"bytes,4,opt,name=usage_bytes,json=usageBytes,proto3" json:"usage_bytes,omitempty"`
	// The amount of anonymous and swap cache memory (includes transparent hugepages).
	RssBytes *UInt64Value `protobuf:"bytes,5,opt,name=rss_bytes,json=rssBytes,proto3" json:"rss_bytes,omitempty"`
	// Cumulative number of minor page faults.
	PageFaults *UInt64Value `protobuf:"bytes,6,opt,name=page_faults,json=pageFaults,proto3" json:"page_faults,omitempty"`
	// Cumulative number of major page faults.
	MajorPageFaults *UInt64Value `protobuf:"bytes,7,opt,name=major_page_faults,json=majorPageFaults,proto3" json:"major_page_faults,omitempty"`
	// Memory PSI statistics.
	Psi           *PsiStats `protobuf:"bytes,8,opt,name=psi,proto3" json:"psi,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MemoryUsage) Reset() {
	*x = MemoryUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[135]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MemoryUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MemoryUsage) ProtoMessage() {}

func (x *MemoryUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[135]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MemoryUsage.ProtoReflect.Descriptor instead.
func (*MemoryUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{135}
}

func (x *MemoryUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *MemoryUsage) GetWorkingSetBytes() *UInt64Value {
	if x != nil {
		return x.WorkingSetBytes
	}
	return nil
}

func (x *MemoryUsage) GetAvailableBytes() *UInt64Value {
	if x != nil {
		return x.AvailableBytes
	}
	return nil
}

func (x *MemoryUsage) GetUsageBytes() *UInt64Value {
	if x != nil {
		return x.UsageBytes
	}
	return nil
}

func (x *MemoryUsage) GetRssBytes() *UInt64Value {
	if x != nil {
		return x.RssBytes
	}
	return nil
}

func (x *MemoryUsage) GetPageFaults() *UInt64Value {
	if x != nil {
		return x.PageFaults
	}
	return nil
}

func (x *MemoryUsage) GetMajorPageFaults() *UInt64Value {
	if x != nil {
		return x.MajorPageFaults
	}
	return nil
}

func (x *MemoryUsage) GetPsi() *PsiStats {
	if x != nil {
		return x.Psi
	}
	return nil
}

type IoUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// IO PSI statistics.
	Psi           *PsiStats `protobuf:"bytes,2,opt,name=psi,proto3" json:"psi,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IoUsage) Reset() {
	*x = IoUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[136]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IoUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IoUsage) ProtoMessage() {}

func (x *IoUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[136]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IoUsage.ProtoReflect.Descriptor instead.
func (*IoUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{136}
}

func (x *IoUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *IoUsage) GetPsi() *PsiStats {
	if x != nil {
		return x.Psi
	}
	return nil
}

type SwapUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Available swap for use. This is defined as the swap limit - swapUsageBytes.
	SwapAvailableBytes *UInt64Value `protobuf:"bytes,2,opt,name=swap_available_bytes,json=swapAvailableBytes,proto3" json:"swap_available_bytes,omitempty"`
	// Total memory in use. This includes all memory regardless of when it was accessed.
	SwapUsageBytes *UInt64Value `protobuf:"bytes,3,opt,name=swap_usage_bytes,json=swapUsageBytes,proto3" json:"swap_usage_bytes,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *SwapUsage) Reset() {
	*x = SwapUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[137]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SwapUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SwapUsage) ProtoMessage() {}

func (x *SwapUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[137]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SwapUsage.ProtoReflect.Descriptor instead.
func (*SwapUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{137}
}

func (x *SwapUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *SwapUsage) GetSwapAvailableBytes() *UInt64Value {
	if x != nil {
		return x.SwapAvailableBytes
	}
	return nil
}

func (x *SwapUsage) GetSwapUsageBytes() *UInt64Value {
	if x != nil {
		return x.SwapUsageBytes
	}
	return nil
}

// WindowsMemoryUsage provides the memory usage information specific to Windows
type WindowsMemoryUsage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The amount of working set memory in bytes.
	WorkingSetBytes *UInt64Value `protobuf:"bytes,2,opt,name=working_set_bytes,json=workingSetBytes,proto3" json:"working_set_bytes,omitempty"`
	// Available memory for use. This is defined as the memory limit - commit_memory_bytes.
	AvailableBytes *UInt64Value `protobuf:"bytes,3,opt,name=available_bytes,json=availableBytes,proto3" json:"available_bytes,omitempty"`
	// Cumulative number of page faults.
	PageFaults *UInt64Value `protobuf:"bytes,4,opt,name=page_faults,json=pageFaults,proto3" json:"page_faults,omitempty"`
	// Total commit memory in use. Commit memory is total of physical and virtual memory in use.
	CommitMemoryBytes *UInt64Value `protobuf:"bytes,5,opt,name=commit_memory_bytes,json=commitMemoryBytes,proto3" json:"commit_memory_bytes,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *WindowsMemoryUsage) Reset() {
	*x = WindowsMemoryUsage{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[138]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsMemoryUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsMemoryUsage) ProtoMessage() {}

func (x *WindowsMemoryUsage) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[138]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsMemoryUsage.ProtoReflect.Descriptor instead.
func (*WindowsMemoryUsage) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{138}
}

func (x *WindowsMemoryUsage) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *WindowsMemoryUsage) GetWorkingSetBytes() *UInt64Value {
	if x != nil {
		return x.WorkingSetBytes
	}
	return nil
}

func (x *WindowsMemoryUsage) GetAvailableBytes() *UInt64Value {
	if x != nil {
		return x.AvailableBytes
	}
	return nil
}

func (x *WindowsMemoryUsage) GetPageFaults() *UInt64Value {
	if x != nil {
		return x.PageFaults
	}
	return nil
}

func (x *WindowsMemoryUsage) GetCommitMemoryBytes() *UInt64Value {
	if x != nil {
		return x.CommitMemoryBytes
	}
	return nil
}

type ReopenContainerLogRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container for which to reopen the log.
	ContainerId   string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReopenContainerLogRequest) Reset() {
	*x = ReopenContainerLogRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[139]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReopenContainerLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReopenContainerLogRequest) ProtoMessage() {}

func (x *ReopenContainerLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[139]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReopenContainerLogRequest.ProtoReflect.Descriptor instead.
func (*ReopenContainerLogRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{139}
}

func (x *ReopenContainerLogRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type ReopenContainerLogResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReopenContainerLogResponse) Reset() {
	*x = ReopenContainerLogResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[140]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReopenContainerLogResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReopenContainerLogResponse) ProtoMessage() {}

func (x *ReopenContainerLogResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[140]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReopenContainerLogResponse.ProtoReflect.Descriptor instead.
func (*ReopenContainerLogResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{140}
}

type CheckpointContainerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container to be checkpointed.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Location of the checkpoint archive used for export
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Timeout in seconds for the checkpoint to complete.
	// Timeout of zero means to use the CRI default.
	// Timeout > 0 means to use the user specified timeout.
	Timeout       int64 `protobuf:"varint,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CheckpointContainerRequest) Reset() {
	*x = CheckpointContainerRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[141]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckpointContainerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckpointContainerRequest) ProtoMessage() {}

func (x *CheckpointContainerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[141]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckpointContainerRequest.ProtoReflect.Descriptor instead.
func (*CheckpointContainerRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{141}
}

func (x *CheckpointContainerRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *CheckpointContainerRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *CheckpointContainerRequest) GetTimeout() int64 {
	if x != nil {
		return x.Timeout
	}
	return 0
}

type CheckpointContainerResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CheckpointContainerResponse) Reset() {
	*x = CheckpointContainerResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[142]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckpointContainerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckpointContainerResponse) ProtoMessage() {}

func (x *CheckpointContainerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[142]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckpointContainerResponse.ProtoReflect.Descriptor instead.
func (*CheckpointContainerResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{142}
}

type GetEventsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetEventsRequest) Reset() {
	*x = GetEventsRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[143]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEventsRequest) ProtoMessage() {}

func (x *GetEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[143]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEventsRequest.ProtoReflect.Descriptor instead.
func (*GetEventsRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{143}
}

type ContainerEventResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the container
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Type of the container event
	ContainerEventType ContainerEventType `protobuf:"varint,2,opt,name=container_event_type,json=containerEventType,proto3,enum=runtime.v1.ContainerEventType" json:"container_event_type,omitempty"`
	// Creation timestamp in nanoseconds of this event
	CreatedAt int64 `protobuf:"varint,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Sandbox status
	PodSandboxStatus *PodSandboxStatus `protobuf:"bytes,4,opt,name=pod_sandbox_status,json=podSandboxStatus,proto3" json:"pod_sandbox_status,omitempty"`
	// Container statuses
	ContainersStatuses []*ContainerStatus `protobuf:"bytes,5,rep,name=containers_statuses,json=containersStatuses,proto3" json:"containers_statuses,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ContainerEventResponse) Reset() {
	*x = ContainerEventResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[144]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerEventResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerEventResponse) ProtoMessage() {}

func (x *ContainerEventResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[144]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerEventResponse.ProtoReflect.Descriptor instead.
func (*ContainerEventResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{144}
}

func (x *ContainerEventResponse) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *ContainerEventResponse) GetContainerEventType() ContainerEventType {
	if x != nil {
		return x.ContainerEventType
	}
	return ContainerEventType_CONTAINER_CREATED_EVENT
}

func (x *ContainerEventResponse) GetCreatedAt() int64 {
	if x != nil {
		return x.CreatedAt
	}
	return 0
}

func (x *ContainerEventResponse) GetPodSandboxStatus() *PodSandboxStatus {
	if x != nil {
		return x.PodSandboxStatus
	}
	return nil
}

func (x *ContainerEventResponse) GetContainersStatuses() []*ContainerStatus {
	if x != nil {
		return x.ContainersStatuses
	}
	return nil
}

type ListMetricDescriptorsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListMetricDescriptorsRequest) Reset() {
	*x = ListMetricDescriptorsRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[145]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMetricDescriptorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetricDescriptorsRequest) ProtoMessage() {}

func (x *ListMetricDescriptorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[145]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetricDescriptorsRequest.ProtoReflect.Descriptor instead.
func (*ListMetricDescriptorsRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{145}
}

type ListMetricDescriptorsResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Descriptors   []*MetricDescriptor    `protobuf:"bytes,1,rep,name=descriptors,proto3" json:"descriptors,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListMetricDescriptorsResponse) Reset() {
	*x = ListMetricDescriptorsResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[146]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMetricDescriptorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetricDescriptorsResponse) ProtoMessage() {}

func (x *ListMetricDescriptorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[146]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetricDescriptorsResponse.ProtoReflect.Descriptor instead.
func (*ListMetricDescriptorsResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{146}
}

func (x *ListMetricDescriptorsResponse) GetDescriptors() []*MetricDescriptor {
	if x != nil {
		return x.Descriptors
	}
	return nil
}

type MetricDescriptor struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name field will be used as a unique identifier of this MetricDescriptor,
	// and be used in conjunction with the Metric structure to populate the full Metric.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Help string `protobuf:"bytes,2,opt,name=help,proto3" json:"help,omitempty"`
	// When a metric uses this metric descriptor, it should only define
	// labels that have previously been declared in label_keys.
	// It is the responsibility of the runtime to correctly keep sorted the keys and values.
	// If the two slices have different length, the behavior is undefined.
	LabelKeys     []string `protobuf:"bytes,3,rep,name=label_keys,json=labelKeys,proto3" json:"label_keys,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MetricDescriptor) Reset() {
	*x = MetricDescriptor{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[147]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricDescriptor) ProtoMessage() {}

func (x *MetricDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[147]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricDescriptor.ProtoReflect.Descriptor instead.
func (*MetricDescriptor) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{147}
}

func (x *MetricDescriptor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MetricDescriptor) GetHelp() string {
	if x != nil {
		return x.Help
	}
	return ""
}

func (x *MetricDescriptor) GetLabelKeys() []string {
	if x != nil {
		return x.LabelKeys
	}
	return nil
}

type ListPodSandboxMetricsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPodSandboxMetricsRequest) Reset() {
	*x = ListPodSandboxMetricsRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[148]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPodSandboxMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodSandboxMetricsRequest) ProtoMessage() {}

func (x *ListPodSandboxMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[148]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodSandboxMetricsRequest.ProtoReflect.Descriptor instead.
func (*ListPodSandboxMetricsRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{148}
}

type ListPodSandboxMetricsResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PodMetrics    []*PodSandboxMetrics   `protobuf:"bytes,1,rep,name=pod_metrics,json=podMetrics,proto3" json:"pod_metrics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPodSandboxMetricsResponse) Reset() {
	*x = ListPodSandboxMetricsResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[149]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPodSandboxMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodSandboxMetricsResponse) ProtoMessage() {}

func (x *ListPodSandboxMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[149]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodSandboxMetricsResponse.ProtoReflect.Descriptor instead.
func (*ListPodSandboxMetricsResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{149}
}

func (x *ListPodSandboxMetricsResponse) GetPodMetrics() []*PodSandboxMetrics {
	if x != nil {
		return x.PodMetrics
	}
	return nil
}

type PodSandboxMetrics struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	PodSandboxId     string                 `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	Metrics          []*Metric              `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	ContainerMetrics []*ContainerMetrics    `protobuf:"bytes,3,rep,name=container_metrics,json=containerMetrics,proto3" json:"container_metrics,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *PodSandboxMetrics) Reset() {
	*x = PodSandboxMetrics{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[150]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodSandboxMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSandboxMetrics) ProtoMessage() {}

func (x *PodSandboxMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[150]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSandboxMetrics.ProtoReflect.Descriptor instead.
func (*PodSandboxMetrics) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{150}
}

func (x *PodSandboxMetrics) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *PodSandboxMetrics) GetMetrics() []*Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *PodSandboxMetrics) GetContainerMetrics() []*ContainerMetrics {
	if x != nil {
		return x.ContainerMetrics
	}
	return nil
}

type ContainerMetrics struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ContainerId   string                 `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	Metrics       []*Metric              `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerMetrics) Reset() {
	*x = ContainerMetrics{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[151]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerMetrics) ProtoMessage() {}

func (x *ContainerMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[151]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerMetrics.ProtoReflect.Descriptor instead.
func (*ContainerMetrics) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{151}
}

func (x *ContainerMetrics) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *ContainerMetrics) GetMetrics() []*Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

type Metric struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name must match a name previously returned in a MetricDescriptors call,
	// otherwise, it will be ignored.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Timestamp should be 0 if the metric was gathered live.
	// If it was cached, the Timestamp should reflect the time in nanoseconds it was collected.
	Timestamp  int64      `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	MetricType MetricType `protobuf:"varint,3,opt,name=metric_type,json=metricType,proto3,enum=runtime.v1.MetricType" json:"metric_type,omitempty"`
	// The corresponding LabelValues to the LabelKeys defined in the MetricDescriptor.
	// It is the responsibility of the runtime to correctly keep sorted the keys and values.
	// If the two slices have different length, the behavior is undefined.
	LabelValues   []string     `protobuf:"bytes,4,rep,name=label_values,json=labelValues,proto3" json:"label_values,omitempty"`
	Value         *UInt64Value `protobuf:"bytes,5,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Metric) Reset() {
	*x = Metric{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[152]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metric) ProtoMessage() {}

func (x *Metric) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[152]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metric.ProtoReflect.Descriptor instead.
func (*Metric) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{152}
}

func (x *Metric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Metric) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Metric) GetMetricType() MetricType {
	if x != nil {
		return x.MetricType
	}
	return MetricType_COUNTER
}

func (x *Metric) GetLabelValues() []string {
	if x != nil {
		return x.LabelValues
	}
	return nil
}

func (x *Metric) GetValue() *UInt64Value {
	if x != nil {
		return x.Value
	}
	return nil
}

type RuntimeConfigRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RuntimeConfigRequest) Reset() {
	*x = RuntimeConfigRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[153]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfigRequest) ProtoMessage() {}

func (x *RuntimeConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[153]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfigRequest.ProtoReflect.Descriptor instead.
func (*RuntimeConfigRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{153}
}

type RuntimeConfigResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration information for Linux-based runtimes. This field contains
	// global runtime configuration options that are not specific to runtime
	// handlers.
	Linux         *LinuxRuntimeConfiguration `protobuf:"bytes,1,opt,name=linux,proto3" json:"linux,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RuntimeConfigResponse) Reset() {
	*x = RuntimeConfigResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[154]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfigResponse) ProtoMessage() {}

func (x *RuntimeConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[154]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfigResponse.ProtoReflect.Descriptor instead.
func (*RuntimeConfigResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{154}
}

func (x *RuntimeConfigResponse) GetLinux() *LinuxRuntimeConfiguration {
	if x != nil {
		return x.Linux
	}
	return nil
}

type LinuxRuntimeConfiguration struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Cgroup driver to use
	// Note: this field should not change for the lifecycle of the Kubelet,
	// or while there are running containers.
	// The Kubelet will not re-request this after startup, and will construct the cgroup
	// hierarchy assuming it is static.
	// If the runtime wishes to change this value, it must be accompanied by removal of
	// all pods, and a restart of the Kubelet. The easiest way to do this is with a full node reboot.
	CgroupDriver  CgroupDriver `protobuf:"varint,1,opt,name=cgroup_driver,json=cgroupDriver,proto3,enum=runtime.v1.CgroupDriver" json:"cgroup_driver,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LinuxRuntimeConfiguration) Reset() {
	*x = LinuxRuntimeConfiguration{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[155]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxRuntimeConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxRuntimeConfiguration) ProtoMessage() {}

func (x *LinuxRuntimeConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[155]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxRuntimeConfiguration.ProtoReflect.Descriptor instead.
func (*LinuxRuntimeConfiguration) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{155}
}

func (x *LinuxRuntimeConfiguration) GetCgroupDriver() CgroupDriver {
	if x != nil {
		return x.CgroupDriver
	}
	return CgroupDriver_SYSTEMD
}

type UpdatePodSandboxResourcesRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the PodSandbox to update.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Optional overhead represents the overheads associated with this sandbox
	Overhead *LinuxContainerResources `protobuf:"bytes,2,opt,name=overhead,proto3" json:"overhead,omitempty"`
	// Optional resources represents the sum of container resources for this sandbox
	Resources     *LinuxContainerResources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdatePodSandboxResourcesRequest) Reset() {
	*x = UpdatePodSandboxResourcesRequest{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[156]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePodSandboxResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePodSandboxResourcesRequest) ProtoMessage() {}

func (x *UpdatePodSandboxResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[156]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePodSandboxResourcesRequest.ProtoReflect.Descriptor instead.
func (*UpdatePodSandboxResourcesRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{156}
}

func (x *UpdatePodSandboxResourcesRequest) GetPodSandboxId() string {
	if x != nil {
		return x.PodSandboxId
	}
	return ""
}

func (x *UpdatePodSandboxResourcesRequest) GetOverhead() *LinuxContainerResources {
	if x != nil {
		return x.Overhead
	}
	return nil
}

func (x *UpdatePodSandboxResourcesRequest) GetResources() *LinuxContainerResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type UpdatePodSandboxResourcesResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdatePodSandboxResourcesResponse) Reset() {
	*x = UpdatePodSandboxResourcesResponse{}
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[157]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePodSandboxResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePodSandboxResourcesResponse) ProtoMessage() {}

func (x *UpdatePodSandboxResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes[157]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePodSandboxResourcesResponse.ProtoReflect.Descriptor instead.
func (*UpdatePodSandboxResourcesResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP(), []int{157}
}

var File_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto protoreflect.FileDescriptor

var file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDesc = string([]byte{
	0x0a, 0x38, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x73, 0x72, 0x63, 0x2f, 0x6b, 0x38,
	0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x63, 0x72, 0x69, 0x2d, 0x61, 0x70, 0x69, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0a, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x22, 0x2a, 0x0a, 0x0e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xa7, 0x01, 0x0a, 0x0f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5b, 0x0a, 0x09,
	0x44, 0x4e, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x73, 0x12,
	0x18, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x9c, 0x01, 0x0a, 0x0b, 0x50, 0x6f,
	0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x30, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x25, 0x0a, 0x0e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x6f,
	0x72, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x12,
	0x17, 0x0a, 0x07, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x68, 0x6f, 0x73, 0x74, 0x49, 0x70, 0x22, 0xc5, 0x03, 0x0a, 0x05, 0x4d, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73,
	0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f,
	0x73, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e,
	0x6c, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x72, 0x65,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x65, 0x6c,
	0x69, 0x6e, 0x75, 0x78, 0x52, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x3e, 0x0a, 0x0b, 0x70,
	0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f,
	0x75, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x70, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x0b, 0x75,
	0x69, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x44,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x75, 0x69, 0x64, 0x4d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x37, 0x0a, 0x0b, 0x67, 0x69, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x44, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x52, 0x0b, 0x67, 0x69, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2e, 0x0a,
	0x13, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x72, 0x65, 0x63, 0x75,
	0x72, 0x73, 0x69, 0x76, 0x65, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x2b, 0x0a,
	0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x75, 0x62, 0x50, 0x61, 0x74, 0x68,
	0x22, 0x5f, 0x0a, 0x09, 0x49, 0x44, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a,
	0x07, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06,
	0x68, 0x6f, 0x73, 0x74, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x22, 0x94, 0x01, 0x0a, 0x0d, 0x55, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x12, 0x2d, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x19, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f,
	0x64, 0x65, 0x12, 0x29, 0x0a, 0x04, 0x75, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x44,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x75, 0x69, 0x64, 0x73, 0x12, 0x29, 0x0a,
	0x04, 0x67, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x44, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x52, 0x04, 0x67, 0x69, 0x64, 0x73, 0x22, 0xff, 0x01, 0x0a, 0x0f, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x2b, 0x0a, 0x03, 0x70, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x03, 0x70, 0x69, 0x64, 0x12, 0x2b,
	0x0a, 0x03, 0x69, 0x70, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x03, 0x69, 0x70, 0x63, 0x12, 0x1b, 0x0a, 0x09, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0e, 0x75, 0x73, 0x65, 0x72,
	0x6e, 0x73, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x0d, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x22, 0x0a, 0x0a, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xa1,
	0x05, 0x0a, 0x1b, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x48,
	0x0a, 0x11, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x42, 0x0a, 0x0f, 0x73, 0x65, 0x6c, 0x69,
	0x6e, 0x75, 0x78, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x45, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73, 0x65,
	0x6c, 0x69, 0x6e, 0x75, 0x78, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x0a, 0x0b,
	0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x72, 0x75, 0x6e, 0x41, 0x73,
	0x55, 0x73, 0x65, 0x72, 0x12, 0x38, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0a, 0x72, 0x75, 0x6e, 0x41, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x27,
	0x0a, 0x0f, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x66,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c,
	0x79, 0x52, 0x6f, 0x6f, 0x74, 0x66, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x73, 0x75, 0x70, 0x70, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x03, 0x52, 0x12, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x62, 0x0a, 0x1a, 0x73, 0x75, 0x70, 0x70,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1e, 0x0a, 0x0a,
	0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x12, 0x35, 0x0a, 0x07,
	0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x07, 0x73, 0x65, 0x63, 0x63,
	0x6f, 0x6d, 0x70, 0x12, 0x37, 0x0a, 0x08, 0x61, 0x70, 0x70, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x52, 0x08, 0x61, 0x70, 0x70, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x12, 0x34, 0x0a, 0x14,
	0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12,
	0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x22, 0xc4, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x4a, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x68, 0x6f, 0x73, 0x74, 0x5f,
	0x72, 0x65, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x68, 0x6f, 0x73, 0x74, 0x52, 0x65, 0x66, 0x22, 0x40, 0x0a, 0x0b, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x6e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x68, 0x6f, 0x73, 0x74, 0x10, 0x02, 0x22, 0x9a, 0x03, 0x0a, 0x15, 0x4c, 0x69,
	0x6e, 0x75, 0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x6e, 0x75, 0x78, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x48, 0x0a, 0x07,
	0x73, 0x79, 0x73, 0x63, 0x74, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x53, 0x79, 0x73, 0x63, 0x74, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x73,
	0x79, 0x73, 0x63, 0x74, 0x6c, 0x73, 0x12, 0x3f, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x68, 0x65,
	0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x08, 0x6f,
	0x76, 0x65, 0x72, 0x68, 0x65, 0x61, 0x64, 0x12, 0x41, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x53, 0x79,
	0x73, 0x63, 0x74, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x72, 0x0a, 0x12, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x07, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x22, 0x89, 0x05, 0x0a, 0x10, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x68,
	0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68,
	0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x6f, 0x67, 0x5f, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6c, 0x6f, 0x67, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x34, 0x0a, 0x0a,
	0x64, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x4e,
	0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x64, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x3c, 0x0a, 0x0d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x52, 0x0c, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x40, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x37, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x6e, 0x75, 0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x12, 0x3d, 0x0a, 0x07,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x75, 0x0a, 0x14, 0x52, 0x75, 0x6e, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34,
	0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x22, 0x3d, 0x0a,
	0x15, 0x52, 0x75, 0x6e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x22, 0x3d, 0x0a, 0x15,
	0x53, 0x74, 0x6f, 0x70, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x22, 0x18, 0x0a, 0x16, 0x53,
	0x74, 0x6f, 0x70, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f, 0x0a, 0x17, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x22, 0x1a, 0x0a, 0x18, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x59, 0x0a, 0x17, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a,
	0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x22, 0x17, 0x0a,
	0x05, 0x50, 0x6f, 0x64, 0x49, 0x50, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x70, 0x22, 0x63, 0x0a, 0x17, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x70, 0x12, 0x38, 0x0a, 0x0e, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x69, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x49, 0x50, 0x52, 0x0d, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x73, 0x22, 0x42, 0x0a, 0x09, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x4e, 0x0a, 0x15, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x35, 0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x52, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x22,
	0xdf, 0x04, 0x0a, 0x10, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x3a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x31, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x41, 0x74, 0x12, 0x3d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x37, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x75, 0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x12, 0x40, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4f, 0x0a, 0x0b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27, 0x0a,
	0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xb9, 0x02, 0x0a, 0x18, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x42, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x4c, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x1a, 0x37, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x49, 0x0a,
	0x14, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x31, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0xf4, 0x01, 0x0a, 0x10, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x36, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x40, 0x0a,
	0x12, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x4d, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xd5,
	0x03, 0x0a, 0x0a, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3a, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x49, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x46, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f,
	0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2c, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x3e,
	0x0a, 0x16, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f,
	0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x22, 0x4c,
	0x0a, 0x17, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0xc6, 0x01, 0x0a,
	0x15, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x5b, 0x0a, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x1a, 0x40, 0x0a, 0x12, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x57, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x50,
	0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73,
	0x22, 0xf8, 0x02, 0x0a, 0x14, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3a, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x44, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x53, 0x0a, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc9, 0x01, 0x0a, 0x0f,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12,
	0x40, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x12, 0x36, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x75, 0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x12, 0x3c, 0x0a, 0x07, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x50,
	0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x07,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x22, 0xb8, 0x02, 0x0a, 0x14, 0x4c, 0x69, 0x6e, 0x75,
	0x78, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x03, 0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x70, 0x75, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x2f, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x32, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x32, 0x0a,
	0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x3a, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x23, 0x0a,
	0x02, 0x69, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x02,
	0x69, 0x6f, 0x22, 0xb8, 0x02, 0x0a, 0x16, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x50, 0x6f,
	0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x2d, 0x0a,
	0x03, 0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43,
	0x70, 0x75, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x36, 0x0a, 0x06,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x73, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x06, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x12, 0x39, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x39, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x73, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x41, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x22, 0xbf, 0x01,
	0x0a, 0x0c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x4e, 0x0a, 0x11,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x41, 0x0a, 0x0a,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x22,
	0xd4, 0x01, 0x0a, 0x13, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x55, 0x0a, 0x11, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x48, 0x0a, 0x0a,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x22, 0xff, 0x01, 0x0a, 0x15, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x08, 0x72, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x07, 0x72, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x09, 0x72, 0x78, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x72, 0x78, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x32,
	0x0a, 0x08, 0x74, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x74, 0x78, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x34, 0x0a, 0x09, 0x74, 0x78, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08,
	0x74, 0x78, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0xa8, 0x02, 0x0a, 0x1c, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x73, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a,
	0x08, 0x72, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x72, 0x78, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x45, 0x0a, 0x12, 0x72, 0x78, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f,
	0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x72, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x73, 0x44, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x12, 0x32, 0x0a, 0x08, 0x74, 0x78, 0x5f, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x07, 0x74, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x12,
	0x74, 0x78, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x64, 0x72, 0x6f, 0x70, 0x70,
	0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x10, 0x74, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x44, 0x72, 0x6f, 0x70,
	0x70, 0x65, 0x64, 0x22, 0x6a, 0x0a, 0x0c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x12, 0x3c, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22,
	0x71, 0x0a, 0x13, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x12, 0x3c, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x22, 0x86, 0x02, 0x0a, 0x09, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x48, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x30, 0x0a, 0x14, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x75, 0x73, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x1a, 0x3e, 0x0a, 0x10, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x32, 0x0a, 0x08, 0x4b,
	0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x95, 0x04, 0x0a, 0x17, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x63,
	0x70, 0x75, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x09, 0x63, 0x70, 0x75, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x70,
	0x75, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x63,
	0x70, 0x75, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x70, 0x75, 0x5f, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x70, 0x75,
	0x53, 0x68, 0x61, 0x72, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x15, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x49, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x6f, 0x6f, 0x6d,
	0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x61, 0x64, 0x6a, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0b, 0x6f, 0x6f, 0x6d, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x41, 0x64, 0x6a, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x70, 0x75, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x75, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x63, 0x70, 0x75, 0x73, 0x65, 0x74, 0x43, 0x70, 0x75, 0x73, 0x12, 0x1f,
	0x0a, 0x0b, 0x63, 0x70, 0x75, 0x73, 0x65, 0x74, 0x5f, 0x6d, 0x65, 0x6d, 0x73, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x70, 0x75, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x73, 0x12,
	0x42, 0x0a, 0x0f, 0x68, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x52, 0x0e, 0x68, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x12, 0x4a, 0x0a, 0x07, 0x75, 0x6e, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x55, 0x6e, 0x69, 0x66, 0x69, 0x65,
	0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x75, 0x6e, 0x69, 0x66, 0x69, 0x65, 0x64, 0x12,
	0x3a, 0x0a, 0x1a, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x77, 0x61, 0x70, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x16, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x53, 0x77, 0x61, 0x70, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x49, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x55,
	0x6e, 0x69, 0x66, 0x69, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x42, 0x0a, 0x0d, 0x48, 0x75, 0x67, 0x65, 0x70,
	0x61, 0x67, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x22, 0x61, 0x0a, 0x0d, 0x53,
	0x45, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72,
	0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x72, 0x6f, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x9e,
	0x01, 0x0a, 0x0a, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x29, 0x0a,
	0x10, 0x61, 0x64, 0x64, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x64, 0x64, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x72, 0x6f, 0x70,
	0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x10, 0x64, 0x72, 0x6f, 0x70, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x61, 0x64, 0x64, 0x5f, 0x61, 0x6d, 0x62,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x61, 0x64, 0x64, 0x41, 0x6d, 0x62, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22,
	0xa2, 0x07, 0x0a, 0x1d, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x3a, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52,
	0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1e, 0x0a,
	0x0a, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x12, 0x48, 0x0a,
	0x11, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x42, 0x0a, 0x0f, 0x73, 0x65, 0x6c, 0x69, 0x6e,
	0x75, 0x78, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x45,
	0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73, 0x65, 0x6c,
	0x69, 0x6e, 0x75, 0x78, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x0a, 0x0b, 0x72,
	0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x72, 0x75, 0x6e, 0x41, 0x73, 0x55,
	0x73, 0x65, 0x72, 0x12, 0x38, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0a, 0x72, 0x75, 0x6e, 0x41, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x26, 0x0a,
	0x0f, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x75, 0x6e, 0x41, 0x73, 0x55, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c,
	0x79, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x66, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e,
	0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x52, 0x6f, 0x6f, 0x74, 0x66, 0x73, 0x12, 0x2f,
	0x0a, 0x13, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x03, 0x52, 0x12, 0x73, 0x75, 0x70,
	0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12,
	0x62, 0x0a, 0x1a, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x20, 0x0a, 0x0c, 0x6e, 0x6f, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x70, 0x72,
	0x69, 0x76, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x6e, 0x6f, 0x4e, 0x65, 0x77,
	0x50, 0x72, 0x69, 0x76, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x73, 0x6b, 0x65, 0x64, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x73,
	0x6b, 0x65, 0x64, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x61, 0x64,
	0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0d, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12,
	0x35, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x07, 0x73,
	0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x12, 0x37, 0x0a, 0x08, 0x61, 0x70, 0x70, 0x61, 0x72, 0x6d,
	0x6f, 0x72, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x08, 0x61, 0x70, 0x70, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x12,
	0x2d, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x61,
	0x70, 0x70, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x34,
	0x0a, 0x14, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x12, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x50, 0x61, 0x74, 0x68, 0x22, 0xaf, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x54, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x69, 0x0a, 0x12, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x10,
	0x0a, 0x03, 0x67, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x67, 0x69, 0x64,
	0x12, 0x2f, 0x0a, 0x13, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x12, 0x73,
	0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x22, 0x4d, 0x0a, 0x16, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x22, 0xe4, 0x01, 0x0a, 0x1d, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x75, 0x6e,
	0x41, 0x73, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x21, 0x0a, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x68, 0x6f, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x4f, 0x0a, 0x11, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x6f, 0x0a, 0x17, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x54, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x73, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x95, 0x01, 0x0a, 0x1f, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x26, 0x0a, 0x0f,
	0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x75, 0x6e, 0x41, 0x73, 0x55, 0x73, 0x65, 0x72,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x12, 0x21, 0x0a,
	0x0c, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x22, 0xb5, 0x01, 0x0a, 0x16, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x0a, 0x09, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x56, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xa6, 0x02, 0x0a, 0x19, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x70, 0x75, 0x5f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x70, 0x75, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x70, 0x75, 0x5f, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75,
	0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x70, 0x75, 0x4d, 0x61, 0x78, 0x69,
	0x6d, 0x75, 0x6d, 0x12, 0x31, 0x0a, 0x15, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x12, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x49,
	0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x72, 0x6f, 0x6f, 0x74, 0x66, 0x73,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x72, 0x6f, 0x6f, 0x74, 0x66, 0x73, 0x53, 0x69, 0x7a, 0x65,
	0x49, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0d, 0x61, 0x66, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x79, 0x5f, 0x63, 0x70, 0x75, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x73, 0x43, 0x70, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x66, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x79, 0x52, 0x0c, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x43, 0x70, 0x75,
	0x73, 0x22, 0x51, 0x0a, 0x17, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43, 0x70, 0x75, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x08,
	0x63, 0x70, 0x75, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07,
	0x63, 0x70, 0x75, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x63, 0x70, 0x75, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x22, 0x41, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07,
	0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x22, 0x6e, 0x0a, 0x06, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73,
	0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x1f, 0x0a, 0x09, 0x43, 0x44, 0x49, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9c, 0x07, 0x0a, 0x0f, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2b, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72,
	0x67, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67,
	0x44, 0x69, 0x72, 0x12, 0x28, 0x0a, 0x04, 0x65, 0x6e, 0x76, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b,
	0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x65, 0x6e, 0x76, 0x73, 0x12, 0x29, 0x0a,
	0x06, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x06, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x2c, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4e, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x64, 0x69, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x05, 0x73, 0x74, 0x64, 0x69, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x64, 0x69,
	0x6e, 0x5f, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x74,
	0x64, 0x69, 0x6e, 0x4f, 0x6e, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x74, 0x79, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x74, 0x74, 0x79, 0x12, 0x36, 0x0a, 0x05, 0x6c, 0x69, 0x6e,
	0x75, 0x78, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75,
	0x78, 0x12, 0x3c, 0x0a, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x12,
	0x36, 0x0a, 0x0b, 0x43, 0x44, 0x49, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x11,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x44, 0x49, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0a, 0x43, 0x44, 0x49,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x70, 0x5f,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x52, 0x0a, 0x73, 0x74, 0x6f, 0x70, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xb8, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x12, 0x33, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x0a,
	0x0e, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x3c, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64,
	0x22, 0x3a, 0x0a, 0x15, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x22, 0x18, 0x0a, 0x16,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0x0a, 0x14, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21,
	0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0x17, 0x0a, 0x15, 0x53,
	0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0x0a, 0x16, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21,
	0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49,
	0x64, 0x22, 0x19, 0x0a, 0x17, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0x0a, 0x13,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x97, 0x02, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x35, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x12, 0x55, 0x0a, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x40, 0x0a,
	0x12, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x4c, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xb2, 0x04,
	0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x70,
	0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49,
	0x64, 0x12, 0x39, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2b, 0x0a, 0x05,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x66, 0x12, 0x30, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x48, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x19, 0x0a, 0x08,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x64, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x4f, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x0a,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x73, 0x22, 0x55, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x22, 0x95, 0x07, 0x0a, 0x0f, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x39,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x30, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x69, 0x6e,
	0x69, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a,
	0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x41, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x78,
	0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x65,
	0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65,
	0x66, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x66, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x4e, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x29, 0x0a, 0x06, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x0e,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x06, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12,
	0x19, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x50, 0x61, 0x74, 0x68, 0x12, 0x3c, 0x0a, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x49, 0x64, 0x12, 0x2d, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x52, 0x04, 0x75, 0x73,
	0x65, 0x72, 0x12, 0x33, 0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x0a, 0x73, 0x74, 0x6f,
	0x70, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xca, 0x01, 0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x41, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x37, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x90, 0x01, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75,
	0x78, 0x12, 0x3f, 0x0a, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x22, 0x45, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x55,
	0x73, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x55, 0x73,
	0x65, 0x72, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x22, 0xe0, 0x02, 0x0a, 0x1f, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x39, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e,
	0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x12, 0x3f, 0x0a, 0x07, 0x77,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x07, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x12, 0x5e, 0x0a, 0x0b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3e, 0x0a, 0x10,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x22, 0x0a, 0x20,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x60, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x6d, 0x64, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x03, 0x63, 0x6d, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x22, 0x5f, 0x0a, 0x10, 0x45, 0x78, 0x65, 0x63, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06,
	0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x43,
	0x6f, 0x64, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x0b, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x6d, 0x64, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x03, 0x63, 0x6d, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x74, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x74, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74,
	0x64, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x73, 0x74, 0x64, 0x69, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x65,
	0x72, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72,
	0x22, 0x20, 0x0a, 0x0c, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x6c, 0x22, 0x8a, 0x01, 0x0a, 0x0d, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x64, 0x69, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x73, 0x74, 0x64, 0x69, 0x6e, 0x12, 0x10, 0x0a,
	0x03, 0x74, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x74, 0x74, 0x79, 0x12,
	0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x22,
	0x22, 0x0a, 0x0e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x22, 0x4e, 0x0a, 0x12, 0x50, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64,
	0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x04, 0x70,
	0x6f, 0x72, 0x74, 0x22, 0x27, 0x0a, 0x13, 0x50, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x22, 0x3a, 0x0a, 0x0b,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x22, 0x44, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xf4,
	0x01, 0x0a, 0x05, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x70, 0x6f,
	0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x70,
	0x6f, 0x54, 0x61, 0x67, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x5f, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x70,
	0x6f, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x28, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x29, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x16, 0x0a,
	0x06, 0x70, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x70,
	0x69, 0x6e, 0x6e, 0x65, 0x64, 0x22, 0x3f, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x06, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x06,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x22, 0x5b, 0x0a, 0x12, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x05,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x62, 0x6f, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62,
	0x6f, 0x73, 0x65, 0x22, 0xb6, 0x01, 0x0a, 0x13, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x69,
	0x6e, 0x66, 0x6f, 0x1a, 0x37, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xe1, 0x01, 0x0a,
	0x0a, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x75,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0x80, 0x01, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x61, 0x75, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0x80, 0x01, 0x01, 0x52, 0x04, 0x61, 0x75, 0x74,
	0x68, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2a, 0x0a, 0x0e, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0x80, 0x01, 0x01, 0x52, 0x0d, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0x80, 0x01,
	0x01, 0x52, 0x0d, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xb0, 0x01, 0x0a, 0x10, 0x50, 0x75, 0x6c, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x12, 0x2a, 0x0a, 0x04, 0x61, 0x75, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x61, 0x75, 0x74, 0x68, 0x12, 0x43,
	0x0a, 0x0e, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0x30, 0x0a, 0x11, 0x50, 0x75, 0x6c, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x66, 0x22, 0x41, 0x0a, 0x12, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x22, 0x15, 0x0a, 0x13, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x2a, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x19, 0x0a, 0x08, 0x70, 0x6f, 0x64, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x6f, 0x64, 0x43, 0x69, 0x64, 0x72, 0x22, 0x51, 0x0a, 0x0d, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5e,
	0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0d, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x1d,
	0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x70, 0x0a,
	0x10, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a,
	0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x4d, 0x0a, 0x0d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x3c, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x29,
	0x0a, 0x0d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x22, 0x7e, 0x0a, 0x16, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x1a, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65,
	0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69,
	0x76, 0x65, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x12, 0x27, 0x0a, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x22, 0x64, 0x0a, 0x0e, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x3e, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22,
	0x4f, 0x0a, 0x0f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x12, 0x3c, 0x0a, 0x1a, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0xb6, 0x02, 0x0a, 0x0e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x38, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f,
	0x12, 0x45, 0x0a, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x52, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x12, 0x37, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x1a, 0x37, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x14, 0x0a, 0x12, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x46, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22,
	0x23, 0x0a, 0x0b, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x36, 0x0a, 0x14, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0xd8, 0x01, 0x0a,
	0x0f, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x35,
	0x0a, 0x05, 0x66, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52,
	0x04, 0x66, 0x73, 0x49, 0x64, 0x12, 0x36, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x09, 0x75, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x38, 0x0a,
	0x0b, 0x69, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x69, 0x6e, 0x6f,
	0x64, 0x65, 0x73, 0x55, 0x73, 0x65, 0x64, 0x22, 0xa5, 0x01, 0x0a, 0x16, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x12, 0x35, 0x0a, 0x05, 0x66, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x52, 0x04, 0x66, 0x73, 0x49, 0x64, 0x12, 0x36, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x64, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x75, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22,
	0xb1, 0x01, 0x0a, 0x13, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x11, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x10, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x73, 0x12, 0x50, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69,
	0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x14, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x73, 0x22, 0x3a, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x22,
	0x4a, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0x55, 0x0a, 0x19, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0xea, 0x01, 0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x70,
	0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49,
	0x64, 0x12, 0x5a, 0x0a, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x40, 0x0a,
	0x12, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x4e, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22,
	0xf4, 0x02, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x39, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x43, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xbe, 0x02, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x0a, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x0a,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x03, 0x63, 0x70,
	0x75, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x70, 0x75, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x03, 0x63,
	0x70, 0x75, 0x12, 0x2f, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x06, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x12, 0x42, 0x0a, 0x0e, 0x77, 0x72, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6c, 0x61, 0x79, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x12, 0x29, 0x0a, 0x04, 0x73, 0x77, 0x61, 0x70, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x77, 0x61, 0x70, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x04, 0x73, 0x77,
	0x61, 0x70, 0x12, 0x23, 0x0a, 0x02, 0x69, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x02, 0x69, 0x6f, 0x22, 0x8a, 0x02, 0x0a, 0x15, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x3f, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x2d, 0x0a, 0x03, 0x63, 0x70, 0x75, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x73, 0x43, 0x70, 0x75, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x03, 0x63, 0x70,
	0x75, 0x12, 0x36, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x49, 0x0a, 0x0e, 0x77, 0x72, 0x69,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4c,
	0x61, 0x79, 0x65, 0x72, 0x22, 0x5c, 0x0a, 0x08, 0x50, 0x73, 0x69, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x27, 0x0a, 0x04, 0x46, 0x75, 0x6c, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73, 0x69, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x04, 0x46, 0x75, 0x6c, 0x6c, 0x12, 0x27, 0x0a, 0x04, 0x53, 0x6f, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73, 0x69, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04, 0x53, 0x6f,
	0x6d, 0x65, 0x22, 0x63, 0x0a, 0x07, 0x50, 0x73, 0x69, 0x44, 0x61, 0x74, 0x61, 0x12, 0x14, 0x0a,
	0x05, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x54, 0x6f,
	0x74, 0x61, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x41, 0x76, 0x67, 0x31, 0x30, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x05, 0x41, 0x76, 0x67, 0x31, 0x30, 0x12, 0x14, 0x0a, 0x05, 0x41, 0x76, 0x67,
	0x36, 0x30, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x41, 0x76, 0x67, 0x36, 0x30, 0x12,
	0x16, 0x0a, 0x06, 0x41, 0x76, 0x67, 0x33, 0x30, 0x30, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x06, 0x41, 0x76, 0x67, 0x33, 0x30, 0x30, 0x22, 0xe3, 0x01, 0x0a, 0x08, 0x43, 0x70, 0x75, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x12, 0x4e, 0x0a, 0x17, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x72, 0x65,
	0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x72, 0x65, 0x4e, 0x61, 0x6e, 0x6f, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x12, 0x41, 0x0a, 0x10, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6e, 0x6f,
	0x5f, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x75, 0x73, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6e, 0x6f,
	0x43, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x03, 0x70, 0x73, 0x69, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x73, 0x69, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x03, 0x70, 0x73, 0x69, 0x22, 0xc2, 0x01,
	0x0a, 0x0f, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43, 0x70, 0x75, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x4e, 0x0a, 0x17, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x6e, 0x61,
	0x6e, 0x6f, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x72, 0x65, 0x4e, 0x61, 0x6e, 0x6f, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12,
	0x41, 0x0a, 0x10, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x5f, 0x63, 0x6f,
	0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0e, 0x75, 0x73, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6e, 0x6f, 0x43, 0x6f, 0x72,
	0x65, 0x73, 0x22, 0xc9, 0x03, 0x0a, 0x0b, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x12, 0x43, 0x0a, 0x11, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x0b, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x75, 0x73, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x34, 0x0a, 0x09, 0x72, 0x73, 0x73, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x72,
	0x73, 0x73, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x0b, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x46, 0x61, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x43, 0x0a, 0x11, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x50, 0x61, 0x67, 0x65,
	0x46, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x03, 0x70, 0x73, 0x69, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x73, 0x69, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x03, 0x70, 0x73, 0x69, 0x22, 0x4f,
	0x0a, 0x07, 0x49, 0x6f, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x26, 0x0a, 0x03, 0x70, 0x73, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x73, 0x69, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x03, 0x70, 0x73, 0x69, 0x22,
	0xb7, 0x01, 0x0a, 0x09, 0x53, 0x77, 0x61, 0x70, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x49, 0x0a, 0x14, 0x73,
	0x77, 0x61, 0x70, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x12, 0x73, 0x77, 0x61, 0x70, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x10, 0x73, 0x77, 0x61, 0x70, 0x5f, 0x75,
	0x73, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x73, 0x77, 0x61, 0x70, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0xbc, 0x02, 0x0a, 0x12, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x43,
	0x0a, 0x11, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x0b, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x47, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x3e, 0x0a, 0x19, 0x52, 0x65, 0x6f, 0x70,
	0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x22, 0x1c, 0x0a, 0x1a, 0x52, 0x65, 0x6f, 0x70,
	0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x75, 0x0a, 0x1a, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0x1d, 0x0a,
	0x1b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x12, 0x0a, 0x10,
	0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x22, 0xc6, 0x02, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50,
	0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12,
	0x4a, 0x0a, 0x12, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x10, 0x70, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4c, 0x0a, 0x13, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x22, 0x1e, 0x0a, 0x1c, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x5f, 0x0a, 0x1d, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x22, 0x59, 0x0a, 0x10, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x65, 0x6c, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x68, 0x65, 0x6c, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f,
	0x6b, 0x65, 0x79, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x4b, 0x65, 0x79, 0x73, 0x22, 0x1e, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x5f, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x0b, 0x70, 0x6f, 0x64, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x0a, 0x70, 0x6f, 0x64, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0xb2, 0x01, 0x0a, 0x11, 0x50, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x24, 0x0a, 0x0e,
	0x70, 0x6f, 0x64, 0x5f, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x49, 0x64, 0x12, 0x2c, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x49, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x63, 0x0a, 0x10, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x2c, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x22, 0xc5, 0x01, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x37, 0x0a,
	0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x16, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x16, 0x0a, 0x14, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x22, 0x54, 0x0a, 0x15, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x05, 0x6c, 0x69, 0x6e,
	0x75, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x05, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x22, 0x5a, 0x0a, 0x19, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0d, 0x63, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x52, 0x0c, 0x63, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x72, 0x22, 0xcc, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x64,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f, 0x73,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x70, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x49, 0x64, 0x12, 0x3f, 0x0a,
	0x08, 0x6f, 0x76, 0x65, 0x72, 0x68, 0x65, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e,
	0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x68, 0x65, 0x61, 0x64, 0x12, 0x41,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x6e, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x22, 0x23, 0x0a, 0x21, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2a, 0x26, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x43, 0x50, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x55,
	0x44, 0x50, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x43, 0x54, 0x50, 0x10, 0x02, 0x2a, 0x6d,
	0x0a, 0x10, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52, 0x4f, 0x50, 0x41, 0x47, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x50,
	0x52, 0x4f, 0x50, 0x41, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x48, 0x4f, 0x53, 0x54, 0x5f,
	0x54, 0x4f, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x10, 0x01, 0x12, 0x1d,
	0x0a, 0x19, 0x50, 0x52, 0x4f, 0x50, 0x41, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x49,
	0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x2a, 0x3d, 0x0a,
	0x0d, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x07,
	0x0a, 0x03, 0x50, 0x4f, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4e, 0x54, 0x41,
	0x49, 0x4e, 0x45, 0x52, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x10, 0x03, 0x2a, 0x31, 0x0a, 0x18,
	0x53, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x65, 0x72, 0x67,
	0x65, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x69, 0x63, 0x74, 0x10, 0x01, 0x2a,
	0x3a, 0x0a, 0x0f, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x41, 0x4e, 0x44, 0x42, 0x4f, 0x58, 0x5f, 0x52, 0x45,
	0x41, 0x44, 0x59, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x41, 0x4e, 0x44, 0x42, 0x4f, 0x58,
	0x5f, 0x4e, 0x4f, 0x54, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x2a, 0xac, 0x08, 0x0a, 0x06,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x55, 0x4e, 0x54, 0x49, 0x4d,
	0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53,
	0x49, 0x47, 0x41, 0x42, 0x52, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x41,
	0x4c, 0x52, 0x4d, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x47, 0x42, 0x55, 0x53, 0x10,
	0x03, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x43, 0x48, 0x4c, 0x44, 0x10, 0x04, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x49, 0x47, 0x43, 0x4c, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49,
	0x47, 0x43, 0x4f, 0x4e, 0x54, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x47, 0x46, 0x50,
	0x45, 0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x47, 0x48, 0x55, 0x50, 0x10, 0x08, 0x12,
	0x0a, 0x0a, 0x06, 0x53, 0x49, 0x47, 0x49, 0x4c, 0x4c, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x49, 0x47, 0x49, 0x4e, 0x54, 0x10, 0x0a, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x49, 0x47, 0x49, 0x4f,
	0x10, 0x0b, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x47, 0x49, 0x4f, 0x54, 0x10, 0x0c, 0x12, 0x0b,
	0x0a, 0x07, 0x53, 0x49, 0x47, 0x4b, 0x49, 0x4c, 0x4c, 0x10, 0x0d, 0x12, 0x0b, 0x0a, 0x07, 0x53,
	0x49, 0x47, 0x50, 0x49, 0x50, 0x45, 0x10, 0x0e, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x50,
	0x4f, 0x4c, 0x4c, 0x10, 0x0f, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x50, 0x52, 0x4f, 0x46,
	0x10, 0x10, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x47, 0x50, 0x57, 0x52, 0x10, 0x11, 0x12, 0x0b,
	0x0a, 0x07, 0x53, 0x49, 0x47, 0x51, 0x55, 0x49, 0x54, 0x10, 0x12, 0x12, 0x0b, 0x0a, 0x07, 0x53,
	0x49, 0x47, 0x53, 0x45, 0x47, 0x56, 0x10, 0x13, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x49, 0x47, 0x53,
	0x54, 0x4b, 0x46, 0x4c, 0x54, 0x10, 0x14, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x53, 0x54,
	0x4f, 0x50, 0x10, 0x15, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x47, 0x53, 0x59, 0x53, 0x10, 0x16,
	0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x54, 0x45, 0x52, 0x4d, 0x10, 0x17, 0x12, 0x0b, 0x0a,
	0x07, 0x53, 0x49, 0x47, 0x54, 0x52, 0x41, 0x50, 0x10, 0x18, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49,
	0x47, 0x54, 0x53, 0x54, 0x50, 0x10, 0x19, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x54, 0x54,
	0x49, 0x4e, 0x10, 0x1a, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x54, 0x54, 0x4f, 0x55, 0x10,
	0x1b, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x47, 0x55, 0x52, 0x47, 0x10, 0x1c, 0x12, 0x0b, 0x0a,
	0x07, 0x53, 0x49, 0x47, 0x55, 0x53, 0x52, 0x31, 0x10, 0x1d, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49,
	0x47, 0x55, 0x53, 0x52, 0x32, 0x10, 0x1e, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x49, 0x47, 0x56, 0x54,
	0x41, 0x4c, 0x52, 0x4d, 0x10, 0x1f, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x49, 0x47, 0x57, 0x49, 0x4e,
	0x43, 0x48, 0x10, 0x20, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x58, 0x43, 0x50, 0x55, 0x10,
	0x21, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x58, 0x46, 0x53, 0x5a, 0x10, 0x22, 0x12, 0x0c,
	0x0a, 0x08, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x10, 0x23, 0x12, 0x11, 0x0a, 0x0d,
	0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55, 0x53, 0x31, 0x10, 0x24, 0x12,
	0x11, 0x0a, 0x0d, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55, 0x53, 0x32,
	0x10, 0x25, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x50, 0x4c,
	0x55, 0x53, 0x33, 0x10, 0x26, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x49,
	0x4e, 0x50, 0x4c, 0x55, 0x53, 0x34, 0x10, 0x27, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x49, 0x47, 0x52,
	0x54, 0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55, 0x53, 0x35, 0x10, 0x28, 0x12, 0x11, 0x0a, 0x0d, 0x53,
	0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55, 0x53, 0x36, 0x10, 0x29, 0x12, 0x11,
	0x0a, 0x0d, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55, 0x53, 0x37, 0x10,
	0x2a, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55,
	0x53, 0x38, 0x10, 0x2b, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e,
	0x50, 0x4c, 0x55, 0x53, 0x39, 0x10, 0x2c, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52, 0x54,
	0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55, 0x53, 0x31, 0x30, 0x10, 0x2d, 0x12, 0x12, 0x0a, 0x0e, 0x53,
	0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55, 0x53, 0x31, 0x31, 0x10, 0x2e, 0x12,
	0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55, 0x53, 0x31,
	0x32, 0x10, 0x2f, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x50,
	0x4c, 0x55, 0x53, 0x31, 0x33, 0x10, 0x30, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52, 0x54,
	0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55, 0x53, 0x31, 0x34, 0x10, 0x31, 0x12, 0x12, 0x0a, 0x0e, 0x53,
	0x49, 0x47, 0x52, 0x54, 0x4d, 0x49, 0x4e, 0x50, 0x4c, 0x55, 0x53, 0x31, 0x35, 0x10, 0x32, 0x12,
	0x13, 0x0a, 0x0f, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58, 0x4d, 0x49, 0x4e, 0x55, 0x53,
	0x31, 0x34, 0x10, 0x33, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58,
	0x4d, 0x49, 0x4e, 0x55, 0x53, 0x31, 0x33, 0x10, 0x34, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x49, 0x47,
	0x52, 0x54, 0x4d, 0x41, 0x58, 0x4d, 0x49, 0x4e, 0x55, 0x53, 0x31, 0x32, 0x10, 0x35, 0x12, 0x13,
	0x0a, 0x0f, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58, 0x4d, 0x49, 0x4e, 0x55, 0x53, 0x31,
	0x31, 0x10, 0x36, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58, 0x4d,
	0x49, 0x4e, 0x55, 0x53, 0x31, 0x30, 0x10, 0x37, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52,
	0x54, 0x4d, 0x41, 0x58, 0x4d, 0x49, 0x4e, 0x55, 0x53, 0x39, 0x10, 0x38, 0x12, 0x12, 0x0a, 0x0e,
	0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58, 0x4d, 0x49, 0x4e, 0x55, 0x53, 0x38, 0x10, 0x39,
	0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58, 0x4d, 0x49, 0x4e, 0x55,
	0x53, 0x37, 0x10, 0x3a, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58,
	0x4d, 0x49, 0x4e, 0x55, 0x53, 0x36, 0x10, 0x3b, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52,
	0x54, 0x4d, 0x41, 0x58, 0x4d, 0x49, 0x4e, 0x55, 0x53, 0x35, 0x10, 0x3c, 0x12, 0x12, 0x0a, 0x0e,
	0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58, 0x4d, 0x49, 0x4e, 0x55, 0x53, 0x34, 0x10, 0x3d,
	0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58, 0x4d, 0x49, 0x4e, 0x55,
	0x53, 0x33, 0x10, 0x3e, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58,
	0x4d, 0x49, 0x4e, 0x55, 0x53, 0x32, 0x10, 0x3f, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x49, 0x47, 0x52,
	0x54, 0x4d, 0x41, 0x58, 0x4d, 0x49, 0x4e, 0x55, 0x53, 0x31, 0x10, 0x40, 0x12, 0x0c, 0x0a, 0x08,
	0x53, 0x49, 0x47, 0x52, 0x54, 0x4d, 0x41, 0x58, 0x10, 0x41, 0x2a, 0x6b, 0x0a, 0x0e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52,
	0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f,
	0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x45, 0x58, 0x49, 0x54, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x03, 0x2a, 0x88, 0x01, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b,
	0x0a, 0x17, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x44, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x43,
	0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44,
	0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4f, 0x4e, 0x54,
	0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x5f, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e,
	0x45, 0x52, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x10, 0x03, 0x2a, 0x24, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x45, 0x52, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x47, 0x41, 0x55, 0x47, 0x45, 0x10, 0x01, 0x2a, 0x29, 0x0a, 0x0c, 0x43, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x59, 0x53, 0x54,
	0x45, 0x4d, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x46,
	0x53, 0x10, 0x01, 0x32, 0xfa, 0x15, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x56, 0x0a, 0x0d,
	0x52, 0x75, 0x6e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x12, 0x20, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x6f,
	0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x59, 0x0a, 0x0e, 0x53, 0x74, 0x6f, 0x70, 0x50, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x12, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x50, 0x6f, 0x64, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x5f, 0x0a, 0x10, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x12, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x6f, 0x64, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x5f, 0x0a, 0x10, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x59, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64,
	0x62, 0x6f, 0x78, 0x12, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5c, 0x0a, 0x0f,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12,
	0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x59, 0x0a, 0x0e, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x21, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x56, 0x0a, 0x0d, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x20, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5c, 0x0a,
	0x0f, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x12, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x59, 0x0a, 0x0e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x21, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5c, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x77, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x2b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x65, 0x0a,
	0x12, 0x52, 0x65, 0x6f, 0x70, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x4c, 0x6f, 0x67, 0x12, 0x25, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x6f, 0x70, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6f, 0x70, 0x65, 0x6e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x47, 0x0a, 0x08, 0x45, 0x78, 0x65, 0x63, 0x53, 0x79, 0x6e, 0x63,
	0x12, 0x1b, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53,
	0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x3b, 0x0a,
	0x04, 0x45, 0x78, 0x65, 0x63, 0x12, 0x17, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x18,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x41, 0x0a, 0x06, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x12, 0x19, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x50, 0x0a,
	0x0b, 0x50, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x12, 0x1e, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x59, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x65, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x25, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x5c, 0x0a, 0x0f, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x68, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x26, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62,
	0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x68, 0x0a, 0x13, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x26, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x41, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x19, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x68, 0x0a, 0x13, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x26, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x5a, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x6e, 0x0a, 0x15,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x29, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x6e, 0x0a, 0x15,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x28, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f,
	0x78, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x29, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x56, 0x0a, 0x0d,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x21, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x7a, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f,
	0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x2c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x6f, 0x64, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x32, 0x9f, 0x03, 0x0a, 0x0c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x4d, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12,
	0x1d, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x50, 0x0a, 0x0b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x1e, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x4a, 0x0a, 0x09, 0x50, 0x75, 0x6c, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12,
	0x1c, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x6c,
	0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x50,
	0x0a, 0x0b, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x1e, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x50, 0x0a, 0x0b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x1e, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x46, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1f, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x46, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x42, 0x24, 0x5a, 0x22, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x63, 0x72, 0x69,
	0x2d, 0x61, 0x70, 0x69, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescOnce sync.Once
	file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescData []byte
)

func file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescGZIP() []byte {
	file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescOnce.Do(func() {
		file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDesc), len(file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDesc)))
	})
	return file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDescData
}

var file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes = make([]protoimpl.MessageInfo, 186)
var file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_goTypes = []any{
	(Protocol)(0),                             // 0: runtime.v1.Protocol
	(MountPropagation)(0),                     // 1: runtime.v1.MountPropagation
	(NamespaceMode)(0),                        // 2: runtime.v1.NamespaceMode
	(SupplementalGroupsPolicy)(0),             // 3: runtime.v1.SupplementalGroupsPolicy
	(PodSandboxState)(0),                      // 4: runtime.v1.PodSandboxState
	(Signal)(0),                               // 5: runtime.v1.Signal
	(ContainerState)(0),                       // 6: runtime.v1.ContainerState
	(ContainerEventType)(0),                   // 7: runtime.v1.ContainerEventType
	(MetricType)(0),                           // 8: runtime.v1.MetricType
	(CgroupDriver)(0),                         // 9: runtime.v1.CgroupDriver
	(SecurityProfile_ProfileType)(0),          // 10: runtime.v1.SecurityProfile.ProfileType
	(*VersionRequest)(nil),                    // 11: runtime.v1.VersionRequest
	(*VersionResponse)(nil),                   // 12: runtime.v1.VersionResponse
	(*DNSConfig)(nil),                         // 13: runtime.v1.DNSConfig
	(*PortMapping)(nil),                       // 14: runtime.v1.PortMapping
	(*Mount)(nil),                             // 15: runtime.v1.Mount
	(*IDMapping)(nil),                         // 16: runtime.v1.IDMapping
	(*UserNamespace)(nil),                     // 17: runtime.v1.UserNamespace
	(*NamespaceOption)(nil),                   // 18: runtime.v1.NamespaceOption
	(*Int64Value)(nil),                        // 19: runtime.v1.Int64Value
	(*LinuxSandboxSecurityContext)(nil),       // 20: runtime.v1.LinuxSandboxSecurityContext
	(*SecurityProfile)(nil),                   // 21: runtime.v1.SecurityProfile
	(*LinuxPodSandboxConfig)(nil),             // 22: runtime.v1.LinuxPodSandboxConfig
	(*PodSandboxMetadata)(nil),                // 23: runtime.v1.PodSandboxMetadata
	(*PodSandboxConfig)(nil),                  // 24: runtime.v1.PodSandboxConfig
	(*RunPodSandboxRequest)(nil),              // 25: runtime.v1.RunPodSandboxRequest
	(*RunPodSandboxResponse)(nil),             // 26: runtime.v1.RunPodSandboxResponse
	(*StopPodSandboxRequest)(nil),             // 27: runtime.v1.StopPodSandboxRequest
	(*StopPodSandboxResponse)(nil),            // 28: runtime.v1.StopPodSandboxResponse
	(*RemovePodSandboxRequest)(nil),           // 29: runtime.v1.RemovePodSandboxRequest
	(*RemovePodSandboxResponse)(nil),          // 30: runtime.v1.RemovePodSandboxResponse
	(*PodSandboxStatusRequest)(nil),           // 31: runtime.v1.PodSandboxStatusRequest
	(*PodIP)(nil),                             // 32: runtime.v1.PodIP
	(*PodSandboxNetworkStatus)(nil),           // 33: runtime.v1.PodSandboxNetworkStatus
	(*Namespace)(nil),                         // 34: runtime.v1.Namespace
	(*LinuxPodSandboxStatus)(nil),             // 35: runtime.v1.LinuxPodSandboxStatus
	(*PodSandboxStatus)(nil),                  // 36: runtime.v1.PodSandboxStatus
	(*PodSandboxStatusResponse)(nil),          // 37: runtime.v1.PodSandboxStatusResponse
	(*PodSandboxStateValue)(nil),              // 38: runtime.v1.PodSandboxStateValue
	(*PodSandboxFilter)(nil),                  // 39: runtime.v1.PodSandboxFilter
	(*ListPodSandboxRequest)(nil),             // 40: runtime.v1.ListPodSandboxRequest
	(*PodSandbox)(nil),                        // 41: runtime.v1.PodSandbox
	(*ListPodSandboxResponse)(nil),            // 42: runtime.v1.ListPodSandboxResponse
	(*PodSandboxStatsRequest)(nil),            // 43: runtime.v1.PodSandboxStatsRequest
	(*PodSandboxStatsResponse)(nil),           // 44: runtime.v1.PodSandboxStatsResponse
	(*PodSandboxStatsFilter)(nil),             // 45: runtime.v1.PodSandboxStatsFilter
	(*ListPodSandboxStatsRequest)(nil),        // 46: runtime.v1.ListPodSandboxStatsRequest
	(*ListPodSandboxStatsResponse)(nil),       // 47: runtime.v1.ListPodSandboxStatsResponse
	(*PodSandboxAttributes)(nil),              // 48: runtime.v1.PodSandboxAttributes
	(*PodSandboxStats)(nil),                   // 49: runtime.v1.PodSandboxStats
	(*LinuxPodSandboxStats)(nil),              // 50: runtime.v1.LinuxPodSandboxStats
	(*WindowsPodSandboxStats)(nil),            // 51: runtime.v1.WindowsPodSandboxStats
	(*NetworkUsage)(nil),                      // 52: runtime.v1.NetworkUsage
	(*WindowsNetworkUsage)(nil),               // 53: runtime.v1.WindowsNetworkUsage
	(*NetworkInterfaceUsage)(nil),             // 54: runtime.v1.NetworkInterfaceUsage
	(*WindowsNetworkInterfaceUsage)(nil),      // 55: runtime.v1.WindowsNetworkInterfaceUsage
	(*ProcessUsage)(nil),                      // 56: runtime.v1.ProcessUsage
	(*WindowsProcessUsage)(nil),               // 57: runtime.v1.WindowsProcessUsage
	(*ImageSpec)(nil),                         // 58: runtime.v1.ImageSpec
	(*KeyValue)(nil),                          // 59: runtime.v1.KeyValue
	(*LinuxContainerResources)(nil),           // 60: runtime.v1.LinuxContainerResources
	(*HugepageLimit)(nil),                     // 61: runtime.v1.HugepageLimit
	(*SELinuxOption)(nil),                     // 62: runtime.v1.SELinuxOption
	(*Capability)(nil),                        // 63: runtime.v1.Capability
	(*LinuxContainerSecurityContext)(nil),     // 64: runtime.v1.LinuxContainerSecurityContext
	(*LinuxContainerConfig)(nil),              // 65: runtime.v1.LinuxContainerConfig
	(*LinuxContainerUser)(nil),                // 66: runtime.v1.LinuxContainerUser
	(*WindowsNamespaceOption)(nil),            // 67: runtime.v1.WindowsNamespaceOption
	(*WindowsSandboxSecurityContext)(nil),     // 68: runtime.v1.WindowsSandboxSecurityContext
	(*WindowsPodSandboxConfig)(nil),           // 69: runtime.v1.WindowsPodSandboxConfig
	(*WindowsContainerSecurityContext)(nil),   // 70: runtime.v1.WindowsContainerSecurityContext
	(*WindowsContainerConfig)(nil),            // 71: runtime.v1.WindowsContainerConfig
	(*WindowsContainerResources)(nil),         // 72: runtime.v1.WindowsContainerResources
	(*WindowsCpuGroupAffinity)(nil),           // 73: runtime.v1.WindowsCpuGroupAffinity
	(*ContainerMetadata)(nil),                 // 74: runtime.v1.ContainerMetadata
	(*Device)(nil),                            // 75: runtime.v1.Device
	(*CDIDevice)(nil),                         // 76: runtime.v1.CDIDevice
	(*ContainerConfig)(nil),                   // 77: runtime.v1.ContainerConfig
	(*CreateContainerRequest)(nil),            // 78: runtime.v1.CreateContainerRequest
	(*CreateContainerResponse)(nil),           // 79: runtime.v1.CreateContainerResponse
	(*StartContainerRequest)(nil),             // 80: runtime.v1.StartContainerRequest
	(*StartContainerResponse)(nil),            // 81: runtime.v1.StartContainerResponse
	(*StopContainerRequest)(nil),              // 82: runtime.v1.StopContainerRequest
	(*StopContainerResponse)(nil),             // 83: runtime.v1.StopContainerResponse
	(*RemoveContainerRequest)(nil),            // 84: runtime.v1.RemoveContainerRequest
	(*RemoveContainerResponse)(nil),           // 85: runtime.v1.RemoveContainerResponse
	(*ContainerStateValue)(nil),               // 86: runtime.v1.ContainerStateValue
	(*ContainerFilter)(nil),                   // 87: runtime.v1.ContainerFilter
	(*ListContainersRequest)(nil),             // 88: runtime.v1.ListContainersRequest
	(*Container)(nil),                         // 89: runtime.v1.Container
	(*ListContainersResponse)(nil),            // 90: runtime.v1.ListContainersResponse
	(*ContainerStatusRequest)(nil),            // 91: runtime.v1.ContainerStatusRequest
	(*ContainerStatus)(nil),                   // 92: runtime.v1.ContainerStatus
	(*ContainerStatusResponse)(nil),           // 93: runtime.v1.ContainerStatusResponse
	(*ContainerResources)(nil),                // 94: runtime.v1.ContainerResources
	(*ContainerUser)(nil),                     // 95: runtime.v1.ContainerUser
	(*UpdateContainerResourcesRequest)(nil),   // 96: runtime.v1.UpdateContainerResourcesRequest
	(*UpdateContainerResourcesResponse)(nil),  // 97: runtime.v1.UpdateContainerResourcesResponse
	(*ExecSyncRequest)(nil),                   // 98: runtime.v1.ExecSyncRequest
	(*ExecSyncResponse)(nil),                  // 99: runtime.v1.ExecSyncResponse
	(*ExecRequest)(nil),                       // 100: runtime.v1.ExecRequest
	(*ExecResponse)(nil),                      // 101: runtime.v1.ExecResponse
	(*AttachRequest)(nil),                     // 102: runtime.v1.AttachRequest
	(*AttachResponse)(nil),                    // 103: runtime.v1.AttachResponse
	(*PortForwardRequest)(nil),                // 104: runtime.v1.PortForwardRequest
	(*PortForwardResponse)(nil),               // 105: runtime.v1.PortForwardResponse
	(*ImageFilter)(nil),                       // 106: runtime.v1.ImageFilter
	(*ListImagesRequest)(nil),                 // 107: runtime.v1.ListImagesRequest
	(*Image)(nil),                             // 108: runtime.v1.Image
	(*ListImagesResponse)(nil),                // 109: runtime.v1.ListImagesResponse
	(*ImageStatusRequest)(nil),                // 110: runtime.v1.ImageStatusRequest
	(*ImageStatusResponse)(nil),               // 111: runtime.v1.ImageStatusResponse
	(*AuthConfig)(nil),                        // 112: runtime.v1.AuthConfig
	(*PullImageRequest)(nil),                  // 113: runtime.v1.PullImageRequest
	(*PullImageResponse)(nil),                 // 114: runtime.v1.PullImageResponse
	(*RemoveImageRequest)(nil),                // 115: runtime.v1.RemoveImageRequest
	(*RemoveImageResponse)(nil),               // 116: runtime.v1.RemoveImageResponse
	(*NetworkConfig)(nil),                     // 117: runtime.v1.NetworkConfig
	(*RuntimeConfig)(nil),                     // 118: runtime.v1.RuntimeConfig
	(*UpdateRuntimeConfigRequest)(nil),        // 119: runtime.v1.UpdateRuntimeConfigRequest
	(*UpdateRuntimeConfigResponse)(nil),       // 120: runtime.v1.UpdateRuntimeConfigResponse
	(*RuntimeCondition)(nil),                  // 121: runtime.v1.RuntimeCondition
	(*RuntimeStatus)(nil),                     // 122: runtime.v1.RuntimeStatus
	(*StatusRequest)(nil),                     // 123: runtime.v1.StatusRequest
	(*RuntimeHandlerFeatures)(nil),            // 124: runtime.v1.RuntimeHandlerFeatures
	(*RuntimeHandler)(nil),                    // 125: runtime.v1.RuntimeHandler
	(*RuntimeFeatures)(nil),                   // 126: runtime.v1.RuntimeFeatures
	(*StatusResponse)(nil),                    // 127: runtime.v1.StatusResponse
	(*ImageFsInfoRequest)(nil),                // 128: runtime.v1.ImageFsInfoRequest
	(*UInt64Value)(nil),                       // 129: runtime.v1.UInt64Value
	(*FilesystemIdentifier)(nil),              // 130: runtime.v1.FilesystemIdentifier
	(*FilesystemUsage)(nil),                   // 131: runtime.v1.FilesystemUsage
	(*WindowsFilesystemUsage)(nil),            // 132: runtime.v1.WindowsFilesystemUsage
	(*ImageFsInfoResponse)(nil),               // 133: runtime.v1.ImageFsInfoResponse
	(*ContainerStatsRequest)(nil),             // 134: runtime.v1.ContainerStatsRequest
	(*ContainerStatsResponse)(nil),            // 135: runtime.v1.ContainerStatsResponse
	(*ListContainerStatsRequest)(nil),         // 136: runtime.v1.ListContainerStatsRequest
	(*ContainerStatsFilter)(nil),              // 137: runtime.v1.ContainerStatsFilter
	(*ListContainerStatsResponse)(nil),        // 138: runtime.v1.ListContainerStatsResponse
	(*ContainerAttributes)(nil),               // 139: runtime.v1.ContainerAttributes
	(*ContainerStats)(nil),                    // 140: runtime.v1.ContainerStats
	(*WindowsContainerStats)(nil),             // 141: runtime.v1.WindowsContainerStats
	(*PsiStats)(nil),                          // 142: runtime.v1.PsiStats
	(*PsiData)(nil),                           // 143: runtime.v1.PsiData
	(*CpuUsage)(nil),                          // 144: runtime.v1.CpuUsage
	(*WindowsCpuUsage)(nil),                   // 145: runtime.v1.WindowsCpuUsage
	(*MemoryUsage)(nil),                       // 146: runtime.v1.MemoryUsage
	(*IoUsage)(nil),                           // 147: runtime.v1.IoUsage
	(*SwapUsage)(nil),                         // 148: runtime.v1.SwapUsage
	(*WindowsMemoryUsage)(nil),                // 149: runtime.v1.WindowsMemoryUsage
	(*ReopenContainerLogRequest)(nil),         // 150: runtime.v1.ReopenContainerLogRequest
	(*ReopenContainerLogResponse)(nil),        // 151: runtime.v1.ReopenContainerLogResponse
	(*CheckpointContainerRequest)(nil),        // 152: runtime.v1.CheckpointContainerRequest
	(*CheckpointContainerResponse)(nil),       // 153: runtime.v1.CheckpointContainerResponse
	(*GetEventsRequest)(nil),                  // 154: runtime.v1.GetEventsRequest
	(*ContainerEventResponse)(nil),            // 155: runtime.v1.ContainerEventResponse
	(*ListMetricDescriptorsRequest)(nil),      // 156: runtime.v1.ListMetricDescriptorsRequest
	(*ListMetricDescriptorsResponse)(nil),     // 157: runtime.v1.ListMetricDescriptorsResponse
	(*MetricDescriptor)(nil),                  // 158: runtime.v1.MetricDescriptor
	(*ListPodSandboxMetricsRequest)(nil),      // 159: runtime.v1.ListPodSandboxMetricsRequest
	(*ListPodSandboxMetricsResponse)(nil),     // 160: runtime.v1.ListPodSandboxMetricsResponse
	(*PodSandboxMetrics)(nil),                 // 161: runtime.v1.PodSandboxMetrics
	(*ContainerMetrics)(nil),                  // 162: runtime.v1.ContainerMetrics
	(*Metric)(nil),                            // 163: runtime.v1.Metric
	(*RuntimeConfigRequest)(nil),              // 164: runtime.v1.RuntimeConfigRequest
	(*RuntimeConfigResponse)(nil),             // 165: runtime.v1.RuntimeConfigResponse
	(*LinuxRuntimeConfiguration)(nil),         // 166: runtime.v1.LinuxRuntimeConfiguration
	(*UpdatePodSandboxResourcesRequest)(nil),  // 167: runtime.v1.UpdatePodSandboxResourcesRequest
	(*UpdatePodSandboxResourcesResponse)(nil), // 168: runtime.v1.UpdatePodSandboxResourcesResponse
	nil, // 169: runtime.v1.LinuxPodSandboxConfig.SysctlsEntry
	nil, // 170: runtime.v1.PodSandboxConfig.LabelsEntry
	nil, // 171: runtime.v1.PodSandboxConfig.AnnotationsEntry
	nil, // 172: runtime.v1.PodSandboxStatus.LabelsEntry
	nil, // 173: runtime.v1.PodSandboxStatus.AnnotationsEntry
	nil, // 174: runtime.v1.PodSandboxStatusResponse.InfoEntry
	nil, // 175: runtime.v1.PodSandboxFilter.LabelSelectorEntry
	nil, // 176: runtime.v1.PodSandbox.LabelsEntry
	nil, // 177: runtime.v1.PodSandbox.AnnotationsEntry
	nil, // 178: runtime.v1.PodSandboxStatsFilter.LabelSelectorEntry
	nil, // 179: runtime.v1.PodSandboxAttributes.LabelsEntry
	nil, // 180: runtime.v1.PodSandboxAttributes.AnnotationsEntry
	nil, // 181: runtime.v1.ImageSpec.AnnotationsEntry
	nil, // 182: runtime.v1.LinuxContainerResources.UnifiedEntry
	nil, // 183: runtime.v1.ContainerConfig.LabelsEntry
	nil, // 184: runtime.v1.ContainerConfig.AnnotationsEntry
	nil, // 185: runtime.v1.ContainerFilter.LabelSelectorEntry
	nil, // 186: runtime.v1.Container.LabelsEntry
	nil, // 187: runtime.v1.Container.AnnotationsEntry
	nil, // 188: runtime.v1.ContainerStatus.LabelsEntry
	nil, // 189: runtime.v1.ContainerStatus.AnnotationsEntry
	nil, // 190: runtime.v1.ContainerStatusResponse.InfoEntry
	nil, // 191: runtime.v1.UpdateContainerResourcesRequest.AnnotationsEntry
	nil, // 192: runtime.v1.ImageStatusResponse.InfoEntry
	nil, // 193: runtime.v1.StatusResponse.InfoEntry
	nil, // 194: runtime.v1.ContainerStatsFilter.LabelSelectorEntry
	nil, // 195: runtime.v1.ContainerAttributes.LabelsEntry
	nil, // 196: runtime.v1.ContainerAttributes.AnnotationsEntry
}
var file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_depIdxs = []int32{
	0,   // 0: runtime.v1.PortMapping.protocol:type_name -> runtime.v1.Protocol
	1,   // 1: runtime.v1.Mount.propagation:type_name -> runtime.v1.MountPropagation
	16,  // 2: runtime.v1.Mount.uidMappings:type_name -> runtime.v1.IDMapping
	16,  // 3: runtime.v1.Mount.gidMappings:type_name -> runtime.v1.IDMapping
	58,  // 4: runtime.v1.Mount.image:type_name -> runtime.v1.ImageSpec
	2,   // 5: runtime.v1.UserNamespace.mode:type_name -> runtime.v1.NamespaceMode
	16,  // 6: runtime.v1.UserNamespace.uids:type_name -> runtime.v1.IDMapping
	16,  // 7: runtime.v1.UserNamespace.gids:type_name -> runtime.v1.IDMapping
	2,   // 8: runtime.v1.NamespaceOption.network:type_name -> runtime.v1.NamespaceMode
	2,   // 9: runtime.v1.NamespaceOption.pid:type_name -> runtime.v1.NamespaceMode
	2,   // 10: runtime.v1.NamespaceOption.ipc:type_name -> runtime.v1.NamespaceMode
	17,  // 11: runtime.v1.NamespaceOption.userns_options:type_name -> runtime.v1.UserNamespace
	18,  // 12: runtime.v1.LinuxSandboxSecurityContext.namespace_options:type_name -> runtime.v1.NamespaceOption
	62,  // 13: runtime.v1.LinuxSandboxSecurityContext.selinux_options:type_name -> runtime.v1.SELinuxOption
	19,  // 14: runtime.v1.LinuxSandboxSecurityContext.run_as_user:type_name -> runtime.v1.Int64Value
	19,  // 15: runtime.v1.LinuxSandboxSecurityContext.run_as_group:type_name -> runtime.v1.Int64Value
	3,   // 16: runtime.v1.LinuxSandboxSecurityContext.supplemental_groups_policy:type_name -> runtime.v1.SupplementalGroupsPolicy
	21,  // 17: runtime.v1.LinuxSandboxSecurityContext.seccomp:type_name -> runtime.v1.SecurityProfile
	21,  // 18: runtime.v1.LinuxSandboxSecurityContext.apparmor:type_name -> runtime.v1.SecurityProfile
	10,  // 19: runtime.v1.SecurityProfile.profile_type:type_name -> runtime.v1.SecurityProfile.ProfileType
	20,  // 20: runtime.v1.LinuxPodSandboxConfig.security_context:type_name -> runtime.v1.LinuxSandboxSecurityContext
	169, // 21: runtime.v1.LinuxPodSandboxConfig.sysctls:type_name -> runtime.v1.LinuxPodSandboxConfig.SysctlsEntry
	60,  // 22: runtime.v1.LinuxPodSandboxConfig.overhead:type_name -> runtime.v1.LinuxContainerResources
	60,  // 23: runtime.v1.LinuxPodSandboxConfig.resources:type_name -> runtime.v1.LinuxContainerResources
	23,  // 24: runtime.v1.PodSandboxConfig.metadata:type_name -> runtime.v1.PodSandboxMetadata
	13,  // 25: runtime.v1.PodSandboxConfig.dns_config:type_name -> runtime.v1.DNSConfig
	14,  // 26: runtime.v1.PodSandboxConfig.port_mappings:type_name -> runtime.v1.PortMapping
	170, // 27: runtime.v1.PodSandboxConfig.labels:type_name -> runtime.v1.PodSandboxConfig.LabelsEntry
	171, // 28: runtime.v1.PodSandboxConfig.annotations:type_name -> runtime.v1.PodSandboxConfig.AnnotationsEntry
	22,  // 29: runtime.v1.PodSandboxConfig.linux:type_name -> runtime.v1.LinuxPodSandboxConfig
	69,  // 30: runtime.v1.PodSandboxConfig.windows:type_name -> runtime.v1.WindowsPodSandboxConfig
	24,  // 31: runtime.v1.RunPodSandboxRequest.config:type_name -> runtime.v1.PodSandboxConfig
	32,  // 32: runtime.v1.PodSandboxNetworkStatus.additional_ips:type_name -> runtime.v1.PodIP
	18,  // 33: runtime.v1.Namespace.options:type_name -> runtime.v1.NamespaceOption
	34,  // 34: runtime.v1.LinuxPodSandboxStatus.namespaces:type_name -> runtime.v1.Namespace
	23,  // 35: runtime.v1.PodSandboxStatus.metadata:type_name -> runtime.v1.PodSandboxMetadata
	4,   // 36: runtime.v1.PodSandboxStatus.state:type_name -> runtime.v1.PodSandboxState
	33,  // 37: runtime.v1.PodSandboxStatus.network:type_name -> runtime.v1.PodSandboxNetworkStatus
	35,  // 38: runtime.v1.PodSandboxStatus.linux:type_name -> runtime.v1.LinuxPodSandboxStatus
	172, // 39: runtime.v1.PodSandboxStatus.labels:type_name -> runtime.v1.PodSandboxStatus.LabelsEntry
	173, // 40: runtime.v1.PodSandboxStatus.annotations:type_name -> runtime.v1.PodSandboxStatus.AnnotationsEntry
	36,  // 41: runtime.v1.PodSandboxStatusResponse.status:type_name -> runtime.v1.PodSandboxStatus
	174, // 42: runtime.v1.PodSandboxStatusResponse.info:type_name -> runtime.v1.PodSandboxStatusResponse.InfoEntry
	92,  // 43: runtime.v1.PodSandboxStatusResponse.containers_statuses:type_name -> runtime.v1.ContainerStatus
	4,   // 44: runtime.v1.PodSandboxStateValue.state:type_name -> runtime.v1.PodSandboxState
	38,  // 45: runtime.v1.PodSandboxFilter.state:type_name -> runtime.v1.PodSandboxStateValue
	175, // 46: runtime.v1.PodSandboxFilter.label_selector:type_name -> runtime.v1.PodSandboxFilter.LabelSelectorEntry
	39,  // 47: runtime.v1.ListPodSandboxRequest.filter:type_name -> runtime.v1.PodSandboxFilter
	23,  // 48: runtime.v1.PodSandbox.metadata:type_name -> runtime.v1.PodSandboxMetadata
	4,   // 49: runtime.v1.PodSandbox.state:type_name -> runtime.v1.PodSandboxState
	176, // 50: runtime.v1.PodSandbox.labels:type_name -> runtime.v1.PodSandbox.LabelsEntry
	177, // 51: runtime.v1.PodSandbox.annotations:type_name -> runtime.v1.PodSandbox.AnnotationsEntry
	41,  // 52: runtime.v1.ListPodSandboxResponse.items:type_name -> runtime.v1.PodSandbox
	49,  // 53: runtime.v1.PodSandboxStatsResponse.stats:type_name -> runtime.v1.PodSandboxStats
	178, // 54: runtime.v1.PodSandboxStatsFilter.label_selector:type_name -> runtime.v1.PodSandboxStatsFilter.LabelSelectorEntry
	45,  // 55: runtime.v1.ListPodSandboxStatsRequest.filter:type_name -> runtime.v1.PodSandboxStatsFilter
	49,  // 56: runtime.v1.ListPodSandboxStatsResponse.stats:type_name -> runtime.v1.PodSandboxStats
	23,  // 57: runtime.v1.PodSandboxAttributes.metadata:type_name -> runtime.v1.PodSandboxMetadata
	179, // 58: runtime.v1.PodSandboxAttributes.labels:type_name -> runtime.v1.PodSandboxAttributes.LabelsEntry
	180, // 59: runtime.v1.PodSandboxAttributes.annotations:type_name -> runtime.v1.PodSandboxAttributes.AnnotationsEntry
	48,  // 60: runtime.v1.PodSandboxStats.attributes:type_name -> runtime.v1.PodSandboxAttributes
	50,  // 61: runtime.v1.PodSandboxStats.linux:type_name -> runtime.v1.LinuxPodSandboxStats
	51,  // 62: runtime.v1.PodSandboxStats.windows:type_name -> runtime.v1.WindowsPodSandboxStats
	144, // 63: runtime.v1.LinuxPodSandboxStats.cpu:type_name -> runtime.v1.CpuUsage
	146, // 64: runtime.v1.LinuxPodSandboxStats.memory:type_name -> runtime.v1.MemoryUsage
	52,  // 65: runtime.v1.LinuxPodSandboxStats.network:type_name -> runtime.v1.NetworkUsage
	56,  // 66: runtime.v1.LinuxPodSandboxStats.process:type_name -> runtime.v1.ProcessUsage
	140, // 67: runtime.v1.LinuxPodSandboxStats.containers:type_name -> runtime.v1.ContainerStats
	147, // 68: runtime.v1.LinuxPodSandboxStats.io:type_name -> runtime.v1.IoUsage
	145, // 69: runtime.v1.WindowsPodSandboxStats.cpu:type_name -> runtime.v1.WindowsCpuUsage
	149, // 70: runtime.v1.WindowsPodSandboxStats.memory:type_name -> runtime.v1.WindowsMemoryUsage
	53,  // 71: runtime.v1.WindowsPodSandboxStats.network:type_name -> runtime.v1.WindowsNetworkUsage
	57,  // 72: runtime.v1.WindowsPodSandboxStats.process:type_name -> runtime.v1.WindowsProcessUsage
	141, // 73: runtime.v1.WindowsPodSandboxStats.containers:type_name -> runtime.v1.WindowsContainerStats
	54,  // 74: runtime.v1.NetworkUsage.default_interface:type_name -> runtime.v1.NetworkInterfaceUsage
	54,  // 75: runtime.v1.NetworkUsage.interfaces:type_name -> runtime.v1.NetworkInterfaceUsage
	55,  // 76: runtime.v1.WindowsNetworkUsage.default_interface:type_name -> runtime.v1.WindowsNetworkInterfaceUsage
	55,  // 77: runtime.v1.WindowsNetworkUsage.interfaces:type_name -> runtime.v1.WindowsNetworkInterfaceUsage
	129, // 78: runtime.v1.NetworkInterfaceUsage.rx_bytes:type_name -> runtime.v1.UInt64Value
	129, // 79: runtime.v1.NetworkInterfaceUsage.rx_errors:type_name -> runtime.v1.UInt64Value
	129, // 80: runtime.v1.NetworkInterfaceUsage.tx_bytes:type_name -> runtime.v1.UInt64Value
	129, // 81: runtime.v1.NetworkInterfaceUsage.tx_errors:type_name -> runtime.v1.UInt64Value
	129, // 82: runtime.v1.WindowsNetworkInterfaceUsage.rx_bytes:type_name -> runtime.v1.UInt64Value
	129, // 83: runtime.v1.WindowsNetworkInterfaceUsage.rx_packets_dropped:type_name -> runtime.v1.UInt64Value
	129, // 84: runtime.v1.WindowsNetworkInterfaceUsage.tx_bytes:type_name -> runtime.v1.UInt64Value
	129, // 85: runtime.v1.WindowsNetworkInterfaceUsage.tx_packets_dropped:type_name -> runtime.v1.UInt64Value
	129, // 86: runtime.v1.ProcessUsage.process_count:type_name -> runtime.v1.UInt64Value
	129, // 87: runtime.v1.WindowsProcessUsage.process_count:type_name -> runtime.v1.UInt64Value
	181, // 88: runtime.v1.ImageSpec.annotations:type_name -> runtime.v1.ImageSpec.AnnotationsEntry
	61,  // 89: runtime.v1.LinuxContainerResources.hugepage_limits:type_name -> runtime.v1.HugepageLimit
	182, // 90: runtime.v1.LinuxContainerResources.unified:type_name -> runtime.v1.LinuxContainerResources.UnifiedEntry
	63,  // 91: runtime.v1.LinuxContainerSecurityContext.capabilities:type_name -> runtime.v1.Capability
	18,  // 92: runtime.v1.LinuxContainerSecurityContext.namespace_options:type_name -> runtime.v1.NamespaceOption
	62,  // 93: runtime.v1.LinuxContainerSecurityContext.selinux_options:type_name -> runtime.v1.SELinuxOption
	19,  // 94: runtime.v1.LinuxContainerSecurityContext.run_as_user:type_name -> runtime.v1.Int64Value
	19,  // 95: runtime.v1.LinuxContainerSecurityContext.run_as_group:type_name -> runtime.v1.Int64Value
	3,   // 96: runtime.v1.LinuxContainerSecurityContext.supplemental_groups_policy:type_name -> runtime.v1.SupplementalGroupsPolicy
	21,  // 97: runtime.v1.LinuxContainerSecurityContext.seccomp:type_name -> runtime.v1.SecurityProfile
	21,  // 98: runtime.v1.LinuxContainerSecurityContext.apparmor:type_name -> runtime.v1.SecurityProfile
	60,  // 99: runtime.v1.LinuxContainerConfig.resources:type_name -> runtime.v1.LinuxContainerResources
	64,  // 100: runtime.v1.LinuxContainerConfig.security_context:type_name -> runtime.v1.LinuxContainerSecurityContext
	2,   // 101: runtime.v1.WindowsNamespaceOption.network:type_name -> runtime.v1.NamespaceMode
	67,  // 102: runtime.v1.WindowsSandboxSecurityContext.namespace_options:type_name -> runtime.v1.WindowsNamespaceOption
	68,  // 103: runtime.v1.WindowsPodSandboxConfig.security_context:type_name -> runtime.v1.WindowsSandboxSecurityContext
	72,  // 104: runtime.v1.WindowsContainerConfig.resources:type_name -> runtime.v1.WindowsContainerResources
	70,  // 105: runtime.v1.WindowsContainerConfig.security_context:type_name -> runtime.v1.WindowsContainerSecurityContext
	73,  // 106: runtime.v1.WindowsContainerResources.affinity_cpus:type_name -> runtime.v1.WindowsCpuGroupAffinity
	74,  // 107: runtime.v1.ContainerConfig.metadata:type_name -> runtime.v1.ContainerMetadata
	58,  // 108: runtime.v1.ContainerConfig.image:type_name -> runtime.v1.ImageSpec
	59,  // 109: runtime.v1.ContainerConfig.envs:type_name -> runtime.v1.KeyValue
	15,  // 110: runtime.v1.ContainerConfig.mounts:type_name -> runtime.v1.Mount
	75,  // 111: runtime.v1.ContainerConfig.devices:type_name -> runtime.v1.Device
	183, // 112: runtime.v1.ContainerConfig.labels:type_name -> runtime.v1.ContainerConfig.LabelsEntry
	184, // 113: runtime.v1.ContainerConfig.annotations:type_name -> runtime.v1.ContainerConfig.AnnotationsEntry
	65,  // 114: runtime.v1.ContainerConfig.linux:type_name -> runtime.v1.LinuxContainerConfig
	71,  // 115: runtime.v1.ContainerConfig.windows:type_name -> runtime.v1.WindowsContainerConfig
	76,  // 116: runtime.v1.ContainerConfig.CDI_devices:type_name -> runtime.v1.CDIDevice
	5,   // 117: runtime.v1.ContainerConfig.stop_signal:type_name -> runtime.v1.Signal
	77,  // 118: runtime.v1.CreateContainerRequest.config:type_name -> runtime.v1.ContainerConfig
	24,  // 119: runtime.v1.CreateContainerRequest.sandbox_config:type_name -> runtime.v1.PodSandboxConfig
	6,   // 120: runtime.v1.ContainerStateValue.state:type_name -> runtime.v1.ContainerState
	86,  // 121: runtime.v1.ContainerFilter.state:type_name -> runtime.v1.ContainerStateValue
	185, // 122: runtime.v1.ContainerFilter.label_selector:type_name -> runtime.v1.ContainerFilter.LabelSelectorEntry
	87,  // 123: runtime.v1.ListContainersRequest.filter:type_name -> runtime.v1.ContainerFilter
	74,  // 124: runtime.v1.Container.metadata:type_name -> runtime.v1.ContainerMetadata
	58,  // 125: runtime.v1.Container.image:type_name -> runtime.v1.ImageSpec
	6,   // 126: runtime.v1.Container.state:type_name -> runtime.v1.ContainerState
	186, // 127: runtime.v1.Container.labels:type_name -> runtime.v1.Container.LabelsEntry
	187, // 128: runtime.v1.Container.annotations:type_name -> runtime.v1.Container.AnnotationsEntry
	89,  // 129: runtime.v1.ListContainersResponse.containers:type_name -> runtime.v1.Container
	74,  // 130: runtime.v1.ContainerStatus.metadata:type_name -> runtime.v1.ContainerMetadata
	6,   // 131: runtime.v1.ContainerStatus.state:type_name -> runtime.v1.ContainerState
	58,  // 132: runtime.v1.ContainerStatus.image:type_name -> runtime.v1.ImageSpec
	188, // 133: runtime.v1.ContainerStatus.labels:type_name -> runtime.v1.ContainerStatus.LabelsEntry
	189, // 134: runtime.v1.ContainerStatus.annotations:type_name -> runtime.v1.ContainerStatus.AnnotationsEntry
	15,  // 135: runtime.v1.ContainerStatus.mounts:type_name -> runtime.v1.Mount
	94,  // 136: runtime.v1.ContainerStatus.resources:type_name -> runtime.v1.ContainerResources
	95,  // 137: runtime.v1.ContainerStatus.user:type_name -> runtime.v1.ContainerUser
	5,   // 138: runtime.v1.ContainerStatus.stop_signal:type_name -> runtime.v1.Signal
	92,  // 139: runtime.v1.ContainerStatusResponse.status:type_name -> runtime.v1.ContainerStatus
	190, // 140: runtime.v1.ContainerStatusResponse.info:type_name -> runtime.v1.ContainerStatusResponse.InfoEntry
	60,  // 141: runtime.v1.ContainerResources.linux:type_name -> runtime.v1.LinuxContainerResources
	72,  // 142: runtime.v1.ContainerResources.windows:type_name -> runtime.v1.WindowsContainerResources
	66,  // 143: runtime.v1.ContainerUser.linux:type_name -> runtime.v1.LinuxContainerUser
	60,  // 144: runtime.v1.UpdateContainerResourcesRequest.linux:type_name -> runtime.v1.LinuxContainerResources
	72,  // 145: runtime.v1.UpdateContainerResourcesRequest.windows:type_name -> runtime.v1.WindowsContainerResources
	191, // 146: runtime.v1.UpdateContainerResourcesRequest.annotations:type_name -> runtime.v1.UpdateContainerResourcesRequest.AnnotationsEntry
	58,  // 147: runtime.v1.ImageFilter.image:type_name -> runtime.v1.ImageSpec
	106, // 148: runtime.v1.ListImagesRequest.filter:type_name -> runtime.v1.ImageFilter
	19,  // 149: runtime.v1.Image.uid:type_name -> runtime.v1.Int64Value
	58,  // 150: runtime.v1.Image.spec:type_name -> runtime.v1.ImageSpec
	108, // 151: runtime.v1.ListImagesResponse.images:type_name -> runtime.v1.Image
	58,  // 152: runtime.v1.ImageStatusRequest.image:type_name -> runtime.v1.ImageSpec
	108, // 153: runtime.v1.ImageStatusResponse.image:type_name -> runtime.v1.Image
	192, // 154: runtime.v1.ImageStatusResponse.info:type_name -> runtime.v1.ImageStatusResponse.InfoEntry
	58,  // 155: runtime.v1.PullImageRequest.image:type_name -> runtime.v1.ImageSpec
	112, // 156: runtime.v1.PullImageRequest.auth:type_name -> runtime.v1.AuthConfig
	24,  // 157: runtime.v1.PullImageRequest.sandbox_config:type_name -> runtime.v1.PodSandboxConfig
	58,  // 158: runtime.v1.RemoveImageRequest.image:type_name -> runtime.v1.ImageSpec
	117, // 159: runtime.v1.RuntimeConfig.network_config:type_name -> runtime.v1.NetworkConfig
	118, // 160: runtime.v1.UpdateRuntimeConfigRequest.runtime_config:type_name -> runtime.v1.RuntimeConfig
	121, // 161: runtime.v1.RuntimeStatus.conditions:type_name -> runtime.v1.RuntimeCondition
	124, // 162: runtime.v1.RuntimeHandler.features:type_name -> runtime.v1.RuntimeHandlerFeatures
	122, // 163: runtime.v1.StatusResponse.status:type_name -> runtime.v1.RuntimeStatus
	193, // 164: runtime.v1.StatusResponse.info:type_name -> runtime.v1.StatusResponse.InfoEntry
	125, // 165: runtime.v1.StatusResponse.runtime_handlers:type_name -> runtime.v1.RuntimeHandler
	126, // 166: runtime.v1.StatusResponse.features:type_name -> runtime.v1.RuntimeFeatures
	130, // 167: runtime.v1.FilesystemUsage.fs_id:type_name -> runtime.v1.FilesystemIdentifier
	129, // 168: runtime.v1.FilesystemUsage.used_bytes:type_name -> runtime.v1.UInt64Value
	129, // 169: runtime.v1.FilesystemUsage.inodes_used:type_name -> runtime.v1.UInt64Value
	130, // 170: runtime.v1.WindowsFilesystemUsage.fs_id:type_name -> runtime.v1.FilesystemIdentifier
	129, // 171: runtime.v1.WindowsFilesystemUsage.used_bytes:type_name -> runtime.v1.UInt64Value
	131, // 172: runtime.v1.ImageFsInfoResponse.image_filesystems:type_name -> runtime.v1.FilesystemUsage
	131, // 173: runtime.v1.ImageFsInfoResponse.container_filesystems:type_name -> runtime.v1.FilesystemUsage
	140, // 174: runtime.v1.ContainerStatsResponse.stats:type_name -> runtime.v1.ContainerStats
	137, // 175: runtime.v1.ListContainerStatsRequest.filter:type_name -> runtime.v1.ContainerStatsFilter
	194, // 176: runtime.v1.ContainerStatsFilter.label_selector:type_name -> runtime.v1.ContainerStatsFilter.LabelSelectorEntry
	140, // 177: runtime.v1.ListContainerStatsResponse.stats:type_name -> runtime.v1.ContainerStats
	74,  // 178: runtime.v1.ContainerAttributes.metadata:type_name -> runtime.v1.ContainerMetadata
	195, // 179: runtime.v1.ContainerAttributes.labels:type_name -> runtime.v1.ContainerAttributes.LabelsEntry
	196, // 180: runtime.v1.ContainerAttributes.annotations:type_name -> runtime.v1.ContainerAttributes.AnnotationsEntry
	139, // 181: runtime.v1.ContainerStats.attributes:type_name -> runtime.v1.ContainerAttributes
	144, // 182: runtime.v1.ContainerStats.cpu:type_name -> runtime.v1.CpuUsage
	146, // 183: runtime.v1.ContainerStats.memory:type_name -> runtime.v1.MemoryUsage
	131, // 184: runtime.v1.ContainerStats.writable_layer:type_name -> runtime.v1.FilesystemUsage
	148, // 185: runtime.v1.ContainerStats.swap:type_name -> runtime.v1.SwapUsage
	147, // 186: runtime.v1.ContainerStats.io:type_name -> runtime.v1.IoUsage
	139, // 187: runtime.v1.WindowsContainerStats.attributes:type_name -> runtime.v1.ContainerAttributes
	145, // 188: runtime.v1.WindowsContainerStats.cpu:type_name -> runtime.v1.WindowsCpuUsage
	149, // 189: runtime.v1.WindowsContainerStats.memory:type_name -> runtime.v1.WindowsMemoryUsage
	132, // 190: runtime.v1.WindowsContainerStats.writable_layer:type_name -> runtime.v1.WindowsFilesystemUsage
	143, // 191: runtime.v1.PsiStats.Full:type_name -> runtime.v1.PsiData
	143, // 192: runtime.v1.PsiStats.Some:type_name -> runtime.v1.PsiData
	129, // 193: runtime.v1.CpuUsage.usage_core_nano_seconds:type_name -> runtime.v1.UInt64Value
	129, // 194: runtime.v1.CpuUsage.usage_nano_cores:type_name -> runtime.v1.UInt64Value
	142, // 195: runtime.v1.CpuUsage.psi:type_name -> runtime.v1.PsiStats
	129, // 196: runtime.v1.WindowsCpuUsage.usage_core_nano_seconds:type_name -> runtime.v1.UInt64Value
	129, // 197: runtime.v1.WindowsCpuUsage.usage_nano_cores:type_name -> runtime.v1.UInt64Value
	129, // 198: runtime.v1.MemoryUsage.working_set_bytes:type_name -> runtime.v1.UInt64Value
	129, // 199: runtime.v1.MemoryUsage.available_bytes:type_name -> runtime.v1.UInt64Value
	129, // 200: runtime.v1.MemoryUsage.usage_bytes:type_name -> runtime.v1.UInt64Value
	129, // 201: runtime.v1.MemoryUsage.rss_bytes:type_name -> runtime.v1.UInt64Value
	129, // 202: runtime.v1.MemoryUsage.page_faults:type_name -> runtime.v1.UInt64Value
	129, // 203: runtime.v1.MemoryUsage.major_page_faults:type_name -> runtime.v1.UInt64Value
	142, // 204: runtime.v1.MemoryUsage.psi:type_name -> runtime.v1.PsiStats
	142, // 205: runtime.v1.IoUsage.psi:type_name -> runtime.v1.PsiStats
	129, // 206: runtime.v1.SwapUsage.swap_available_bytes:type_name -> runtime.v1.UInt64Value
	129, // 207: runtime.v1.SwapUsage.swap_usage_bytes:type_name -> runtime.v1.UInt64Value
	129, // 208: runtime.v1.WindowsMemoryUsage.working_set_bytes:type_name -> runtime.v1.UInt64Value
	129, // 209: runtime.v1.WindowsMemoryUsage.available_bytes:type_name -> runtime.v1.UInt64Value
	129, // 210: runtime.v1.WindowsMemoryUsage.page_faults:type_name -> runtime.v1.UInt64Value
	129, // 211: runtime.v1.WindowsMemoryUsage.commit_memory_bytes:type_name -> runtime.v1.UInt64Value
	7,   // 212: runtime.v1.ContainerEventResponse.container_event_type:type_name -> runtime.v1.ContainerEventType
	36,  // 213: runtime.v1.ContainerEventResponse.pod_sandbox_status:type_name -> runtime.v1.PodSandboxStatus
	92,  // 214: runtime.v1.ContainerEventResponse.containers_statuses:type_name -> runtime.v1.ContainerStatus
	158, // 215: runtime.v1.ListMetricDescriptorsResponse.descriptors:type_name -> runtime.v1.MetricDescriptor
	161, // 216: runtime.v1.ListPodSandboxMetricsResponse.pod_metrics:type_name -> runtime.v1.PodSandboxMetrics
	163, // 217: runtime.v1.PodSandboxMetrics.metrics:type_name -> runtime.v1.Metric
	162, // 218: runtime.v1.PodSandboxMetrics.container_metrics:type_name -> runtime.v1.ContainerMetrics
	163, // 219: runtime.v1.ContainerMetrics.metrics:type_name -> runtime.v1.Metric
	8,   // 220: runtime.v1.Metric.metric_type:type_name -> runtime.v1.MetricType
	129, // 221: runtime.v1.Metric.value:type_name -> runtime.v1.UInt64Value
	166, // 222: runtime.v1.RuntimeConfigResponse.linux:type_name -> runtime.v1.LinuxRuntimeConfiguration
	9,   // 223: runtime.v1.LinuxRuntimeConfiguration.cgroup_driver:type_name -> runtime.v1.CgroupDriver
	60,  // 224: runtime.v1.UpdatePodSandboxResourcesRequest.overhead:type_name -> runtime.v1.LinuxContainerResources
	60,  // 225: runtime.v1.UpdatePodSandboxResourcesRequest.resources:type_name -> runtime.v1.LinuxContainerResources
	11,  // 226: runtime.v1.RuntimeService.Version:input_type -> runtime.v1.VersionRequest
	25,  // 227: runtime.v1.RuntimeService.RunPodSandbox:input_type -> runtime.v1.RunPodSandboxRequest
	27,  // 228: runtime.v1.RuntimeService.StopPodSandbox:input_type -> runtime.v1.StopPodSandboxRequest
	29,  // 229: runtime.v1.RuntimeService.RemovePodSandbox:input_type -> runtime.v1.RemovePodSandboxRequest
	31,  // 230: runtime.v1.RuntimeService.PodSandboxStatus:input_type -> runtime.v1.PodSandboxStatusRequest
	40,  // 231: runtime.v1.RuntimeService.ListPodSandbox:input_type -> runtime.v1.ListPodSandboxRequest
	78,  // 232: runtime.v1.RuntimeService.CreateContainer:input_type -> runtime.v1.CreateContainerRequest
	80,  // 233: runtime.v1.RuntimeService.StartContainer:input_type -> runtime.v1.StartContainerRequest
	82,  // 234: runtime.v1.RuntimeService.StopContainer:input_type -> runtime.v1.StopContainerRequest
	84,  // 235: runtime.v1.RuntimeService.RemoveContainer:input_type -> runtime.v1.RemoveContainerRequest
	88,  // 236: runtime.v1.RuntimeService.ListContainers:input_type -> runtime.v1.ListContainersRequest
	91,  // 237: runtime.v1.RuntimeService.ContainerStatus:input_type -> runtime.v1.ContainerStatusRequest
	96,  // 238: runtime.v1.RuntimeService.UpdateContainerResources:input_type -> runtime.v1.UpdateContainerResourcesRequest
	150, // 239: runtime.v1.RuntimeService.ReopenContainerLog:input_type -> runtime.v1.ReopenContainerLogRequest
	98,  // 240: runtime.v1.RuntimeService.ExecSync:input_type -> runtime.v1.ExecSyncRequest
	100, // 241: runtime.v1.RuntimeService.Exec:input_type -> runtime.v1.ExecRequest
	102, // 242: runtime.v1.RuntimeService.Attach:input_type -> runtime.v1.AttachRequest
	104, // 243: runtime.v1.RuntimeService.PortForward:input_type -> runtime.v1.PortForwardRequest
	134, // 244: runtime.v1.RuntimeService.ContainerStats:input_type -> runtime.v1.ContainerStatsRequest
	136, // 245: runtime.v1.RuntimeService.ListContainerStats:input_type -> runtime.v1.ListContainerStatsRequest
	43,  // 246: runtime.v1.RuntimeService.PodSandboxStats:input_type -> runtime.v1.PodSandboxStatsRequest
	46,  // 247: runtime.v1.RuntimeService.ListPodSandboxStats:input_type -> runtime.v1.ListPodSandboxStatsRequest
	119, // 248: runtime.v1.RuntimeService.UpdateRuntimeConfig:input_type -> runtime.v1.UpdateRuntimeConfigRequest
	123, // 249: runtime.v1.RuntimeService.Status:input_type -> runtime.v1.StatusRequest
	152, // 250: runtime.v1.RuntimeService.CheckpointContainer:input_type -> runtime.v1.CheckpointContainerRequest
	154, // 251: runtime.v1.RuntimeService.GetContainerEvents:input_type -> runtime.v1.GetEventsRequest
	156, // 252: runtime.v1.RuntimeService.ListMetricDescriptors:input_type -> runtime.v1.ListMetricDescriptorsRequest
	159, // 253: runtime.v1.RuntimeService.ListPodSandboxMetrics:input_type -> runtime.v1.ListPodSandboxMetricsRequest
	164, // 254: runtime.v1.RuntimeService.RuntimeConfig:input_type -> runtime.v1.RuntimeConfigRequest
	167, // 255: runtime.v1.RuntimeService.UpdatePodSandboxResources:input_type -> runtime.v1.UpdatePodSandboxResourcesRequest
	107, // 256: runtime.v1.ImageService.ListImages:input_type -> runtime.v1.ListImagesRequest
	110, // 257: runtime.v1.ImageService.ImageStatus:input_type -> runtime.v1.ImageStatusRequest
	113, // 258: runtime.v1.ImageService.PullImage:input_type -> runtime.v1.PullImageRequest
	115, // 259: runtime.v1.ImageService.RemoveImage:input_type -> runtime.v1.RemoveImageRequest
	128, // 260: runtime.v1.ImageService.ImageFsInfo:input_type -> runtime.v1.ImageFsInfoRequest
	12,  // 261: runtime.v1.RuntimeService.Version:output_type -> runtime.v1.VersionResponse
	26,  // 262: runtime.v1.RuntimeService.RunPodSandbox:output_type -> runtime.v1.RunPodSandboxResponse
	28,  // 263: runtime.v1.RuntimeService.StopPodSandbox:output_type -> runtime.v1.StopPodSandboxResponse
	30,  // 264: runtime.v1.RuntimeService.RemovePodSandbox:output_type -> runtime.v1.RemovePodSandboxResponse
	37,  // 265: runtime.v1.RuntimeService.PodSandboxStatus:output_type -> runtime.v1.PodSandboxStatusResponse
	42,  // 266: runtime.v1.RuntimeService.ListPodSandbox:output_type -> runtime.v1.ListPodSandboxResponse
	79,  // 267: runtime.v1.RuntimeService.CreateContainer:output_type -> runtime.v1.CreateContainerResponse
	81,  // 268: runtime.v1.RuntimeService.StartContainer:output_type -> runtime.v1.StartContainerResponse
	83,  // 269: runtime.v1.RuntimeService.StopContainer:output_type -> runtime.v1.StopContainerResponse
	85,  // 270: runtime.v1.RuntimeService.RemoveContainer:output_type -> runtime.v1.RemoveContainerResponse
	90,  // 271: runtime.v1.RuntimeService.ListContainers:output_type -> runtime.v1.ListContainersResponse
	93,  // 272: runtime.v1.RuntimeService.ContainerStatus:output_type -> runtime.v1.ContainerStatusResponse
	97,  // 273: runtime.v1.RuntimeService.UpdateContainerResources:output_type -> runtime.v1.UpdateContainerResourcesResponse
	151, // 274: runtime.v1.RuntimeService.ReopenContainerLog:output_type -> runtime.v1.ReopenContainerLogResponse
	99,  // 275: runtime.v1.RuntimeService.ExecSync:output_type -> runtime.v1.ExecSyncResponse
	101, // 276: runtime.v1.RuntimeService.Exec:output_type -> runtime.v1.ExecResponse
	103, // 277: runtime.v1.RuntimeService.Attach:output_type -> runtime.v1.AttachResponse
	105, // 278: runtime.v1.RuntimeService.PortForward:output_type -> runtime.v1.PortForwardResponse
	135, // 279: runtime.v1.RuntimeService.ContainerStats:output_type -> runtime.v1.ContainerStatsResponse
	138, // 280: runtime.v1.RuntimeService.ListContainerStats:output_type -> runtime.v1.ListContainerStatsResponse
	44,  // 281: runtime.v1.RuntimeService.PodSandboxStats:output_type -> runtime.v1.PodSandboxStatsResponse
	47,  // 282: runtime.v1.RuntimeService.ListPodSandboxStats:output_type -> runtime.v1.ListPodSandboxStatsResponse
	120, // 283: runtime.v1.RuntimeService.UpdateRuntimeConfig:output_type -> runtime.v1.UpdateRuntimeConfigResponse
	127, // 284: runtime.v1.RuntimeService.Status:output_type -> runtime.v1.StatusResponse
	153, // 285: runtime.v1.RuntimeService.CheckpointContainer:output_type -> runtime.v1.CheckpointContainerResponse
	155, // 286: runtime.v1.RuntimeService.GetContainerEvents:output_type -> runtime.v1.ContainerEventResponse
	157, // 287: runtime.v1.RuntimeService.ListMetricDescriptors:output_type -> runtime.v1.ListMetricDescriptorsResponse
	160, // 288: runtime.v1.RuntimeService.ListPodSandboxMetrics:output_type -> runtime.v1.ListPodSandboxMetricsResponse
	165, // 289: runtime.v1.RuntimeService.RuntimeConfig:output_type -> runtime.v1.RuntimeConfigResponse
	168, // 290: runtime.v1.RuntimeService.UpdatePodSandboxResources:output_type -> runtime.v1.UpdatePodSandboxResourcesResponse
	109, // 291: runtime.v1.ImageService.ListImages:output_type -> runtime.v1.ListImagesResponse
	111, // 292: runtime.v1.ImageService.ImageStatus:output_type -> runtime.v1.ImageStatusResponse
	114, // 293: runtime.v1.ImageService.PullImage:output_type -> runtime.v1.PullImageResponse
	116, // 294: runtime.v1.ImageService.RemoveImage:output_type -> runtime.v1.RemoveImageResponse
	133, // 295: runtime.v1.ImageService.ImageFsInfo:output_type -> runtime.v1.ImageFsInfoResponse
	261, // [261:296] is the sub-list for method output_type
	226, // [226:261] is the sub-list for method input_type
	226, // [226:226] is the sub-list for extension type_name
	226, // [226:226] is the sub-list for extension extendee
	0,   // [0:226] is the sub-list for field type_name
}

func init() { file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_init() }
func file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_init() {
	if File_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDesc), len(file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_rawDesc)),
			NumEnums:      11,
			NumMessages:   186,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_goTypes,
		DependencyIndexes: file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_depIdxs,
		EnumInfos:         file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_enumTypes,
		MessageInfos:      file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_msgTypes,
	}.Build()
	File_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto = out.File
	file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_goTypes = nil
	file_staging_src_k8s_io_cri_api_pkg_apis_runtime_v1_api_proto_depIdxs = nil
}
