; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2023-2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================
; REQUIRES: llvm-14-plus, regkeys
; RUN: igc_opt -platformbmg -igc-emit-visa -simd-mode 16 -inputrt -regkey ResourceLoopUnrollIteration=4,DumpVISAASMToConsole -S < %s | FileCheck %s
;
; Test checks how we emit ResourceLoop


@ThreadGroupSize_X = constant i32 64
@ThreadGroupSize_Y = constant i32 1
@ThreadGroupSize_Z = constant i32 1

define spir_kernel void @test1(i32 %src1, i32 %val, i32 addrspace(1)* %dst) {
entry:
; CHECK:  _main_0:

  %svn = call i16 @llvm.genx.GenISA.DCL.SystemValue.i16(i32 17)
; CHECK:      mov (M1, 16) svn(0,0)<1> threadIdInGroupX(0,0)<1;1,0>

  %nonuniform = zext i16 %svn to i32
; CHECK:      mov (M1, 16) nonuniform(0,0)<1> svn{{.*}}(0,0)<1;1,0>

  %NonUniformResource = inttoptr i32 %nonuniform to <4 x float> addrspace(2621440)*
  %offset = add i32 %src1, 1
; CHECK:      add (M1_NM, 1) offset(0,0)<1> src1(0,0)<0;1,0> 0x1:w
; CHECK:      mov (M1_NM, 1) offsetTrunc(0,0)<1> offset(0,0)<0;1,0>
; CHECK:      mov (M1, 16) offsetTruncBroadcast(0,0)<1> offsetTrunc(0,0)<0;1,0>

  %call = call <3 x i32> @llvm.genx.GenISA.ldrawvector.indexed.v3i32.p2621440v4f32(<4 x float> addrspace(2621440)* %NonUniformResource, i32 %offset, i32 4, i1 false)
; CHECK:  _test1_001__opt_resource_loop:
; CHECK:     setp (M1_NM, 16) P4 0x0:ud
; CHECK:     setp (M1_NM, 16) P5 0x0:ud
; CHECK:     cmp.eq (M1, 16) P5 V0032(0,0)<0;1,0> V0032(0,0)<0;1,0>
; CHECK:     mov (M1_NM, 1) V0033(0,0)<1> P5
; CHECK:     fbl (M1_NM, 1) V0034(0,0)<1> V0033(0,0)<0;1,0>
; CHECK:     shl (M1_NM, 1) V0034(0,0)<1> V0034(0,0)<0;1,0> 0x2:w
; CHECK:     addr_add (M1_NM, 1) A0(0)<1> &nonuniform V0035(0,0)<0;1,0>
; CHECK:     mov (M1_NM, 1) V0036(0,0)<1> r[A0(0),0]<0;1,0>:d
; CHECK:     cmp.eq (M1, 16) P6 V0036(0,0)<0;1,0> nonuniform(0,0)<1;1,0>
; CHECK:     (P6) lsc_load.ugm.ca.ca (M1, 16)  call_:d32x3  bss(V0036)[offsetTruncBroadcast]:a32
; CHECK:     or (M1_NM, 16) P4 P4 P6
; CHECK:     xor (M1_NM, 16) P5 P5 P6
; CHECK:     mov (M1_NM, 1) V0033(0,0)<1> P5
; CHECK:     fbl (M1_NM, 1) V0037(0,0)<1> V0033(0,0)<0;1,0>
; CHECK:     and (M1_NM, 1) V0037(0,0)<1> V0037(0,0)<0;1,0> 0xf:ud
; CHECK:     shl (M1_NM, 1) V0037(0,0)<1> V0037(0,0)<0;1,0> 0x2:w
; CHECK:     addr_add (M1_NM, 1) A1(0)<1> &nonuniform V0038(0,0)<0;1,0>
; CHECK:     mov (M1_NM, 1) V0039(0,0)<1> r[A1(0),0]<0;1,0>:d
; CHECK:     cmp.eq (M1, 16) P7 V0039(0,0)<0;1,0> nonuniform(0,0)<1;1,0>
; CHECK:     and (M1_NM, 16) P7 P7 P5
; CHECK:     (P7) lsc_load.ugm.ca.ca (M1, 16)  call_:d32x3  bss(V0039)[offsetTruncBroadcast]:a32
; CHECK:     or (M1_NM, 16) P4 P4 P7
; CHECK:     xor (M1_NM, 16) P5 P5 P7
; CHECK:     mov (M1_NM, 1) V0033(0,0)<1> P5
; CHECK:     fbl (M1_NM, 1) V0040(0,0)<1> V0033(0,0)<0;1,0>
; CHECK:     and (M1_NM, 1) V0040(0,0)<1> V0040(0,0)<0;1,0> 0xf:ud
; CHECK:     shl (M1_NM, 1) V0040(0,0)<1> V0040(0,0)<0;1,0> 0x2:w
; CHECK:     addr_add (M1_NM, 1) A2(0)<1> &nonuniform V0041(0,0)<0;1,0>
; CHECK:     mov (M1_NM, 1) V0042(0,0)<1> r[A2(0),0]<0;1,0>:d
; CHECK:     cmp.eq (M1, 16) P8 V0042(0,0)<0;1,0> nonuniform(0,0)<1;1,0>
; CHECK:     and (M1_NM, 16) P8 P8 P5
; CHECK:     (P8) lsc_load.ugm.ca.ca (M1, 16)  call_:d32x3  bss(V0042)[offsetTruncBroadcast]:a32
; CHECK:     or (M1_NM, 16) P4 P4 P8
; CHECK:     xor (M1_NM, 16) P5 P5 P8
; CHECK:     mov (M1_NM, 1) V0033(0,0)<1> P5
; CHECK:     fbl (M1_NM, 1) V0043(0,0)<1> V0033(0,0)<0;1,0>
; CHECK:     and (M1_NM, 1) V0043(0,0)<1> V0043(0,0)<0;1,0> 0xf:ud
; CHECK:     shl (M1_NM, 1) V0043(0,0)<1> V0043(0,0)<0;1,0> 0x2:w
; CHECK:     addr_add (M1_NM, 1) A3(0)<1> &nonuniform V0044(0,0)<0;1,0>
; CHECK:     mov (M1_NM, 1) V0045(0,0)<1> r[A3(0),0]<0;1,0>:d
; CHECK:     cmp.eq (M1, 16) P9 V0045(0,0)<0;1,0> nonuniform(0,0)<1;1,0>
; CHECK:     and (M1_NM, 16) P9 P9 P5
; CHECK:     (P9) lsc_load.ugm.ca.ca (M1, 16)  call_:d32x3  bss(V0045)[offsetTruncBroadcast]:a32
; CHECK:     or (M1_NM, 16) P4 P4 P9
; CHECK:     (!P4) goto (M1, 16) _test1_001__opt_resource_loop
  %out = extractelement <3 x i32> %call, i32 %val
  store i32 %out, i32 addrspace(1)* %dst, align 1
  ret void
}

declare <3 x i32> @llvm.genx.GenISA.ldrawvector.indexed.v3i32.p2621440v4f32(<4 x float> addrspace(2621440)*, i32, i32, i1) #4

declare i16 @llvm.genx.GenISA.DCL.SystemValue.i16(i32) #1
declare i32 @llvm.genx.GenISA.WaveShuffleIndex.i32(i32, i32, i32) #6

declare i32 @llvm.genx.GenISA.WaveBallot(i1, i32)
declare i32 @llvm.genx.GenISA.firstbitLo(i32)

attributes #4 = { argmemonly nounwind readonly }


!IGCMetadata = !{!0}
!igc.functions = !{!21}

!0 = !{!"ModuleMD", !1}
!1 = !{!"FuncMD", !2, !3}
!2 = !{!"FuncMDMap[0]", void (i32, i32, i32 addrspace(1)*)* @test1}
!3 = !{!"FuncMDValue[0]", !4, !17}
!4 = !{!"resAllocMD", !5}
!5 = !{!"argAllocMDList", !6, !10, !11, !14, !15, !16}
!6 = !{!"argAllocMDListVec[0]", !7, !8, !9}
!7 = !{!"type", i32 0}
!8 = !{!"extensionType", i32 -1}
!9 = !{!"indexType", i32 -1}
!10 = !{!"argAllocMDListVec[1]", !7, !8, !9}
!11 = !{!"argAllocMDListVec[2]", !12, !8, !13}
!12 = !{!"type", i32 1}
!13 = !{!"indexType", i32 0}
!14 = !{!"argAllocMDListVec[3]", !7, !8, !9}
!15 = !{!"argAllocMDListVec[4]", !7, !8, !9}
!16 = !{!"argAllocMDListVec[5]", !7, !8, !9}
!17 = !{!"m_OpenCLArgTypeQualifiers", !18, !19, !20}
!18 = !{!"m_OpenCLArgTypeQualifiersVec[0]", !""}
!19 = !{!"m_OpenCLArgTypeQualifiersVec[1]", !""}
!20 = !{!"m_OpenCLArgTypeQualifiersVec[2]", !""}
!21 = !{void (i32, i32, i32 addrspace(1)*)* @test1, !22}
!22 = !{!23}
!23 = !{!"function_type", i32 0}

