/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-std=c23 -pedantic-errors" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

__attribute__((noipa)) void
foo (int *p)
{
  *p = 1;
}

#if __BITINT_MAXWIDTH__ >= 512
__attribute__((noipa)) void
test512 (unsigned _BitInt(512) *p, _BitInt(512) *q, int *r, int i, int j, int k)
{
  int l;
  for (l = 0; l < 15; ++l)
    {
      r[l * 4] = p[l * 2] < p[l * 2 + 1];
      r[l * 4 + 1] = p[l * 2 + i] <= p[l * 2 + 1 + i];
      r[l * 4 + 2] = p[l * 2 + j] > p[l * 2 + 1 + j];
      r[l * 4 + 3] = p[l * 2 + k] >= p[l * 2 + 1 + k];
    }
  r[60] = 0;
  if (p[30] < p[31])
    foo (r + 60);
  r[61] = 0;
  if (p[30 + i] <= p[31 + i])
    foo (r + 61);
  r[62] = 0;
  if (p[30 + j] > p[31 + j])
    foo (r + 62);
  r[63] = 0;
  if (p[30 + k] >= p[31 + k])
    foo (r + 63);
  for (l = 0; l < 15; ++l)
    {
      r[64 + l * 4] = q[l * 2] < q[l * 2 + 1];
      r[64 + l * 4 + 1] = q[l * 2 + i] <= q[l * 2 + 1 + i];
      r[64 + l * 4 + 2] = q[l * 2 + j] > q[l * 2 + 1 + j];
      r[64 + l * 4 + 3] = q[l * 2 + k] >= q[l * 2 + 1 + k];
    }
  r[124] = 0;
  if (q[30] < q[31])
    foo (r + 124);
  r[125] = 0;
  if (q[30 + i] <= q[31 + i])
    foo (r + 125);
  r[126] = 0;
  if (q[30 + j] > q[31 + j])
    foo (r + 126);
  r[127] = 0;
  if (q[30 + k] >= q[31 + k])
    foo (r + 127);
  r[128] = p[1] > 6439347061437255154344143895240926184374246647113289384213701629724754669640618959339573646567333876513773564431668184949351528059730009728584631317244784uwb;
  r[129] = p[1 + i] >= 6439347061437255154344143895240926184374246647113289384213701629724754669640618959339573646567333876513773564431668184949351528059730009728584631317244784uwb;
  r[130] = p[1 + j] < 6439347061437255154344143895240926184374246647113289384213701629724754669640618959339573646567333876513773564431668184949351528059730009728584631317244784uwb;
  r[131] = p[1 + k] <= 6439347061437255154344143895240926184374246647113289384213701629724754669640618959339573646567333876513773564431668184949351528059730009728584631317244784uwb;
  r[132] = p[9] > 2716607166516370952811015778464637315429428288163165175168021720761495785980681441127279995453132974713988249553556243035771473482679750625718958791524521uwb;
  r[133] = p[9 + i] >= 2716607166516370952811015778464637315429428288163165175168021720761495785980681441127279995453132974713988249553556243035771473482679750625718958791524521uwb;
  r[134] = p[9 + j] < 2716607166516370952811015778464637315429428288163165175168021720761495785980681441127279995453132974713988249553556243035771473482679750625718958791524521uwb;
  r[135] = p[9 + k] <= 2716607166516370952811015778464637315429428288163165175168021720761495785980681441127279995453132974713988249553556243035771473482679750625718958791524521uwb;
  r[136] = p[26] > 419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb;
  r[137] = p[26 + i] >= 419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb;
  r[138] = p[26 + j] < 419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb;
  r[139] = p[26 + k] <= 419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb;
  r[140] = 0;
  if (p[27] > 419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb)
    foo (r + 140);
  r[141] = 0;
  if (p[27 + i] >= 419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb)
    foo (r + 141);
  r[142] = 0;
  if (p[27 + j] < 419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb)
    foo (r + 142);
  r[143] = 0;
  if (p[27 + k] <= 419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb)
    foo (r + 143);
  r[144] = q[1] > 2090630783083976726560608899307022527212315311978198188753257152565888263284874347844598962661131937985796633260411082466462809997821330828145983020205878wb;
  r[145] = q[1 + i] >= 2090630783083976726560608899307022527212315311978198188753257152565888263284874347844598962661131937985796633260411082466462809997821330828145983020205878wb;
  r[146] = q[1 + j] < 2090630783083976726560608899307022527212315311978198188753257152565888263284874347844598962661131937985796633260411082466462809997821330828145983020205878wb;
  r[147] = q[1 + k] <= 2090630783083976726560608899307022527212315311978198188753257152565888263284874347844598962661131937985796633260411082466462809997821330828145983020205878wb;
  r[148] = q[9] > -696290237363643551117711996671220443230309432588348036053438948181530078288074148843479004574555088489161912619769067173411081743987060302136728183033248wb;
  r[149] = q[9 + i] >= -696290237363643551117711996671220443230309432588348036053438948181530078288074148843479004574555088489161912619769067173411081743987060302136728183033248wb;
  r[150] = q[9 + j] < -696290237363643551117711996671220443230309432588348036053438948181530078288074148843479004574555088489161912619769067173411081743987060302136728183033248wb;
  r[151] = q[9 + k] <= -696290237363643551117711996671220443230309432588348036053438948181530078288074148843479004574555088489161912619769067173411081743987060302136728183033248wb;
  r[152] = q[26] > 3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb;
  r[153] = q[26 + i] >= 3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb;
  r[154] = q[26 + j] < 3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb;
  r[155] = q[26 + k] <= 3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb;
  r[156] = 0;
  if (q[27] > 3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb)
    foo (r + 156);
  r[157] = 0;
  if (q[27 + i] >= 3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb)
    foo (r + 157);
  r[158] = 0;
  if (q[27 + j] < 3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb)
    foo (r + 158);
  r[159] = 0;
  if (q[27 + k] <= 3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb)
    foo (r + 159);
}

__attribute__((noipa)) void
check512 (void)
{
  static unsigned _BitInt(512) p[] = {
    6439347061437255154344143895240926184374246647113289384213701629724754669640618959339573646567333876513773564431668184949351528059730009728584631317244784uwb,
    6762041868534283027737681277586698577353418805123389711320743680311823204229693866395914533471197396356562852824213136960386892331859705466032560089589592uwb,
    7100250278744661687919272778464450926810863027145401799102911979534742186567792066709428057992170537490418870754413231800386208987723160090542309342698220uwb,
    7431268529135416278983437544316801791166063098864169546640210976381712748574214253654088092817057535251702063086179197094765059987561230250458545651487418uwb,
    9387962895034579582865984241538651927900235272350318828874682759815638374313243456156983345067518642781984662712425803679907225577643018022275640009873699uwb,
    3166230719682742738348931360884455391542162846555514350392658765013906649241346404508710229903813619084763077863317735446920504536945766338357887078773371uwb,
    11992372489178914246038509566828166672578807653701495597132497332700673199287169715202932677475715468669004681974601325099819634089747001502188758884172602uwb,
    7183772320147988217157628195460873099945185725664709745424293290802245140824151762181161628318220701467892891169914379357484378623421022918276231818933625uwb,
    2716607166516370952811015778464637315429428288163165175168021720761495785980681441127279995453132974713988249553556243035771473482679750625718958791524521uwb,
    2716607166516370952811015778464637315429428288163165175168021720761495785980681441127279995453132974713988249553556243035771473482679750625718958791524521uwb - 1,
    12641036253945464668613158871576838890244642877026977530604698385615142732677552062689011995329072722635530415107759810021792111602714418929346777947581722uwb,
    12641036253945464668613158871576838890244642877026977530604698385615142732677552062689011995329072722635530415107759810021792111602714418929346777947581722uwb + 1,
    8922448217105188951537312155524913197158477782806467330054048115953920100033906218746035610108190050394196228624539921400738404901092299164323787527159808uwb,
    8922448217105188951537312155524913197158477782806467330054048115953920100033906218746035610108190050394196228624539921400738404901092299164323787527159808uwb - 18446744073709551616uwb,
    8922448217105188951537312155524913197158477782806467330054048115953920100033906218746035610108190050394196228624539921400738404901092299164323787527159808uwb,
    8922448217105188951537312155524913197158477782806467330054048115953920100033906218746035610108190050394196228624539921400738404901092299164323787527159808uwb - 1,
    8922448217105188951537312155524913197158477782806467330054048115953920100033906218746035610108190050394196228624539921400738404901092299164323787527159808uwb,
    8922448217105188951537312155524913197158477782806467330054048115953920100033906218746035610108190050394196228624539921400738404901092299164323787527159808uwb + 1,
    8922448217105188951537312155524913197158477782806467330054048115953920100033906218746035610108190050394196228624539921400738404901092299164323787527159808uwb,
    8922448217105188951537312155524913197158477782806467330054048115953920100033906218746035610108190050394196228624539921400738404901092299164323787527159808uwb,
    419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb,
    419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb - 39402006196394479212279040100143613805079739270465446667948293404245721771497210611414266254884915640806627990306816uwb,
    419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb,
    419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb + 39402006196394479212279040100143613805079739270465446667948293404245721771497210611414266254884915640806627990306816uwb,
    419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb,
    419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb - 1,
    419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb,
    419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb + 1,
    419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb,
    419738665353613393951601598131892680944319219800892426789126665343642933931943588470723015570704289785844248033634460199784949778501149813068325535612928uwb,
    10128841244658791126648561211937592176780958236989426886389971194372978046367048331953118621224361972312674509897766160468914015517030880732802761461031257uwb,
    10128841244658791126648561211937592176780958236989426886389971194372978046367048331953118621224361972312674509897766160468914015517030880732802761461031257uwb
  };
  static _BitInt(512) q[] = {
    2090630783083976726560608899307022527212315311978198188753257152565888263284874347844598962661131937985796633260411082466462809997821330828145983020205878wb,
    5297891122069759152190358277191301380039917110906456442739988947584072293285648331709545720897009753992228929981833882700804979946892323846480198848327132wb,
    -5175455635851811471365509786771967259502175482181487858405840994248880218291771627060836702250940532261110768615360129062649520600089218199000819977507401wb,
    -1197417987356054452650938717940723527397958134105969279763141389784758850378928132483783317153283733701258756175700200053452996288076889759098734389999989wb,
    376956342115769081675826480328100204258176592231230579846860212707171684351927919252138022581568644395505257039021425128449272854523981924151678168936546wb,
    -3213922658862209387519332343658781663313426526489443455850614508466930839492348067449248688649920694680442694775272326426735943224604674195708324515087099wb,
    -26226634446852143139032827542275726163637222096291661272058678439249826123155608154486599937246756733481215161556643451523636377101397790340001692756671wb,
    2387778007768951206967793842263829269147949222877356804856598206833350996940762526208017209413841449433410232587427590886259349063804766729190889440858025wb,
    -696290237363643551117711996671220443230309432588348036053438948181530078288074148843479004574555088489161912619769067173411081743987060302136728183033248wb,
    -696290237363643551117711996671220443230309432588348036053438948181530078288074148843479004574555088489161912619769067173411081743987060302136728183033248wb - 1,
    5076345582133566846688236290712078493812804531016237797772016838314392198062936803967594662767716104530499878914245621558744394736829525675805759950337585wb,
    5076345582133566846688236290712078493812804531016237797772016838314392198062936803967594662767716104530499878914245621558744394736829525675805759950337585wb + 1,
    76333981980921012896605396538225276147251180731694673353838618004648399286703323410022822396010620396184658817947322688521663381589809974158923162189824wb,
    76333981980921012896605396538225276147251180731694673353838618004648399286703323410022822396010620396184658817947322688521663381589809974158923162189824wb - 18446744073709551616wb,
    76333981980921012896605396538225276147251180731694673353838618004648399286703323410022822396010620396184658817947322688521663381589809974158923162189824wb,
    76333981980921012896605396538225276147251180731694673353838618004648399286703323410022822396010620396184658817947322688521663381589809974158923162189824wb - 1,
    76333981980921012896605396538225276147251180731694673353838618004648399286703323410022822396010620396184658817947322688521663381589809974158923162189824wb,
    76333981980921012896605396538225276147251180731694673353838618004648399286703323410022822396010620396184658817947322688521663381589809974158923162189824wb + 1,
    76333981980921012896605396538225276147251180731694673353838618004648399286703323410022822396010620396184658817947322688521663381589809974158923162189824wb,
    76333981980921012896605396538225276147251180731694673353838618004648399286703323410022822396010620396184658817947322688521663381589809974158923162189824wb,
    -3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb,
    -3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb - 6277101735386680763835789423207666416102355444464034512896wb,
    -3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb,
    -3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb + 6277101735386680763835789423207666416102355444464034512896wb,
    -3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb,
    -3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb - 1,
    -3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb,
    -3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb + 1,
    -3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb,
    -3803169810302811951423866897603196308644585632212248377372707505362914913528085871414141191637221346044389898087027979721998214953093947532239443142377472wb,
    -663334509177964622465622357697170286154368667858847871698225590542683746494347453401587549116942795508119009999390315794925881271012501058045923403034199wb,
    -663334509177964622465622357697170286154368667858847871698225590542683746494347453401587549116942795508119009999390315794925881271012501058045923403034199wb
  };
  int r[160];
  static int e[160] = {
    1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
    0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1,
    1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1,
    1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0,
    1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1
  };
  test512 (p, q, r, 0, 0, 0);
  for (int i = 0; i < 160; ++i)
    if (r[i] != e[i])
      __builtin_abort ();
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) void
test575 (unsigned _BitInt(575) *p, _BitInt(575) *q, int *r, int i, int j, int k)
{
  int l;
  for (l = 0; l < 15; ++l)
    {
      r[l * 4] = p[l * 2] < p[l * 2 + 1];
      r[l * 4 + 1] = p[l * 2 + i] <= p[l * 2 + 1 + i];
      r[l * 4 + 2] = p[l * 2 + j] > p[l * 2 + 1 + j];
      r[l * 4 + 3] = p[l * 2 + k] >= p[l * 2 + 1 + k];
    }
  r[60] = 0;
  if (p[30] < p[31])
    foo (r + 60);
  r[61] = 0;
  if (p[30 + i] <= p[31 + i])
    foo (r + 61);
  r[62] = 0;
  if (p[30 + j] > p[31 + j])
    foo (r + 62);
  r[63] = 0;
  if (p[30 + k] >= p[31 + k])
    foo (r + 63);
  for (l = 0; l < 15; ++l)
    {
      r[64 + l * 4] = q[l * 2] < q[l * 2 + 1];
      r[64 + l * 4 + 1] = q[l * 2 + i] <= q[l * 2 + 1 + i];
      r[64 + l * 4 + 2] = q[l * 2 + j] > q[l * 2 + 1 + j];
      r[64 + l * 4 + 3] = q[l * 2 + k] >= q[l * 2 + 1 + k];
    }
  r[124] = 0;
  if (q[30] < q[31])
    foo (r + 124);
  r[125] = 0;
  if (q[30 + i] <= q[31 + i])
    foo (r + 125);
  r[126] = 0;
  if (q[30 + j] > q[31 + j])
    foo (r + 126);
  r[127] = 0;
  if (q[30 + k] >= q[31 + k])
    foo (r + 127);
  r[128] = p[1] > 20670903802240325105911328843875002676780679796965659887810279910476905646991707533359633196332088191362534479568251649420016839659631716684161458660332642627037004465943031uwb;
  r[129] = p[1 + i] >= 20670903802240325105911328843875002676780679796965659887810279910476905646991707533359633196332088191362534479568251649420016839659631716684161458660332642627037004465943031uwb;
  r[130] = p[1 + j] < 20670903802240325105911328843875002676780679796965659887810279910476905646991707533359633196332088191362534479568251649420016839659631716684161458660332642627037004465943031uwb;
  r[131] = p[1 + k] <= 20670903802240325105911328843875002676780679796965659887810279910476905646991707533359633196332088191362534479568251649420016839659631716684161458660332642627037004465943031uwb;
  r[132] = p[9] > 3090473864111819272422440709625579853033878497967848058942349684272558230226217367538319212654996864729950831478837556651015327221470111893258987353940473822396493825387378uwb;
  r[133] = p[9 + i] >= 3090473864111819272422440709625579853033878497967848058942349684272558230226217367538319212654996864729950831478837556651015327221470111893258987353940473822396493825387378uwb;
  r[134] = p[9 + j] < 3090473864111819272422440709625579853033878497967848058942349684272558230226217367538319212654996864729950831478837556651015327221470111893258987353940473822396493825387378uwb;
  r[135] = p[9 + k] <= 3090473864111819272422440709625579853033878497967848058942349684272558230226217367538319212654996864729950831478837556651015327221470111893258987353940473822396493825387378uwb;
  r[136] = p[26] > 32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb;
  r[137] = p[26 + i] >= 32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb;
  r[138] = p[26 + j] < 32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb;
  r[139] = p[26 + k] <= 32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb;
  r[140] = 0;
  if (p[27] > 32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb)
    foo (r + 140);
  r[141] = 0;
  if (p[27 + i] >= 32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb)
    foo (r + 141);
  r[142] = 0;
  if (p[27 + j] < 32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb)
    foo (r + 142);
  r[143] = 0;
  if (p[27 + k] <= 32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb)
    foo (r + 143);
  r[144] = q[1] > -16024899825125698861378150913416105280348720287461133876385645855428118759753753693038310256905822130840919293800517449664090240148479686087771461105141796446993957309177045wb;
  r[145] = q[1 + i] >= -16024899825125698861378150913416105280348720287461133876385645855428118759753753693038310256905822130840919293800517449664090240148479686087771461105141796446993957309177045wb;
  r[146] = q[1 + j] < -16024899825125698861378150913416105280348720287461133876385645855428118759753753693038310256905822130840919293800517449664090240148479686087771461105141796446993957309177045wb;
  r[147] = q[1 + k] <= -16024899825125698861378150913416105280348720287461133876385645855428118759753753693038310256905822130840919293800517449664090240148479686087771461105141796446993957309177045wb;
  r[148] = q[9] > 58304255896761105723976011538967955499349019141200282089271806304495956703405537252312168244240400239567714934306206832214441693408953280684020766705604407959670312862112067wb;
  r[149] = q[9 + i] >= 58304255896761105723976011538967955499349019141200282089271806304495956703405537252312168244240400239567714934306206832214441693408953280684020766705604407959670312862112067wb;
  r[150] = q[9 + j] < 58304255896761105723976011538967955499349019141200282089271806304495956703405537252312168244240400239567714934306206832214441693408953280684020766705604407959670312862112067wb;
  r[151] = q[9 + k] <= 58304255896761105723976011538967955499349019141200282089271806304495956703405537252312168244240400239567714934306206832214441693408953280684020766705604407959670312862112067wb;
  r[152] = q[26] > 5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb;
  r[153] = q[26 + i] >= 5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb;
  r[154] = q[26 + j] < 5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb;
  r[155] = q[26 + k] <= 5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb;
  r[156] = 0;
  if (q[27] > 5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb)
    foo (r + 156);
  r[157] = 0;
  if (q[27 + i] >= 5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb)
    foo (r + 157);
  r[158] = 0;
  if (q[27 + j] < 5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb)
    foo (r + 158);
  r[159] = 0;
  if (q[27 + k] <= 5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb)
    foo (r + 159);
}

__attribute__((noipa)) void
check575 (void)
{
  static unsigned _BitInt(575) p[] = {
    20670903802240325105911328843875002676780679796965659887810279910476905646991707533359633196332088191362534479568251649420016839659631716684161458660332642627037004465943031uwb,
    49836863281122150110976162564317489099243240060228310477726588559007020237654535886855965503007498301850523952960694293079759086994244623132359873685415478540406438465172529uwb,
    101667739273597064965717829455384743619074292631575734674415300078314703020971656449536574871164441895580568359346194993799527328879777131705988166820718349177377030581506226uwb,
    80233423044307189839832679537616515928636785173353789034947437038572207116613067927657166726935743880478344956088014540963626767254100174497579222671797940959076429057916182uwb,
    97607764806301954960180192904514327019672797546593465640967968069805351962335581135107484573411646213834310418744666537049560033943330633542409774950231074157796998179151769uwb,
    99099235847887185556638324204228969647146126640633556693610768362203817464971524250335424151842349844365719435719612388970493211957199457919255952798632861734037338994194966uwb,
    96074581713567517318016295073161521338909508333544695778644303001677582373061974284621003059876740600584228853347041280615851508249074891807094765318948991008650765902599128uwb,
    15041679461477111400649592642834193580709001861981524454028015552897618001389619787056916841370949982467368838858876017142572779037936015252240846631518852370288984853313032uwb,
    3090473864111819272422440709625579853033878497967848058942349684272558230226217367538319212654996864729950831478837556651015327221470111893258987353940473822396493825387378uwb,
    3090473864111819272422440709625579853033878497967848058942349684272558230226217367538319212654996864729950831478837556651015327221470111893258987353940473822396493825387378uwb - 1,
    24687788671445747328062841851441115170362216714281949080981056837718636733099501838839343860093294574222940008960321348311574274097362076438265776869659934585082628479484536uwb,
    24687788671445747328062841851441115170362216714281949080981056837718636733099501838839343860093294574222940008960321348311574274097362076438265776869659934585082628479484536uwb + 1,\
    47614907307737548529956044769514214288024476724410617147178248001248351816791887941016492346949195777207895982954879948136089705588820700968975703834863097085713265316593664uwb,
    47614907307737548529956044769514214288024476724410617147178248001248351816791887941016492346949195777207895982954879948136089705588820700968975703834863097085713265316593664uwb - 18446744073709551616uwb,
    47614907307737548529956044769514214288024476724410617147178248001248351816791887941016492346949195777207895982954879948136089705588820700968975703834863097085713265316593664uwb,
    47614907307737548529956044769514214288024476724410617147178248001248351816791887941016492346949195777207895982954879948136089705588820700968975703834863097085713265316593664uwb - 1,
    47614907307737548529956044769514214288024476724410617147178248001248351816791887941016492346949195777207895982954879948136089705588820700968975703834863097085713265316593664uwb,
    47614907307737548529956044769514214288024476724410617147178248001248351816791887941016492346949195777207895982954879948136089705588820700968975703834863097085713265316593664uwb + 1,
    47614907307737548529956044769514214288024476724410617147178248001248351816791887941016492346949195777207895982954879948136089705588820700968975703834863097085713265316593664uwb,
    47614907307737548529956044769514214288024476724410617147178248001248351816791887941016492346949195777207895982954879948136089705588820700968975703834863097085713265316593664uwb,
    32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb,
    32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb - 13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006084096uwb,
    32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb,
    32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb + 13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006084096uwb,
    32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb,
    32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb - 1,
    32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb,
    32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb + 1,
    32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb,
    32300371493042338295430399331232255118632292468465563882493105489267627026599093946004621996863635202389007853529819771477875971454599651226062726008225128378230201091358720uwb,
    51633735166516291946287076289285239234614696135400087552338648850396978875047534195381428791244881087469912840942965704049340728476496893527920582382910651979554452116116272uwb,
    51633735166516291946287076289285239234614696135400087552338648850396978875047534195381428791244881087469912840942965704049340728476496893527920582382910651979554452116116272uwb
  };
  static _BitInt(575) q[] = {
    -16024899825125698861378150913416105280348720287461133876385645855428118759753753693038310256905822130840919293800517449664090240148479686087771461105141796446993957309177045wb,
    -51390644150207754083049224884205617519374685858021340086606047722946185332781222093929175551224144597441976819384400839391617209092608330883818358373143049025398242971422533wb,
    -20809715567752942978812919265762383091400170370538364777815196254289178900619639932788104439550680105583194256562402043742602192720264733467556618411468069787890087436518391wb,
    -43478068345605895172576873114727639397122657577727331984515310626703015763793150203012686140133812758008909595858389385754649550027270841464683283530974333174240307326289977wb,
    21067536974893828187213625307418104748755825376641087283640893104632378341787632507091012136429031707836504909794544075439508068134695815107226742106718247426895718454571312wb,
    21059037076325069627888376003421918344895371516177629929139897951865178711273978220082835739571514841970324298196012637442412751291560252279454786817442227655976906976548376wb,
    55073439925103775330639545123285198131334712919437487448183092392908579762995884122632962257443311586409720754276146674776790868518679130616646045890806469671103608966017526wb,
    -3663639803402473230919436108605440689203511417836937035771974096034195998647953190615349428343475558818004598945205472788914786751065095519363354010927131384676070154882437wb,
    58304255896761105723976011538967955499349019141200282089271806304495956703405537252312168244240400239567714934306206832214441693408953280684020766705604407959670312862112067wb,
    58304255896761105723976011538967955499349019141200282089271806304495956703405537252312168244240400239567714934306206832214441693408953280684020766705604407959670312862112067wb - 1,
    19766430864130481024653308710810905134755769634549241890712862316488061577142782818791682881169095930184520701227673190291943682114543262971807474281675881316596313965163891wb,
    19766430864130481024653308710810905134755769634549241890712862316488061577142782818791682881169095930184520701227673190291943682114543262971807474281675881316596313965163891wb + 1,
    -34289018974597784349033110006663080173300111534374645051386853751555192083544833095189889341716428776365054335337832864819656266482761085202092232298171290655379977534439424wb,
    -34289018974597784349033110006663080173300111534374645051386853751555192083544833095189889341716428776365054335337832864819656266482761085202092232298171290655379977534439424wb - 18446744073709551616wb,
    -34289018974597784349033110006663080173300111534374645051386853751555192083544833095189889341716428776365054335337832864819656266482761085202092232298171290655379977534439424wb,
    -34289018974597784349033110006663080173300111534374645051386853751555192083544833095189889341716428776365054335337832864819656266482761085202092232298171290655379977534439424wb - 1,
    -34289018974597784349033110006663080173300111534374645051386853751555192083544833095189889341716428776365054335337832864819656266482761085202092232298171290655379977534439424wb,
    -34289018974597784349033110006663080173300111534374645051386853751555192083544833095189889341716428776365054335337832864819656266482761085202092232298171290655379977534439424wb + 1,
    -34289018974597784349033110006663080173300111534374645051386853751555192083544833095189889341716428776365054335337832864819656266482761085202092232298171290655379977534439424wb,
    -34289018974597784349033110006663080173300111534374645051386853751555192083544833095189889341716428776365054335337832864819656266482761085202092232298171290655379977534439424wb,
    5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb,
    5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb - 39402006196394479212279040100143613805079739270465446667948293404245721771497210611414266254884915640806627990306816wb,
    5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb,
    5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb + 39402006196394479212279040100143613805079739270465446667948293404245721771497210611414266254884915640806627990306816wb,
    5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb,
    5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb - 1,
    5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb,
    5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb + 1,
    5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb,
    5792382359367624136729259459647895570083840504542461480157806156670329217124243749211279307138790818182646144303340305156516829311465729191448709861740266920986130350342144wb,
    8558311355808808607005104837820226337084035299904651624497753594925617942910238887167551309507473356128849516219332540284243795507166584146318106852798224239555032058705368wb,
    8558311355808808607005104837820226337084035299904651624497753594925617942910238887167551309507473356128849516219332540284243795507166584146318106852798224239555032058705368wb
  };
  int r[160];
  static int e[160] = {
    1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1,
    0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1,
    0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1,
    1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0
  };
  test575 (p, q, r, 0, 0, 0);
  for (int i = 0; i < 160; ++i)
    if (r[i] != e[i])
      __builtin_abort ();
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 512
  check512 ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  check575 ();
#endif
  return 0;
}
