// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm %s -o - | FileCheck %s
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm %s -o - | FileCheck %s --check-prefix=SEGMENTED
// expected-no-diagnostics

#define NUM_TEAMS 250
#define NUM_THREADS 256
#define N NUM_THREADS * NUM_TEAMS

int main() {
  int in[N], out1[N];
  int sum1 = 0;

#pragma omp target teams distribute parallel for reduction(inscan, +:sum1) map(tofrom: in, out1) num_teams(NUM_TEAMS) num_threads(NUM_THREADS)
  for(int i = 0; i < N; i++) {
    sum1 += in[i];  // input phase
    #pragma omp scan inclusive(sum1)
    out1[i] = sum1; // scan phase
  }

  int sum2 = 0;
  int out2[N];

#pragma omp target teams distribute parallel for reduction(inscan, +:sum2) map(tofrom: in, out2) num_teams(NUM_TEAMS) num_threads(NUM_THREADS)
  for(int i = 0; i < N; i++) {
    out2[i] = sum2;  // scan phase
    #pragma omp scan exclusive(sum2)
    sum2 += in[i];   // input phase
  }

  return 0;
}
// CHECK-LABEL: define {{[^@]+}}@main
// CHECK-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[IN:%.*]] = alloca [64000 x i32], align 16
// CHECK-NEXT:    [[OUT1:%.*]] = alloca [64000 x i32], align 16
// CHECK-NEXT:    [[SUM1:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_BASEPTRS10:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_PTRS11:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_MAPPERS12:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[_TMP13:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[KERNEL_ARGS14:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK-NEXT:    [[_TMP17:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[SUM2:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[OUT2:%.*]] = alloca [64000 x i32], align 16
// CHECK-NEXT:    [[_TMP18:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOFFLOAD_BASEPTRS28:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_PTRS29:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_MAPPERS30:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[_TMP31:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[KERNEL_ARGS32:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_BASEPTRS40:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_PTRS41:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[DOTOFFLOAD_MAPPERS42:%.*]] = alloca [8 x ptr], align 8
// CHECK-NEXT:    [[_TMP43:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[KERNEL_ARGS44:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK-NEXT:    [[_TMP47:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM1]], align 4
// CHECK-NEXT:    [[TMP0:%.*]] = call ptr @llvm.stacksave.p0()
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[SAVED_STACK]], align 8
// CHECK-NEXT:    [[VLA:%.*]] = alloca i32, i64 0, align 16
// CHECK-NEXT:    [[D_TEAM_VALS:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAM_VALS]], align 4
// CHECK-NEXT:    [[D_TEAMS_DONE_PTR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR]], align 4
// CHECK-NEXT:    [[D_SCAN_STORAGE:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE]], align 4
// CHECK-NEXT:    [[DEFAULT_DEV:%.*]] = call i32 @omp_get_default_device()
// CHECK-NEXT:    [[INITIAL_DEVID:%.*]] = call i32 @omp_get_initial_device()
// CHECK-NEXT:    [[D_TEAM_VALS1:%.*]] = call ptr @omp_target_alloc(i64 1000, i32 [[DEFAULT_DEV]])
// CHECK-NEXT:    [[D_SCAN_STORAGE2:%.*]] = call ptr @omp_target_alloc(i64 512004, i32 [[DEFAULT_DEV]])
// CHECK-NEXT:    store i32 0, ptr [[D_TEAMS_DONE_PTR]], align 4
// CHECK-NEXT:    [[D_TEAMS_DONE_PTR3:%.*]] = call ptr @omp_target_alloc(i64 4, i32 [[DEFAULT_DEV]])
// CHECK-NEXT:    [[TMP1:%.*]] = call i32 @omp_target_memcpy(ptr [[D_TEAMS_DONE_PTR3]], ptr [[D_TEAMS_DONE_PTR]], i64 4, i64 0, i64 0, i32 [[DEFAULT_DEV]], i32 [[INITIAL_DEVID]])
// CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[TMP2]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[TMP3]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK-NEXT:    store ptr null, ptr [[TMP4]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[IN]], ptr [[TMP5]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[IN]], ptr [[TMP6]], align 8
// CHECK-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK-NEXT:    store ptr null, ptr [[TMP7]], align 8
// CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[OUT1]], ptr [[TMP8]], align 8
// CHECK-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[OUT1]], ptr [[TMP9]], align 8
// CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK-NEXT:    store ptr null, ptr [[TMP10]], align 8
// CHECK-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK-NEXT:    store i64 0, ptr [[TMP11]], align 8
// CHECK-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK-NEXT:    store i64 0, ptr [[TMP12]], align 8
// CHECK-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK-NEXT:    store ptr null, ptr [[TMP13]], align 8
// CHECK-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[VLA]], ptr [[TMP14]], align 8
// CHECK-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[VLA]], ptr [[TMP15]], align 8
// CHECK-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK-NEXT:    store ptr null, ptr [[TMP16]], align 8
// CHECK-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[D_TEAM_VALS1]], ptr [[TMP17]], align 8
// CHECK-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[D_TEAM_VALS1]], ptr [[TMP18]], align 8
// CHECK-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// CHECK-NEXT:    store ptr null, ptr [[TMP19]], align 8
// CHECK-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK-NEXT:    store ptr [[D_TEAMS_DONE_PTR3]], ptr [[TMP20]], align 8
// CHECK-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK-NEXT:    store ptr [[D_TEAMS_DONE_PTR3]], ptr [[TMP21]], align 8
// CHECK-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 6
// CHECK-NEXT:    store ptr null, ptr [[TMP22]], align 8
// CHECK-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 7
// CHECK-NEXT:    store ptr [[D_SCAN_STORAGE2]], ptr [[TMP23]], align 8
// CHECK-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 7
// CHECK-NEXT:    store ptr [[D_SCAN_STORAGE2]], ptr [[TMP24]], align 8
// CHECK-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 7
// CHECK-NEXT:    store ptr null, ptr [[TMP25]], align 8
// CHECK-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP28:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK-NEXT:    store i32 3, ptr [[TMP28]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK-NEXT:    store i32 8, ptr [[TMP29]], align 4
// CHECK-NEXT:    [[TMP30:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[TMP26]], ptr [[TMP30]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK-NEXT:    store ptr [[TMP27]], ptr [[TMP31]], align 8
// CHECK-NEXT:    [[TMP32:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK-NEXT:    store ptr @.offload_sizes, ptr [[TMP32]], align 8
// CHECK-NEXT:    [[TMP33:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK-NEXT:    store ptr @.offload_maptypes, ptr [[TMP33]], align 8
// CHECK-NEXT:    [[TMP34:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK-NEXT:    store ptr null, ptr [[TMP34]], align 8
// CHECK-NEXT:    [[TMP35:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK-NEXT:    store ptr null, ptr [[TMP35]], align 8
// CHECK-NEXT:    [[TMP36:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK-NEXT:    store i64 64000, ptr [[TMP36]], align 8
// CHECK-NEXT:    [[TMP37:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 9
// CHECK-NEXT:    store i64 0, ptr [[TMP37]], align 8
// CHECK-NEXT:    [[TMP38:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 10
// CHECK-NEXT:    store [3 x i32] [i32 250, i32 0, i32 0], ptr [[TMP38]], align 4
// CHECK-NEXT:    [[TMP39:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 11
// CHECK-NEXT:    store [3 x i32] [i32 256, i32 0, i32 0], ptr [[TMP39]], align 4
// CHECK-NEXT:    [[TMP40:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 12
// CHECK-NEXT:    store i32 0, ptr [[TMP40]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB4:[0-9]+]], i64 -1, i32 250, i32 256, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14.region_id, ptr [[KERNEL_ARGS]])
// CHECK-NEXT:    [[TMP42:%.*]] = icmp ne i32 [[TMP41]], 0
// CHECK-NEXT:    br i1 [[TMP42]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK:       omp_offload.failed:
// CHECK-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14(ptr [[SUM1]], ptr [[IN]], ptr [[OUT1]], i64 0, ptr [[VLA]], ptr [[D_TEAM_VALS]], ptr [[D_TEAMS_DONE_PTR]], ptr [[D_SCAN_STORAGE]]) #[[ATTR3:[0-9]+]]
// CHECK-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK:       omp_offload.cont:
// CHECK-NEXT:    [[D_TEAM_VALS5:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAM_VALS5]], align 4
// CHECK-NEXT:    [[D_TEAMS_DONE_PTR6:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR6]], align 4
// CHECK-NEXT:    [[D_SCAN_STORAGE7:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE7]], align 4
// CHECK-NEXT:    [[DEFAULT_DEV8:%.*]] = call i32 @omp_get_default_device()
// CHECK-NEXT:    [[INITIAL_DEVID9:%.*]] = call i32 @omp_get_initial_device()
// CHECK-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[TMP43]], align 8
// CHECK-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS11]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[TMP44]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 0
// CHECK-NEXT:    store ptr null, ptr [[TMP45]], align 8
// CHECK-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[IN]], ptr [[TMP46]], align 8
// CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS11]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[IN]], ptr [[TMP47]], align 8
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 1
// CHECK-NEXT:    store ptr null, ptr [[TMP48]], align 8
// CHECK-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[OUT1]], ptr [[TMP49]], align 8
// CHECK-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS11]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[OUT1]], ptr [[TMP50]], align 8
// CHECK-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 2
// CHECK-NEXT:    store ptr null, ptr [[TMP51]], align 8
// CHECK-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 3
// CHECK-NEXT:    store i64 0, ptr [[TMP52]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS11]], i32 0, i32 3
// CHECK-NEXT:    store i64 0, ptr [[TMP53]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 3
// CHECK-NEXT:    store ptr null, ptr [[TMP54]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[VLA]], ptr [[TMP55]], align 8
// CHECK-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS11]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[VLA]], ptr [[TMP56]], align 8
// CHECK-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 4
// CHECK-NEXT:    store ptr null, ptr [[TMP57]], align 8
// CHECK-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[D_TEAM_VALS1]], ptr [[TMP58]], align 8
// CHECK-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS11]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[D_TEAM_VALS1]], ptr [[TMP59]], align 8
// CHECK-NEXT:    [[TMP60:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 5
// CHECK-NEXT:    store ptr null, ptr [[TMP60]], align 8
// CHECK-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 6
// CHECK-NEXT:    store ptr [[D_TEAMS_DONE_PTR3]], ptr [[TMP61]], align 8
// CHECK-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS11]], i32 0, i32 6
// CHECK-NEXT:    store ptr [[D_TEAMS_DONE_PTR3]], ptr [[TMP62]], align 8
// CHECK-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 6
// CHECK-NEXT:    store ptr null, ptr [[TMP63]], align 8
// CHECK-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 7
// CHECK-NEXT:    store ptr [[D_SCAN_STORAGE2]], ptr [[TMP64]], align 8
// CHECK-NEXT:    [[TMP65:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS11]], i32 0, i32 7
// CHECK-NEXT:    store ptr [[D_SCAN_STORAGE2]], ptr [[TMP65]], align 8
// CHECK-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 7
// CHECK-NEXT:    store ptr null, ptr [[TMP66]], align 8
// CHECK-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 0
// CHECK-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS11]], i32 0, i32 0
// CHECK-NEXT:    [[TMP69:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 0
// CHECK-NEXT:    store i32 3, ptr [[TMP69]], align 4
// CHECK-NEXT:    [[TMP70:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 1
// CHECK-NEXT:    store i32 8, ptr [[TMP70]], align 4
// CHECK-NEXT:    [[TMP71:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[TMP67]], ptr [[TMP71]], align 8
// CHECK-NEXT:    [[TMP72:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 3
// CHECK-NEXT:    store ptr [[TMP68]], ptr [[TMP72]], align 8
// CHECK-NEXT:    [[TMP73:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 4
// CHECK-NEXT:    store ptr @.offload_sizes.1, ptr [[TMP73]], align 8
// CHECK-NEXT:    [[TMP74:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 5
// CHECK-NEXT:    store ptr @.offload_maptypes.2, ptr [[TMP74]], align 8
// CHECK-NEXT:    [[TMP75:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 6
// CHECK-NEXT:    store ptr null, ptr [[TMP75]], align 8
// CHECK-NEXT:    [[TMP76:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 7
// CHECK-NEXT:    store ptr null, ptr [[TMP76]], align 8
// CHECK-NEXT:    [[TMP77:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 8
// CHECK-NEXT:    store i64 64000, ptr [[TMP77]], align 8
// CHECK-NEXT:    [[TMP78:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 9
// CHECK-NEXT:    store i64 0, ptr [[TMP78]], align 8
// CHECK-NEXT:    [[TMP79:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 10
// CHECK-NEXT:    store [3 x i32] [i32 250, i32 0, i32 0], ptr [[TMP79]], align 4
// CHECK-NEXT:    [[TMP80:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 11
// CHECK-NEXT:    store [3 x i32] [i32 256, i32 0, i32 0], ptr [[TMP80]], align 4
// CHECK-NEXT:    [[TMP81:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS14]], i32 0, i32 12
// CHECK-NEXT:    store i32 0, ptr [[TMP81]], align 4
// CHECK-NEXT:    [[TMP82:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB4]], i64 -1, i32 250, i32 256, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14_1.region_id, ptr [[KERNEL_ARGS14]])
// CHECK-NEXT:    [[TMP83:%.*]] = icmp ne i32 [[TMP82]], 0
// CHECK-NEXT:    br i1 [[TMP83]], label [[OMP_OFFLOAD_FAILED15:%.*]], label [[OMP_OFFLOAD_CONT16:%.*]]
// CHECK:       omp_offload.failed15:
// CHECK-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14_1(ptr [[SUM1]], ptr [[IN]], ptr [[OUT1]], i64 0, ptr [[VLA]], ptr [[D_TEAM_VALS5]], ptr [[D_TEAMS_DONE_PTR6]], ptr [[D_SCAN_STORAGE7]]) #[[ATTR3]]
// CHECK-NEXT:    br label [[OMP_OFFLOAD_CONT16]]
// CHECK:       omp_offload.cont16:
// CHECK-NEXT:    call void @omp_target_free(ptr [[D_TEAM_VALS1]], i32 [[DEFAULT_DEV8]])
// CHECK-NEXT:    call void @omp_target_free(ptr [[D_TEAMS_DONE_PTR3]], i32 [[DEFAULT_DEV8]])
// CHECK-NEXT:    call void @omp_target_free(ptr [[D_SCAN_STORAGE2]], i32 [[DEFAULT_DEV8]])
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw i32, ptr [[VLA]], i64 -1
// CHECK-NEXT:    [[TMP84:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    store i32 [[TMP84]], ptr [[SUM1]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM2]], align 4
// CHECK-NEXT:    [[VLA19:%.*]] = alloca i32, i64 0, align 16
// CHECK-NEXT:    [[D_TEAM_VALS20:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAM_VALS20]], align 4
// CHECK-NEXT:    [[D_TEAMS_DONE_PTR21:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR21]], align 4
// CHECK-NEXT:    [[D_SCAN_STORAGE22:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE22]], align 4
// CHECK-NEXT:    [[DEFAULT_DEV23:%.*]] = call i32 @omp_get_default_device()
// CHECK-NEXT:    [[INITIAL_DEVID24:%.*]] = call i32 @omp_get_initial_device()
// CHECK-NEXT:    [[D_TEAM_VALS25:%.*]] = call ptr @omp_target_alloc(i64 1000, i32 [[DEFAULT_DEV23]])
// CHECK-NEXT:    [[D_SCAN_STORAGE26:%.*]] = call ptr @omp_target_alloc(i64 512004, i32 [[DEFAULT_DEV23]])
// CHECK-NEXT:    store i32 0, ptr [[D_TEAMS_DONE_PTR21]], align 4
// CHECK-NEXT:    [[D_TEAMS_DONE_PTR27:%.*]] = call ptr @omp_target_alloc(i64 4, i32 [[DEFAULT_DEV23]])
// CHECK-NEXT:    [[TMP85:%.*]] = call i32 @omp_target_memcpy(ptr [[D_TEAMS_DONE_PTR27]], ptr [[D_TEAMS_DONE_PTR21]], i64 4, i64 0, i64 0, i32 [[DEFAULT_DEV23]], i32 [[INITIAL_DEVID24]])
// CHECK-NEXT:    [[TMP86:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS28]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[OUT2]], ptr [[TMP86]], align 8
// CHECK-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS29]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[OUT2]], ptr [[TMP87]], align 8
// CHECK-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS30]], i64 0, i64 0
// CHECK-NEXT:    store ptr null, ptr [[TMP88]], align 8
// CHECK-NEXT:    [[TMP89:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS28]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[SUM2]], ptr [[TMP89]], align 8
// CHECK-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS29]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[SUM2]], ptr [[TMP90]], align 8
// CHECK-NEXT:    [[TMP91:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS30]], i64 0, i64 1
// CHECK-NEXT:    store ptr null, ptr [[TMP91]], align 8
// CHECK-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS28]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[IN]], ptr [[TMP92]], align 8
// CHECK-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS29]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[IN]], ptr [[TMP93]], align 8
// CHECK-NEXT:    [[TMP94:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS30]], i64 0, i64 2
// CHECK-NEXT:    store ptr null, ptr [[TMP94]], align 8
// CHECK-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS28]], i32 0, i32 3
// CHECK-NEXT:    store i64 0, ptr [[TMP95]], align 8
// CHECK-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS29]], i32 0, i32 3
// CHECK-NEXT:    store i64 0, ptr [[TMP96]], align 8
// CHECK-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS30]], i64 0, i64 3
// CHECK-NEXT:    store ptr null, ptr [[TMP97]], align 8
// CHECK-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS28]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[VLA19]], ptr [[TMP98]], align 8
// CHECK-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS29]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[VLA19]], ptr [[TMP99]], align 8
// CHECK-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS30]], i64 0, i64 4
// CHECK-NEXT:    store ptr null, ptr [[TMP100]], align 8
// CHECK-NEXT:    [[TMP101:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS28]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[D_TEAM_VALS25]], ptr [[TMP101]], align 8
// CHECK-NEXT:    [[TMP102:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS29]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[D_TEAM_VALS25]], ptr [[TMP102]], align 8
// CHECK-NEXT:    [[TMP103:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS30]], i64 0, i64 5
// CHECK-NEXT:    store ptr null, ptr [[TMP103]], align 8
// CHECK-NEXT:    [[TMP104:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS28]], i32 0, i32 6
// CHECK-NEXT:    store ptr [[D_TEAMS_DONE_PTR27]], ptr [[TMP104]], align 8
// CHECK-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS29]], i32 0, i32 6
// CHECK-NEXT:    store ptr [[D_TEAMS_DONE_PTR27]], ptr [[TMP105]], align 8
// CHECK-NEXT:    [[TMP106:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS30]], i64 0, i64 6
// CHECK-NEXT:    store ptr null, ptr [[TMP106]], align 8
// CHECK-NEXT:    [[TMP107:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS28]], i32 0, i32 7
// CHECK-NEXT:    store ptr [[D_SCAN_STORAGE26]], ptr [[TMP107]], align 8
// CHECK-NEXT:    [[TMP108:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS29]], i32 0, i32 7
// CHECK-NEXT:    store ptr [[D_SCAN_STORAGE26]], ptr [[TMP108]], align 8
// CHECK-NEXT:    [[TMP109:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS30]], i64 0, i64 7
// CHECK-NEXT:    store ptr null, ptr [[TMP109]], align 8
// CHECK-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS28]], i32 0, i32 0
// CHECK-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS29]], i32 0, i32 0
// CHECK-NEXT:    [[TMP112:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 0
// CHECK-NEXT:    store i32 3, ptr [[TMP112]], align 4
// CHECK-NEXT:    [[TMP113:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 1
// CHECK-NEXT:    store i32 8, ptr [[TMP113]], align 4
// CHECK-NEXT:    [[TMP114:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[TMP110]], ptr [[TMP114]], align 8
// CHECK-NEXT:    [[TMP115:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 3
// CHECK-NEXT:    store ptr [[TMP111]], ptr [[TMP115]], align 8
// CHECK-NEXT:    [[TMP116:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 4
// CHECK-NEXT:    store ptr @.offload_sizes.3, ptr [[TMP116]], align 8
// CHECK-NEXT:    [[TMP117:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 5
// CHECK-NEXT:    store ptr @.offload_maptypes.4, ptr [[TMP117]], align 8
// CHECK-NEXT:    [[TMP118:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 6
// CHECK-NEXT:    store ptr null, ptr [[TMP118]], align 8
// CHECK-NEXT:    [[TMP119:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 7
// CHECK-NEXT:    store ptr null, ptr [[TMP119]], align 8
// CHECK-NEXT:    [[TMP120:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 8
// CHECK-NEXT:    store i64 64000, ptr [[TMP120]], align 8
// CHECK-NEXT:    [[TMP121:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 9
// CHECK-NEXT:    store i64 0, ptr [[TMP121]], align 8
// CHECK-NEXT:    [[TMP122:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 10
// CHECK-NEXT:    store [3 x i32] [i32 250, i32 0, i32 0], ptr [[TMP122]], align 4
// CHECK-NEXT:    [[TMP123:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 11
// CHECK-NEXT:    store [3 x i32] [i32 256, i32 0, i32 0], ptr [[TMP123]], align 4
// CHECK-NEXT:    [[TMP124:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS32]], i32 0, i32 12
// CHECK-NEXT:    store i32 0, ptr [[TMP124]], align 4
// CHECK-NEXT:    [[TMP125:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB4]], i64 -1, i32 250, i32 256, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24.region_id, ptr [[KERNEL_ARGS32]])
// CHECK-NEXT:    [[TMP126:%.*]] = icmp ne i32 [[TMP125]], 0
// CHECK-NEXT:    br i1 [[TMP126]], label [[OMP_OFFLOAD_FAILED33:%.*]], label [[OMP_OFFLOAD_CONT34:%.*]]
// CHECK:       omp_offload.failed33:
// CHECK-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24(ptr [[OUT2]], ptr [[SUM2]], ptr [[IN]], i64 0, ptr [[VLA19]], ptr [[D_TEAM_VALS20]], ptr [[D_TEAMS_DONE_PTR21]], ptr [[D_SCAN_STORAGE22]]) #[[ATTR3]]
// CHECK-NEXT:    br label [[OMP_OFFLOAD_CONT34]]
// CHECK:       omp_offload.cont34:
// CHECK-NEXT:    [[D_TEAM_VALS35:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAM_VALS35]], align 4
// CHECK-NEXT:    [[D_TEAMS_DONE_PTR36:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR36]], align 4
// CHECK-NEXT:    [[D_SCAN_STORAGE37:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE37]], align 4
// CHECK-NEXT:    [[DEFAULT_DEV38:%.*]] = call i32 @omp_get_default_device()
// CHECK-NEXT:    [[INITIAL_DEVID39:%.*]] = call i32 @omp_get_initial_device()
// CHECK-NEXT:    [[TMP127:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS40]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[OUT2]], ptr [[TMP127]], align 8
// CHECK-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS41]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[OUT2]], ptr [[TMP128]], align 8
// CHECK-NEXT:    [[TMP129:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS42]], i64 0, i64 0
// CHECK-NEXT:    store ptr null, ptr [[TMP129]], align 8
// CHECK-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS40]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[SUM2]], ptr [[TMP130]], align 8
// CHECK-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS41]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[SUM2]], ptr [[TMP131]], align 8
// CHECK-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS42]], i64 0, i64 1
// CHECK-NEXT:    store ptr null, ptr [[TMP132]], align 8
// CHECK-NEXT:    [[TMP133:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS40]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[IN]], ptr [[TMP133]], align 8
// CHECK-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS41]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[IN]], ptr [[TMP134]], align 8
// CHECK-NEXT:    [[TMP135:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS42]], i64 0, i64 2
// CHECK-NEXT:    store ptr null, ptr [[TMP135]], align 8
// CHECK-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS40]], i32 0, i32 3
// CHECK-NEXT:    store i64 0, ptr [[TMP136]], align 8
// CHECK-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS41]], i32 0, i32 3
// CHECK-NEXT:    store i64 0, ptr [[TMP137]], align 8
// CHECK-NEXT:    [[TMP138:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS42]], i64 0, i64 3
// CHECK-NEXT:    store ptr null, ptr [[TMP138]], align 8
// CHECK-NEXT:    [[TMP139:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS40]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[VLA19]], ptr [[TMP139]], align 8
// CHECK-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS41]], i32 0, i32 4
// CHECK-NEXT:    store ptr [[VLA19]], ptr [[TMP140]], align 8
// CHECK-NEXT:    [[TMP141:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS42]], i64 0, i64 4
// CHECK-NEXT:    store ptr null, ptr [[TMP141]], align 8
// CHECK-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS40]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[D_TEAM_VALS25]], ptr [[TMP142]], align 8
// CHECK-NEXT:    [[TMP143:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS41]], i32 0, i32 5
// CHECK-NEXT:    store ptr [[D_TEAM_VALS25]], ptr [[TMP143]], align 8
// CHECK-NEXT:    [[TMP144:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS42]], i64 0, i64 5
// CHECK-NEXT:    store ptr null, ptr [[TMP144]], align 8
// CHECK-NEXT:    [[TMP145:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS40]], i32 0, i32 6
// CHECK-NEXT:    store ptr [[D_TEAMS_DONE_PTR27]], ptr [[TMP145]], align 8
// CHECK-NEXT:    [[TMP146:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS41]], i32 0, i32 6
// CHECK-NEXT:    store ptr [[D_TEAMS_DONE_PTR27]], ptr [[TMP146]], align 8
// CHECK-NEXT:    [[TMP147:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS42]], i64 0, i64 6
// CHECK-NEXT:    store ptr null, ptr [[TMP147]], align 8
// CHECK-NEXT:    [[TMP148:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS40]], i32 0, i32 7
// CHECK-NEXT:    store ptr [[D_SCAN_STORAGE26]], ptr [[TMP148]], align 8
// CHECK-NEXT:    [[TMP149:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS41]], i32 0, i32 7
// CHECK-NEXT:    store ptr [[D_SCAN_STORAGE26]], ptr [[TMP149]], align 8
// CHECK-NEXT:    [[TMP150:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_MAPPERS42]], i64 0, i64 7
// CHECK-NEXT:    store ptr null, ptr [[TMP150]], align 8
// CHECK-NEXT:    [[TMP151:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_BASEPTRS40]], i32 0, i32 0
// CHECK-NEXT:    [[TMP152:%.*]] = getelementptr inbounds [8 x ptr], ptr [[DOTOFFLOAD_PTRS41]], i32 0, i32 0
// CHECK-NEXT:    [[TMP153:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 0
// CHECK-NEXT:    store i32 3, ptr [[TMP153]], align 4
// CHECK-NEXT:    [[TMP154:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 1
// CHECK-NEXT:    store i32 8, ptr [[TMP154]], align 4
// CHECK-NEXT:    [[TMP155:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 2
// CHECK-NEXT:    store ptr [[TMP151]], ptr [[TMP155]], align 8
// CHECK-NEXT:    [[TMP156:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 3
// CHECK-NEXT:    store ptr [[TMP152]], ptr [[TMP156]], align 8
// CHECK-NEXT:    [[TMP157:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 4
// CHECK-NEXT:    store ptr @.offload_sizes.5, ptr [[TMP157]], align 8
// CHECK-NEXT:    [[TMP158:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 5
// CHECK-NEXT:    store ptr @.offload_maptypes.6, ptr [[TMP158]], align 8
// CHECK-NEXT:    [[TMP159:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 6
// CHECK-NEXT:    store ptr null, ptr [[TMP159]], align 8
// CHECK-NEXT:    [[TMP160:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 7
// CHECK-NEXT:    store ptr null, ptr [[TMP160]], align 8
// CHECK-NEXT:    [[TMP161:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 8
// CHECK-NEXT:    store i64 64000, ptr [[TMP161]], align 8
// CHECK-NEXT:    [[TMP162:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 9
// CHECK-NEXT:    store i64 0, ptr [[TMP162]], align 8
// CHECK-NEXT:    [[TMP163:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 10
// CHECK-NEXT:    store [3 x i32] [i32 250, i32 0, i32 0], ptr [[TMP163]], align 4
// CHECK-NEXT:    [[TMP164:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 11
// CHECK-NEXT:    store [3 x i32] [i32 256, i32 0, i32 0], ptr [[TMP164]], align 4
// CHECK-NEXT:    [[TMP165:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS44]], i32 0, i32 12
// CHECK-NEXT:    store i32 0, ptr [[TMP165]], align 4
// CHECK-NEXT:    [[TMP166:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB4]], i64 -1, i32 250, i32 256, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24_1.region_id, ptr [[KERNEL_ARGS44]])
// CHECK-NEXT:    [[TMP167:%.*]] = icmp ne i32 [[TMP166]], 0
// CHECK-NEXT:    br i1 [[TMP167]], label [[OMP_OFFLOAD_FAILED45:%.*]], label [[OMP_OFFLOAD_CONT46:%.*]]
// CHECK:       omp_offload.failed45:
// CHECK-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24_1(ptr [[OUT2]], ptr [[SUM2]], ptr [[IN]], i64 0, ptr [[VLA19]], ptr [[D_TEAM_VALS35]], ptr [[D_TEAMS_DONE_PTR36]], ptr [[D_SCAN_STORAGE37]]) #[[ATTR3]]
// CHECK-NEXT:    br label [[OMP_OFFLOAD_CONT46]]
// CHECK:       omp_offload.cont46:
// CHECK-NEXT:    call void @omp_target_free(ptr [[D_TEAM_VALS25]], i32 [[DEFAULT_DEV38]])
// CHECK-NEXT:    call void @omp_target_free(ptr [[D_TEAMS_DONE_PTR27]], i32 [[DEFAULT_DEV38]])
// CHECK-NEXT:    call void @omp_target_free(ptr [[D_SCAN_STORAGE26]], i32 [[DEFAULT_DEV38]])
// CHECK-NEXT:    [[ARRAYIDX48:%.*]] = getelementptr inbounds nuw i32, ptr [[VLA19]], i64 -1
// CHECK-NEXT:    [[TMP168:%.*]] = load i32, ptr [[ARRAYIDX48]], align 4
// CHECK-NEXT:    store i32 [[TMP168]], ptr [[SUM2]], align 4
// CHECK-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-NEXT:    [[TMP169:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// CHECK-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP169]])
// CHECK-NEXT:    [[TMP170:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK-NEXT:    ret i32 [[TMP170]]
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[_TMP5:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB4]])
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR]], align 8
// CHECK-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR]], align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2]], align 8
// CHECK-NEXT:    [[TMP_VLA:%.*]] = alloca i32, i64 64000, align 4
// CHECK-NEXT:    store ptr [[TMP_VLA]], ptr [[TMP8]], align 16
// CHECK-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB4]], i32 [[TMP3]], i32 250, i32 0)
// CHECK-NEXT:    [[D_TEAM_VALS:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAM_VALS]], align 4
// CHECK-NEXT:    [[D_TEAMS_DONE_PTR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR]], align 4
// CHECK-NEXT:    [[D_SCAN_STORAGE:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE]], align 4
// CHECK-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB4]], i32 8, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14.omp_outlined, ptr [[TMP4]], ptr [[TMP5]], ptr [[TMP6]], i64 [[TMP7]], ptr [[TMP8]], ptr [[D_TEAM_VALS]], ptr [[D_TEAMS_DONE_PTR]], ptr [[D_SCAN_STORAGE]])
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 63999
// CHECK-NEXT:    [[TMP9:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    store i32 [[TMP9]], ptr [[TMP4]], align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14.omp_outlined
// CHECK-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR]], align 8
// CHECK-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2]], align 8
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK-NEXT:    store i32 63999, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// CHECK-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 63999
// CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK:       cond.true:
// CHECK-NEXT:    br label [[COND_END:%.*]]
// CHECK:       cond.false:
// CHECK-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    br label [[COND_END]]
// CHECK:       cond.end:
// CHECK-NEXT:    [[COND:%.*]] = phi i32 [ 63999, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK:       omp.inner.for.cond:
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK:       omp.inner.for.body:
// CHECK-NEXT:    call void @__kmpc_push_num_threads(ptr @[[GLOB4]], i32 [[TMP9]], i32 256)
// CHECK-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP15]] to i64
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK-NEXT:    [[D_TEAM_VALS:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAM_VALS]], align 4
// CHECK-NEXT:    [[D_TEAMS_DONE_PTR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR]], align 4
// CHECK-NEXT:    [[D_SCAN_STORAGE:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE]], align 4
// CHECK-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB4]], i32 10, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14.omp_outlined.omp_outlined, i64 [[TMP16]], i64 [[TMP18]], ptr [[TMP3]], ptr [[TMP4]], ptr [[TMP5]], i64 [[TMP6]], ptr [[TMP7]], ptr [[D_TEAM_VALS]], ptr [[D_TEAMS_DONE_PTR]], ptr [[D_SCAN_STORAGE]])
// CHECK-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK:       omp.inner.for.inc:
// CHECK-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK:       omp.inner.for.end:
// CHECK-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK:       omp.loop.exit:
// CHECK-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP9]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14.omp_outlined.omp_outlined
// CHECK-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[_TMP5:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[SUM17:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IV16:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[_TMP17:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_LB18:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_UB19:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_STRIDE20:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IS_LAST21:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[I22:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[SUM133:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR]], align 8
// CHECK-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2]], align 8
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK-NEXT:    store i32 63999, ptr [[DOTOMP_UB]], align 4
// CHECK-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// CHECK-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2:[0-9]+]], i32 [[TMP9]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 63999
// CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK:       cond.true:
// CHECK-NEXT:    br label [[COND_END:%.*]]
// CHECK:       cond.false:
// CHECK-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK-NEXT:    br label [[COND_END]]
// CHECK:       cond.end:
// CHECK-NEXT:    [[COND:%.*]] = phi i32 [ 63999, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK:       omp.inner.for.cond:
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK:       omp.inner.for.body:
// CHECK-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM17]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[I]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP16]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = load i32, ptr [[SUM17]], align 4
// CHECK-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP18]], [[TMP17]]
// CHECK-NEXT:    store i32 [[ADD8]], ptr [[SUM17]], align 4
// CHECK-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP20]]
// CHECK-NEXT:    [[TMP21:%.*]] = load i32, ptr [[SUM17]], align 4
// CHECK-NEXT:    store i32 [[TMP21]], ptr [[ARRAYIDX9]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[SUM17]], align 4
// CHECK-NEXT:    [[TMP23:%.*]] = load i32, ptr [[I]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP23]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM10]]
// CHECK-NEXT:    store i32 [[TMP22]], ptr [[ARRAYIDX11]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK:       omp.inner.for.inc:
// CHECK-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK-NEXT:    store i32 [[ADD12]], ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK:       omp.inner.for.end:
// CHECK-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK:       omp.loop.exit:
// CHECK-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP9]])
// CHECK-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3:[0-9]+]], i32 [[TMP9]])
// CHECK-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB4]], i32 [[TMP9]])
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK:       omp_if.then:
// CHECK-NEXT:    [[TMP27:%.*]] = call double @llvm.log2.f64(double 6.400000e+04) #[[ATTR3]]
// CHECK-NEXT:    [[TMP28:%.*]] = call double @llvm.ceil.f64(double [[TMP27]]) #[[ATTR3]]
// CHECK-NEXT:    [[TMP29:%.*]] = fptoui double [[TMP28]] to i32
// CHECK-NEXT:    br label [[OMP_OUTER_LOG_SCAN_BODY:%.*]]
// CHECK:       omp.outer.log.scan.body:
// CHECK-NEXT:    [[TMP30:%.*]] = phi i32 [ 0, [[OMP_IF_THEN]] ], [ [[TMP39:%.*]], [[OMP_INNER_LOG_SCAN_EXIT:%.*]] ]
// CHECK-NEXT:    [[TMP31:%.*]] = phi i64 [ 1, [[OMP_IF_THEN]] ], [ [[TMP40:%.*]], [[OMP_INNER_LOG_SCAN_EXIT]] ]
// CHECK-NEXT:    [[TMP32:%.*]] = icmp uge i64 63999, [[TMP31]]
// CHECK-NEXT:    br i1 [[TMP32]], label [[OMP_INNER_LOG_SCAN_BODY:%.*]], label [[OMP_INNER_LOG_SCAN_EXIT]]
// CHECK:       omp.inner.log.scan.body:
// CHECK-NEXT:    [[TMP33:%.*]] = phi i64 [ 63999, [[OMP_OUTER_LOG_SCAN_BODY]] ], [ [[TMP37:%.*]], [[OMP_INNER_LOG_SCAN_BODY]] ]
// CHECK-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP33]]
// CHECK-NEXT:    [[TMP34:%.*]] = sub nuw i64 [[TMP33]], [[TMP31]]
// CHECK-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP34]]
// CHECK-NEXT:    [[TMP35:%.*]] = load i32, ptr [[ARRAYIDX13]], align 4
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[ARRAYIDX14]], align 4
// CHECK-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP35]], [[TMP36]]
// CHECK-NEXT:    store i32 [[ADD15]], ptr [[ARRAYIDX13]], align 4
// CHECK-NEXT:    [[TMP37]] = sub nuw i64 [[TMP33]], 1
// CHECK-NEXT:    [[TMP38:%.*]] = icmp uge i64 [[TMP37]], [[TMP31]]
// CHECK-NEXT:    br i1 [[TMP38]], label [[OMP_INNER_LOG_SCAN_BODY]], label [[OMP_INNER_LOG_SCAN_EXIT]]
// CHECK:       omp.inner.log.scan.exit:
// CHECK-NEXT:    [[TMP39]] = add nuw i32 [[TMP30]], 1
// CHECK-NEXT:    [[TMP40]] = shl nuw i64 [[TMP31]], 1
// CHECK-NEXT:    [[TMP41:%.*]] = icmp ne i32 [[TMP39]], [[TMP29]]
// CHECK-NEXT:    br i1 [[TMP41]], label [[OMP_OUTER_LOG_SCAN_BODY]], label [[OMP_OUTER_LOG_SCAN_EXIT:%.*]]
// CHECK:       omp.outer.log.scan.exit:
// CHECK-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB4]], i32 [[TMP9]])
// CHECK-NEXT:    br label [[OMP_IF_END]]
// CHECK:       omp_if.end:
// CHECK-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3]], i32 [[TMP9]])
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB18]], align 4
// CHECK-NEXT:    store i32 63999, ptr [[DOTOMP_UB19]], align 4
// CHECK-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE20]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST21]], align 4
// CHECK-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2]], i32 [[TMP9]], i32 34, ptr [[DOTOMP_IS_LAST21]], ptr [[DOTOMP_LB18]], ptr [[DOTOMP_UB19]], ptr [[DOTOMP_STRIDE20]], i32 1, i32 1)
// CHECK-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_UB19]], align 4
// CHECK-NEXT:    [[CMP23:%.*]] = icmp sgt i32 [[TMP42]], 63999
// CHECK-NEXT:    br i1 [[CMP23]], label [[COND_TRUE24:%.*]], label [[COND_FALSE25:%.*]]
// CHECK:       cond.true24:
// CHECK-NEXT:    br label [[COND_END26:%.*]]
// CHECK:       cond.false25:
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_UB19]], align 4
// CHECK-NEXT:    br label [[COND_END26]]
// CHECK:       cond.end26:
// CHECK-NEXT:    [[COND27:%.*]] = phi i32 [ 63999, [[COND_TRUE24]] ], [ [[TMP43]], [[COND_FALSE25]] ]
// CHECK-NEXT:    store i32 [[COND27]], ptr [[DOTOMP_UB19]], align 4
// CHECK-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTOMP_LB18]], align 4
// CHECK-NEXT:    store i32 [[TMP44]], ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND28:%.*]]
// CHECK:       omp.inner.for.cond28:
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTOMP_UB19]], align 4
// CHECK-NEXT:    [[CMP29:%.*]] = icmp sle i32 [[TMP45]], [[TMP46]]
// CHECK-NEXT:    br i1 [[CMP29]], label [[OMP_INNER_FOR_BODY30:%.*]], label [[OMP_INNER_FOR_END47:%.*]]
// CHECK:       omp.inner.for.body30:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    [[MUL31:%.*]] = mul nsw i32 [[TMP47]], 1
// CHECK-NEXT:    [[ADD32:%.*]] = add nsw i32 0, [[MUL31]]
// CHECK-NEXT:    store i32 [[ADD32]], ptr [[I22]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM133]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH39:%.*]]
// CHECK:       omp.before.scan.bb34:
// CHECK-NEXT:    [[TMP48:%.*]] = load i32, ptr [[I22]], align 4
// CHECK-NEXT:    [[IDXPROM35:%.*]] = sext i32 [[TMP48]] to i64
// CHECK-NEXT:    [[ARRAYIDX36:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM35]]
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr [[ARRAYIDX36]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[SUM133]], align 4
// CHECK-NEXT:    [[ADD37:%.*]] = add nsw i32 [[TMP50]], [[TMP49]]
// CHECK-NEXT:    store i32 [[ADD37]], ptr [[SUM133]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE44:%.*]]
// CHECK:       omp.exit.inscan.bb38:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE44]]
// CHECK:       omp.inscan.dispatch39:
// CHECK-NEXT:    [[TMP51:%.*]] = load i32, ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    [[TMP52:%.*]] = zext i32 [[TMP51]] to i64
// CHECK-NEXT:    [[ARRAYIDX40:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP52]]
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[ARRAYIDX40]], align 4
// CHECK-NEXT:    store i32 [[TMP53]], ptr [[SUM133]], align 4
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB41:%.*]]
// CHECK:       omp.after.scan.bb41:
// CHECK-NEXT:    [[TMP54:%.*]] = load i32, ptr [[SUM133]], align 4
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr [[I22]], align 4
// CHECK-NEXT:    [[IDXPROM42:%.*]] = sext i32 [[TMP55]] to i64
// CHECK-NEXT:    [[ARRAYIDX43:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM42]]
// CHECK-NEXT:    store i32 [[TMP54]], ptr [[ARRAYIDX43]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB38:%.*]]
// CHECK:       omp.body.continue44:
// CHECK-NEXT:    br label [[OMP_INNER_FOR_INC45:%.*]]
// CHECK:       omp.inner.for.inc45:
// CHECK-NEXT:    [[TMP56:%.*]] = load i32, ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    [[ADD46:%.*]] = add nsw i32 [[TMP56]], 1
// CHECK-NEXT:    store i32 [[ADD46]], ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND28]]
// CHECK:       omp.inner.for.end47:
// CHECK-NEXT:    br label [[OMP_LOOP_EXIT48:%.*]]
// CHECK:       omp.loop.exit48:
// CHECK-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP9]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14_1
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR]], align 8
// CHECK-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2]], align 8
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[_TMP5:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB4]])
// CHECK-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR]], align 8
// CHECK-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2]], align 8
// CHECK-NEXT:    [[TMP_VLA:%.*]] = alloca i32, i64 64000, align 4
// CHECK-NEXT:    store ptr [[TMP_VLA]], ptr [[TMP8]], align 16
// CHECK-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB4]], i32 [[TMP3]], i32 250, i32 0)
// CHECK-NEXT:    [[D_TEAM_VALS:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAM_VALS]], align 4
// CHECK-NEXT:    [[D_TEAMS_DONE_PTR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR]], align 4
// CHECK-NEXT:    [[D_SCAN_STORAGE:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE]], align 4
// CHECK-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB4]], i32 8, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24.omp_outlined, ptr [[TMP4]], ptr [[TMP5]], ptr [[TMP6]], i64 [[TMP7]], ptr [[TMP8]], ptr [[D_TEAM_VALS]], ptr [[D_TEAMS_DONE_PTR]], ptr [[D_SCAN_STORAGE]])
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 63999
// CHECK-NEXT:    [[TMP9:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    store i32 [[TMP9]], ptr [[TMP5]], align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24.omp_outlined
// CHECK-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR]], align 8
// CHECK-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2]], align 8
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK-NEXT:    store i32 63999, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// CHECK-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1]], i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 63999
// CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK:       cond.true:
// CHECK-NEXT:    br label [[COND_END:%.*]]
// CHECK:       cond.false:
// CHECK-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    br label [[COND_END]]
// CHECK:       cond.end:
// CHECK-NEXT:    [[COND:%.*]] = phi i32 [ 63999, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK:       omp.inner.for.cond:
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK:       omp.inner.for.body:
// CHECK-NEXT:    call void @__kmpc_push_num_threads(ptr @[[GLOB4]], i32 [[TMP9]], i32 256)
// CHECK-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP15]] to i64
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK-NEXT:    [[D_TEAM_VALS:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAM_VALS]], align 4
// CHECK-NEXT:    [[D_TEAMS_DONE_PTR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR]], align 4
// CHECK-NEXT:    [[D_SCAN_STORAGE:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE]], align 4
// CHECK-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB4]], i32 10, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24.omp_outlined.omp_outlined, i64 [[TMP16]], i64 [[TMP18]], ptr [[TMP3]], ptr [[TMP4]], ptr [[TMP5]], i64 [[TMP6]], ptr [[TMP7]], ptr [[D_TEAM_VALS]], ptr [[D_TEAMS_DONE_PTR]], ptr [[D_SCAN_STORAGE]])
// CHECK-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK:       omp.inner.for.inc:
// CHECK-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK:       omp.inner.for.end:
// CHECK-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK:       omp.loop.exit:
// CHECK-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP9]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24.omp_outlined.omp_outlined
// CHECK-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[_TMP5:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[SUM27:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IV16:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[_TMP17:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_LB18:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_UB19:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_STRIDE20:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IS_LAST21:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[I22:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[SUM233:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR]], align 8
// CHECK-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2]], align 8
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK-NEXT:    store i32 63999, ptr [[DOTOMP_UB]], align 4
// CHECK-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// CHECK-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2]], i32 [[TMP9]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 63999
// CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK:       cond.true:
// CHECK-NEXT:    br label [[COND_END:%.*]]
// CHECK:       cond.false:
// CHECK-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK-NEXT:    br label [[COND_END]]
// CHECK:       cond.end:
// CHECK-NEXT:    [[COND:%.*]] = phi i32 [ 63999, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK:       omp.inner.for.cond:
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK:       omp.inner.for.body:
// CHECK-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM27]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[SUM27]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[I]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP3]], i64 0, i64 [[IDXPROM]]
// CHECK-NEXT:    store i32 [[TMP16]], ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[TMP19:%.*]] = zext i32 [[TMP18]] to i64
// CHECK-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP19]]
// CHECK-NEXT:    [[TMP20:%.*]] = load i32, ptr [[SUM27]], align 4
// CHECK-NEXT:    store i32 [[TMP20]], ptr [[ARRAYIDX8]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP21:%.*]] = load i32, ptr [[I]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP21]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM9]]
// CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[ARRAYIDX10]], align 4
// CHECK-NEXT:    [[TMP23:%.*]] = load i32, ptr [[SUM27]], align 4
// CHECK-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP23]], [[TMP22]]
// CHECK-NEXT:    store i32 [[ADD11]], ptr [[SUM27]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK:       omp.inner.for.inc:
// CHECK-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK-NEXT:    store i32 [[ADD12]], ptr [[DOTOMP_IV]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK:       omp.inner.for.end:
// CHECK-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK:       omp.loop.exit:
// CHECK-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP9]])
// CHECK-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3]], i32 [[TMP9]])
// CHECK-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB4]], i32 [[TMP9]])
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK:       omp_if.then:
// CHECK-NEXT:    [[TMP27:%.*]] = call double @llvm.log2.f64(double 6.400000e+04) #[[ATTR3]]
// CHECK-NEXT:    [[TMP28:%.*]] = call double @llvm.ceil.f64(double [[TMP27]]) #[[ATTR3]]
// CHECK-NEXT:    [[TMP29:%.*]] = fptoui double [[TMP28]] to i32
// CHECK-NEXT:    br label [[OMP_OUTER_LOG_SCAN_BODY:%.*]]
// CHECK:       omp.outer.log.scan.body:
// CHECK-NEXT:    [[TMP30:%.*]] = phi i32 [ 0, [[OMP_IF_THEN]] ], [ [[TMP39:%.*]], [[OMP_INNER_LOG_SCAN_EXIT:%.*]] ]
// CHECK-NEXT:    [[TMP31:%.*]] = phi i64 [ 1, [[OMP_IF_THEN]] ], [ [[TMP40:%.*]], [[OMP_INNER_LOG_SCAN_EXIT]] ]
// CHECK-NEXT:    [[TMP32:%.*]] = icmp uge i64 63999, [[TMP31]]
// CHECK-NEXT:    br i1 [[TMP32]], label [[OMP_INNER_LOG_SCAN_BODY:%.*]], label [[OMP_INNER_LOG_SCAN_EXIT]]
// CHECK:       omp.inner.log.scan.body:
// CHECK-NEXT:    [[TMP33:%.*]] = phi i64 [ 63999, [[OMP_OUTER_LOG_SCAN_BODY]] ], [ [[TMP37:%.*]], [[OMP_INNER_LOG_SCAN_BODY]] ]
// CHECK-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP33]]
// CHECK-NEXT:    [[TMP34:%.*]] = sub nuw i64 [[TMP33]], [[TMP31]]
// CHECK-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP34]]
// CHECK-NEXT:    [[TMP35:%.*]] = load i32, ptr [[ARRAYIDX13]], align 4
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[ARRAYIDX14]], align 4
// CHECK-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP35]], [[TMP36]]
// CHECK-NEXT:    store i32 [[ADD15]], ptr [[ARRAYIDX13]], align 4
// CHECK-NEXT:    [[TMP37]] = sub nuw i64 [[TMP33]], 1
// CHECK-NEXT:    [[TMP38:%.*]] = icmp uge i64 [[TMP37]], [[TMP31]]
// CHECK-NEXT:    br i1 [[TMP38]], label [[OMP_INNER_LOG_SCAN_BODY]], label [[OMP_INNER_LOG_SCAN_EXIT]]
// CHECK:       omp.inner.log.scan.exit:
// CHECK-NEXT:    [[TMP39]] = add nuw i32 [[TMP30]], 1
// CHECK-NEXT:    [[TMP40]] = shl nuw i64 [[TMP31]], 1
// CHECK-NEXT:    [[TMP41:%.*]] = icmp ne i32 [[TMP39]], [[TMP29]]
// CHECK-NEXT:    br i1 [[TMP41]], label [[OMP_OUTER_LOG_SCAN_BODY]], label [[OMP_OUTER_LOG_SCAN_EXIT:%.*]]
// CHECK:       omp.outer.log.scan.exit:
// CHECK-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB4]], i32 [[TMP9]])
// CHECK-NEXT:    br label [[OMP_IF_END]]
// CHECK:       omp_if.end:
// CHECK-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3]], i32 [[TMP9]])
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB18]], align 4
// CHECK-NEXT:    store i32 63999, ptr [[DOTOMP_UB19]], align 4
// CHECK-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE20]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST21]], align 4
// CHECK-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2]], i32 [[TMP9]], i32 34, ptr [[DOTOMP_IS_LAST21]], ptr [[DOTOMP_LB18]], ptr [[DOTOMP_UB19]], ptr [[DOTOMP_STRIDE20]], i32 1, i32 1)
// CHECK-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_UB19]], align 4
// CHECK-NEXT:    [[CMP23:%.*]] = icmp sgt i32 [[TMP42]], 63999
// CHECK-NEXT:    br i1 [[CMP23]], label [[COND_TRUE24:%.*]], label [[COND_FALSE25:%.*]]
// CHECK:       cond.true24:
// CHECK-NEXT:    br label [[COND_END26:%.*]]
// CHECK:       cond.false25:
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_UB19]], align 4
// CHECK-NEXT:    br label [[COND_END26]]
// CHECK:       cond.end26:
// CHECK-NEXT:    [[COND27:%.*]] = phi i32 [ 63999, [[COND_TRUE24]] ], [ [[TMP43]], [[COND_FALSE25]] ]
// CHECK-NEXT:    store i32 [[COND27]], ptr [[DOTOMP_UB19]], align 4
// CHECK-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTOMP_LB18]], align 4
// CHECK-NEXT:    store i32 [[TMP44]], ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND28:%.*]]
// CHECK:       omp.inner.for.cond28:
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTOMP_UB19]], align 4
// CHECK-NEXT:    [[CMP29:%.*]] = icmp sle i32 [[TMP45]], [[TMP46]]
// CHECK-NEXT:    br i1 [[CMP29]], label [[OMP_INNER_FOR_BODY30:%.*]], label [[OMP_INNER_FOR_END47:%.*]]
// CHECK:       omp.inner.for.body30:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    [[MUL31:%.*]] = mul nsw i32 [[TMP47]], 1
// CHECK-NEXT:    [[ADD32:%.*]] = add nsw i32 0, [[MUL31]]
// CHECK-NEXT:    store i32 [[ADD32]], ptr [[I22]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM233]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH38:%.*]]
// CHECK:       omp.before.scan.bb34:
// CHECK-NEXT:    [[TMP48:%.*]] = load i32, ptr [[SUM233]], align 4
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr [[I22]], align 4
// CHECK-NEXT:    [[IDXPROM35:%.*]] = sext i32 [[TMP49]] to i64
// CHECK-NEXT:    [[ARRAYIDX36:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP3]], i64 0, i64 [[IDXPROM35]]
// CHECK-NEXT:    store i32 [[TMP48]], ptr [[ARRAYIDX36]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE44:%.*]]
// CHECK:       omp.exit.inscan.bb37:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE44]]
// CHECK:       omp.inscan.dispatch38:
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = zext i32 [[TMP50]] to i64
// CHECK-NEXT:    [[TMP52:%.*]] = icmp eq i64 [[TMP51]], 0
// CHECK-NEXT:    br i1 [[TMP52]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// CHECK:       omp.exclusive.dec:
// CHECK-NEXT:    [[TMP53:%.*]] = sub nuw i64 [[TMP51]], 1
// CHECK-NEXT:    [[ARRAYIDX39:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP53]]
// CHECK-NEXT:    [[TMP54:%.*]] = load i32, ptr [[ARRAYIDX39]], align 4
// CHECK-NEXT:    store i32 [[TMP54]], ptr [[SUM233]], align 4
// CHECK-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// CHECK:       omp.exclusive.copy.exit:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB34:%.*]]
// CHECK:       omp.after.scan.bb40:
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr [[I22]], align 4
// CHECK-NEXT:    [[IDXPROM41:%.*]] = sext i32 [[TMP55]] to i64
// CHECK-NEXT:    [[ARRAYIDX42:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM41]]
// CHECK-NEXT:    [[TMP56:%.*]] = load i32, ptr [[ARRAYIDX42]], align 4
// CHECK-NEXT:    [[TMP57:%.*]] = load i32, ptr [[SUM233]], align 4
// CHECK-NEXT:    [[ADD43:%.*]] = add nsw i32 [[TMP57]], [[TMP56]]
// CHECK-NEXT:    store i32 [[ADD43]], ptr [[SUM233]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB37:%.*]]
// CHECK:       omp.body.continue44:
// CHECK-NEXT:    br label [[OMP_INNER_FOR_INC45:%.*]]
// CHECK:       omp.inner.for.inc45:
// CHECK-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    [[ADD46:%.*]] = add nsw i32 [[TMP58]], 1
// CHECK-NEXT:    store i32 [[ADD46]], ptr [[DOTOMP_IV16]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND28]]
// CHECK:       omp.inner.for.end47:
// CHECK-NEXT:    br label [[OMP_LOOP_EXIT48:%.*]]
// CHECK:       omp.loop.exit48:
// CHECK-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP9]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24_1
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR2]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR]], align 8
// CHECK-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2]], align 8
// CHECK-NEXT:    ret void
//
//
// SEGMENTED-LABEL: define {{[^@]+}}@main
// SEGMENTED-SAME: () #[[ATTR0:[0-9]+]] {
// SEGMENTED-NEXT:  entry:
// SEGMENTED-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[IN:%.*]] = alloca [64000 x i32], align 16
// SEGMENTED-NEXT:    [[OUT1:%.*]] = alloca [64000 x i32], align 16
// SEGMENTED-NEXT:    [[SUM1:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[_TMP5:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// SEGMENTED-NEXT:    [[DOTOFFLOAD_BASEPTRS12:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[DOTOFFLOAD_PTRS13:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[DOTOFFLOAD_MAPPERS14:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[_TMP15:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[KERNEL_ARGS16:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// SEGMENTED-NEXT:    [[_TMP19:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[SUM2:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[OUT2:%.*]] = alloca [64000 x i32], align 16
// SEGMENTED-NEXT:    [[_TMP20:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_LB30:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_UB31:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOFFLOAD_BASEPTRS36:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[DOTOFFLOAD_PTRS37:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[DOTOFFLOAD_MAPPERS38:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[_TMP39:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[KERNEL_ARGS40:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// SEGMENTED-NEXT:    [[DOTOFFLOAD_BASEPTRS49:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[DOTOFFLOAD_PTRS50:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[DOTOFFLOAD_MAPPERS51:%.*]] = alloca [9 x ptr], align 8
// SEGMENTED-NEXT:    [[_TMP52:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[KERNEL_ARGS53:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// SEGMENTED-NEXT:    [[_TMP56:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[SUM1]], align 4
// SEGMENTED-NEXT:    [[TMP0:%.*]] = call ptr @llvm.stacksave.p0()
// SEGMENTED-NEXT:    store ptr [[TMP0]], ptr [[SAVED_STACK]], align 8
// SEGMENTED-NEXT:    [[VLA:%.*]] = alloca i32, i64 0, align 16
// SEGMENTED-NEXT:    [[D_TEAM_VALS:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAM_VALS]], align 4
// SEGMENTED-NEXT:    [[D_TEAMS_DONE_PTR:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR]], align 4
// SEGMENTED-NEXT:    [[D_SCAN_STORAGE:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE]], align 4
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SEGMENT_VALS]], align 4
// SEGMENTED-NEXT:    [[DEFAULT_DEV:%.*]] = call i32 @omp_get_default_device()
// SEGMENTED-NEXT:    [[INITIAL_DEVID:%.*]] = call i32 @omp_get_initial_device()
// SEGMENTED-NEXT:    [[D_TEAM_VALS1:%.*]] = call ptr @omp_target_alloc(i64 1000, i32 [[DEFAULT_DEV]])
// SEGMENTED-NEXT:    [[D_SCAN_STORAGE2:%.*]] = call ptr @omp_target_alloc(i64 512004, i32 [[DEFAULT_DEV]])
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// SEGMENTED-NEXT:    store i32 63999, ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// SEGMENTED-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    [[TMP3:%.*]] = sub i32 [[TMP2]], [[TMP1]]
// SEGMENTED-NEXT:    [[SEGMENT_VALS_SIZE:%.*]] = add i32 [[TMP3]], 1
// SEGMENTED-NEXT:    [[TMP4:%.*]] = zext i32 [[SEGMENT_VALS_SIZE]] to i64
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS_SZ:%.*]] = mul i64 4, [[TMP4]]
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS3:%.*]] = call ptr @omp_target_alloc(i64 [[D_SEGMENT_VALS_SZ]], i32 [[DEFAULT_DEV]])
// SEGMENTED-NEXT:    store i32 0, ptr [[D_TEAMS_DONE_PTR]], align 4
// SEGMENTED-NEXT:    [[D_TEAMS_DONE_PTR4:%.*]] = call ptr @omp_target_alloc(i64 4, i32 [[DEFAULT_DEV]])
// SEGMENTED-NEXT:    [[TMP5:%.*]] = call i32 @omp_target_memcpy(ptr [[D_TEAMS_DONE_PTR4]], ptr [[D_TEAMS_DONE_PTR]], i64 4, i64 0, i64 0, i32 [[DEFAULT_DEV]], i32 [[INITIAL_DEVID]])
// SEGMENTED-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// SEGMENTED-NEXT:    store ptr [[SUM1]], ptr [[TMP6]], align 8
// SEGMENTED-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// SEGMENTED-NEXT:    store ptr [[SUM1]], ptr [[TMP7]], align 8
// SEGMENTED-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP8]], align 8
// SEGMENTED-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[TMP9]], align 8
// SEGMENTED-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[TMP10]], align 8
// SEGMENTED-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP11]], align 8
// SEGMENTED-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[OUT1]], ptr [[TMP12]], align 8
// SEGMENTED-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[OUT1]], ptr [[TMP13]], align 8
// SEGMENTED-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP14]], align 8
// SEGMENTED-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP15]], align 8
// SEGMENTED-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP16]], align 8
// SEGMENTED-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP17]], align 8
// SEGMENTED-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr [[VLA]], ptr [[TMP18]], align 8
// SEGMENTED-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr [[VLA]], ptr [[TMP19]], align 8
// SEGMENTED-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP20]], align 8
// SEGMENTED-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr [[D_TEAM_VALS1]], ptr [[TMP21]], align 8
// SEGMENTED-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr [[D_TEAM_VALS1]], ptr [[TMP22]], align 8
// SEGMENTED-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP23]], align 8
// SEGMENTED-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr [[D_TEAMS_DONE_PTR4]], ptr [[TMP24]], align 8
// SEGMENTED-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr [[D_TEAMS_DONE_PTR4]], ptr [[TMP25]], align 8
// SEGMENTED-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 6
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP26]], align 8
// SEGMENTED-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr [[D_SCAN_STORAGE2]], ptr [[TMP27]], align 8
// SEGMENTED-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr [[D_SCAN_STORAGE2]], ptr [[TMP28]], align 8
// SEGMENTED-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 7
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP29]], align 8
// SEGMENTED-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 8
// SEGMENTED-NEXT:    store ptr [[D_SEGMENT_VALS3]], ptr [[TMP30]], align 8
// SEGMENTED-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 8
// SEGMENTED-NEXT:    store ptr [[D_SEGMENT_VALS3]], ptr [[TMP31]], align 8
// SEGMENTED-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 8
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP32]], align 8
// SEGMENTED-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// SEGMENTED-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// SEGMENTED-NEXT:    [[TMP35:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// SEGMENTED-NEXT:    store i32 3, ptr [[TMP35]], align 4
// SEGMENTED-NEXT:    [[TMP36:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// SEGMENTED-NEXT:    store i32 9, ptr [[TMP36]], align 4
// SEGMENTED-NEXT:    [[TMP37:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[TMP33]], ptr [[TMP37]], align 8
// SEGMENTED-NEXT:    [[TMP38:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// SEGMENTED-NEXT:    store ptr [[TMP34]], ptr [[TMP38]], align 8
// SEGMENTED-NEXT:    [[TMP39:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr @.offload_sizes, ptr [[TMP39]], align 8
// SEGMENTED-NEXT:    [[TMP40:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr @.offload_maptypes, ptr [[TMP40]], align 8
// SEGMENTED-NEXT:    [[TMP41:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP41]], align 8
// SEGMENTED-NEXT:    [[TMP42:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP42]], align 8
// SEGMENTED-NEXT:    [[TMP43:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// SEGMENTED-NEXT:    store i64 64000, ptr [[TMP43]], align 8
// SEGMENTED-NEXT:    [[TMP44:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 9
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP44]], align 8
// SEGMENTED-NEXT:    [[TMP45:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 10
// SEGMENTED-NEXT:    store [3 x i32] [i32 250, i32 0, i32 0], ptr [[TMP45]], align 4
// SEGMENTED-NEXT:    [[TMP46:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 11
// SEGMENTED-NEXT:    store [3 x i32] [i32 256, i32 0, i32 0], ptr [[TMP46]], align 4
// SEGMENTED-NEXT:    [[TMP47:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 12
// SEGMENTED-NEXT:    store i32 0, ptr [[TMP47]], align 4
// SEGMENTED-NEXT:    [[TMP48:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB4:[0-9]+]], i64 -1, i32 250, i32 256, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14.region_id, ptr [[KERNEL_ARGS]])
// SEGMENTED-NEXT:    [[TMP49:%.*]] = icmp ne i32 [[TMP48]], 0
// SEGMENTED-NEXT:    br i1 [[TMP49]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// SEGMENTED:       omp_offload.failed:
// SEGMENTED-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14(ptr [[SUM1]], ptr [[IN]], ptr [[OUT1]], i64 0, ptr [[VLA]], ptr [[D_TEAM_VALS]], ptr [[D_TEAMS_DONE_PTR]], ptr [[D_SCAN_STORAGE]], ptr [[D_SEGMENT_VALS]]) #[[ATTR3:[0-9]+]]
// SEGMENTED-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// SEGMENTED:       omp_offload.cont:
// SEGMENTED-NEXT:    [[D_TEAM_VALS6:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAM_VALS6]], align 4
// SEGMENTED-NEXT:    [[D_TEAMS_DONE_PTR7:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR7]], align 4
// SEGMENTED-NEXT:    [[D_SCAN_STORAGE8:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE8]], align 4
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS9:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SEGMENT_VALS9]], align 4
// SEGMENTED-NEXT:    [[DEFAULT_DEV10:%.*]] = call i32 @omp_get_default_device()
// SEGMENTED-NEXT:    [[INITIAL_DEVID11:%.*]] = call i32 @omp_get_initial_device()
// SEGMENTED-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 0
// SEGMENTED-NEXT:    store ptr [[SUM1]], ptr [[TMP50]], align 8
// SEGMENTED-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS13]], i32 0, i32 0
// SEGMENTED-NEXT:    store ptr [[SUM1]], ptr [[TMP51]], align 8
// SEGMENTED-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS14]], i64 0, i64 0
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP52]], align 8
// SEGMENTED-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 1
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[TMP53]], align 8
// SEGMENTED-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS13]], i32 0, i32 1
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[TMP54]], align 8
// SEGMENTED-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS14]], i64 0, i64 1
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP55]], align 8
// SEGMENTED-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[OUT1]], ptr [[TMP56]], align 8
// SEGMENTED-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS13]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[OUT1]], ptr [[TMP57]], align 8
// SEGMENTED-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS14]], i64 0, i64 2
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP58]], align 8
// SEGMENTED-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 3
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP59]], align 8
// SEGMENTED-NEXT:    [[TMP60:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS13]], i32 0, i32 3
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP60]], align 8
// SEGMENTED-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS14]], i64 0, i64 3
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP61]], align 8
// SEGMENTED-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr [[VLA]], ptr [[TMP62]], align 8
// SEGMENTED-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS13]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr [[VLA]], ptr [[TMP63]], align 8
// SEGMENTED-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS14]], i64 0, i64 4
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP64]], align 8
// SEGMENTED-NEXT:    [[TMP65:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr [[D_TEAM_VALS1]], ptr [[TMP65]], align 8
// SEGMENTED-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS13]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr [[D_TEAM_VALS1]], ptr [[TMP66]], align 8
// SEGMENTED-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS14]], i64 0, i64 5
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP67]], align 8
// SEGMENTED-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr [[D_TEAMS_DONE_PTR4]], ptr [[TMP68]], align 8
// SEGMENTED-NEXT:    [[TMP69:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS13]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr [[D_TEAMS_DONE_PTR4]], ptr [[TMP69]], align 8
// SEGMENTED-NEXT:    [[TMP70:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS14]], i64 0, i64 6
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP70]], align 8
// SEGMENTED-NEXT:    [[TMP71:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr [[D_SCAN_STORAGE2]], ptr [[TMP71]], align 8
// SEGMENTED-NEXT:    [[TMP72:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS13]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr [[D_SCAN_STORAGE2]], ptr [[TMP72]], align 8
// SEGMENTED-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS14]], i64 0, i64 7
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP73]], align 8
// SEGMENTED-NEXT:    [[TMP74:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 8
// SEGMENTED-NEXT:    store ptr [[D_SEGMENT_VALS3]], ptr [[TMP74]], align 8
// SEGMENTED-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS13]], i32 0, i32 8
// SEGMENTED-NEXT:    store ptr [[D_SEGMENT_VALS3]], ptr [[TMP75]], align 8
// SEGMENTED-NEXT:    [[TMP76:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS14]], i64 0, i64 8
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP76]], align 8
// SEGMENTED-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 0
// SEGMENTED-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS13]], i32 0, i32 0
// SEGMENTED-NEXT:    [[TMP79:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 0
// SEGMENTED-NEXT:    store i32 3, ptr [[TMP79]], align 4
// SEGMENTED-NEXT:    [[TMP80:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 1
// SEGMENTED-NEXT:    store i32 9, ptr [[TMP80]], align 4
// SEGMENTED-NEXT:    [[TMP81:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[TMP77]], ptr [[TMP81]], align 8
// SEGMENTED-NEXT:    [[TMP82:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 3
// SEGMENTED-NEXT:    store ptr [[TMP78]], ptr [[TMP82]], align 8
// SEGMENTED-NEXT:    [[TMP83:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr @.offload_sizes.1, ptr [[TMP83]], align 8
// SEGMENTED-NEXT:    [[TMP84:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr @.offload_maptypes.2, ptr [[TMP84]], align 8
// SEGMENTED-NEXT:    [[TMP85:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP85]], align 8
// SEGMENTED-NEXT:    [[TMP86:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP86]], align 8
// SEGMENTED-NEXT:    [[TMP87:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 8
// SEGMENTED-NEXT:    store i64 64000, ptr [[TMP87]], align 8
// SEGMENTED-NEXT:    [[TMP88:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 9
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP88]], align 8
// SEGMENTED-NEXT:    [[TMP89:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 10
// SEGMENTED-NEXT:    store [3 x i32] [i32 250, i32 0, i32 0], ptr [[TMP89]], align 4
// SEGMENTED-NEXT:    [[TMP90:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 11
// SEGMENTED-NEXT:    store [3 x i32] [i32 256, i32 0, i32 0], ptr [[TMP90]], align 4
// SEGMENTED-NEXT:    [[TMP91:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS16]], i32 0, i32 12
// SEGMENTED-NEXT:    store i32 0, ptr [[TMP91]], align 4
// SEGMENTED-NEXT:    [[TMP92:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB4]], i64 -1, i32 250, i32 256, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14_1.region_id, ptr [[KERNEL_ARGS16]])
// SEGMENTED-NEXT:    [[TMP93:%.*]] = icmp ne i32 [[TMP92]], 0
// SEGMENTED-NEXT:    br i1 [[TMP93]], label [[OMP_OFFLOAD_FAILED17:%.*]], label [[OMP_OFFLOAD_CONT18:%.*]]
// SEGMENTED:       omp_offload.failed17:
// SEGMENTED-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14_1(ptr [[SUM1]], ptr [[IN]], ptr [[OUT1]], i64 0, ptr [[VLA]], ptr [[D_TEAM_VALS6]], ptr [[D_TEAMS_DONE_PTR7]], ptr [[D_SCAN_STORAGE8]], ptr [[D_SEGMENT_VALS9]]) #[[ATTR3]]
// SEGMENTED-NEXT:    br label [[OMP_OFFLOAD_CONT18]]
// SEGMENTED:       omp_offload.cont18:
// SEGMENTED-NEXT:    call void @omp_target_free(ptr [[D_TEAM_VALS1]], i32 [[DEFAULT_DEV10]])
// SEGMENTED-NEXT:    call void @omp_target_free(ptr [[D_TEAMS_DONE_PTR4]], i32 [[DEFAULT_DEV10]])
// SEGMENTED-NEXT:    call void @omp_target_free(ptr [[D_SCAN_STORAGE2]], i32 [[DEFAULT_DEV10]])
// SEGMENTED-NEXT:    call void @omp_target_free(ptr [[D_SEGMENT_VALS3]], i32 [[DEFAULT_DEV10]])
// SEGMENTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw i32, ptr [[VLA]], i64 -1
// SEGMENTED-NEXT:    [[TMP94:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP94]], ptr [[SUM1]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[SUM2]], align 4
// SEGMENTED-NEXT:    [[VLA21:%.*]] = alloca i32, i64 0, align 16
// SEGMENTED-NEXT:    [[D_TEAM_VALS22:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAM_VALS22]], align 4
// SEGMENTED-NEXT:    [[D_TEAMS_DONE_PTR23:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR23]], align 4
// SEGMENTED-NEXT:    [[D_SCAN_STORAGE24:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE24]], align 4
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS25:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SEGMENT_VALS25]], align 4
// SEGMENTED-NEXT:    [[DEFAULT_DEV26:%.*]] = call i32 @omp_get_default_device()
// SEGMENTED-NEXT:    [[INITIAL_DEVID27:%.*]] = call i32 @omp_get_initial_device()
// SEGMENTED-NEXT:    [[D_TEAM_VALS28:%.*]] = call ptr @omp_target_alloc(i64 1000, i32 [[DEFAULT_DEV26]])
// SEGMENTED-NEXT:    [[D_SCAN_STORAGE29:%.*]] = call ptr @omp_target_alloc(i64 512004, i32 [[DEFAULT_DEV26]])
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_LB30]], align 4
// SEGMENTED-NEXT:    store i32 63999, ptr [[DOTOMP_UB31]], align 4
// SEGMENTED-NEXT:    [[TMP95:%.*]] = load i32, ptr [[DOTOMP_LB30]], align 4
// SEGMENTED-NEXT:    [[TMP96:%.*]] = load i32, ptr [[DOTOMP_UB31]], align 4
// SEGMENTED-NEXT:    [[TMP97:%.*]] = sub i32 [[TMP96]], [[TMP95]]
// SEGMENTED-NEXT:    [[SEGMENT_VALS_SIZE32:%.*]] = add i32 [[TMP97]], 1
// SEGMENTED-NEXT:    [[TMP98:%.*]] = zext i32 [[SEGMENT_VALS_SIZE32]] to i64
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS_SZ33:%.*]] = mul i64 4, [[TMP98]]
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS34:%.*]] = call ptr @omp_target_alloc(i64 [[D_SEGMENT_VALS_SZ33]], i32 [[DEFAULT_DEV26]])
// SEGMENTED-NEXT:    store i32 0, ptr [[D_TEAMS_DONE_PTR23]], align 4
// SEGMENTED-NEXT:    [[D_TEAMS_DONE_PTR35:%.*]] = call ptr @omp_target_alloc(i64 4, i32 [[DEFAULT_DEV26]])
// SEGMENTED-NEXT:    [[TMP99:%.*]] = call i32 @omp_target_memcpy(ptr [[D_TEAMS_DONE_PTR35]], ptr [[D_TEAMS_DONE_PTR23]], i64 4, i64 0, i64 0, i32 [[DEFAULT_DEV26]], i32 [[INITIAL_DEVID27]])
// SEGMENTED-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS36]], i32 0, i32 0
// SEGMENTED-NEXT:    store ptr [[OUT2]], ptr [[TMP100]], align 8
// SEGMENTED-NEXT:    [[TMP101:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS37]], i32 0, i32 0
// SEGMENTED-NEXT:    store ptr [[OUT2]], ptr [[TMP101]], align 8
// SEGMENTED-NEXT:    [[TMP102:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS38]], i64 0, i64 0
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP102]], align 8
// SEGMENTED-NEXT:    [[TMP103:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS36]], i32 0, i32 1
// SEGMENTED-NEXT:    store ptr [[SUM2]], ptr [[TMP103]], align 8
// SEGMENTED-NEXT:    [[TMP104:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS37]], i32 0, i32 1
// SEGMENTED-NEXT:    store ptr [[SUM2]], ptr [[TMP104]], align 8
// SEGMENTED-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS38]], i64 0, i64 1
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP105]], align 8
// SEGMENTED-NEXT:    [[TMP106:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS36]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[TMP106]], align 8
// SEGMENTED-NEXT:    [[TMP107:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS37]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[TMP107]], align 8
// SEGMENTED-NEXT:    [[TMP108:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS38]], i64 0, i64 2
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP108]], align 8
// SEGMENTED-NEXT:    [[TMP109:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS36]], i32 0, i32 3
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP109]], align 8
// SEGMENTED-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS37]], i32 0, i32 3
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP110]], align 8
// SEGMENTED-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS38]], i64 0, i64 3
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP111]], align 8
// SEGMENTED-NEXT:    [[TMP112:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS36]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr [[VLA21]], ptr [[TMP112]], align 8
// SEGMENTED-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS37]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr [[VLA21]], ptr [[TMP113]], align 8
// SEGMENTED-NEXT:    [[TMP114:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS38]], i64 0, i64 4
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP114]], align 8
// SEGMENTED-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS36]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr [[D_TEAM_VALS28]], ptr [[TMP115]], align 8
// SEGMENTED-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS37]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr [[D_TEAM_VALS28]], ptr [[TMP116]], align 8
// SEGMENTED-NEXT:    [[TMP117:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS38]], i64 0, i64 5
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP117]], align 8
// SEGMENTED-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS36]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr [[D_TEAMS_DONE_PTR35]], ptr [[TMP118]], align 8
// SEGMENTED-NEXT:    [[TMP119:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS37]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr [[D_TEAMS_DONE_PTR35]], ptr [[TMP119]], align 8
// SEGMENTED-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS38]], i64 0, i64 6
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP120]], align 8
// SEGMENTED-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS36]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr [[D_SCAN_STORAGE29]], ptr [[TMP121]], align 8
// SEGMENTED-NEXT:    [[TMP122:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS37]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr [[D_SCAN_STORAGE29]], ptr [[TMP122]], align 8
// SEGMENTED-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS38]], i64 0, i64 7
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP123]], align 8
// SEGMENTED-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS36]], i32 0, i32 8
// SEGMENTED-NEXT:    store ptr [[D_SEGMENT_VALS34]], ptr [[TMP124]], align 8
// SEGMENTED-NEXT:    [[TMP125:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS37]], i32 0, i32 8
// SEGMENTED-NEXT:    store ptr [[D_SEGMENT_VALS34]], ptr [[TMP125]], align 8
// SEGMENTED-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS38]], i64 0, i64 8
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP126]], align 8
// SEGMENTED-NEXT:    [[TMP127:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS36]], i32 0, i32 0
// SEGMENTED-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS37]], i32 0, i32 0
// SEGMENTED-NEXT:    [[TMP129:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 0
// SEGMENTED-NEXT:    store i32 3, ptr [[TMP129]], align 4
// SEGMENTED-NEXT:    [[TMP130:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 1
// SEGMENTED-NEXT:    store i32 9, ptr [[TMP130]], align 4
// SEGMENTED-NEXT:    [[TMP131:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[TMP127]], ptr [[TMP131]], align 8
// SEGMENTED-NEXT:    [[TMP132:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 3
// SEGMENTED-NEXT:    store ptr [[TMP128]], ptr [[TMP132]], align 8
// SEGMENTED-NEXT:    [[TMP133:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr @.offload_sizes.3, ptr [[TMP133]], align 8
// SEGMENTED-NEXT:    [[TMP134:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr @.offload_maptypes.4, ptr [[TMP134]], align 8
// SEGMENTED-NEXT:    [[TMP135:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP135]], align 8
// SEGMENTED-NEXT:    [[TMP136:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP136]], align 8
// SEGMENTED-NEXT:    [[TMP137:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 8
// SEGMENTED-NEXT:    store i64 64000, ptr [[TMP137]], align 8
// SEGMENTED-NEXT:    [[TMP138:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 9
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP138]], align 8
// SEGMENTED-NEXT:    [[TMP139:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 10
// SEGMENTED-NEXT:    store [3 x i32] [i32 250, i32 0, i32 0], ptr [[TMP139]], align 4
// SEGMENTED-NEXT:    [[TMP140:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 11
// SEGMENTED-NEXT:    store [3 x i32] [i32 256, i32 0, i32 0], ptr [[TMP140]], align 4
// SEGMENTED-NEXT:    [[TMP141:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS40]], i32 0, i32 12
// SEGMENTED-NEXT:    store i32 0, ptr [[TMP141]], align 4
// SEGMENTED-NEXT:    [[TMP142:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB4]], i64 -1, i32 250, i32 256, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24.region_id, ptr [[KERNEL_ARGS40]])
// SEGMENTED-NEXT:    [[TMP143:%.*]] = icmp ne i32 [[TMP142]], 0
// SEGMENTED-NEXT:    br i1 [[TMP143]], label [[OMP_OFFLOAD_FAILED41:%.*]], label [[OMP_OFFLOAD_CONT42:%.*]]
// SEGMENTED:       omp_offload.failed41:
// SEGMENTED-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24(ptr [[OUT2]], ptr [[SUM2]], ptr [[IN]], i64 0, ptr [[VLA21]], ptr [[D_TEAM_VALS22]], ptr [[D_TEAMS_DONE_PTR23]], ptr [[D_SCAN_STORAGE24]], ptr [[D_SEGMENT_VALS25]]) #[[ATTR3]]
// SEGMENTED-NEXT:    br label [[OMP_OFFLOAD_CONT42]]
// SEGMENTED:       omp_offload.cont42:
// SEGMENTED-NEXT:    [[D_TEAM_VALS43:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAM_VALS43]], align 4
// SEGMENTED-NEXT:    [[D_TEAMS_DONE_PTR44:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR44]], align 4
// SEGMENTED-NEXT:    [[D_SCAN_STORAGE45:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE45]], align 4
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS46:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SEGMENT_VALS46]], align 4
// SEGMENTED-NEXT:    [[DEFAULT_DEV47:%.*]] = call i32 @omp_get_default_device()
// SEGMENTED-NEXT:    [[INITIAL_DEVID48:%.*]] = call i32 @omp_get_initial_device()
// SEGMENTED-NEXT:    [[TMP144:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS49]], i32 0, i32 0
// SEGMENTED-NEXT:    store ptr [[OUT2]], ptr [[TMP144]], align 8
// SEGMENTED-NEXT:    [[TMP145:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS50]], i32 0, i32 0
// SEGMENTED-NEXT:    store ptr [[OUT2]], ptr [[TMP145]], align 8
// SEGMENTED-NEXT:    [[TMP146:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS51]], i64 0, i64 0
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP146]], align 8
// SEGMENTED-NEXT:    [[TMP147:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS49]], i32 0, i32 1
// SEGMENTED-NEXT:    store ptr [[SUM2]], ptr [[TMP147]], align 8
// SEGMENTED-NEXT:    [[TMP148:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS50]], i32 0, i32 1
// SEGMENTED-NEXT:    store ptr [[SUM2]], ptr [[TMP148]], align 8
// SEGMENTED-NEXT:    [[TMP149:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS51]], i64 0, i64 1
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP149]], align 8
// SEGMENTED-NEXT:    [[TMP150:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS49]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[TMP150]], align 8
// SEGMENTED-NEXT:    [[TMP151:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS50]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[TMP151]], align 8
// SEGMENTED-NEXT:    [[TMP152:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS51]], i64 0, i64 2
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP152]], align 8
// SEGMENTED-NEXT:    [[TMP153:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS49]], i32 0, i32 3
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP153]], align 8
// SEGMENTED-NEXT:    [[TMP154:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS50]], i32 0, i32 3
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP154]], align 8
// SEGMENTED-NEXT:    [[TMP155:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS51]], i64 0, i64 3
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP155]], align 8
// SEGMENTED-NEXT:    [[TMP156:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS49]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr [[VLA21]], ptr [[TMP156]], align 8
// SEGMENTED-NEXT:    [[TMP157:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS50]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr [[VLA21]], ptr [[TMP157]], align 8
// SEGMENTED-NEXT:    [[TMP158:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS51]], i64 0, i64 4
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP158]], align 8
// SEGMENTED-NEXT:    [[TMP159:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS49]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr [[D_TEAM_VALS28]], ptr [[TMP159]], align 8
// SEGMENTED-NEXT:    [[TMP160:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS50]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr [[D_TEAM_VALS28]], ptr [[TMP160]], align 8
// SEGMENTED-NEXT:    [[TMP161:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS51]], i64 0, i64 5
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP161]], align 8
// SEGMENTED-NEXT:    [[TMP162:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS49]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr [[D_TEAMS_DONE_PTR35]], ptr [[TMP162]], align 8
// SEGMENTED-NEXT:    [[TMP163:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS50]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr [[D_TEAMS_DONE_PTR35]], ptr [[TMP163]], align 8
// SEGMENTED-NEXT:    [[TMP164:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS51]], i64 0, i64 6
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP164]], align 8
// SEGMENTED-NEXT:    [[TMP165:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS49]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr [[D_SCAN_STORAGE29]], ptr [[TMP165]], align 8
// SEGMENTED-NEXT:    [[TMP166:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS50]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr [[D_SCAN_STORAGE29]], ptr [[TMP166]], align 8
// SEGMENTED-NEXT:    [[TMP167:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS51]], i64 0, i64 7
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP167]], align 8
// SEGMENTED-NEXT:    [[TMP168:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS49]], i32 0, i32 8
// SEGMENTED-NEXT:    store ptr [[D_SEGMENT_VALS34]], ptr [[TMP168]], align 8
// SEGMENTED-NEXT:    [[TMP169:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS50]], i32 0, i32 8
// SEGMENTED-NEXT:    store ptr [[D_SEGMENT_VALS34]], ptr [[TMP169]], align 8
// SEGMENTED-NEXT:    [[TMP170:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS51]], i64 0, i64 8
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP170]], align 8
// SEGMENTED-NEXT:    [[TMP171:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS49]], i32 0, i32 0
// SEGMENTED-NEXT:    [[TMP172:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS50]], i32 0, i32 0
// SEGMENTED-NEXT:    [[TMP173:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 0
// SEGMENTED-NEXT:    store i32 3, ptr [[TMP173]], align 4
// SEGMENTED-NEXT:    [[TMP174:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 1
// SEGMENTED-NEXT:    store i32 9, ptr [[TMP174]], align 4
// SEGMENTED-NEXT:    [[TMP175:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 2
// SEGMENTED-NEXT:    store ptr [[TMP171]], ptr [[TMP175]], align 8
// SEGMENTED-NEXT:    [[TMP176:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 3
// SEGMENTED-NEXT:    store ptr [[TMP172]], ptr [[TMP176]], align 8
// SEGMENTED-NEXT:    [[TMP177:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 4
// SEGMENTED-NEXT:    store ptr @.offload_sizes.5, ptr [[TMP177]], align 8
// SEGMENTED-NEXT:    [[TMP178:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 5
// SEGMENTED-NEXT:    store ptr @.offload_maptypes.6, ptr [[TMP178]], align 8
// SEGMENTED-NEXT:    [[TMP179:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 6
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP179]], align 8
// SEGMENTED-NEXT:    [[TMP180:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 7
// SEGMENTED-NEXT:    store ptr null, ptr [[TMP180]], align 8
// SEGMENTED-NEXT:    [[TMP181:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 8
// SEGMENTED-NEXT:    store i64 64000, ptr [[TMP181]], align 8
// SEGMENTED-NEXT:    [[TMP182:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 9
// SEGMENTED-NEXT:    store i64 0, ptr [[TMP182]], align 8
// SEGMENTED-NEXT:    [[TMP183:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 10
// SEGMENTED-NEXT:    store [3 x i32] [i32 250, i32 0, i32 0], ptr [[TMP183]], align 4
// SEGMENTED-NEXT:    [[TMP184:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 11
// SEGMENTED-NEXT:    store [3 x i32] [i32 256, i32 0, i32 0], ptr [[TMP184]], align 4
// SEGMENTED-NEXT:    [[TMP185:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS53]], i32 0, i32 12
// SEGMENTED-NEXT:    store i32 0, ptr [[TMP185]], align 4
// SEGMENTED-NEXT:    [[TMP186:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB4]], i64 -1, i32 250, i32 256, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24_1.region_id, ptr [[KERNEL_ARGS53]])
// SEGMENTED-NEXT:    [[TMP187:%.*]] = icmp ne i32 [[TMP186]], 0
// SEGMENTED-NEXT:    br i1 [[TMP187]], label [[OMP_OFFLOAD_FAILED54:%.*]], label [[OMP_OFFLOAD_CONT55:%.*]]
// SEGMENTED:       omp_offload.failed54:
// SEGMENTED-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24_1(ptr [[OUT2]], ptr [[SUM2]], ptr [[IN]], i64 0, ptr [[VLA21]], ptr [[D_TEAM_VALS43]], ptr [[D_TEAMS_DONE_PTR44]], ptr [[D_SCAN_STORAGE45]], ptr [[D_SEGMENT_VALS46]]) #[[ATTR3]]
// SEGMENTED-NEXT:    br label [[OMP_OFFLOAD_CONT55]]
// SEGMENTED:       omp_offload.cont55:
// SEGMENTED-NEXT:    call void @omp_target_free(ptr [[D_TEAM_VALS28]], i32 [[DEFAULT_DEV47]])
// SEGMENTED-NEXT:    call void @omp_target_free(ptr [[D_TEAMS_DONE_PTR35]], i32 [[DEFAULT_DEV47]])
// SEGMENTED-NEXT:    call void @omp_target_free(ptr [[D_SCAN_STORAGE29]], i32 [[DEFAULT_DEV47]])
// SEGMENTED-NEXT:    call void @omp_target_free(ptr [[D_SEGMENT_VALS34]], i32 [[DEFAULT_DEV47]])
// SEGMENTED-NEXT:    [[ARRAYIDX57:%.*]] = getelementptr inbounds nuw i32, ptr [[VLA21]], i64 -1
// SEGMENTED-NEXT:    [[TMP188:%.*]] = load i32, ptr [[ARRAYIDX57]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP188]], ptr [[SUM2]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SEGMENTED-NEXT:    [[TMP189:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// SEGMENTED-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP189]])
// SEGMENTED-NEXT:    [[TMP190:%.*]] = load i32, ptr [[RETVAL]], align 4
// SEGMENTED-NEXT:    ret i32 [[TMP190]]
//
//
// SEGMENTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14
// SEGMENTED-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR2:[0-9]+]] {
// SEGMENTED-NEXT:  entry:
// SEGMENTED-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[_TMP6:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB4]])
// SEGMENTED-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5]], align 8
// SEGMENTED-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM1_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[OUT1_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP8:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[SUM1_ADDR2]], align 8
// SEGMENTED-NEXT:    [[TMP_VLA:%.*]] = alloca i32, i64 64000, align 4
// SEGMENTED-NEXT:    store ptr [[TMP_VLA]], ptr [[TMP9]], align 16
// SEGMENTED-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB4]], i32 [[TMP4]], i32 250, i32 0)
// SEGMENTED-NEXT:    [[D_TEAM_VALS:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAM_VALS]], align 4
// SEGMENTED-NEXT:    [[D_TEAMS_DONE_PTR:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR]], align 4
// SEGMENTED-NEXT:    [[D_SCAN_STORAGE:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE]], align 4
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SEGMENT_VALS]], align 4
// SEGMENTED-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB4]], i32 9, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14.omp_outlined, ptr [[TMP5]], ptr [[TMP6]], ptr [[TMP7]], i64 [[TMP8]], ptr [[TMP9]], ptr [[D_TEAM_VALS]], ptr [[D_TEAMS_DONE_PTR]], ptr [[D_SCAN_STORAGE]], ptr [[D_SEGMENT_VALS]])
// SEGMENTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP9]], i64 63999
// SEGMENTED-NEXT:    [[TMP10:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP10]], ptr [[TMP5]], align 4
// SEGMENTED-NEXT:    ret void
//
//
// SEGMENTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14.omp_outlined
// SEGMENTED-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR2]] {
// SEGMENTED-NEXT:  entry:
// SEGMENTED-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[I:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5]], align 8
// SEGMENTED-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2]], align 8
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// SEGMENTED-NEXT:    store i32 63999, ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// SEGMENTED-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// SEGMENTED-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP10]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// SEGMENTED-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 63999
// SEGMENTED-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// SEGMENTED:       cond.true:
// SEGMENTED-NEXT:    br label [[COND_END:%.*]]
// SEGMENTED:       cond.false:
// SEGMENTED-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    br label [[COND_END]]
// SEGMENTED:       cond.end:
// SEGMENTED-NEXT:    [[COND:%.*]] = phi i32 [ 63999, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// SEGMENTED-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP13]], ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// SEGMENTED:       omp.inner.for.cond:
// SEGMENTED-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// SEGMENTED-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// SEGMENTED:       omp.inner.for.body:
// SEGMENTED-NEXT:    call void @__kmpc_push_num_threads(ptr @[[GLOB4]], i32 [[TMP10]], i32 256)
// SEGMENTED-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// SEGMENTED-NEXT:    [[TMP17:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    [[TMP19:%.*]] = zext i32 [[TMP18]] to i64
// SEGMENTED-NEXT:    [[D_TEAM_VALS:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAM_VALS]], align 4
// SEGMENTED-NEXT:    [[D_TEAMS_DONE_PTR:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR]], align 4
// SEGMENTED-NEXT:    [[D_SCAN_STORAGE:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE]], align 4
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SEGMENT_VALS]], align 4
// SEGMENTED-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB4]], i32 11, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14.omp_outlined.omp_outlined, i64 [[TMP17]], i64 [[TMP19]], ptr [[TMP4]], ptr [[TMP5]], ptr [[TMP6]], i64 [[TMP7]], ptr [[TMP8]], ptr [[D_TEAM_VALS]], ptr [[D_TEAMS_DONE_PTR]], ptr [[D_SCAN_STORAGE]], ptr [[D_SEGMENT_VALS]])
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// SEGMENTED:       omp.inner.for.inc:
// SEGMENTED-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4
// SEGMENTED-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// SEGMENTED-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND]]
// SEGMENTED:       omp.inner.for.end:
// SEGMENTED-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// SEGMENTED:       omp.loop.exit:
// SEGMENTED-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP10]])
// SEGMENTED-NEXT:    ret void
//
//
// SEGMENTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14.omp_outlined.omp_outlined
// SEGMENTED-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR2]] {
// SEGMENTED-NEXT:  entry:
// SEGMENTED-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[_TMP6:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[I:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[SUM18:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_IV17:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[_TMP18:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_LB19:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_UB20:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_STRIDE21:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_IS_LAST22:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[I23:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[SUM134:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5]], align 8
// SEGMENTED-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2]], align 8
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// SEGMENTED-NEXT:    store i32 63999, ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// SEGMENTED-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// SEGMENTED-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2:[0-9]+]], i32 [[TMP10]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// SEGMENTED-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 63999
// SEGMENTED-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// SEGMENTED:       cond.true:
// SEGMENTED-NEXT:    br label [[COND_END:%.*]]
// SEGMENTED:       cond.false:
// SEGMENTED-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    br label [[COND_END]]
// SEGMENTED:       cond.end:
// SEGMENTED-NEXT:    [[COND:%.*]] = phi i32 [ 63999, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// SEGMENTED-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP13]], ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// SEGMENTED:       omp.inner.for.cond:
// SEGMENTED-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// SEGMENTED-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// SEGMENTED:       omp.inner.for.body:
// SEGMENTED-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// SEGMENTED-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-NEXT:    store i32 [[ADD]], ptr [[I]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[SUM18]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED:       omp.before.scan.bb:
// SEGMENTED-NEXT:    [[TMP17:%.*]] = load i32, ptr [[I]], align 4
// SEGMENTED-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-NEXT:    [[TMP18:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-NEXT:    [[TMP19:%.*]] = load i32, ptr [[SUM18]], align 4
// SEGMENTED-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP19]], [[TMP18]]
// SEGMENTED-NEXT:    store i32 [[ADD9]], ptr [[SUM18]], align 4
// SEGMENTED-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[TMP21:%.*]] = zext i32 [[TMP20]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP21]]
// SEGMENTED-NEXT:    [[TMP22:%.*]] = load i32, ptr [[SUM18]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP22]], ptr [[ARRAYIDX10]], align 4
// SEGMENTED-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED:       omp.exit.inscan.bb:
// SEGMENTED-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED:       omp.inscan.dispatch:
// SEGMENTED-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// SEGMENTED:       omp.after.scan.bb:
// SEGMENTED-NEXT:    [[TMP23:%.*]] = load i32, ptr [[SUM18]], align 4
// SEGMENTED-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I]], align 4
// SEGMENTED-NEXT:    [[IDXPROM11:%.*]] = sext i32 [[TMP24]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM11]]
// SEGMENTED-NEXT:    store i32 [[TMP23]], ptr [[ARRAYIDX12]], align 4
// SEGMENTED-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED:       omp.body.continue:
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// SEGMENTED:       omp.inner.for.inc:
// SEGMENTED-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP25]], 1
// SEGMENTED-NEXT:    store i32 [[ADD13]], ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND]]
// SEGMENTED:       omp.inner.for.end:
// SEGMENTED-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// SEGMENTED:       omp.loop.exit:
// SEGMENTED-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP10]])
// SEGMENTED-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3:[0-9]+]], i32 [[TMP10]])
// SEGMENTED-NEXT:    [[TMP26:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB4]], i32 [[TMP10]])
// SEGMENTED-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// SEGMENTED-NEXT:    br i1 [[TMP27]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// SEGMENTED:       omp_if.then:
// SEGMENTED-NEXT:    [[TMP28:%.*]] = call double @llvm.log2.f64(double 6.400000e+04) #[[ATTR3]]
// SEGMENTED-NEXT:    [[TMP29:%.*]] = call double @llvm.ceil.f64(double [[TMP28]]) #[[ATTR3]]
// SEGMENTED-NEXT:    [[TMP30:%.*]] = fptoui double [[TMP29]] to i32
// SEGMENTED-NEXT:    br label [[OMP_OUTER_LOG_SCAN_BODY:%.*]]
// SEGMENTED:       omp.outer.log.scan.body:
// SEGMENTED-NEXT:    [[TMP31:%.*]] = phi i32 [ 0, [[OMP_IF_THEN]] ], [ [[TMP40:%.*]], [[OMP_INNER_LOG_SCAN_EXIT:%.*]] ]
// SEGMENTED-NEXT:    [[TMP32:%.*]] = phi i64 [ 1, [[OMP_IF_THEN]] ], [ [[TMP41:%.*]], [[OMP_INNER_LOG_SCAN_EXIT]] ]
// SEGMENTED-NEXT:    [[TMP33:%.*]] = icmp uge i64 63999, [[TMP32]]
// SEGMENTED-NEXT:    br i1 [[TMP33]], label [[OMP_INNER_LOG_SCAN_BODY:%.*]], label [[OMP_INNER_LOG_SCAN_EXIT]]
// SEGMENTED:       omp.inner.log.scan.body:
// SEGMENTED-NEXT:    [[TMP34:%.*]] = phi i64 [ 63999, [[OMP_OUTER_LOG_SCAN_BODY]] ], [ [[TMP38:%.*]], [[OMP_INNER_LOG_SCAN_BODY]] ]
// SEGMENTED-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP34]]
// SEGMENTED-NEXT:    [[TMP35:%.*]] = sub nuw i64 [[TMP34]], [[TMP32]]
// SEGMENTED-NEXT:    [[ARRAYIDX15:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP35]]
// SEGMENTED-NEXT:    [[TMP36:%.*]] = load i32, ptr [[ARRAYIDX14]], align 4
// SEGMENTED-NEXT:    [[TMP37:%.*]] = load i32, ptr [[ARRAYIDX15]], align 4
// SEGMENTED-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP36]], [[TMP37]]
// SEGMENTED-NEXT:    store i32 [[ADD16]], ptr [[ARRAYIDX14]], align 4
// SEGMENTED-NEXT:    [[TMP38]] = sub nuw i64 [[TMP34]], 1
// SEGMENTED-NEXT:    [[TMP39:%.*]] = icmp uge i64 [[TMP38]], [[TMP32]]
// SEGMENTED-NEXT:    br i1 [[TMP39]], label [[OMP_INNER_LOG_SCAN_BODY]], label [[OMP_INNER_LOG_SCAN_EXIT]]
// SEGMENTED:       omp.inner.log.scan.exit:
// SEGMENTED-NEXT:    [[TMP40]] = add nuw i32 [[TMP31]], 1
// SEGMENTED-NEXT:    [[TMP41]] = shl nuw i64 [[TMP32]], 1
// SEGMENTED-NEXT:    [[TMP42:%.*]] = icmp ne i32 [[TMP40]], [[TMP30]]
// SEGMENTED-NEXT:    br i1 [[TMP42]], label [[OMP_OUTER_LOG_SCAN_BODY]], label [[OMP_OUTER_LOG_SCAN_EXIT:%.*]]
// SEGMENTED:       omp.outer.log.scan.exit:
// SEGMENTED-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB4]], i32 [[TMP10]])
// SEGMENTED-NEXT:    br label [[OMP_IF_END]]
// SEGMENTED:       omp_if.end:
// SEGMENTED-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3]], i32 [[TMP10]])
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_LB19]], align 4
// SEGMENTED-NEXT:    store i32 63999, ptr [[DOTOMP_UB20]], align 4
// SEGMENTED-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE21]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST22]], align 4
// SEGMENTED-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2]], i32 [[TMP10]], i32 34, ptr [[DOTOMP_IS_LAST22]], ptr [[DOTOMP_LB19]], ptr [[DOTOMP_UB20]], ptr [[DOTOMP_STRIDE21]], i32 1, i32 1)
// SEGMENTED-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_UB20]], align 4
// SEGMENTED-NEXT:    [[CMP24:%.*]] = icmp sgt i32 [[TMP43]], 63999
// SEGMENTED-NEXT:    br i1 [[CMP24]], label [[COND_TRUE25:%.*]], label [[COND_FALSE26:%.*]]
// SEGMENTED:       cond.true25:
// SEGMENTED-NEXT:    br label [[COND_END27:%.*]]
// SEGMENTED:       cond.false26:
// SEGMENTED-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTOMP_UB20]], align 4
// SEGMENTED-NEXT:    br label [[COND_END27]]
// SEGMENTED:       cond.end27:
// SEGMENTED-NEXT:    [[COND28:%.*]] = phi i32 [ 63999, [[COND_TRUE25]] ], [ [[TMP44]], [[COND_FALSE26]] ]
// SEGMENTED-NEXT:    store i32 [[COND28]], ptr [[DOTOMP_UB20]], align 4
// SEGMENTED-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTOMP_LB19]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP45]], ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND29:%.*]]
// SEGMENTED:       omp.inner.for.cond29:
// SEGMENTED-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_UB20]], align 4
// SEGMENTED-NEXT:    [[CMP30:%.*]] = icmp sle i32 [[TMP46]], [[TMP47]]
// SEGMENTED-NEXT:    br i1 [[CMP30]], label [[OMP_INNER_FOR_BODY31:%.*]], label [[OMP_INNER_FOR_END48:%.*]]
// SEGMENTED:       omp.inner.for.body31:
// SEGMENTED-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    [[MUL32:%.*]] = mul nsw i32 [[TMP48]], 1
// SEGMENTED-NEXT:    [[ADD33:%.*]] = add nsw i32 0, [[MUL32]]
// SEGMENTED-NEXT:    store i32 [[ADD33]], ptr [[I23]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[SUM134]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INSCAN_DISPATCH40:%.*]]
// SEGMENTED:       omp.before.scan.bb35:
// SEGMENTED-NEXT:    [[TMP49:%.*]] = load i32, ptr [[I23]], align 4
// SEGMENTED-NEXT:    [[IDXPROM36:%.*]] = sext i32 [[TMP49]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX37:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM36]]
// SEGMENTED-NEXT:    [[TMP50:%.*]] = load i32, ptr [[ARRAYIDX37]], align 4
// SEGMENTED-NEXT:    [[TMP51:%.*]] = load i32, ptr [[SUM134]], align 4
// SEGMENTED-NEXT:    [[ADD38:%.*]] = add nsw i32 [[TMP51]], [[TMP50]]
// SEGMENTED-NEXT:    store i32 [[ADD38]], ptr [[SUM134]], align 4
// SEGMENTED-NEXT:    br label [[OMP_BODY_CONTINUE45:%.*]]
// SEGMENTED:       omp.exit.inscan.bb39:
// SEGMENTED-NEXT:    br label [[OMP_BODY_CONTINUE45]]
// SEGMENTED:       omp.inscan.dispatch40:
// SEGMENTED-NEXT:    [[TMP52:%.*]] = load i32, ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    [[TMP53:%.*]] = zext i32 [[TMP52]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX41:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP53]]
// SEGMENTED-NEXT:    [[TMP54:%.*]] = load i32, ptr [[ARRAYIDX41]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP54]], ptr [[SUM134]], align 4
// SEGMENTED-NEXT:    br label [[OMP_AFTER_SCAN_BB42:%.*]]
// SEGMENTED:       omp.after.scan.bb42:
// SEGMENTED-NEXT:    [[TMP55:%.*]] = load i32, ptr [[SUM134]], align 4
// SEGMENTED-NEXT:    [[TMP56:%.*]] = load i32, ptr [[I23]], align 4
// SEGMENTED-NEXT:    [[IDXPROM43:%.*]] = sext i32 [[TMP56]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX44:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM43]]
// SEGMENTED-NEXT:    store i32 [[TMP55]], ptr [[ARRAYIDX44]], align 4
// SEGMENTED-NEXT:    br label [[OMP_EXIT_INSCAN_BB39:%.*]]
// SEGMENTED:       omp.body.continue45:
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_INC46:%.*]]
// SEGMENTED:       omp.inner.for.inc46:
// SEGMENTED-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    [[ADD47:%.*]] = add nsw i32 [[TMP57]], 1
// SEGMENTED-NEXT:    store i32 [[ADD47]], ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND29]]
// SEGMENTED:       omp.inner.for.end48:
// SEGMENTED-NEXT:    br label [[OMP_LOOP_EXIT49:%.*]]
// SEGMENTED:       omp.loop.exit49:
// SEGMENTED-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP10]])
// SEGMENTED-NEXT:    ret void
//
//
// SEGMENTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14_1
// SEGMENTED-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR2]] {
// SEGMENTED-NEXT:  entry:
// SEGMENTED-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5]], align 8
// SEGMENTED-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2]], align 8
// SEGMENTED-NEXT:    ret void
//
//
// SEGMENTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24
// SEGMENTED-SAME: (ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR2]] {
// SEGMENTED-NEXT:  entry:
// SEGMENTED-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[_TMP6:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB4]])
// SEGMENTED-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5]], align 8
// SEGMENTED-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT2_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM2_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP8:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[SUM2_ADDR2]], align 8
// SEGMENTED-NEXT:    [[TMP_VLA:%.*]] = alloca i32, i64 64000, align 4
// SEGMENTED-NEXT:    store ptr [[TMP_VLA]], ptr [[TMP9]], align 16
// SEGMENTED-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB4]], i32 [[TMP4]], i32 250, i32 0)
// SEGMENTED-NEXT:    [[D_TEAM_VALS:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAM_VALS]], align 4
// SEGMENTED-NEXT:    [[D_TEAMS_DONE_PTR:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR]], align 4
// SEGMENTED-NEXT:    [[D_SCAN_STORAGE:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE]], align 4
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SEGMENT_VALS]], align 4
// SEGMENTED-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB4]], i32 9, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24.omp_outlined, ptr [[TMP5]], ptr [[TMP6]], ptr [[TMP7]], i64 [[TMP8]], ptr [[TMP9]], ptr [[D_TEAM_VALS]], ptr [[D_TEAMS_DONE_PTR]], ptr [[D_SCAN_STORAGE]], ptr [[D_SEGMENT_VALS]])
// SEGMENTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP9]], i64 63999
// SEGMENTED-NEXT:    [[TMP10:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP10]], ptr [[TMP6]], align 4
// SEGMENTED-NEXT:    ret void
//
//
// SEGMENTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24.omp_outlined
// SEGMENTED-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR2]] {
// SEGMENTED-NEXT:  entry:
// SEGMENTED-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[I:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5]], align 8
// SEGMENTED-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2]], align 8
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// SEGMENTED-NEXT:    store i32 63999, ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// SEGMENTED-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// SEGMENTED-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1]], i32 [[TMP10]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// SEGMENTED-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 63999
// SEGMENTED-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// SEGMENTED:       cond.true:
// SEGMENTED-NEXT:    br label [[COND_END:%.*]]
// SEGMENTED:       cond.false:
// SEGMENTED-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    br label [[COND_END]]
// SEGMENTED:       cond.end:
// SEGMENTED-NEXT:    [[COND:%.*]] = phi i32 [ 63999, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// SEGMENTED-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP13]], ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// SEGMENTED:       omp.inner.for.cond:
// SEGMENTED-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// SEGMENTED-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// SEGMENTED:       omp.inner.for.body:
// SEGMENTED-NEXT:    call void @__kmpc_push_num_threads(ptr @[[GLOB4]], i32 [[TMP10]], i32 256)
// SEGMENTED-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// SEGMENTED-NEXT:    [[TMP17:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// SEGMENTED-NEXT:    [[TMP19:%.*]] = zext i32 [[TMP18]] to i64
// SEGMENTED-NEXT:    [[D_TEAM_VALS:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAM_VALS]], align 4
// SEGMENTED-NEXT:    [[D_TEAMS_DONE_PTR:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_TEAMS_DONE_PTR]], align 4
// SEGMENTED-NEXT:    [[D_SCAN_STORAGE:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SCAN_STORAGE]], align 4
// SEGMENTED-NEXT:    [[D_SEGMENT_VALS:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr null, ptr [[D_SEGMENT_VALS]], align 4
// SEGMENTED-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB4]], i32 11, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24.omp_outlined.omp_outlined, i64 [[TMP17]], i64 [[TMP19]], ptr [[TMP4]], ptr [[TMP5]], ptr [[TMP6]], i64 [[TMP7]], ptr [[TMP8]], ptr [[D_TEAM_VALS]], ptr [[D_TEAMS_DONE_PTR]], ptr [[D_SCAN_STORAGE]], ptr [[D_SEGMENT_VALS]])
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// SEGMENTED:       omp.inner.for.inc:
// SEGMENTED-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4
// SEGMENTED-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// SEGMENTED-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND]]
// SEGMENTED:       omp.inner.for.end:
// SEGMENTED-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// SEGMENTED:       omp.loop.exit:
// SEGMENTED-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP10]])
// SEGMENTED-NEXT:    ret void
//
//
// SEGMENTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24.omp_outlined.omp_outlined
// SEGMENTED-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR2]] {
// SEGMENTED-NEXT:  entry:
// SEGMENTED-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[_TMP6:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[I:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[SUM28:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_IV17:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[_TMP18:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_LB19:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_UB20:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_STRIDE21:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[DOTOMP_IS_LAST22:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[I23:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    [[SUM234:%.*]] = alloca i32, align 4
// SEGMENTED-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5]], align 8
// SEGMENTED-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2]], align 8
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// SEGMENTED-NEXT:    store i32 63999, ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// SEGMENTED-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// SEGMENTED-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2]], i32 [[TMP10]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// SEGMENTED-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 63999
// SEGMENTED-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// SEGMENTED:       cond.true:
// SEGMENTED-NEXT:    br label [[COND_END:%.*]]
// SEGMENTED:       cond.false:
// SEGMENTED-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    br label [[COND_END]]
// SEGMENTED:       cond.end:
// SEGMENTED-NEXT:    [[COND:%.*]] = phi i32 [ 63999, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// SEGMENTED-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP13]], ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// SEGMENTED:       omp.inner.for.cond:
// SEGMENTED-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// SEGMENTED-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// SEGMENTED-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// SEGMENTED:       omp.inner.for.body:
// SEGMENTED-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// SEGMENTED-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-NEXT:    store i32 [[ADD]], ptr [[I]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[SUM28]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED:       omp.before.scan.bb:
// SEGMENTED-NEXT:    [[TMP17:%.*]] = load i32, ptr [[SUM28]], align 4
// SEGMENTED-NEXT:    [[TMP18:%.*]] = load i32, ptr [[I]], align 4
// SEGMENTED-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP18]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-NEXT:    store i32 [[TMP17]], ptr [[ARRAYIDX]], align 4
// SEGMENTED-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED:       omp.exit.inscan.bb:
// SEGMENTED-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP20]]
// SEGMENTED-NEXT:    [[TMP21:%.*]] = load i32, ptr [[SUM28]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP21]], ptr [[ARRAYIDX9]], align 4
// SEGMENTED-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED:       omp.inscan.dispatch:
// SEGMENTED-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// SEGMENTED:       omp.after.scan.bb:
// SEGMENTED-NEXT:    [[TMP22:%.*]] = load i32, ptr [[I]], align 4
// SEGMENTED-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP22]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM10]]
// SEGMENTED-NEXT:    [[TMP23:%.*]] = load i32, ptr [[ARRAYIDX11]], align 4
// SEGMENTED-NEXT:    [[TMP24:%.*]] = load i32, ptr [[SUM28]], align 4
// SEGMENTED-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP24]], [[TMP23]]
// SEGMENTED-NEXT:    store i32 [[ADD12]], ptr [[SUM28]], align 4
// SEGMENTED-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED:       omp.body.continue:
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// SEGMENTED:       omp.inner.for.inc:
// SEGMENTED-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP25]], 1
// SEGMENTED-NEXT:    store i32 [[ADD13]], ptr [[DOTOMP_IV]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND]]
// SEGMENTED:       omp.inner.for.end:
// SEGMENTED-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// SEGMENTED:       omp.loop.exit:
// SEGMENTED-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP10]])
// SEGMENTED-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3]], i32 [[TMP10]])
// SEGMENTED-NEXT:    [[TMP26:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB4]], i32 [[TMP10]])
// SEGMENTED-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// SEGMENTED-NEXT:    br i1 [[TMP27]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// SEGMENTED:       omp_if.then:
// SEGMENTED-NEXT:    [[TMP28:%.*]] = call double @llvm.log2.f64(double 6.400000e+04) #[[ATTR3]]
// SEGMENTED-NEXT:    [[TMP29:%.*]] = call double @llvm.ceil.f64(double [[TMP28]]) #[[ATTR3]]
// SEGMENTED-NEXT:    [[TMP30:%.*]] = fptoui double [[TMP29]] to i32
// SEGMENTED-NEXT:    br label [[OMP_OUTER_LOG_SCAN_BODY:%.*]]
// SEGMENTED:       omp.outer.log.scan.body:
// SEGMENTED-NEXT:    [[TMP31:%.*]] = phi i32 [ 0, [[OMP_IF_THEN]] ], [ [[TMP40:%.*]], [[OMP_INNER_LOG_SCAN_EXIT:%.*]] ]
// SEGMENTED-NEXT:    [[TMP32:%.*]] = phi i64 [ 1, [[OMP_IF_THEN]] ], [ [[TMP41:%.*]], [[OMP_INNER_LOG_SCAN_EXIT]] ]
// SEGMENTED-NEXT:    [[TMP33:%.*]] = icmp uge i64 63999, [[TMP32]]
// SEGMENTED-NEXT:    br i1 [[TMP33]], label [[OMP_INNER_LOG_SCAN_BODY:%.*]], label [[OMP_INNER_LOG_SCAN_EXIT]]
// SEGMENTED:       omp.inner.log.scan.body:
// SEGMENTED-NEXT:    [[TMP34:%.*]] = phi i64 [ 63999, [[OMP_OUTER_LOG_SCAN_BODY]] ], [ [[TMP38:%.*]], [[OMP_INNER_LOG_SCAN_BODY]] ]
// SEGMENTED-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP34]]
// SEGMENTED-NEXT:    [[TMP35:%.*]] = sub nuw i64 [[TMP34]], [[TMP32]]
// SEGMENTED-NEXT:    [[ARRAYIDX15:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP35]]
// SEGMENTED-NEXT:    [[TMP36:%.*]] = load i32, ptr [[ARRAYIDX14]], align 4
// SEGMENTED-NEXT:    [[TMP37:%.*]] = load i32, ptr [[ARRAYIDX15]], align 4
// SEGMENTED-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP36]], [[TMP37]]
// SEGMENTED-NEXT:    store i32 [[ADD16]], ptr [[ARRAYIDX14]], align 4
// SEGMENTED-NEXT:    [[TMP38]] = sub nuw i64 [[TMP34]], 1
// SEGMENTED-NEXT:    [[TMP39:%.*]] = icmp uge i64 [[TMP38]], [[TMP32]]
// SEGMENTED-NEXT:    br i1 [[TMP39]], label [[OMP_INNER_LOG_SCAN_BODY]], label [[OMP_INNER_LOG_SCAN_EXIT]]
// SEGMENTED:       omp.inner.log.scan.exit:
// SEGMENTED-NEXT:    [[TMP40]] = add nuw i32 [[TMP31]], 1
// SEGMENTED-NEXT:    [[TMP41]] = shl nuw i64 [[TMP32]], 1
// SEGMENTED-NEXT:    [[TMP42:%.*]] = icmp ne i32 [[TMP40]], [[TMP30]]
// SEGMENTED-NEXT:    br i1 [[TMP42]], label [[OMP_OUTER_LOG_SCAN_BODY]], label [[OMP_OUTER_LOG_SCAN_EXIT:%.*]]
// SEGMENTED:       omp.outer.log.scan.exit:
// SEGMENTED-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB4]], i32 [[TMP10]])
// SEGMENTED-NEXT:    br label [[OMP_IF_END]]
// SEGMENTED:       omp_if.end:
// SEGMENTED-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3]], i32 [[TMP10]])
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_LB19]], align 4
// SEGMENTED-NEXT:    store i32 63999, ptr [[DOTOMP_UB20]], align 4
// SEGMENTED-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE21]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST22]], align 4
// SEGMENTED-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2]], i32 [[TMP10]], i32 34, ptr [[DOTOMP_IS_LAST22]], ptr [[DOTOMP_LB19]], ptr [[DOTOMP_UB20]], ptr [[DOTOMP_STRIDE21]], i32 1, i32 1)
// SEGMENTED-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_UB20]], align 4
// SEGMENTED-NEXT:    [[CMP24:%.*]] = icmp sgt i32 [[TMP43]], 63999
// SEGMENTED-NEXT:    br i1 [[CMP24]], label [[COND_TRUE25:%.*]], label [[COND_FALSE26:%.*]]
// SEGMENTED:       cond.true25:
// SEGMENTED-NEXT:    br label [[COND_END27:%.*]]
// SEGMENTED:       cond.false26:
// SEGMENTED-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTOMP_UB20]], align 4
// SEGMENTED-NEXT:    br label [[COND_END27]]
// SEGMENTED:       cond.end27:
// SEGMENTED-NEXT:    [[COND28:%.*]] = phi i32 [ 63999, [[COND_TRUE25]] ], [ [[TMP44]], [[COND_FALSE26]] ]
// SEGMENTED-NEXT:    store i32 [[COND28]], ptr [[DOTOMP_UB20]], align 4
// SEGMENTED-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTOMP_LB19]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP45]], ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND29:%.*]]
// SEGMENTED:       omp.inner.for.cond29:
// SEGMENTED-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_UB20]], align 4
// SEGMENTED-NEXT:    [[CMP30:%.*]] = icmp sle i32 [[TMP46]], [[TMP47]]
// SEGMENTED-NEXT:    br i1 [[CMP30]], label [[OMP_INNER_FOR_BODY31:%.*]], label [[OMP_INNER_FOR_END48:%.*]]
// SEGMENTED:       omp.inner.for.body31:
// SEGMENTED-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    [[MUL32:%.*]] = mul nsw i32 [[TMP48]], 1
// SEGMENTED-NEXT:    [[ADD33:%.*]] = add nsw i32 0, [[MUL32]]
// SEGMENTED-NEXT:    store i32 [[ADD33]], ptr [[I23]], align 4
// SEGMENTED-NEXT:    store i32 0, ptr [[SUM234]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INSCAN_DISPATCH39:%.*]]
// SEGMENTED:       omp.before.scan.bb35:
// SEGMENTED-NEXT:    [[TMP49:%.*]] = load i32, ptr [[SUM234]], align 4
// SEGMENTED-NEXT:    [[TMP50:%.*]] = load i32, ptr [[I23]], align 4
// SEGMENTED-NEXT:    [[IDXPROM36:%.*]] = sext i32 [[TMP50]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX37:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM36]]
// SEGMENTED-NEXT:    store i32 [[TMP49]], ptr [[ARRAYIDX37]], align 4
// SEGMENTED-NEXT:    br label [[OMP_BODY_CONTINUE45:%.*]]
// SEGMENTED:       omp.exit.inscan.bb38:
// SEGMENTED-NEXT:    br label [[OMP_BODY_CONTINUE45]]
// SEGMENTED:       omp.inscan.dispatch39:
// SEGMENTED-NEXT:    [[TMP51:%.*]] = load i32, ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    [[TMP52:%.*]] = zext i32 [[TMP51]] to i64
// SEGMENTED-NEXT:    [[TMP53:%.*]] = icmp eq i64 [[TMP52]], 0
// SEGMENTED-NEXT:    br i1 [[TMP53]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// SEGMENTED:       omp.exclusive.dec:
// SEGMENTED-NEXT:    [[TMP54:%.*]] = sub nuw i64 [[TMP52]], 1
// SEGMENTED-NEXT:    [[ARRAYIDX40:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP54]]
// SEGMENTED-NEXT:    [[TMP55:%.*]] = load i32, ptr [[ARRAYIDX40]], align 4
// SEGMENTED-NEXT:    store i32 [[TMP55]], ptr [[SUM234]], align 4
// SEGMENTED-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// SEGMENTED:       omp.exclusive.copy.exit:
// SEGMENTED-NEXT:    br label [[OMP_BEFORE_SCAN_BB35:%.*]]
// SEGMENTED:       omp.after.scan.bb41:
// SEGMENTED-NEXT:    [[TMP56:%.*]] = load i32, ptr [[I23]], align 4
// SEGMENTED-NEXT:    [[IDXPROM42:%.*]] = sext i32 [[TMP56]] to i64
// SEGMENTED-NEXT:    [[ARRAYIDX43:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM42]]
// SEGMENTED-NEXT:    [[TMP57:%.*]] = load i32, ptr [[ARRAYIDX43]], align 4
// SEGMENTED-NEXT:    [[TMP58:%.*]] = load i32, ptr [[SUM234]], align 4
// SEGMENTED-NEXT:    [[ADD44:%.*]] = add nsw i32 [[TMP58]], [[TMP57]]
// SEGMENTED-NEXT:    store i32 [[ADD44]], ptr [[SUM234]], align 4
// SEGMENTED-NEXT:    br label [[OMP_EXIT_INSCAN_BB38:%.*]]
// SEGMENTED:       omp.body.continue45:
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_INC46:%.*]]
// SEGMENTED:       omp.inner.for.inc46:
// SEGMENTED-NEXT:    [[TMP59:%.*]] = load i32, ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    [[ADD47:%.*]] = add nsw i32 [[TMP59]], 1
// SEGMENTED-NEXT:    store i32 [[ADD47]], ptr [[DOTOMP_IV17]], align 4
// SEGMENTED-NEXT:    br label [[OMP_INNER_FOR_COND29]]
// SEGMENTED:       omp.inner.for.end48:
// SEGMENTED-NEXT:    br label [[OMP_LOOP_EXIT49:%.*]]
// SEGMENTED:       omp.loop.exit49:
// SEGMENTED-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP10]])
// SEGMENTED-NEXT:    ret void
//
//
// SEGMENTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24_1
// SEGMENTED-SAME: (ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR2]] {
// SEGMENTED-NEXT:  entry:
// SEGMENTED-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// SEGMENTED-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8
// SEGMENTED-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[IN]], ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4]], align 8
// SEGMENTED-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5]], align 8
// SEGMENTED-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// SEGMENTED-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2]], align 8
// SEGMENTED-NEXT:    ret void
//
