/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.exception;

import org.dita.dost.exception.SAXExceptionWrapper;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.Configuration;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DITAOTXMLErrorHandler
implements ErrorHandler {
    private final String filePath;
    private final DITAOTLogger logger;
    private final Configuration.Mode mode;

    public DITAOTXMLErrorHandler(String file, DITAOTLogger logger, Configuration.Mode mode) {
        this.filePath = file;
        this.logger = logger;
        this.mode = mode;
    }

    @Override
    public void error(SAXParseException saxException) throws SAXException {
        SAXExceptionWrapper ex = new SAXExceptionWrapper(this.filePath, saxException);
        if (this.mode == Configuration.Mode.STRICT) {
            throw ex;
        }
        this.logger.error(MessageUtils.getMessage("DOTJ088E", saxException.getMessage()).setLocation(saxException).toString(), saxException);
    }

    @Override
    public void fatalError(SAXParseException saxException) throws SAXException {
        throw new SAXExceptionWrapper(this.filePath, saxException);
    }

    @Override
    public void warning(SAXParseException saxException) throws SAXException {
        String msg = new SAXExceptionWrapper(this.filePath, saxException).getMessage();
        this.logger.warn(msg);
    }
}

