//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by defaulter-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&corev1.ConfigMap{}, func(obj interface{}) { SetObjectDefaults_ConfigMap(obj.(*corev1.ConfigMap)) })
	scheme.AddTypeDefaultingFunc(&corev1.ConfigMapList{}, func(obj interface{}) { SetObjectDefaults_ConfigMapList(obj.(*corev1.ConfigMapList)) })
	scheme.AddTypeDefaultingFunc(&corev1.Endpoints{}, func(obj interface{}) { SetObjectDefaults_Endpoints(obj.(*corev1.Endpoints)) })
	scheme.AddTypeDefaultingFunc(&corev1.EndpointsList{}, func(obj interface{}) { SetObjectDefaults_EndpointsList(obj.(*corev1.EndpointsList)) })
	scheme.AddTypeDefaultingFunc(&corev1.LimitRange{}, func(obj interface{}) { SetObjectDefaults_LimitRange(obj.(*corev1.LimitRange)) })
	scheme.AddTypeDefaultingFunc(&corev1.LimitRangeList{}, func(obj interface{}) { SetObjectDefaults_LimitRangeList(obj.(*corev1.LimitRangeList)) })
	scheme.AddTypeDefaultingFunc(&corev1.Namespace{}, func(obj interface{}) { SetObjectDefaults_Namespace(obj.(*corev1.Namespace)) })
	scheme.AddTypeDefaultingFunc(&corev1.NamespaceList{}, func(obj interface{}) { SetObjectDefaults_NamespaceList(obj.(*corev1.NamespaceList)) })
	scheme.AddTypeDefaultingFunc(&corev1.Node{}, func(obj interface{}) { SetObjectDefaults_Node(obj.(*corev1.Node)) })
	scheme.AddTypeDefaultingFunc(&corev1.NodeList{}, func(obj interface{}) { SetObjectDefaults_NodeList(obj.(*corev1.NodeList)) })
	scheme.AddTypeDefaultingFunc(&corev1.PersistentVolume{}, func(obj interface{}) { SetObjectDefaults_PersistentVolume(obj.(*corev1.PersistentVolume)) })
	scheme.AddTypeDefaultingFunc(&corev1.PersistentVolumeClaim{}, func(obj interface{}) { SetObjectDefaults_PersistentVolumeClaim(obj.(*corev1.PersistentVolumeClaim)) })
	scheme.AddTypeDefaultingFunc(&corev1.PersistentVolumeClaimList{}, func(obj interface{}) {
		SetObjectDefaults_PersistentVolumeClaimList(obj.(*corev1.PersistentVolumeClaimList))
	})
	scheme.AddTypeDefaultingFunc(&corev1.PersistentVolumeList{}, func(obj interface{}) { SetObjectDefaults_PersistentVolumeList(obj.(*corev1.PersistentVolumeList)) })
	scheme.AddTypeDefaultingFunc(&corev1.Pod{}, func(obj interface{}) { SetObjectDefaults_Pod(obj.(*corev1.Pod)) })
	scheme.AddTypeDefaultingFunc(&corev1.PodList{}, func(obj interface{}) { SetObjectDefaults_PodList(obj.(*corev1.PodList)) })
	scheme.AddTypeDefaultingFunc(&corev1.PodLogOptions{}, func(obj interface{}) { SetObjectDefaults_PodLogOptions(obj.(*corev1.PodLogOptions)) })
	scheme.AddTypeDefaultingFunc(&corev1.PodStatusResult{}, func(obj interface{}) { SetObjectDefaults_PodStatusResult(obj.(*corev1.PodStatusResult)) })
	scheme.AddTypeDefaultingFunc(&corev1.PodTemplate{}, func(obj interface{}) { SetObjectDefaults_PodTemplate(obj.(*corev1.PodTemplate)) })
	scheme.AddTypeDefaultingFunc(&corev1.PodTemplateList{}, func(obj interface{}) { SetObjectDefaults_PodTemplateList(obj.(*corev1.PodTemplateList)) })
	scheme.AddTypeDefaultingFunc(&corev1.ReplicationController{}, func(obj interface{}) { SetObjectDefaults_ReplicationController(obj.(*corev1.ReplicationController)) })
	scheme.AddTypeDefaultingFunc(&corev1.ReplicationControllerList{}, func(obj interface{}) {
		SetObjectDefaults_ReplicationControllerList(obj.(*corev1.ReplicationControllerList))
	})
	scheme.AddTypeDefaultingFunc(&corev1.ResourceQuota{}, func(obj interface{}) { SetObjectDefaults_ResourceQuota(obj.(*corev1.ResourceQuota)) })
	scheme.AddTypeDefaultingFunc(&corev1.ResourceQuotaList{}, func(obj interface{}) { SetObjectDefaults_ResourceQuotaList(obj.(*corev1.ResourceQuotaList)) })
	scheme.AddTypeDefaultingFunc(&corev1.Secret{}, func(obj interface{}) { SetObjectDefaults_Secret(obj.(*corev1.Secret)) })
	scheme.AddTypeDefaultingFunc(&corev1.SecretList{}, func(obj interface{}) { SetObjectDefaults_SecretList(obj.(*corev1.SecretList)) })
	scheme.AddTypeDefaultingFunc(&corev1.Service{}, func(obj interface{}) { SetObjectDefaults_Service(obj.(*corev1.Service)) })
	scheme.AddTypeDefaultingFunc(&corev1.ServiceList{}, func(obj interface{}) { SetObjectDefaults_ServiceList(obj.(*corev1.ServiceList)) })
	return nil
}

func SetObjectDefaults_ConfigMap(in *corev1.ConfigMap) {
	SetDefaults_ConfigMap(in)
}

func SetObjectDefaults_ConfigMapList(in *corev1.ConfigMapList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_ConfigMap(a)
	}
}

func SetObjectDefaults_Endpoints(in *corev1.Endpoints) {
	SetDefaults_Endpoints(in)
}

func SetObjectDefaults_EndpointsList(in *corev1.EndpointsList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_Endpoints(a)
	}
}

func SetObjectDefaults_LimitRange(in *corev1.LimitRange) {
	for i := range in.Spec.Limits {
		a := &in.Spec.Limits[i]
		SetDefaults_LimitRangeItem(a)
		SetDefaults_ResourceList(&a.Max)
		SetDefaults_ResourceList(&a.Min)
		SetDefaults_ResourceList(&a.Default)
		SetDefaults_ResourceList(&a.DefaultRequest)
		SetDefaults_ResourceList(&a.MaxLimitRequestRatio)
	}
}

func SetObjectDefaults_LimitRangeList(in *corev1.LimitRangeList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_LimitRange(a)
	}
}

func SetObjectDefaults_Namespace(in *corev1.Namespace) {
	SetDefaults_Namespace(in)
	SetDefaults_NamespaceStatus(&in.Status)
}

func SetObjectDefaults_NamespaceList(in *corev1.NamespaceList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_Namespace(a)
	}
}

func SetObjectDefaults_Node(in *corev1.Node) {
	SetDefaults_NodeStatus(&in.Status)
	SetDefaults_ResourceList(&in.Status.Capacity)
	SetDefaults_ResourceList(&in.Status.Allocatable)
}

func SetObjectDefaults_NodeList(in *corev1.NodeList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_Node(a)
	}
}

func SetObjectDefaults_PersistentVolume(in *corev1.PersistentVolume) {
	SetDefaults_PersistentVolume(in)
	SetDefaults_ResourceList(&in.Spec.Capacity)
	if in.Spec.PersistentVolumeSource.HostPath != nil {
		SetDefaults_HostPathVolumeSource(in.Spec.PersistentVolumeSource.HostPath)
	}
	if in.Spec.PersistentVolumeSource.RBD != nil {
		if in.Spec.PersistentVolumeSource.RBD.RBDPool == "" {
			in.Spec.PersistentVolumeSource.RBD.RBDPool = "rbd"
		}
		if in.Spec.PersistentVolumeSource.RBD.RadosUser == "" {
			in.Spec.PersistentVolumeSource.RBD.RadosUser = "admin"
		}
		if in.Spec.PersistentVolumeSource.RBD.Keyring == "" {
			in.Spec.PersistentVolumeSource.RBD.Keyring = "/etc/ceph/keyring"
		}
	}
	if in.Spec.PersistentVolumeSource.ISCSI != nil {
		if in.Spec.PersistentVolumeSource.ISCSI.ISCSIInterface == "" {
			in.Spec.PersistentVolumeSource.ISCSI.ISCSIInterface = "default"
		}
	}
	if in.Spec.PersistentVolumeSource.AzureDisk != nil {
		if in.Spec.PersistentVolumeSource.AzureDisk.CachingMode == nil {
			ptrVar1 := corev1.AzureDataDiskCachingMode(corev1.AzureDataDiskCachingReadWrite)
			in.Spec.PersistentVolumeSource.AzureDisk.CachingMode = &ptrVar1
		}
		if in.Spec.PersistentVolumeSource.AzureDisk.FSType == nil {
			var ptrVar1 string = "ext4"
			in.Spec.PersistentVolumeSource.AzureDisk.FSType = &ptrVar1
		}
		if in.Spec.PersistentVolumeSource.AzureDisk.ReadOnly == nil {
			var ptrVar1 bool = false
			in.Spec.PersistentVolumeSource.AzureDisk.ReadOnly = &ptrVar1
		}
		if in.Spec.PersistentVolumeSource.AzureDisk.Kind == nil {
			ptrVar1 := corev1.AzureDataDiskKind(corev1.AzureSharedBlobDisk)
			in.Spec.PersistentVolumeSource.AzureDisk.Kind = &ptrVar1
		}
	}
	if in.Spec.PersistentVolumeSource.ScaleIO != nil {
		if in.Spec.PersistentVolumeSource.ScaleIO.StorageMode == "" {
			in.Spec.PersistentVolumeSource.ScaleIO.StorageMode = "ThinProvisioned"
		}
		if in.Spec.PersistentVolumeSource.ScaleIO.FSType == "" {
			in.Spec.PersistentVolumeSource.ScaleIO.FSType = "xfs"
		}
	}
}

func SetObjectDefaults_PersistentVolumeClaim(in *corev1.PersistentVolumeClaim) {
	SetDefaults_PersistentVolumeClaim(in)
	SetDefaults_PersistentVolumeClaimSpec(&in.Spec)
	SetDefaults_ResourceList(&in.Spec.Resources.Limits)
	SetDefaults_ResourceList(&in.Spec.Resources.Requests)
	SetDefaults_ResourceList(&in.Status.Capacity)
	SetDefaults_ResourceList(&in.Status.AllocatedResources)
}

func SetObjectDefaults_PersistentVolumeClaimList(in *corev1.PersistentVolumeClaimList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_PersistentVolumeClaim(a)
	}
}

func SetObjectDefaults_PersistentVolumeList(in *corev1.PersistentVolumeList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_PersistentVolume(a)
	}
}

func SetObjectDefaults_Pod(in *corev1.Pod) {
	SetDefaults_Pod(in)
	SetDefaults_PodSpec(&in.Spec)
	for i := range in.Spec.Volumes {
		a := &in.Spec.Volumes[i]
		SetDefaults_Volume(a)
		if a.VolumeSource.HostPath != nil {
			SetDefaults_HostPathVolumeSource(a.VolumeSource.HostPath)
		}
		if a.VolumeSource.Secret != nil {
			SetDefaults_SecretVolumeSource(a.VolumeSource.Secret)
		}
		if a.VolumeSource.ISCSI != nil {
			if a.VolumeSource.ISCSI.ISCSIInterface == "" {
				a.VolumeSource.ISCSI.ISCSIInterface = "default"
			}
		}
		if a.VolumeSource.RBD != nil {
			if a.VolumeSource.RBD.RBDPool == "" {
				a.VolumeSource.RBD.RBDPool = "rbd"
			}
			if a.VolumeSource.RBD.RadosUser == "" {
				a.VolumeSource.RBD.RadosUser = "admin"
			}
			if a.VolumeSource.RBD.Keyring == "" {
				a.VolumeSource.RBD.Keyring = "/etc/ceph/keyring"
			}
		}
		if a.VolumeSource.DownwardAPI != nil {
			SetDefaults_DownwardAPIVolumeSource(a.VolumeSource.DownwardAPI)
			for j := range a.VolumeSource.DownwardAPI.Items {
				b := &a.VolumeSource.DownwardAPI.Items[j]
				if b.FieldRef != nil {
					SetDefaults_ObjectFieldSelector(b.FieldRef)
				}
			}
		}
		if a.VolumeSource.ConfigMap != nil {
			SetDefaults_ConfigMapVolumeSource(a.VolumeSource.ConfigMap)
		}
		if a.VolumeSource.AzureDisk != nil {
			if a.VolumeSource.AzureDisk.CachingMode == nil {
				ptrVar1 := corev1.AzureDataDiskCachingMode(corev1.AzureDataDiskCachingReadWrite)
				a.VolumeSource.AzureDisk.CachingMode = &ptrVar1
			}
			if a.VolumeSource.AzureDisk.FSType == nil {
				var ptrVar1 string = "ext4"
				a.VolumeSource.AzureDisk.FSType = &ptrVar1
			}
			if a.VolumeSource.AzureDisk.ReadOnly == nil {
				var ptrVar1 bool = false
				a.VolumeSource.AzureDisk.ReadOnly = &ptrVar1
			}
			if a.VolumeSource.AzureDisk.Kind == nil {
				ptrVar1 := corev1.AzureDataDiskKind(corev1.AzureSharedBlobDisk)
				a.VolumeSource.AzureDisk.Kind = &ptrVar1
			}
		}
		if a.VolumeSource.Projected != nil {
			SetDefaults_ProjectedVolumeSource(a.VolumeSource.Projected)
			for j := range a.VolumeSource.Projected.Sources {
				b := &a.VolumeSource.Projected.Sources[j]
				if b.DownwardAPI != nil {
					for k := range b.DownwardAPI.Items {
						c := &b.DownwardAPI.Items[k]
						if c.FieldRef != nil {
							SetDefaults_ObjectFieldSelector(c.FieldRef)
						}
					}
				}
				if b.ServiceAccountToken != nil {
					SetDefaults_ServiceAccountTokenProjection(b.ServiceAccountToken)
				}
			}
		}
		if a.VolumeSource.ScaleIO != nil {
			if a.VolumeSource.ScaleIO.StorageMode == "" {
				a.VolumeSource.ScaleIO.StorageMode = "ThinProvisioned"
			}
			if a.VolumeSource.ScaleIO.FSType == "" {
				a.VolumeSource.ScaleIO.FSType = "xfs"
			}
		}
		if a.VolumeSource.Ephemeral != nil {
			if a.VolumeSource.Ephemeral.VolumeClaimTemplate != nil {
				SetDefaults_PersistentVolumeClaimSpec(&a.VolumeSource.Ephemeral.VolumeClaimTemplate.Spec)
				SetDefaults_ResourceList(&a.VolumeSource.Ephemeral.VolumeClaimTemplate.Spec.Resources.Limits)
				SetDefaults_ResourceList(&a.VolumeSource.Ephemeral.VolumeClaimTemplate.Spec.Resources.Requests)
			}
		}
	}
	for i := range in.Spec.InitContainers {
		a := &in.Spec.InitContainers[i]
		SetDefaults_Container(a)
		for j := range a.Ports {
			b := &a.Ports[j]
			if b.Protocol == "" {
				b.Protocol = "TCP"
			}
		}
		for j := range a.Env {
			b := &a.Env[j]
			if b.ValueFrom != nil {
				if b.ValueFrom.FieldRef != nil {
					SetDefaults_ObjectFieldSelector(b.ValueFrom.FieldRef)
				}
			}
		}
		SetDefaults_ResourceList(&a.Resources.Limits)
		SetDefaults_ResourceList(&a.Resources.Requests)
		if a.LivenessProbe != nil {
			SetDefaults_Probe(a.LivenessProbe)
			if a.LivenessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.LivenessProbe.ProbeHandler.HTTPGet)
			}
			if a.LivenessProbe.ProbeHandler.GRPC != nil {
				if a.LivenessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.ReadinessProbe != nil {
			SetDefaults_Probe(a.ReadinessProbe)
			if a.ReadinessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.ReadinessProbe.ProbeHandler.HTTPGet)
			}
			if a.ReadinessProbe.ProbeHandler.GRPC != nil {
				if a.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.StartupProbe != nil {
			SetDefaults_Probe(a.StartupProbe)
			if a.StartupProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.StartupProbe.ProbeHandler.HTTPGet)
			}
			if a.StartupProbe.ProbeHandler.GRPC != nil {
				if a.StartupProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.Lifecycle != nil {
			if a.Lifecycle.PostStart != nil {
				if a.Lifecycle.PostStart.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.Lifecycle.PostStart.HTTPGet)
				}
			}
			if a.Lifecycle.PreStop != nil {
				if a.Lifecycle.PreStop.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.Lifecycle.PreStop.HTTPGet)
				}
			}
		}
	}
	for i := range in.Spec.Containers {
		a := &in.Spec.Containers[i]
		SetDefaults_Container(a)
		for j := range a.Ports {
			b := &a.Ports[j]
			if b.Protocol == "" {
				b.Protocol = "TCP"
			}
		}
		for j := range a.Env {
			b := &a.Env[j]
			if b.ValueFrom != nil {
				if b.ValueFrom.FieldRef != nil {
					SetDefaults_ObjectFieldSelector(b.ValueFrom.FieldRef)
				}
			}
		}
		SetDefaults_ResourceList(&a.Resources.Limits)
		SetDefaults_ResourceList(&a.Resources.Requests)
		if a.LivenessProbe != nil {
			SetDefaults_Probe(a.LivenessProbe)
			if a.LivenessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.LivenessProbe.ProbeHandler.HTTPGet)
			}
			if a.LivenessProbe.ProbeHandler.GRPC != nil {
				if a.LivenessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.ReadinessProbe != nil {
			SetDefaults_Probe(a.ReadinessProbe)
			if a.ReadinessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.ReadinessProbe.ProbeHandler.HTTPGet)
			}
			if a.ReadinessProbe.ProbeHandler.GRPC != nil {
				if a.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.StartupProbe != nil {
			SetDefaults_Probe(a.StartupProbe)
			if a.StartupProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.StartupProbe.ProbeHandler.HTTPGet)
			}
			if a.StartupProbe.ProbeHandler.GRPC != nil {
				if a.StartupProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.Lifecycle != nil {
			if a.Lifecycle.PostStart != nil {
				if a.Lifecycle.PostStart.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.Lifecycle.PostStart.HTTPGet)
				}
			}
			if a.Lifecycle.PreStop != nil {
				if a.Lifecycle.PreStop.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.Lifecycle.PreStop.HTTPGet)
				}
			}
		}
	}
	for i := range in.Spec.EphemeralContainers {
		a := &in.Spec.EphemeralContainers[i]
		SetDefaults_EphemeralContainer(a)
		for j := range a.EphemeralContainerCommon.Ports {
			b := &a.EphemeralContainerCommon.Ports[j]
			if b.Protocol == "" {
				b.Protocol = "TCP"
			}
		}
		for j := range a.EphemeralContainerCommon.Env {
			b := &a.EphemeralContainerCommon.Env[j]
			if b.ValueFrom != nil {
				if b.ValueFrom.FieldRef != nil {
					SetDefaults_ObjectFieldSelector(b.ValueFrom.FieldRef)
				}
			}
		}
		SetDefaults_ResourceList(&a.EphemeralContainerCommon.Resources.Limits)
		SetDefaults_ResourceList(&a.EphemeralContainerCommon.Resources.Requests)
		if a.EphemeralContainerCommon.LivenessProbe != nil {
			SetDefaults_Probe(a.EphemeralContainerCommon.LivenessProbe)
			if a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.HTTPGet)
			}
			if a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC != nil {
				if a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.EphemeralContainerCommon.ReadinessProbe != nil {
			SetDefaults_Probe(a.EphemeralContainerCommon.ReadinessProbe)
			if a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.HTTPGet)
			}
			if a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC != nil {
				if a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.EphemeralContainerCommon.StartupProbe != nil {
			SetDefaults_Probe(a.EphemeralContainerCommon.StartupProbe)
			if a.EphemeralContainerCommon.StartupProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.StartupProbe.ProbeHandler.HTTPGet)
			}
			if a.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC != nil {
				if a.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.EphemeralContainerCommon.Lifecycle != nil {
			if a.EphemeralContainerCommon.Lifecycle.PostStart != nil {
				if a.EphemeralContainerCommon.Lifecycle.PostStart.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.Lifecycle.PostStart.HTTPGet)
				}
			}
			if a.EphemeralContainerCommon.Lifecycle.PreStop != nil {
				if a.EphemeralContainerCommon.Lifecycle.PreStop.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.Lifecycle.PreStop.HTTPGet)
				}
			}
		}
	}
	SetDefaults_ResourceList(&in.Spec.Overhead)
	if in.Spec.Resources != nil {
		SetDefaults_ResourceList(&in.Spec.Resources.Limits)
		SetDefaults_ResourceList(&in.Spec.Resources.Requests)
	}
	for i := range in.Status.InitContainerStatuses {
		a := &in.Status.InitContainerStatuses[i]
		SetDefaults_ResourceList(&a.AllocatedResources)
		if a.Resources != nil {
			SetDefaults_ResourceList(&a.Resources.Limits)
			SetDefaults_ResourceList(&a.Resources.Requests)
		}
	}
	for i := range in.Status.ContainerStatuses {
		a := &in.Status.ContainerStatuses[i]
		SetDefaults_ResourceList(&a.AllocatedResources)
		if a.Resources != nil {
			SetDefaults_ResourceList(&a.Resources.Limits)
			SetDefaults_ResourceList(&a.Resources.Requests)
		}
	}
	for i := range in.Status.EphemeralContainerStatuses {
		a := &in.Status.EphemeralContainerStatuses[i]
		SetDefaults_ResourceList(&a.AllocatedResources)
		if a.Resources != nil {
			SetDefaults_ResourceList(&a.Resources.Limits)
			SetDefaults_ResourceList(&a.Resources.Requests)
		}
	}
}

func SetObjectDefaults_PodList(in *corev1.PodList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_Pod(a)
	}
}

func SetObjectDefaults_PodLogOptions(in *corev1.PodLogOptions) {
	SetDefaults_PodLogOptions(in)
}

func SetObjectDefaults_PodStatusResult(in *corev1.PodStatusResult) {
	for i := range in.Status.InitContainerStatuses {
		a := &in.Status.InitContainerStatuses[i]
		SetDefaults_ResourceList(&a.AllocatedResources)
		if a.Resources != nil {
			SetDefaults_ResourceList(&a.Resources.Limits)
			SetDefaults_ResourceList(&a.Resources.Requests)
		}
	}
	for i := range in.Status.ContainerStatuses {
		a := &in.Status.ContainerStatuses[i]
		SetDefaults_ResourceList(&a.AllocatedResources)
		if a.Resources != nil {
			SetDefaults_ResourceList(&a.Resources.Limits)
			SetDefaults_ResourceList(&a.Resources.Requests)
		}
	}
	for i := range in.Status.EphemeralContainerStatuses {
		a := &in.Status.EphemeralContainerStatuses[i]
		SetDefaults_ResourceList(&a.AllocatedResources)
		if a.Resources != nil {
			SetDefaults_ResourceList(&a.Resources.Limits)
			SetDefaults_ResourceList(&a.Resources.Requests)
		}
	}
}

func SetObjectDefaults_PodTemplate(in *corev1.PodTemplate) {
	SetDefaults_PodSpec(&in.Template.Spec)
	for i := range in.Template.Spec.Volumes {
		a := &in.Template.Spec.Volumes[i]
		SetDefaults_Volume(a)
		if a.VolumeSource.HostPath != nil {
			SetDefaults_HostPathVolumeSource(a.VolumeSource.HostPath)
		}
		if a.VolumeSource.Secret != nil {
			SetDefaults_SecretVolumeSource(a.VolumeSource.Secret)
		}
		if a.VolumeSource.ISCSI != nil {
			if a.VolumeSource.ISCSI.ISCSIInterface == "" {
				a.VolumeSource.ISCSI.ISCSIInterface = "default"
			}
		}
		if a.VolumeSource.RBD != nil {
			if a.VolumeSource.RBD.RBDPool == "" {
				a.VolumeSource.RBD.RBDPool = "rbd"
			}
			if a.VolumeSource.RBD.RadosUser == "" {
				a.VolumeSource.RBD.RadosUser = "admin"
			}
			if a.VolumeSource.RBD.Keyring == "" {
				a.VolumeSource.RBD.Keyring = "/etc/ceph/keyring"
			}
		}
		if a.VolumeSource.DownwardAPI != nil {
			SetDefaults_DownwardAPIVolumeSource(a.VolumeSource.DownwardAPI)
			for j := range a.VolumeSource.DownwardAPI.Items {
				b := &a.VolumeSource.DownwardAPI.Items[j]
				if b.FieldRef != nil {
					SetDefaults_ObjectFieldSelector(b.FieldRef)
				}
			}
		}
		if a.VolumeSource.ConfigMap != nil {
			SetDefaults_ConfigMapVolumeSource(a.VolumeSource.ConfigMap)
		}
		if a.VolumeSource.AzureDisk != nil {
			if a.VolumeSource.AzureDisk.CachingMode == nil {
				ptrVar1 := corev1.AzureDataDiskCachingMode(corev1.AzureDataDiskCachingReadWrite)
				a.VolumeSource.AzureDisk.CachingMode = &ptrVar1
			}
			if a.VolumeSource.AzureDisk.FSType == nil {
				var ptrVar1 string = "ext4"
				a.VolumeSource.AzureDisk.FSType = &ptrVar1
			}
			if a.VolumeSource.AzureDisk.ReadOnly == nil {
				var ptrVar1 bool = false
				a.VolumeSource.AzureDisk.ReadOnly = &ptrVar1
			}
			if a.VolumeSource.AzureDisk.Kind == nil {
				ptrVar1 := corev1.AzureDataDiskKind(corev1.AzureSharedBlobDisk)
				a.VolumeSource.AzureDisk.Kind = &ptrVar1
			}
		}
		if a.VolumeSource.Projected != nil {
			SetDefaults_ProjectedVolumeSource(a.VolumeSource.Projected)
			for j := range a.VolumeSource.Projected.Sources {
				b := &a.VolumeSource.Projected.Sources[j]
				if b.DownwardAPI != nil {
					for k := range b.DownwardAPI.Items {
						c := &b.DownwardAPI.Items[k]
						if c.FieldRef != nil {
							SetDefaults_ObjectFieldSelector(c.FieldRef)
						}
					}
				}
				if b.ServiceAccountToken != nil {
					SetDefaults_ServiceAccountTokenProjection(b.ServiceAccountToken)
				}
			}
		}
		if a.VolumeSource.ScaleIO != nil {
			if a.VolumeSource.ScaleIO.StorageMode == "" {
				a.VolumeSource.ScaleIO.StorageMode = "ThinProvisioned"
			}
			if a.VolumeSource.ScaleIO.FSType == "" {
				a.VolumeSource.ScaleIO.FSType = "xfs"
			}
		}
		if a.VolumeSource.Ephemeral != nil {
			if a.VolumeSource.Ephemeral.VolumeClaimTemplate != nil {
				SetDefaults_PersistentVolumeClaimSpec(&a.VolumeSource.Ephemeral.VolumeClaimTemplate.Spec)
				SetDefaults_ResourceList(&a.VolumeSource.Ephemeral.VolumeClaimTemplate.Spec.Resources.Limits)
				SetDefaults_ResourceList(&a.VolumeSource.Ephemeral.VolumeClaimTemplate.Spec.Resources.Requests)
			}
		}
	}
	for i := range in.Template.Spec.InitContainers {
		a := &in.Template.Spec.InitContainers[i]
		SetDefaults_Container(a)
		for j := range a.Ports {
			b := &a.Ports[j]
			if b.Protocol == "" {
				b.Protocol = "TCP"
			}
		}
		for j := range a.Env {
			b := &a.Env[j]
			if b.ValueFrom != nil {
				if b.ValueFrom.FieldRef != nil {
					SetDefaults_ObjectFieldSelector(b.ValueFrom.FieldRef)
				}
			}
		}
		SetDefaults_ResourceList(&a.Resources.Limits)
		SetDefaults_ResourceList(&a.Resources.Requests)
		if a.LivenessProbe != nil {
			SetDefaults_Probe(a.LivenessProbe)
			if a.LivenessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.LivenessProbe.ProbeHandler.HTTPGet)
			}
			if a.LivenessProbe.ProbeHandler.GRPC != nil {
				if a.LivenessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.ReadinessProbe != nil {
			SetDefaults_Probe(a.ReadinessProbe)
			if a.ReadinessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.ReadinessProbe.ProbeHandler.HTTPGet)
			}
			if a.ReadinessProbe.ProbeHandler.GRPC != nil {
				if a.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.StartupProbe != nil {
			SetDefaults_Probe(a.StartupProbe)
			if a.StartupProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.StartupProbe.ProbeHandler.HTTPGet)
			}
			if a.StartupProbe.ProbeHandler.GRPC != nil {
				if a.StartupProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.Lifecycle != nil {
			if a.Lifecycle.PostStart != nil {
				if a.Lifecycle.PostStart.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.Lifecycle.PostStart.HTTPGet)
				}
			}
			if a.Lifecycle.PreStop != nil {
				if a.Lifecycle.PreStop.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.Lifecycle.PreStop.HTTPGet)
				}
			}
		}
	}
	for i := range in.Template.Spec.Containers {
		a := &in.Template.Spec.Containers[i]
		SetDefaults_Container(a)
		for j := range a.Ports {
			b := &a.Ports[j]
			if b.Protocol == "" {
				b.Protocol = "TCP"
			}
		}
		for j := range a.Env {
			b := &a.Env[j]
			if b.ValueFrom != nil {
				if b.ValueFrom.FieldRef != nil {
					SetDefaults_ObjectFieldSelector(b.ValueFrom.FieldRef)
				}
			}
		}
		SetDefaults_ResourceList(&a.Resources.Limits)
		SetDefaults_ResourceList(&a.Resources.Requests)
		if a.LivenessProbe != nil {
			SetDefaults_Probe(a.LivenessProbe)
			if a.LivenessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.LivenessProbe.ProbeHandler.HTTPGet)
			}
			if a.LivenessProbe.ProbeHandler.GRPC != nil {
				if a.LivenessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.ReadinessProbe != nil {
			SetDefaults_Probe(a.ReadinessProbe)
			if a.ReadinessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.ReadinessProbe.ProbeHandler.HTTPGet)
			}
			if a.ReadinessProbe.ProbeHandler.GRPC != nil {
				if a.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.StartupProbe != nil {
			SetDefaults_Probe(a.StartupProbe)
			if a.StartupProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.StartupProbe.ProbeHandler.HTTPGet)
			}
			if a.StartupProbe.ProbeHandler.GRPC != nil {
				if a.StartupProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.Lifecycle != nil {
			if a.Lifecycle.PostStart != nil {
				if a.Lifecycle.PostStart.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.Lifecycle.PostStart.HTTPGet)
				}
			}
			if a.Lifecycle.PreStop != nil {
				if a.Lifecycle.PreStop.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.Lifecycle.PreStop.HTTPGet)
				}
			}
		}
	}
	for i := range in.Template.Spec.EphemeralContainers {
		a := &in.Template.Spec.EphemeralContainers[i]
		SetDefaults_EphemeralContainer(a)
		for j := range a.EphemeralContainerCommon.Ports {
			b := &a.EphemeralContainerCommon.Ports[j]
			if b.Protocol == "" {
				b.Protocol = "TCP"
			}
		}
		for j := range a.EphemeralContainerCommon.Env {
			b := &a.EphemeralContainerCommon.Env[j]
			if b.ValueFrom != nil {
				if b.ValueFrom.FieldRef != nil {
					SetDefaults_ObjectFieldSelector(b.ValueFrom.FieldRef)
				}
			}
		}
		SetDefaults_ResourceList(&a.EphemeralContainerCommon.Resources.Limits)
		SetDefaults_ResourceList(&a.EphemeralContainerCommon.Resources.Requests)
		if a.EphemeralContainerCommon.LivenessProbe != nil {
			SetDefaults_Probe(a.EphemeralContainerCommon.LivenessProbe)
			if a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.HTTPGet)
			}
			if a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC != nil {
				if a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.EphemeralContainerCommon.ReadinessProbe != nil {
			SetDefaults_Probe(a.EphemeralContainerCommon.ReadinessProbe)
			if a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.HTTPGet)
			}
			if a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC != nil {
				if a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.EphemeralContainerCommon.StartupProbe != nil {
			SetDefaults_Probe(a.EphemeralContainerCommon.StartupProbe)
			if a.EphemeralContainerCommon.StartupProbe.ProbeHandler.HTTPGet != nil {
				SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.StartupProbe.ProbeHandler.HTTPGet)
			}
			if a.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC != nil {
				if a.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC.Service == nil {
					var ptrVar1 string = ""
					a.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
				}
			}
		}
		if a.EphemeralContainerCommon.Lifecycle != nil {
			if a.EphemeralContainerCommon.Lifecycle.PostStart != nil {
				if a.EphemeralContainerCommon.Lifecycle.PostStart.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.Lifecycle.PostStart.HTTPGet)
				}
			}
			if a.EphemeralContainerCommon.Lifecycle.PreStop != nil {
				if a.EphemeralContainerCommon.Lifecycle.PreStop.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.Lifecycle.PreStop.HTTPGet)
				}
			}
		}
	}
	SetDefaults_ResourceList(&in.Template.Spec.Overhead)
	if in.Template.Spec.Resources != nil {
		SetDefaults_ResourceList(&in.Template.Spec.Resources.Limits)
		SetDefaults_ResourceList(&in.Template.Spec.Resources.Requests)
	}
}

func SetObjectDefaults_PodTemplateList(in *corev1.PodTemplateList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_PodTemplate(a)
	}
}

func SetObjectDefaults_ReplicationController(in *corev1.ReplicationController) {
	SetDefaults_ReplicationController(in)
	if in.Spec.Replicas == nil {
		var ptrVar1 int32 = 1
		in.Spec.Replicas = &ptrVar1
	}
	if in.Spec.Template != nil {
		SetDefaults_PodSpec(&in.Spec.Template.Spec)
		for i := range in.Spec.Template.Spec.Volumes {
			a := &in.Spec.Template.Spec.Volumes[i]
			SetDefaults_Volume(a)
			if a.VolumeSource.HostPath != nil {
				SetDefaults_HostPathVolumeSource(a.VolumeSource.HostPath)
			}
			if a.VolumeSource.Secret != nil {
				SetDefaults_SecretVolumeSource(a.VolumeSource.Secret)
			}
			if a.VolumeSource.ISCSI != nil {
				if a.VolumeSource.ISCSI.ISCSIInterface == "" {
					a.VolumeSource.ISCSI.ISCSIInterface = "default"
				}
			}
			if a.VolumeSource.RBD != nil {
				if a.VolumeSource.RBD.RBDPool == "" {
					a.VolumeSource.RBD.RBDPool = "rbd"
				}
				if a.VolumeSource.RBD.RadosUser == "" {
					a.VolumeSource.RBD.RadosUser = "admin"
				}
				if a.VolumeSource.RBD.Keyring == "" {
					a.VolumeSource.RBD.Keyring = "/etc/ceph/keyring"
				}
			}
			if a.VolumeSource.DownwardAPI != nil {
				SetDefaults_DownwardAPIVolumeSource(a.VolumeSource.DownwardAPI)
				for j := range a.VolumeSource.DownwardAPI.Items {
					b := &a.VolumeSource.DownwardAPI.Items[j]
					if b.FieldRef != nil {
						SetDefaults_ObjectFieldSelector(b.FieldRef)
					}
				}
			}
			if a.VolumeSource.ConfigMap != nil {
				SetDefaults_ConfigMapVolumeSource(a.VolumeSource.ConfigMap)
			}
			if a.VolumeSource.AzureDisk != nil {
				if a.VolumeSource.AzureDisk.CachingMode == nil {
					ptrVar1 := corev1.AzureDataDiskCachingMode(corev1.AzureDataDiskCachingReadWrite)
					a.VolumeSource.AzureDisk.CachingMode = &ptrVar1
				}
				if a.VolumeSource.AzureDisk.FSType == nil {
					var ptrVar1 string = "ext4"
					a.VolumeSource.AzureDisk.FSType = &ptrVar1
				}
				if a.VolumeSource.AzureDisk.ReadOnly == nil {
					var ptrVar1 bool = false
					a.VolumeSource.AzureDisk.ReadOnly = &ptrVar1
				}
				if a.VolumeSource.AzureDisk.Kind == nil {
					ptrVar1 := corev1.AzureDataDiskKind(corev1.AzureSharedBlobDisk)
					a.VolumeSource.AzureDisk.Kind = &ptrVar1
				}
			}
			if a.VolumeSource.Projected != nil {
				SetDefaults_ProjectedVolumeSource(a.VolumeSource.Projected)
				for j := range a.VolumeSource.Projected.Sources {
					b := &a.VolumeSource.Projected.Sources[j]
					if b.DownwardAPI != nil {
						for k := range b.DownwardAPI.Items {
							c := &b.DownwardAPI.Items[k]
							if c.FieldRef != nil {
								SetDefaults_ObjectFieldSelector(c.FieldRef)
							}
						}
					}
					if b.ServiceAccountToken != nil {
						SetDefaults_ServiceAccountTokenProjection(b.ServiceAccountToken)
					}
				}
			}
			if a.VolumeSource.ScaleIO != nil {
				if a.VolumeSource.ScaleIO.StorageMode == "" {
					a.VolumeSource.ScaleIO.StorageMode = "ThinProvisioned"
				}
				if a.VolumeSource.ScaleIO.FSType == "" {
					a.VolumeSource.ScaleIO.FSType = "xfs"
				}
			}
			if a.VolumeSource.Ephemeral != nil {
				if a.VolumeSource.Ephemeral.VolumeClaimTemplate != nil {
					SetDefaults_PersistentVolumeClaimSpec(&a.VolumeSource.Ephemeral.VolumeClaimTemplate.Spec)
					SetDefaults_ResourceList(&a.VolumeSource.Ephemeral.VolumeClaimTemplate.Spec.Resources.Limits)
					SetDefaults_ResourceList(&a.VolumeSource.Ephemeral.VolumeClaimTemplate.Spec.Resources.Requests)
				}
			}
		}
		for i := range in.Spec.Template.Spec.InitContainers {
			a := &in.Spec.Template.Spec.InitContainers[i]
			SetDefaults_Container(a)
			for j := range a.Ports {
				b := &a.Ports[j]
				if b.Protocol == "" {
					b.Protocol = "TCP"
				}
			}
			for j := range a.Env {
				b := &a.Env[j]
				if b.ValueFrom != nil {
					if b.ValueFrom.FieldRef != nil {
						SetDefaults_ObjectFieldSelector(b.ValueFrom.FieldRef)
					}
				}
			}
			SetDefaults_ResourceList(&a.Resources.Limits)
			SetDefaults_ResourceList(&a.Resources.Requests)
			if a.LivenessProbe != nil {
				SetDefaults_Probe(a.LivenessProbe)
				if a.LivenessProbe.ProbeHandler.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.LivenessProbe.ProbeHandler.HTTPGet)
				}
				if a.LivenessProbe.ProbeHandler.GRPC != nil {
					if a.LivenessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						a.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if a.ReadinessProbe != nil {
				SetDefaults_Probe(a.ReadinessProbe)
				if a.ReadinessProbe.ProbeHandler.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.ReadinessProbe.ProbeHandler.HTTPGet)
				}
				if a.ReadinessProbe.ProbeHandler.GRPC != nil {
					if a.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						a.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if a.StartupProbe != nil {
				SetDefaults_Probe(a.StartupProbe)
				if a.StartupProbe.ProbeHandler.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.StartupProbe.ProbeHandler.HTTPGet)
				}
				if a.StartupProbe.ProbeHandler.GRPC != nil {
					if a.StartupProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						a.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if a.Lifecycle != nil {
				if a.Lifecycle.PostStart != nil {
					if a.Lifecycle.PostStart.HTTPGet != nil {
						SetDefaults_HTTPGetAction(a.Lifecycle.PostStart.HTTPGet)
					}
				}
				if a.Lifecycle.PreStop != nil {
					if a.Lifecycle.PreStop.HTTPGet != nil {
						SetDefaults_HTTPGetAction(a.Lifecycle.PreStop.HTTPGet)
					}
				}
			}
		}
		for i := range in.Spec.Template.Spec.Containers {
			a := &in.Spec.Template.Spec.Containers[i]
			SetDefaults_Container(a)
			for j := range a.Ports {
				b := &a.Ports[j]
				if b.Protocol == "" {
					b.Protocol = "TCP"
				}
			}
			for j := range a.Env {
				b := &a.Env[j]
				if b.ValueFrom != nil {
					if b.ValueFrom.FieldRef != nil {
						SetDefaults_ObjectFieldSelector(b.ValueFrom.FieldRef)
					}
				}
			}
			SetDefaults_ResourceList(&a.Resources.Limits)
			SetDefaults_ResourceList(&a.Resources.Requests)
			if a.LivenessProbe != nil {
				SetDefaults_Probe(a.LivenessProbe)
				if a.LivenessProbe.ProbeHandler.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.LivenessProbe.ProbeHandler.HTTPGet)
				}
				if a.LivenessProbe.ProbeHandler.GRPC != nil {
					if a.LivenessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						a.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if a.ReadinessProbe != nil {
				SetDefaults_Probe(a.ReadinessProbe)
				if a.ReadinessProbe.ProbeHandler.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.ReadinessProbe.ProbeHandler.HTTPGet)
				}
				if a.ReadinessProbe.ProbeHandler.GRPC != nil {
					if a.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						a.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if a.StartupProbe != nil {
				SetDefaults_Probe(a.StartupProbe)
				if a.StartupProbe.ProbeHandler.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.StartupProbe.ProbeHandler.HTTPGet)
				}
				if a.StartupProbe.ProbeHandler.GRPC != nil {
					if a.StartupProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						a.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if a.Lifecycle != nil {
				if a.Lifecycle.PostStart != nil {
					if a.Lifecycle.PostStart.HTTPGet != nil {
						SetDefaults_HTTPGetAction(a.Lifecycle.PostStart.HTTPGet)
					}
				}
				if a.Lifecycle.PreStop != nil {
					if a.Lifecycle.PreStop.HTTPGet != nil {
						SetDefaults_HTTPGetAction(a.Lifecycle.PreStop.HTTPGet)
					}
				}
			}
		}
		for i := range in.Spec.Template.Spec.EphemeralContainers {
			a := &in.Spec.Template.Spec.EphemeralContainers[i]
			SetDefaults_EphemeralContainer(a)
			for j := range a.EphemeralContainerCommon.Ports {
				b := &a.EphemeralContainerCommon.Ports[j]
				if b.Protocol == "" {
					b.Protocol = "TCP"
				}
			}
			for j := range a.EphemeralContainerCommon.Env {
				b := &a.EphemeralContainerCommon.Env[j]
				if b.ValueFrom != nil {
					if b.ValueFrom.FieldRef != nil {
						SetDefaults_ObjectFieldSelector(b.ValueFrom.FieldRef)
					}
				}
			}
			SetDefaults_ResourceList(&a.EphemeralContainerCommon.Resources.Limits)
			SetDefaults_ResourceList(&a.EphemeralContainerCommon.Resources.Requests)
			if a.EphemeralContainerCommon.LivenessProbe != nil {
				SetDefaults_Probe(a.EphemeralContainerCommon.LivenessProbe)
				if a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.HTTPGet)
				}
				if a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC != nil {
					if a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						a.EphemeralContainerCommon.LivenessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if a.EphemeralContainerCommon.ReadinessProbe != nil {
				SetDefaults_Probe(a.EphemeralContainerCommon.ReadinessProbe)
				if a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.HTTPGet)
				}
				if a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC != nil {
					if a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						a.EphemeralContainerCommon.ReadinessProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if a.EphemeralContainerCommon.StartupProbe != nil {
				SetDefaults_Probe(a.EphemeralContainerCommon.StartupProbe)
				if a.EphemeralContainerCommon.StartupProbe.ProbeHandler.HTTPGet != nil {
					SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.StartupProbe.ProbeHandler.HTTPGet)
				}
				if a.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC != nil {
					if a.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC.Service == nil {
						var ptrVar1 string = ""
						a.EphemeralContainerCommon.StartupProbe.ProbeHandler.GRPC.Service = &ptrVar1
					}
				}
			}
			if a.EphemeralContainerCommon.Lifecycle != nil {
				if a.EphemeralContainerCommon.Lifecycle.PostStart != nil {
					if a.EphemeralContainerCommon.Lifecycle.PostStart.HTTPGet != nil {
						SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.Lifecycle.PostStart.HTTPGet)
					}
				}
				if a.EphemeralContainerCommon.Lifecycle.PreStop != nil {
					if a.EphemeralContainerCommon.Lifecycle.PreStop.HTTPGet != nil {
						SetDefaults_HTTPGetAction(a.EphemeralContainerCommon.Lifecycle.PreStop.HTTPGet)
					}
				}
			}
		}
		SetDefaults_ResourceList(&in.Spec.Template.Spec.Overhead)
		if in.Spec.Template.Spec.Resources != nil {
			SetDefaults_ResourceList(&in.Spec.Template.Spec.Resources.Limits)
			SetDefaults_ResourceList(&in.Spec.Template.Spec.Resources.Requests)
		}
	}
}

func SetObjectDefaults_ReplicationControllerList(in *corev1.ReplicationControllerList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_ReplicationController(a)
	}
}

func SetObjectDefaults_ResourceQuota(in *corev1.ResourceQuota) {
	SetDefaults_ResourceList(&in.Spec.Hard)
	SetDefaults_ResourceList(&in.Status.Hard)
	SetDefaults_ResourceList(&in.Status.Used)
}

func SetObjectDefaults_ResourceQuotaList(in *corev1.ResourceQuotaList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_ResourceQuota(a)
	}
}

func SetObjectDefaults_Secret(in *corev1.Secret) {
	SetDefaults_Secret(in)
}

func SetObjectDefaults_SecretList(in *corev1.SecretList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_Secret(a)
	}
}

func SetObjectDefaults_Service(in *corev1.Service) {
	SetDefaults_Service(in)
	for i := range in.Spec.Ports {
		a := &in.Spec.Ports[i]
		if a.Protocol == "" {
			a.Protocol = "TCP"
		}
	}
}

func SetObjectDefaults_ServiceList(in *corev1.ServiceList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_Service(a)
	}
}
