# Releasing Rails

In this document, we'll cover the steps necessary to release Rails. Each
section contains steps to take during that time before the release. The times
suggested in each header are just that: suggestions. However, they should
really be considered as minimums.

## 10 Days before release

Today is mostly coordination tasks. Here are the things you must do today:

### Is the CI green? If not, make it green. (See "Fixing the CI")

Do not release with a Red CI. You can find the CI status here:

```
https://buildkite.com/rails/rails
```

### Do we have any Git dependencies? If so, contact those authors.

Having Git dependencies indicates that we depend on unreleased code.
Obviously Rails cannot be released when it depends on unreleased code.
Contact the authors of those particular gems and work out a release date that
suits them.

### Announce your plans to the rest of the team on Basecamp

Let them know of your plans to release.

### Update each CHANGELOG.

Many times commits are made without the CHANGELOG being updated. You should
review the commits since the last release, and fill in any missing information
for each CHANGELOG.

You can review the commits for the 3.0.10 release like this:

```
[aaron@higgins rails (3-0-10)]$ git log v3.0.9..
```

If you're doing a stable branch release, you should also ensure that all of
the CHANGELOG entries in the stable branch are also synced to the main
branch.

## Day of release

If making multiple releases. Publish them in order from oldest to newest, to
ensure that the "greatest" version also shows up in npm and GitHub Releases as
"latest".

### Put the new version in the RAILS_VERSION file.

Include an RC number if appropriate, e.g. `6.0.0.rc1`.

### Build and test the gem.

Run `rake install` to generate the gems and install them locally. You can now
use the version installed locally to generate a new app and check if everything
is working as expected.

This will stop you from looking silly when you push an RC to rubygems.org and
then realize it is broken.

### Check credentials for GitHub

For GitHub run `gh auth status` to check that you are logged in (run `gh login` if not).

The release task will sign the release tag. If you haven't got commit signing
set up, use https://git-scm.com/book/en/v2/Git-Tools-Signing-Your-Work as a
guide. You can generate keys with the GPG suite from here: https://gpgtools.org.

Run `rake prep_release` to prepare the release. This will populate the gemspecs and
npm package.json with the current RAILS_VERSION, add the header to the CHANGELOGs,
build the gems, and check if bundler can resolve the dependencies.

You can now inspect the results in the diff and see if you are happy with the
changes.

To release, Run `rake release`. This will commit the changes, tag it, and create a GitHub
release with the proper release notes in draft mode.

Open the corresponding GitHub release draft and check that the release notes
are correct. If everything is fine, publish the release.

### Publish the gems

To publish the gems approve the [Release workflow in GitHub Actions](https://github.com/rails/rails/actions/workflows/release.yml),
that was created after the release was published.

### Send Rails release announcements

Write a release announcement that includes the version, changes, and links to
GitHub where people can find the specific commit list. Here are the mailing
lists where you should announce:

* [rubyonrails-core](https://discuss.rubyonrails.org/c/rubyonrails-core)
* [rubyonrails-talk](https://discuss.rubyonrails.org/c/rubyonrails-talk)

Use Markdown format for your announcement. Remember to ask people to report
issues with the release candidate to the rubyonrails-core forum.

NOTE: For patch releases, there's a `rake announce` task to generate the release
post. It supports multiple patch releases too:

```
VERSIONS="5.0.5.rc1,5.1.3.rc1" rake announce
```

IMPORTANT: If any users experience regressions when using the release
candidate, you *must* postpone the release. Bugfix releases *should not*
break existing applications.

### Post the announcement to the Rails blog.

The blog at https://rubyonrails.org/blog is built from
https://github.com/rails/website.

Create a file named like
`_posts/$(date +'%F')-Rails-<versions>-have-been-released.markdown`

Add YAML frontmatter
```
---
layout: post
title: 'Rails <VERSIONS> have been released!'
categories: releases
author: <your handle>
published: true
date: <YYYY-MM-DD or `date +%F`>
---
```

Use the markdown generated by `rake announce` earlier as a base for the post.
Add some context for users as to the purpose of this release (bugfix/security).

If this is a part of the latest release series, update `_data/version.yml` so
that the homepage points to the latest version.

### Post the announcement to the Rails X account.

## Security releases

### Emailing the Rails security announce list

Email the security announce list once for each vulnerability fixed.

You can do this, or ask the security team to do it.

Email the security reports to:

* rubyonrails-security@googlegroups.com
* oss-security@lists.openwall.com

Be sure to note the security fixes in your announcement along with CVE numbers
and links to each patch. Some people may not be able to upgrade right away,
so we need to give them the security fixes in patch form.

* Blog announcements
* X announcements
* Merge the release branch to the stable branch
* Drink beer (or other cocktail)

## Misc

### Fixing the CI

There are two simple steps for fixing the CI:

1. Identify the problem
2. Fix it

Repeat these steps until the CI is green.
