// Code generated by go-swagger; DO NOT EDIT.

package webhook_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWebhookServiceListWebhooksParams creates a new WebhookServiceListWebhooksParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWebhookServiceListWebhooksParams() *WebhookServiceListWebhooksParams {
	return &WebhookServiceListWebhooksParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWebhookServiceListWebhooksParamsWithTimeout creates a new WebhookServiceListWebhooksParams object
// with the ability to set a timeout on a request.
func NewWebhookServiceListWebhooksParamsWithTimeout(timeout time.Duration) *WebhookServiceListWebhooksParams {
	return &WebhookServiceListWebhooksParams{
		timeout: timeout,
	}
}

// NewWebhookServiceListWebhooksParamsWithContext creates a new WebhookServiceListWebhooksParams object
// with the ability to set a context for a request.
func NewWebhookServiceListWebhooksParamsWithContext(ctx context.Context) *WebhookServiceListWebhooksParams {
	return &WebhookServiceListWebhooksParams{
		Context: ctx,
	}
}

// NewWebhookServiceListWebhooksParamsWithHTTPClient creates a new WebhookServiceListWebhooksParams object
// with the ability to set a custom HTTPClient for a request.
func NewWebhookServiceListWebhooksParamsWithHTTPClient(client *http.Client) *WebhookServiceListWebhooksParams {
	return &WebhookServiceListWebhooksParams{
		HTTPClient: client,
	}
}

/*
WebhookServiceListWebhooksParams contains all the parameters to send to the API endpoint

	for the webhook service list webhooks operation.

	Typically these are written to a http.Request.
*/
type WebhookServiceListWebhooksParams struct {

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* ParentResourceName.

	   The parent resource of a webhook is an HCP project. A project's resource name format is `project/<project-id>`.
	*/
	ParentResourceName string

	/* SortingOrderBy.

	     Specifies the list of per field ordering that should be used for sorting.
	The order matters as rows are sorted in order by fields and when the field
	matches, the next field is used to tie break the ordering.
	The per field default ordering is ascending.

	The fields should be immutabile, unique, and orderable. If the field is
	not unique, more than one sort fields should be passed.

	Example: oder_by=name,age desc,created_at asc
	In that case, 'name' will get the default 'ascending' order.
	*/
	SortingOrderBy []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the webhook service list webhooks params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebhookServiceListWebhooksParams) WithDefaults() *WebhookServiceListWebhooksParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the webhook service list webhooks params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebhookServiceListWebhooksParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) WithTimeout(timeout time.Duration) *WebhookServiceListWebhooksParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) WithContext(ctx context.Context) *WebhookServiceListWebhooksParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) WithHTTPClient(client *http.Client) *WebhookServiceListWebhooksParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) WithPaginationNextPageToken(paginationNextPageToken *string) *WebhookServiceListWebhooksParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) WithPaginationPageSize(paginationPageSize *int64) *WebhookServiceListWebhooksParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *WebhookServiceListWebhooksParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithParentResourceName adds the parentResourceName to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) WithParentResourceName(parentResourceName string) *WebhookServiceListWebhooksParams {
	o.SetParentResourceName(parentResourceName)
	return o
}

// SetParentResourceName adds the parentResourceName to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) SetParentResourceName(parentResourceName string) {
	o.ParentResourceName = parentResourceName
}

// WithSortingOrderBy adds the sortingOrderBy to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) WithSortingOrderBy(sortingOrderBy []string) *WebhookServiceListWebhooksParams {
	o.SetSortingOrderBy(sortingOrderBy)
	return o
}

// SetSortingOrderBy adds the sortingOrderBy to the webhook service list webhooks params
func (o *WebhookServiceListWebhooksParams) SetSortingOrderBy(sortingOrderBy []string) {
	o.SortingOrderBy = sortingOrderBy
}

// WriteToRequest writes these params to a swagger request
func (o *WebhookServiceListWebhooksParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	// path param parent_resource_name
	if err := r.SetPathParam("parent_resource_name", o.ParentResourceName); err != nil {
		return err
	}

	if o.SortingOrderBy != nil {

		// binding items for sorting.order_by
		joinedSortingOrderBy := o.bindParamSortingOrderBy(reg)

		// query array param sorting.order_by
		if err := r.SetQueryParam("sorting.order_by", joinedSortingOrderBy...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWebhookServiceListWebhooks binds the parameter sorting.order_by
func (o *WebhookServiceListWebhooksParams) bindParamSortingOrderBy(formats strfmt.Registry) []string {
	sortingOrderByIR := o.SortingOrderBy

	var sortingOrderByIC []string
	for _, sortingOrderByIIR := range sortingOrderByIR { // explode []string

		sortingOrderByIIV := sortingOrderByIIR // string as string
		sortingOrderByIC = append(sortingOrderByIC, sortingOrderByIIV)
	}

	// items.CollectionFormat: "multi"
	sortingOrderByIS := swag.JoinByFormat(sortingOrderByIC, "multi")

	return sortingOrderByIS
}
