// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudWaypointListAddOnsResponse ListAddOnsResponse is the response containing all existing Add-ons
//
// swagger:model hashicorp.cloud.waypoint.ListAddOnsResponse
type HashicorpCloudWaypointListAddOnsResponse struct {

	// add ons
	AddOns []*HashicorpCloudWaypointAddOn `json:"add_ons"`

	// pagination
	Pagination *cloud.HashicorpCloudCommonPaginationResponse `json:"pagination,omitempty"`

	// Will return -1 if request has a with_total_count = false or is with_total_count parameter is omitted.
	TotalCount string `json:"total_count,omitempty"`
}

// Validate validates this hashicorp cloud waypoint list add ons response
func (m *HashicorpCloudWaypointListAddOnsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddOns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePagination(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointListAddOnsResponse) validateAddOns(formats strfmt.Registry) error {
	if swag.IsZero(m.AddOns) { // not required
		return nil
	}

	for i := 0; i < len(m.AddOns); i++ {
		if swag.IsZero(m.AddOns[i]) { // not required
			continue
		}

		if m.AddOns[i] != nil {
			if err := m.AddOns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("add_ons" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("add_ons" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointListAddOnsResponse) validatePagination(formats strfmt.Registry) error {
	if swag.IsZero(m.Pagination) { // not required
		return nil
	}

	if m.Pagination != nil {
		if err := m.Pagination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pagination")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint list add ons response based on the context it is used
func (m *HashicorpCloudWaypointListAddOnsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddOns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePagination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointListAddOnsResponse) contextValidateAddOns(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AddOns); i++ {

		if m.AddOns[i] != nil {

			if swag.IsZero(m.AddOns[i]) { // not required
				return nil
			}

			if err := m.AddOns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("add_ons" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("add_ons" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointListAddOnsResponse) contextValidatePagination(ctx context.Context, formats strfmt.Registry) error {

	if m.Pagination != nil {

		if swag.IsZero(m.Pagination) { // not required
			return nil
		}

		if err := m.Pagination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pagination")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointListAddOnsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointListAddOnsResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointListAddOnsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
