// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceListAddOnsReader is a Reader for the WaypointServiceListAddOns structure.
type WaypointServiceListAddOnsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListAddOnsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListAddOnsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListAddOnsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListAddOnsOK creates a WaypointServiceListAddOnsOK with default headers values
func NewWaypointServiceListAddOnsOK() *WaypointServiceListAddOnsOK {
	return &WaypointServiceListAddOnsOK{}
}

/*
WaypointServiceListAddOnsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListAddOnsOK struct {
	Payload *models.HashicorpCloudWaypointListAddOnsResponse
}

// IsSuccess returns true when this waypoint service list add ons o k response has a 2xx status code
func (o *WaypointServiceListAddOnsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list add ons o k response has a 3xx status code
func (o *WaypointServiceListAddOnsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list add ons o k response has a 4xx status code
func (o *WaypointServiceListAddOnsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list add ons o k response has a 5xx status code
func (o *WaypointServiceListAddOnsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list add ons o k response a status code equal to that given
func (o *WaypointServiceListAddOnsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list add ons o k response
func (o *WaypointServiceListAddOnsOK) Code() int {
	return 200
}

func (o *WaypointServiceListAddOnsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-ons][%d] waypointServiceListAddOnsOK %s", 200, payload)
}

func (o *WaypointServiceListAddOnsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-ons][%d] waypointServiceListAddOnsOK %s", 200, payload)
}

func (o *WaypointServiceListAddOnsOK) GetPayload() *models.HashicorpCloudWaypointListAddOnsResponse {
	return o.Payload
}

func (o *WaypointServiceListAddOnsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListAddOnsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListAddOnsDefault creates a WaypointServiceListAddOnsDefault with default headers values
func NewWaypointServiceListAddOnsDefault(code int) *WaypointServiceListAddOnsDefault {
	return &WaypointServiceListAddOnsDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceListAddOnsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListAddOnsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list add ons default response has a 2xx status code
func (o *WaypointServiceListAddOnsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list add ons default response has a 3xx status code
func (o *WaypointServiceListAddOnsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list add ons default response has a 4xx status code
func (o *WaypointServiceListAddOnsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list add ons default response has a 5xx status code
func (o *WaypointServiceListAddOnsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list add ons default response a status code equal to that given
func (o *WaypointServiceListAddOnsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list add ons default response
func (o *WaypointServiceListAddOnsDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListAddOnsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-ons][%d] WaypointService_ListAddOns default %s", o._statusCode, payload)
}

func (o *WaypointServiceListAddOnsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-ons][%d] WaypointService_ListAddOns default %s", o._statusCode, payload)
}

func (o *WaypointServiceListAddOnsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListAddOnsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
