// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Secrets20231128AwsDynamicSecret AWS
//
// swagger:model secrets_20231128AwsDynamicSecret
type Secrets20231128AwsDynamicSecret struct {

	// assume role
	AssumeRole *Secrets20231128AssumeRoleResponse `json:"assume_role,omitempty"`

	// created at
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// created by id
	CreatedByID string `json:"created_by_id,omitempty"`

	// default ttl
	DefaultTTL string `json:"default_ttl,omitempty"`

	// integration name
	IntegrationName string `json:"integration_name,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// updated at
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`

	// updated by id
	UpdatedByID string `json:"updated_by_id,omitempty"`
}

// Validate validates this secrets 20231128 aws dynamic secret
func (m *Secrets20231128AwsDynamicSecret) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAssumeRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Secrets20231128AwsDynamicSecret) validateAssumeRole(formats strfmt.Registry) error {
	if swag.IsZero(m.AssumeRole) { // not required
		return nil
	}

	if m.AssumeRole != nil {
		if err := m.AssumeRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("assume_role")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("assume_role")
			}
			return err
		}
	}

	return nil
}

func (m *Secrets20231128AwsDynamicSecret) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Secrets20231128AwsDynamicSecret) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this secrets 20231128 aws dynamic secret based on the context it is used
func (m *Secrets20231128AwsDynamicSecret) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAssumeRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Secrets20231128AwsDynamicSecret) contextValidateAssumeRole(ctx context.Context, formats strfmt.Registry) error {

	if m.AssumeRole != nil {

		if swag.IsZero(m.AssumeRole) { // not required
			return nil
		}

		if err := m.AssumeRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("assume_role")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("assume_role")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Secrets20231128AwsDynamicSecret) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Secrets20231128AwsDynamicSecret) UnmarshalBinary(b []byte) error {
	var res Secrets20231128AwsDynamicSecret
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
