// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewUnlockOrganizationParams creates a new UnlockOrganizationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnlockOrganizationParams() *UnlockOrganizationParams {
	return &UnlockOrganizationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnlockOrganizationParamsWithTimeout creates a new UnlockOrganizationParams object
// with the ability to set a timeout on a request.
func NewUnlockOrganizationParamsWithTimeout(timeout time.Duration) *UnlockOrganizationParams {
	return &UnlockOrganizationParams{
		timeout: timeout,
	}
}

// NewUnlockOrganizationParamsWithContext creates a new UnlockOrganizationParams object
// with the ability to set a context for a request.
func NewUnlockOrganizationParamsWithContext(ctx context.Context) *UnlockOrganizationParams {
	return &UnlockOrganizationParams{
		Context: ctx,
	}
}

// NewUnlockOrganizationParamsWithHTTPClient creates a new UnlockOrganizationParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnlockOrganizationParamsWithHTTPClient(client *http.Client) *UnlockOrganizationParams {
	return &UnlockOrganizationParams{
		HTTPClient: client,
	}
}

/*
UnlockOrganizationParams contains all the parameters to send to the API endpoint

	for the unlock organization operation.

	Typically these are written to a http.Request.
*/
type UnlockOrganizationParams struct {

	// Body.
	Body models.SecretServiceUnlockOrganizationBody

	// OrganizationID.
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unlock organization params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnlockOrganizationParams) WithDefaults() *UnlockOrganizationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unlock organization params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnlockOrganizationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the unlock organization params
func (o *UnlockOrganizationParams) WithTimeout(timeout time.Duration) *UnlockOrganizationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unlock organization params
func (o *UnlockOrganizationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unlock organization params
func (o *UnlockOrganizationParams) WithContext(ctx context.Context) *UnlockOrganizationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unlock organization params
func (o *UnlockOrganizationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unlock organization params
func (o *UnlockOrganizationParams) WithHTTPClient(client *http.Client) *UnlockOrganizationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unlock organization params
func (o *UnlockOrganizationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the unlock organization params
func (o *UnlockOrganizationParams) WithBody(body models.SecretServiceUnlockOrganizationBody) *UnlockOrganizationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the unlock organization params
func (o *UnlockOrganizationParams) SetBody(body models.SecretServiceUnlockOrganizationBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the unlock organization params
func (o *UnlockOrganizationParams) WithOrganizationID(organizationID string) *UnlockOrganizationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the unlock organization params
func (o *UnlockOrganizationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *UnlockOrganizationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
