// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// ListConfluentIntegrationsReader is a Reader for the ListConfluentIntegrations structure.
type ListConfluentIntegrationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListConfluentIntegrationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListConfluentIntegrationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListConfluentIntegrationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListConfluentIntegrationsOK creates a ListConfluentIntegrationsOK with default headers values
func NewListConfluentIntegrationsOK() *ListConfluentIntegrationsOK {
	return &ListConfluentIntegrationsOK{}
}

/*
ListConfluentIntegrationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListConfluentIntegrationsOK struct {
	Payload *models.Secrets20231128ListConfluentIntegrationsResponse
}

// IsSuccess returns true when this list confluent integrations o k response has a 2xx status code
func (o *ListConfluentIntegrationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list confluent integrations o k response has a 3xx status code
func (o *ListConfluentIntegrationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list confluent integrations o k response has a 4xx status code
func (o *ListConfluentIntegrationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list confluent integrations o k response has a 5xx status code
func (o *ListConfluentIntegrationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list confluent integrations o k response a status code equal to that given
func (o *ListConfluentIntegrationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list confluent integrations o k response
func (o *ListConfluentIntegrationsOK) Code() int {
	return 200
}

func (o *ListConfluentIntegrationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config][%d] listConfluentIntegrationsOK %s", 200, payload)
}

func (o *ListConfluentIntegrationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config][%d] listConfluentIntegrationsOK %s", 200, payload)
}

func (o *ListConfluentIntegrationsOK) GetPayload() *models.Secrets20231128ListConfluentIntegrationsResponse {
	return o.Payload
}

func (o *ListConfluentIntegrationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128ListConfluentIntegrationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListConfluentIntegrationsDefault creates a ListConfluentIntegrationsDefault with default headers values
func NewListConfluentIntegrationsDefault(code int) *ListConfluentIntegrationsDefault {
	return &ListConfluentIntegrationsDefault{
		_statusCode: code,
	}
}

/*
ListConfluentIntegrationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListConfluentIntegrationsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this list confluent integrations default response has a 2xx status code
func (o *ListConfluentIntegrationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list confluent integrations default response has a 3xx status code
func (o *ListConfluentIntegrationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list confluent integrations default response has a 4xx status code
func (o *ListConfluentIntegrationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list confluent integrations default response has a 5xx status code
func (o *ListConfluentIntegrationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list confluent integrations default response a status code equal to that given
func (o *ListConfluentIntegrationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list confluent integrations default response
func (o *ListConfluentIntegrationsDefault) Code() int {
	return o._statusCode
}

func (o *ListConfluentIntegrationsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config][%d] ListConfluentIntegrations default %s", o._statusCode, payload)
}

func (o *ListConfluentIntegrationsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config][%d] ListConfluentIntegrations default %s", o._statusCode, payload)
}

func (o *ListConfluentIntegrationsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ListConfluentIntegrationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
