// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// DeleteAwsIntegrationReader is a Reader for the DeleteAwsIntegration structure.
type DeleteAwsIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteAwsIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteAwsIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteAwsIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteAwsIntegrationOK creates a DeleteAwsIntegrationOK with default headers values
func NewDeleteAwsIntegrationOK() *DeleteAwsIntegrationOK {
	return &DeleteAwsIntegrationOK{}
}

/*
DeleteAwsIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteAwsIntegrationOK struct {
	Payload models.Secrets20231128DeleteAwsIntegrationResponse
}

// IsSuccess returns true when this delete aws integration o k response has a 2xx status code
func (o *DeleteAwsIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete aws integration o k response has a 3xx status code
func (o *DeleteAwsIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete aws integration o k response has a 4xx status code
func (o *DeleteAwsIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete aws integration o k response has a 5xx status code
func (o *DeleteAwsIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete aws integration o k response a status code equal to that given
func (o *DeleteAwsIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete aws integration o k response
func (o *DeleteAwsIntegrationOK) Code() int {
	return 200
}

func (o *DeleteAwsIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}][%d] deleteAwsIntegrationOK %s", 200, payload)
}

func (o *DeleteAwsIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}][%d] deleteAwsIntegrationOK %s", 200, payload)
}

func (o *DeleteAwsIntegrationOK) GetPayload() models.Secrets20231128DeleteAwsIntegrationResponse {
	return o.Payload
}

func (o *DeleteAwsIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAwsIntegrationDefault creates a DeleteAwsIntegrationDefault with default headers values
func NewDeleteAwsIntegrationDefault(code int) *DeleteAwsIntegrationDefault {
	return &DeleteAwsIntegrationDefault{
		_statusCode: code,
	}
}

/*
DeleteAwsIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteAwsIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this delete aws integration default response has a 2xx status code
func (o *DeleteAwsIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete aws integration default response has a 3xx status code
func (o *DeleteAwsIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete aws integration default response has a 4xx status code
func (o *DeleteAwsIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete aws integration default response has a 5xx status code
func (o *DeleteAwsIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete aws integration default response a status code equal to that given
func (o *DeleteAwsIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete aws integration default response
func (o *DeleteAwsIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *DeleteAwsIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}][%d] DeleteAwsIntegration default %s", o._statusCode, payload)
}

func (o *DeleteAwsIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}][%d] DeleteAwsIntegration default %s", o._statusCode, payload)
}

func (o *DeleteAwsIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *DeleteAwsIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
