// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// SearchReader is a Reader for the Search structure.
type SearchReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SearchReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSearchOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSearchDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSearchOK creates a SearchOK with default headers values
func NewSearchOK() *SearchOK {
	return &SearchOK{}
}

/*
SearchOK describes a response with status code 200, with default header values.

A successful response.
*/
type SearchOK struct {
	Payload *models.HashicorpCloudVagrant20220930SearchIndexResponse
}

// IsSuccess returns true when this search o k response has a 2xx status code
func (o *SearchOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this search o k response has a 3xx status code
func (o *SearchOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search o k response has a 4xx status code
func (o *SearchOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this search o k response has a 5xx status code
func (o *SearchOK) IsServerError() bool {
	return false
}

// IsCode returns true when this search o k response a status code equal to that given
func (o *SearchOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the search o k response
func (o *SearchOK) Code() int {
	return 200
}

func (o *SearchOK) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/search][%d] searchOK  %+v", 200, o.Payload)
}

func (o *SearchOK) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/search][%d] searchOK  %+v", 200, o.Payload)
}

func (o *SearchOK) GetPayload() *models.HashicorpCloudVagrant20220930SearchIndexResponse {
	return o.Payload
}

func (o *SearchOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930SearchIndexResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchDefault creates a SearchDefault with default headers values
func NewSearchDefault(code int) *SearchDefault {
	return &SearchDefault{
		_statusCode: code,
	}
}

/*
SearchDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type SearchDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this search default response has a 2xx status code
func (o *SearchDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this search default response has a 3xx status code
func (o *SearchDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this search default response has a 4xx status code
func (o *SearchDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this search default response has a 5xx status code
func (o *SearchDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this search default response a status code equal to that given
func (o *SearchDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the search default response
func (o *SearchDefault) Code() int {
	return o._statusCode
}

func (o *SearchDefault) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/search][%d] Search default  %+v", o._statusCode, o.Payload)
}

func (o *SearchDefault) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/search][%d] Search default  %+v", o._statusCode, o.Payload)
}

func (o *SearchDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *SearchDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
