// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// ListBoxesReader is a Reader for the ListBoxes structure.
type ListBoxesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListBoxesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListBoxesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListBoxesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListBoxesOK creates a ListBoxesOK with default headers values
func NewListBoxesOK() *ListBoxesOK {
	return &ListBoxesOK{}
}

/*
ListBoxesOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListBoxesOK struct {
	Payload *models.HashicorpCloudVagrant20220930ListBoxesResponse
}

// IsSuccess returns true when this list boxes o k response has a 2xx status code
func (o *ListBoxesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list boxes o k response has a 3xx status code
func (o *ListBoxesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list boxes o k response has a 4xx status code
func (o *ListBoxesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list boxes o k response has a 5xx status code
func (o *ListBoxesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list boxes o k response a status code equal to that given
func (o *ListBoxesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list boxes o k response
func (o *ListBoxesOK) Code() int {
	return 200
}

func (o *ListBoxesOK) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/boxes][%d] listBoxesOK  %+v", 200, o.Payload)
}

func (o *ListBoxesOK) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/boxes][%d] listBoxesOK  %+v", 200, o.Payload)
}

func (o *ListBoxesOK) GetPayload() *models.HashicorpCloudVagrant20220930ListBoxesResponse {
	return o.Payload
}

func (o *ListBoxesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930ListBoxesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListBoxesDefault creates a ListBoxesDefault with default headers values
func NewListBoxesDefault(code int) *ListBoxesDefault {
	return &ListBoxesDefault{
		_statusCode: code,
	}
}

/*
ListBoxesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListBoxesDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this list boxes default response has a 2xx status code
func (o *ListBoxesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list boxes default response has a 3xx status code
func (o *ListBoxesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list boxes default response has a 4xx status code
func (o *ListBoxesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list boxes default response has a 5xx status code
func (o *ListBoxesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list boxes default response a status code equal to that given
func (o *ListBoxesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list boxes default response
func (o *ListBoxesDefault) Code() int {
	return o._statusCode
}

func (o *ListBoxesDefault) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/boxes][%d] ListBoxes default  %+v", o._statusCode, o.Payload)
}

func (o *ListBoxesDefault) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/boxes][%d] ListBoxes default  %+v", o._statusCode, o.Payload)
}

func (o *ListBoxesDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ListBoxesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
