// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// NewCreateProviderParams creates a new CreateProviderParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateProviderParams() *CreateProviderParams {
	return &CreateProviderParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateProviderParamsWithTimeout creates a new CreateProviderParams object
// with the ability to set a timeout on a request.
func NewCreateProviderParamsWithTimeout(timeout time.Duration) *CreateProviderParams {
	return &CreateProviderParams{
		timeout: timeout,
	}
}

// NewCreateProviderParamsWithContext creates a new CreateProviderParams object
// with the ability to set a context for a request.
func NewCreateProviderParamsWithContext(ctx context.Context) *CreateProviderParams {
	return &CreateProviderParams{
		Context: ctx,
	}
}

// NewCreateProviderParamsWithHTTPClient creates a new CreateProviderParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateProviderParamsWithHTTPClient(client *http.Client) *CreateProviderParams {
	return &CreateProviderParams{
		HTTPClient: client,
	}
}

/*
CreateProviderParams contains all the parameters to send to the API endpoint

	for the create provider operation.

	Typically these are written to a http.Request.
*/
type CreateProviderParams struct {

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Data.

	   Details of the Provider to create.
	*/
	Data *models.HashicorpCloudVagrant20220930Provider

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version to create the Provider in.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create provider params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateProviderParams) WithDefaults() *CreateProviderParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create provider params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateProviderParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create provider params
func (o *CreateProviderParams) WithTimeout(timeout time.Duration) *CreateProviderParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create provider params
func (o *CreateProviderParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create provider params
func (o *CreateProviderParams) WithContext(ctx context.Context) *CreateProviderParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create provider params
func (o *CreateProviderParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create provider params
func (o *CreateProviderParams) WithHTTPClient(client *http.Client) *CreateProviderParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create provider params
func (o *CreateProviderParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the create provider params
func (o *CreateProviderParams) WithBox(box string) *CreateProviderParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the create provider params
func (o *CreateProviderParams) SetBox(box string) {
	o.Box = box
}

// WithData adds the data to the create provider params
func (o *CreateProviderParams) WithData(data *models.HashicorpCloudVagrant20220930Provider) *CreateProviderParams {
	o.SetData(data)
	return o
}

// SetData adds the data to the create provider params
func (o *CreateProviderParams) SetData(data *models.HashicorpCloudVagrant20220930Provider) {
	o.Data = data
}

// WithRegistry adds the registry to the create provider params
func (o *CreateProviderParams) WithRegistry(registry string) *CreateProviderParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the create provider params
func (o *CreateProviderParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the create provider params
func (o *CreateProviderParams) WithVersion(version string) *CreateProviderParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the create provider params
func (o *CreateProviderParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *CreateProviderParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}
	if o.Data != nil {
		if err := r.SetBodyParam(o.Data); err != nil {
			return err
		}
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
