// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new groups service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new groups service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new groups service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for groups service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GroupsServiceCountGroupsForPrincipals(params *GroupsServiceCountGroupsForPrincipalsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceCountGroupsForPrincipalsOK, error)

	GroupsServiceCountMembersForGroups(params *GroupsServiceCountMembersForGroupsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceCountMembersForGroupsOK, error)

	GroupsServiceCountOrganizationGroups(params *GroupsServiceCountOrganizationGroupsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceCountOrganizationGroupsOK, error)

	GroupsServiceCreateGroup(params *GroupsServiceCreateGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceCreateGroupOK, error)

	GroupsServiceDeleteGroup(params *GroupsServiceDeleteGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceDeleteGroupOK, error)

	GroupsServiceGetGroup(params *GroupsServiceGetGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceGetGroupOK, error)

	GroupsServiceListGroupMembers(params *GroupsServiceListGroupMembersParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceListGroupMembersOK, error)

	GroupsServiceListGroups(params *GroupsServiceListGroupsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceListGroupsOK, error)

	GroupsServiceUpdateGroup(params *GroupsServiceUpdateGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceUpdateGroupOK, error)

	GroupsServiceUpdateGroup2(params *GroupsServiceUpdateGroup2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceUpdateGroup2OK, error)

	GroupsServiceUpdateGroupMembers(params *GroupsServiceUpdateGroupMembersParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceUpdateGroupMembersOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GroupsServiceCountGroupsForPrincipals counts groups for principals will count the number of groups a principal is in for a list of principals
*/
func (a *Client) GroupsServiceCountGroupsForPrincipals(params *GroupsServiceCountGroupsForPrincipalsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceCountGroupsForPrincipalsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceCountGroupsForPrincipalsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_CountGroupsForPrincipals",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/iam/{parent_resource_name}/groups/count-for-principals",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceCountGroupsForPrincipalsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceCountGroupsForPrincipalsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceCountGroupsForPrincipalsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupsServiceCountMembersForGroups counts members for groups returns the count of members per group
*/
func (a *Client) GroupsServiceCountMembersForGroups(params *GroupsServiceCountMembersForGroupsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceCountMembersForGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceCountMembersForGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_CountMembersForGroups",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/iam/{parent_resource_name}/groups/count-members-for-groups",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceCountMembersForGroupsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceCountMembersForGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceCountMembersForGroupsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupsServiceCountOrganizationGroups counts organization groups returns the count of groups for an organization
*/
func (a *Client) GroupsServiceCountOrganizationGroups(params *GroupsServiceCountOrganizationGroupsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceCountOrganizationGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceCountOrganizationGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_CountOrganizationGroups",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/iam/{parent_resource_name}/groups/count",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceCountOrganizationGroupsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceCountOrganizationGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceCountOrganizationGroupsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupsServiceCreateGroup creates group creates a group
*/
func (a *Client) GroupsServiceCreateGroup(params *GroupsServiceCreateGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceCreateGroupOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceCreateGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_CreateGroup",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/iam/{parent_resource_name}/groups",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceCreateGroupReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceCreateGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceCreateGroupDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupsServiceDeleteGroup deletes group deletes a group
*/
func (a *Client) GroupsServiceDeleteGroup(params *GroupsServiceDeleteGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceDeleteGroupOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceDeleteGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_DeleteGroup",
		Method:             "DELETE",
		PathPattern:        "/iam/2019-12-10/{resource_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceDeleteGroupReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceDeleteGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceDeleteGroupDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupsServiceGetGroup gets group gets a group using the organization ID and group name
*/
func (a *Client) GroupsServiceGetGroup(params *GroupsServiceGetGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceGetGroupOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceGetGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_GetGroup",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/{resource_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceGetGroupReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceGetGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceGetGroupDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupsServiceListGroupMembers lists group members retrieves a list of member principals
*/
func (a *Client) GroupsServiceListGroupMembers(params *GroupsServiceListGroupMembersParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceListGroupMembersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceListGroupMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_ListGroupMembers",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/{resource_name}/members",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceListGroupMembersReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceListGroupMembersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceListGroupMembersDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupsServiceListGroups lists groups lists the groups in an organization that match the optional filters
*/
func (a *Client) GroupsServiceListGroups(params *GroupsServiceListGroupsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceListGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceListGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_ListGroups",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/iam/{parent_resource_name}/groups",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceListGroupsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceListGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceListGroupsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupsServiceUpdateGroup updates group updates a group s modifiable fields
*/
func (a *Client) GroupsServiceUpdateGroup(params *GroupsServiceUpdateGroupParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceUpdateGroupOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceUpdateGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_UpdateGroup",
		Method:             "PUT",
		PathPattern:        "/iam/2019-12-10/{resource_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceUpdateGroupReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceUpdateGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceUpdateGroupDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupsServiceUpdateGroup2 updates group updates a group s modifiable fields
*/
func (a *Client) GroupsServiceUpdateGroup2(params *GroupsServiceUpdateGroup2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceUpdateGroup2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceUpdateGroup2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_UpdateGroup2",
		Method:             "PATCH",
		PathPattern:        "/iam/2019-12-10/{resource_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceUpdateGroup2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceUpdateGroup2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceUpdateGroup2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupsServiceUpdateGroupMembers updates group members updates the principal memberships of a group
*/
func (a *Client) GroupsServiceUpdateGroupMembers(params *GroupsServiceUpdateGroupMembersParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupsServiceUpdateGroupMembersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupsServiceUpdateGroupMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GroupsService_UpdateGroupMembers",
		Method:             "PUT",
		PathPattern:        "/iam/2019-12-10/{resource_name}/members",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GroupsServiceUpdateGroupMembersReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupsServiceUpdateGroupMembersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupsServiceUpdateGroupMembersDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
