// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListNodesParams creates a new ListNodesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListNodesParams() *ListNodesParams {
	return &ListNodesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListNodesParamsWithTimeout creates a new ListNodesParams object
// with the ability to set a timeout on a request.
func NewListNodesParamsWithTimeout(timeout time.Duration) *ListNodesParams {
	return &ListNodesParams{
		timeout: timeout,
	}
}

// NewListNodesParamsWithContext creates a new ListNodesParams object
// with the ability to set a context for a request.
func NewListNodesParamsWithContext(ctx context.Context) *ListNodesParams {
	return &ListNodesParams{
		Context: ctx,
	}
}

// NewListNodesParamsWithHTTPClient creates a new ListNodesParams object
// with the ability to set a custom HTTPClient for a request.
func NewListNodesParamsWithHTTPClient(client *http.Client) *ListNodesParams {
	return &ListNodesParams{
		HTTPClient: client,
	}
}

/*
ListNodesParams contains all the parameters to send to the API endpoint

	for the list nodes operation.

	Typically these are written to a http.Request.
*/
type ListNodesParams struct {

	/* Address.

	   Query param filter: list of `address`
	*/
	Address []string

	/* ClusterName.

	   Query param filter: list of `name` of the cluster
	*/
	ClusterName []string

	/* IncludeSyntheticNodes.

	   Include synthetic nodes in response
	*/
	IncludeSyntheticNodes *bool

	/* Name.

	   Query param filter: list of `name` of the nodes
	*/
	Name []string

	/* OrderBy.

	   Sorts the nodes based on a field. Allowed fields: `name`, `partition`, `created_at`, `updated_at` The value needs to be of the format `<Field Name> {asc/desc}` For example: `name`, `partition asc`, `name desc`.
	*/
	OrderBy []string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this parameter to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The maximum number of results per page to return. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned, which you can use to get the next page of results in subsequent
	requests. A value of zero causes `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this parameter to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* Partition.

	   Query param filter: list of `partition`
	*/
	Partition []string

	/* ProjectResourceName.

	   Project resource name of the project to which the node belongs. Resource name will be of the form `project/<project_id>`
	*/
	ProjectResourceName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list nodes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListNodesParams) WithDefaults() *ListNodesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list nodes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListNodesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list nodes params
func (o *ListNodesParams) WithTimeout(timeout time.Duration) *ListNodesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list nodes params
func (o *ListNodesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list nodes params
func (o *ListNodesParams) WithContext(ctx context.Context) *ListNodesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list nodes params
func (o *ListNodesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list nodes params
func (o *ListNodesParams) WithHTTPClient(client *http.Client) *ListNodesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list nodes params
func (o *ListNodesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddress adds the address to the list nodes params
func (o *ListNodesParams) WithAddress(address []string) *ListNodesParams {
	o.SetAddress(address)
	return o
}

// SetAddress adds the address to the list nodes params
func (o *ListNodesParams) SetAddress(address []string) {
	o.Address = address
}

// WithClusterName adds the clusterName to the list nodes params
func (o *ListNodesParams) WithClusterName(clusterName []string) *ListNodesParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the list nodes params
func (o *ListNodesParams) SetClusterName(clusterName []string) {
	o.ClusterName = clusterName
}

// WithIncludeSyntheticNodes adds the includeSyntheticNodes to the list nodes params
func (o *ListNodesParams) WithIncludeSyntheticNodes(includeSyntheticNodes *bool) *ListNodesParams {
	o.SetIncludeSyntheticNodes(includeSyntheticNodes)
	return o
}

// SetIncludeSyntheticNodes adds the includeSyntheticNodes to the list nodes params
func (o *ListNodesParams) SetIncludeSyntheticNodes(includeSyntheticNodes *bool) {
	o.IncludeSyntheticNodes = includeSyntheticNodes
}

// WithName adds the name to the list nodes params
func (o *ListNodesParams) WithName(name []string) *ListNodesParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the list nodes params
func (o *ListNodesParams) SetName(name []string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the list nodes params
func (o *ListNodesParams) WithOrderBy(orderBy []string) *ListNodesParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the list nodes params
func (o *ListNodesParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the list nodes params
func (o *ListNodesParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ListNodesParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the list nodes params
func (o *ListNodesParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the list nodes params
func (o *ListNodesParams) WithPaginationPageSize(paginationPageSize *int64) *ListNodesParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the list nodes params
func (o *ListNodesParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the list nodes params
func (o *ListNodesParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ListNodesParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the list nodes params
func (o *ListNodesParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithPartition adds the partition to the list nodes params
func (o *ListNodesParams) WithPartition(partition []string) *ListNodesParams {
	o.SetPartition(partition)
	return o
}

// SetPartition adds the partition to the list nodes params
func (o *ListNodesParams) SetPartition(partition []string) {
	o.Partition = partition
}

// WithProjectResourceName adds the projectResourceName to the list nodes params
func (o *ListNodesParams) WithProjectResourceName(projectResourceName string) *ListNodesParams {
	o.SetProjectResourceName(projectResourceName)
	return o
}

// SetProjectResourceName adds the projectResourceName to the list nodes params
func (o *ListNodesParams) SetProjectResourceName(projectResourceName string) {
	o.ProjectResourceName = projectResourceName
}

// WriteToRequest writes these params to a swagger request
func (o *ListNodesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Address != nil {

		// binding items for address
		joinedAddress := o.bindParamAddress(reg)

		// query array param address
		if err := r.SetQueryParam("address", joinedAddress...); err != nil {
			return err
		}
	}

	if o.ClusterName != nil {

		// binding items for cluster_name
		joinedClusterName := o.bindParamClusterName(reg)

		// query array param cluster_name
		if err := r.SetQueryParam("cluster_name", joinedClusterName...); err != nil {
			return err
		}
	}

	if o.IncludeSyntheticNodes != nil {

		// query param include_synthetic_nodes
		var qrIncludeSyntheticNodes bool

		if o.IncludeSyntheticNodes != nil {
			qrIncludeSyntheticNodes = *o.IncludeSyntheticNodes
		}
		qIncludeSyntheticNodes := swag.FormatBool(qrIncludeSyntheticNodes)
		if qIncludeSyntheticNodes != "" {

			if err := r.SetQueryParam("include_synthetic_nodes", qIncludeSyntheticNodes); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// binding items for name
		joinedName := o.bindParamName(reg)

		// query array param name
		if err := r.SetQueryParam("name", joinedName...); err != nil {
			return err
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if o.Partition != nil {

		// binding items for partition
		joinedPartition := o.bindParamPartition(reg)

		// query array param partition
		if err := r.SetQueryParam("partition", joinedPartition...); err != nil {
			return err
		}
	}

	// path param project_resource_name
	if err := r.SetPathParam("project_resource_name", o.ProjectResourceName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamListNodes binds the parameter address
func (o *ListNodesParams) bindParamAddress(formats strfmt.Registry) []string {
	addressIR := o.Address

	var addressIC []string
	for _, addressIIR := range addressIR { // explode []string

		addressIIV := addressIIR // string as string
		addressIC = append(addressIC, addressIIV)
	}

	// items.CollectionFormat: "multi"
	addressIS := swag.JoinByFormat(addressIC, "multi")

	return addressIS
}

// bindParamListNodes binds the parameter cluster_name
func (o *ListNodesParams) bindParamClusterName(formats strfmt.Registry) []string {
	clusterNameIR := o.ClusterName

	var clusterNameIC []string
	for _, clusterNameIIR := range clusterNameIR { // explode []string

		clusterNameIIV := clusterNameIIR // string as string
		clusterNameIC = append(clusterNameIC, clusterNameIIV)
	}

	// items.CollectionFormat: "multi"
	clusterNameIS := swag.JoinByFormat(clusterNameIC, "multi")

	return clusterNameIS
}

// bindParamListNodes binds the parameter name
func (o *ListNodesParams) bindParamName(formats strfmt.Registry) []string {
	nameIR := o.Name

	var nameIC []string
	for _, nameIIR := range nameIR { // explode []string

		nameIIV := nameIIR // string as string
		nameIC = append(nameIC, nameIIV)
	}

	// items.CollectionFormat: "multi"
	nameIS := swag.JoinByFormat(nameIC, "multi")

	return nameIS
}

// bindParamListNodes binds the parameter order_by
func (o *ListNodesParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "multi"
	orderByIS := swag.JoinByFormat(orderByIC, "multi")

	return orderByIS
}

// bindParamListNodes binds the parameter partition
func (o *ListNodesParams) bindParamPartition(formats strfmt.Registry) []string {
	partitionIR := o.Partition

	var partitionIC []string
	for _, partitionIIR := range partitionIR { // explode []string

		partitionIIV := partitionIIR // string as string
		partitionIC = append(partitionIC, partitionIIV)
	}

	// items.CollectionFormat: "multi"
	partitionIS := swag.JoinByFormat(partitionIC, "multi")

	return partitionIS
}
