// Code generated by go-swagger; DO NOT EDIT.

package product_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewProductServiceListAvailablePackagesParams creates a new ProductServiceListAvailablePackagesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewProductServiceListAvailablePackagesParams() *ProductServiceListAvailablePackagesParams {
	return &ProductServiceListAvailablePackagesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewProductServiceListAvailablePackagesParamsWithTimeout creates a new ProductServiceListAvailablePackagesParams object
// with the ability to set a timeout on a request.
func NewProductServiceListAvailablePackagesParamsWithTimeout(timeout time.Duration) *ProductServiceListAvailablePackagesParams {
	return &ProductServiceListAvailablePackagesParams{
		timeout: timeout,
	}
}

// NewProductServiceListAvailablePackagesParamsWithContext creates a new ProductServiceListAvailablePackagesParams object
// with the ability to set a context for a request.
func NewProductServiceListAvailablePackagesParamsWithContext(ctx context.Context) *ProductServiceListAvailablePackagesParams {
	return &ProductServiceListAvailablePackagesParams{
		Context: ctx,
	}
}

// NewProductServiceListAvailablePackagesParamsWithHTTPClient creates a new ProductServiceListAvailablePackagesParams object
// with the ability to set a custom HTTPClient for a request.
func NewProductServiceListAvailablePackagesParamsWithHTTPClient(client *http.Client) *ProductServiceListAvailablePackagesParams {
	return &ProductServiceListAvailablePackagesParams{
		HTTPClient: client,
	}
}

/*
ProductServiceListAvailablePackagesParams contains all the parameters to send to the API endpoint

	for the product service list available packages operation.

	Typically these are written to a http.Request.
*/
type ProductServiceListAvailablePackagesParams struct {

	/* OrganizationID.

	   organization_id is the organization ID used to scope the request for available packages.
	*/
	OrganizationID *string

	/* ProjectID.

	   project_id the project ID used to scope the request for available packages.
	*/
	ProjectID *string

	/* RegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	RegionProvider *string

	/* RegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	RegionRegion *string

	/* ResourceType.

	     resource_type is the resource to retrieve available packages for.

	e.g. hashicorp.consul.cluster
	*/
	ResourceType *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the product service list available packages params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ProductServiceListAvailablePackagesParams) WithDefaults() *ProductServiceListAvailablePackagesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the product service list available packages params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ProductServiceListAvailablePackagesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) WithTimeout(timeout time.Duration) *ProductServiceListAvailablePackagesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) WithContext(ctx context.Context) *ProductServiceListAvailablePackagesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) WithHTTPClient(client *http.Client) *ProductServiceListAvailablePackagesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithOrganizationID adds the organizationID to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) WithOrganizationID(organizationID *string) *ProductServiceListAvailablePackagesParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) SetOrganizationID(organizationID *string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) WithProjectID(projectID *string) *ProductServiceListAvailablePackagesParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) SetProjectID(projectID *string) {
	o.ProjectID = projectID
}

// WithRegionProvider adds the regionProvider to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) WithRegionProvider(regionProvider *string) *ProductServiceListAvailablePackagesParams {
	o.SetRegionProvider(regionProvider)
	return o
}

// SetRegionProvider adds the regionProvider to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) SetRegionProvider(regionProvider *string) {
	o.RegionProvider = regionProvider
}

// WithRegionRegion adds the regionRegion to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) WithRegionRegion(regionRegion *string) *ProductServiceListAvailablePackagesParams {
	o.SetRegionRegion(regionRegion)
	return o
}

// SetRegionRegion adds the regionRegion to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) SetRegionRegion(regionRegion *string) {
	o.RegionRegion = regionRegion
}

// WithResourceType adds the resourceType to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) WithResourceType(resourceType *string) *ProductServiceListAvailablePackagesParams {
	o.SetResourceType(resourceType)
	return o
}

// SetResourceType adds the resourceType to the product service list available packages params
func (o *ProductServiceListAvailablePackagesParams) SetResourceType(resourceType *string) {
	o.ResourceType = resourceType
}

// WriteToRequest writes these params to a swagger request
func (o *ProductServiceListAvailablePackagesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.OrganizationID != nil {

		// query param organization_id
		var qrOrganizationID string

		if o.OrganizationID != nil {
			qrOrganizationID = *o.OrganizationID
		}
		qOrganizationID := qrOrganizationID
		if qOrganizationID != "" {

			if err := r.SetQueryParam("organization_id", qOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.ProjectID != nil {

		// query param project_id
		var qrProjectID string

		if o.ProjectID != nil {
			qrProjectID = *o.ProjectID
		}
		qProjectID := qrProjectID
		if qProjectID != "" {

			if err := r.SetQueryParam("project_id", qProjectID); err != nil {
				return err
			}
		}
	}

	if o.RegionProvider != nil {

		// query param region.provider
		var qrRegionProvider string

		if o.RegionProvider != nil {
			qrRegionProvider = *o.RegionProvider
		}
		qRegionProvider := qrRegionProvider
		if qRegionProvider != "" {

			if err := r.SetQueryParam("region.provider", qRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.RegionRegion != nil {

		// query param region.region
		var qrRegionRegion string

		if o.RegionRegion != nil {
			qrRegionRegion = *o.RegionRegion
		}
		qRegionRegion := qrRegionRegion
		if qRegionRegion != "" {

			if err := r.SetQueryParam("region.region", qRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.ResourceType != nil {

		// query param resource_type
		var qrResourceType string

		if o.ResourceType != nil {
			qrResourceType = *o.ResourceType
		}
		qResourceType := qrResourceType
		if qResourceType != "" {

			if err := r.SetQueryParam("resource_type", qResourceType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
