// Copyright 2019 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: grafeas/v1/discovery.proto

package grafeas

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Whether the resource is continuously analyzed.
type DiscoveryOccurrence_ContinuousAnalysis int32

const (
	// Unknown.
	DiscoveryOccurrence_CONTINUOUS_ANALYSIS_UNSPECIFIED DiscoveryOccurrence_ContinuousAnalysis = 0
	// The resource is continuously analyzed.
	DiscoveryOccurrence_ACTIVE DiscoveryOccurrence_ContinuousAnalysis = 1
	// The resource is ignored for continuous analysis.
	DiscoveryOccurrence_INACTIVE DiscoveryOccurrence_ContinuousAnalysis = 2
)

// Enum value maps for DiscoveryOccurrence_ContinuousAnalysis.
var (
	DiscoveryOccurrence_ContinuousAnalysis_name = map[int32]string{
		0: "CONTINUOUS_ANALYSIS_UNSPECIFIED",
		1: "ACTIVE",
		2: "INACTIVE",
	}
	DiscoveryOccurrence_ContinuousAnalysis_value = map[string]int32{
		"CONTINUOUS_ANALYSIS_UNSPECIFIED": 0,
		"ACTIVE":                          1,
		"INACTIVE":                        2,
	}
)

func (x DiscoveryOccurrence_ContinuousAnalysis) Enum() *DiscoveryOccurrence_ContinuousAnalysis {
	p := new(DiscoveryOccurrence_ContinuousAnalysis)
	*p = x
	return p
}

func (x DiscoveryOccurrence_ContinuousAnalysis) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiscoveryOccurrence_ContinuousAnalysis) Descriptor() protoreflect.EnumDescriptor {
	return file_grafeas_v1_discovery_proto_enumTypes[0].Descriptor()
}

func (DiscoveryOccurrence_ContinuousAnalysis) Type() protoreflect.EnumType {
	return &file_grafeas_v1_discovery_proto_enumTypes[0]
}

func (x DiscoveryOccurrence_ContinuousAnalysis) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiscoveryOccurrence_ContinuousAnalysis.Descriptor instead.
func (DiscoveryOccurrence_ContinuousAnalysis) EnumDescriptor() ([]byte, []int) {
	return file_grafeas_v1_discovery_proto_rawDescGZIP(), []int{1, 0}
}

// Analysis status for a resource. Currently for initial analysis only (not
// updated in continuous analysis).
type DiscoveryOccurrence_AnalysisStatus int32

const (
	// Unknown.
	DiscoveryOccurrence_ANALYSIS_STATUS_UNSPECIFIED DiscoveryOccurrence_AnalysisStatus = 0
	// Resource is known but no action has been taken yet.
	DiscoveryOccurrence_PENDING DiscoveryOccurrence_AnalysisStatus = 1
	// Resource is being analyzed.
	DiscoveryOccurrence_SCANNING DiscoveryOccurrence_AnalysisStatus = 2
	// Analysis has finished successfully.
	DiscoveryOccurrence_FINISHED_SUCCESS DiscoveryOccurrence_AnalysisStatus = 3
	// Analysis has completed.
	DiscoveryOccurrence_COMPLETE DiscoveryOccurrence_AnalysisStatus = 3
	// Analysis has finished unsuccessfully, the analysis itself is in a bad
	// state.
	DiscoveryOccurrence_FINISHED_FAILED DiscoveryOccurrence_AnalysisStatus = 4
	// The resource is known not to be supported.
	DiscoveryOccurrence_FINISHED_UNSUPPORTED DiscoveryOccurrence_AnalysisStatus = 5
)

// Enum value maps for DiscoveryOccurrence_AnalysisStatus.
var (
	DiscoveryOccurrence_AnalysisStatus_name = map[int32]string{
		0: "ANALYSIS_STATUS_UNSPECIFIED",
		1: "PENDING",
		2: "SCANNING",
		3: "FINISHED_SUCCESS",
		// Duplicate value: 3: "COMPLETE",
		4: "FINISHED_FAILED",
		5: "FINISHED_UNSUPPORTED",
	}
	DiscoveryOccurrence_AnalysisStatus_value = map[string]int32{
		"ANALYSIS_STATUS_UNSPECIFIED": 0,
		"PENDING":                     1,
		"SCANNING":                    2,
		"FINISHED_SUCCESS":            3,
		"COMPLETE":                    3,
		"FINISHED_FAILED":             4,
		"FINISHED_UNSUPPORTED":        5,
	}
)

func (x DiscoveryOccurrence_AnalysisStatus) Enum() *DiscoveryOccurrence_AnalysisStatus {
	p := new(DiscoveryOccurrence_AnalysisStatus)
	*p = x
	return p
}

func (x DiscoveryOccurrence_AnalysisStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiscoveryOccurrence_AnalysisStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_grafeas_v1_discovery_proto_enumTypes[1].Descriptor()
}

func (DiscoveryOccurrence_AnalysisStatus) Type() protoreflect.EnumType {
	return &file_grafeas_v1_discovery_proto_enumTypes[1]
}

func (x DiscoveryOccurrence_AnalysisStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiscoveryOccurrence_AnalysisStatus.Descriptor instead.
func (DiscoveryOccurrence_AnalysisStatus) EnumDescriptor() ([]byte, []int) {
	return file_grafeas_v1_discovery_proto_rawDescGZIP(), []int{1, 1}
}

// A note that indicates a type of analysis a provider would perform. This note
// exists in a provider's project. A `Discovery` occurrence is created in a
// consumer's project at the start of analysis.
type DiscoveryNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The kind of analysis that is handled by this
	// discovery.
	AnalysisKind NoteKind `protobuf:"varint,1,opt,name=analysis_kind,json=analysisKind,proto3,enum=grafeas.v1.NoteKind" json:"analysis_kind,omitempty"`
}

func (x *DiscoveryNote) Reset() {
	*x = DiscoveryNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_discovery_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryNote) ProtoMessage() {}

func (x *DiscoveryNote) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_discovery_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryNote.ProtoReflect.Descriptor instead.
func (*DiscoveryNote) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_discovery_proto_rawDescGZIP(), []int{0}
}

func (x *DiscoveryNote) GetAnalysisKind() NoteKind {
	if x != nil {
		return x.AnalysisKind
	}
	return NoteKind_NOTE_KIND_UNSPECIFIED
}

// Provides information about the analysis status of a discovered resource.
type DiscoveryOccurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the resource is continuously analyzed.
	ContinuousAnalysis DiscoveryOccurrence_ContinuousAnalysis `protobuf:"varint,1,opt,name=continuous_analysis,json=continuousAnalysis,proto3,enum=grafeas.v1.DiscoveryOccurrence_ContinuousAnalysis" json:"continuous_analysis,omitempty"`
	// The status of discovery for the resource.
	AnalysisStatus    DiscoveryOccurrence_AnalysisStatus     `protobuf:"varint,2,opt,name=analysis_status,json=analysisStatus,proto3,enum=grafeas.v1.DiscoveryOccurrence_AnalysisStatus" json:"analysis_status,omitempty"`
	AnalysisCompleted *DiscoveryOccurrence_AnalysisCompleted `protobuf:"bytes,7,opt,name=analysis_completed,json=analysisCompleted,proto3" json:"analysis_completed,omitempty"`
	// Indicates any errors encountered during analysis of a resource. There
	// could be 0 or more of these errors.
	AnalysisError []*status.Status `protobuf:"bytes,8,rep,name=analysis_error,json=analysisError,proto3" json:"analysis_error,omitempty"`
	// When an error is encountered this will contain a LocalizedMessage under
	// details to show to the user. The LocalizedMessage is output only and
	// populated by the API.
	AnalysisStatusError *status.Status `protobuf:"bytes,3,opt,name=analysis_status_error,json=analysisStatusError,proto3" json:"analysis_status_error,omitempty"`
	// The CPE of the resource being scanned.
	Cpe string `protobuf:"bytes,4,opt,name=cpe,proto3" json:"cpe,omitempty"`
	// The last time this resource was scanned.
	LastScanTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_scan_time,json=lastScanTime,proto3" json:"last_scan_time,omitempty"`
	// The time occurrences related to this discovery occurrence were archived.
	ArchiveTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=archive_time,json=archiveTime,proto3" json:"archive_time,omitempty"`
}

func (x *DiscoveryOccurrence) Reset() {
	*x = DiscoveryOccurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_discovery_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryOccurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryOccurrence) ProtoMessage() {}

func (x *DiscoveryOccurrence) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_discovery_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryOccurrence.ProtoReflect.Descriptor instead.
func (*DiscoveryOccurrence) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_discovery_proto_rawDescGZIP(), []int{1}
}

func (x *DiscoveryOccurrence) GetContinuousAnalysis() DiscoveryOccurrence_ContinuousAnalysis {
	if x != nil {
		return x.ContinuousAnalysis
	}
	return DiscoveryOccurrence_CONTINUOUS_ANALYSIS_UNSPECIFIED
}

func (x *DiscoveryOccurrence) GetAnalysisStatus() DiscoveryOccurrence_AnalysisStatus {
	if x != nil {
		return x.AnalysisStatus
	}
	return DiscoveryOccurrence_ANALYSIS_STATUS_UNSPECIFIED
}

func (x *DiscoveryOccurrence) GetAnalysisCompleted() *DiscoveryOccurrence_AnalysisCompleted {
	if x != nil {
		return x.AnalysisCompleted
	}
	return nil
}

func (x *DiscoveryOccurrence) GetAnalysisError() []*status.Status {
	if x != nil {
		return x.AnalysisError
	}
	return nil
}

func (x *DiscoveryOccurrence) GetAnalysisStatusError() *status.Status {
	if x != nil {
		return x.AnalysisStatusError
	}
	return nil
}

func (x *DiscoveryOccurrence) GetCpe() string {
	if x != nil {
		return x.Cpe
	}
	return ""
}

func (x *DiscoveryOccurrence) GetLastScanTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastScanTime
	}
	return nil
}

func (x *DiscoveryOccurrence) GetArchiveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ArchiveTime
	}
	return nil
}

// Indicates which analysis completed successfully. Multiple types of
// analysis can be performed on a single resource.
type DiscoveryOccurrence_AnalysisCompleted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AnalysisType []string `protobuf:"bytes,1,rep,name=analysis_type,json=analysisType,proto3" json:"analysis_type,omitempty"`
}

func (x *DiscoveryOccurrence_AnalysisCompleted) Reset() {
	*x = DiscoveryOccurrence_AnalysisCompleted{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_discovery_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryOccurrence_AnalysisCompleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryOccurrence_AnalysisCompleted) ProtoMessage() {}

func (x *DiscoveryOccurrence_AnalysisCompleted) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_discovery_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryOccurrence_AnalysisCompleted.ProtoReflect.Descriptor instead.
func (*DiscoveryOccurrence_AnalysisCompleted) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_discovery_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DiscoveryOccurrence_AnalysisCompleted) GetAnalysisType() []string {
	if x != nil {
		return x.AnalysisType
	}
	return nil
}

var File_grafeas_v1_discovery_proto protoreflect.FileDescriptor

var file_grafeas_v1_discovery_proto_rawDesc = []byte{
	0x0a, 0x1a, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0a, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4a, 0x0a, 0x0d,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x39, 0x0a,
	0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x0c, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x4b, 0x69, 0x6e, 0x64, 0x22, 0x85, 0x07, 0x0a, 0x13, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x63, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x5f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x57, 0x0a, 0x0f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x60,
	0x0a, 0x12, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x52, 0x11, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x12, 0x39, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x46, 0x0a, 0x15, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x13,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x63, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x63,
	0x61, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x53,
	0x63, 0x61, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x38, 0x0a, 0x11, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x54, 0x79, 0x70, 0x65, 0x22, 0x53, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75,
	0x6f, 0x75, 0x73, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x23, 0x0a, 0x1f, 0x43,
	0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55, 0x4f, 0x55, 0x53, 0x5f, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x53,
	0x49, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x22, 0xa3, 0x01, 0x0a, 0x0e, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x0a,
	0x1b, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x53, 0x49, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x53,
	0x43, 0x41, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x49, 0x4e,
	0x49, 0x53, 0x48, 0x45, 0x44, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x12, 0x13, 0x0a,
	0x0f, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48, 0x45, 0x44, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48, 0x45, 0x44, 0x5f, 0x55,
	0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x05, 0x1a, 0x02, 0x10, 0x01,
	0x42, 0x51, 0x0a, 0x0d, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0xa2, 0x02, 0x03,
	0x47, 0x52, 0x41, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_grafeas_v1_discovery_proto_rawDescOnce sync.Once
	file_grafeas_v1_discovery_proto_rawDescData = file_grafeas_v1_discovery_proto_rawDesc
)

func file_grafeas_v1_discovery_proto_rawDescGZIP() []byte {
	file_grafeas_v1_discovery_proto_rawDescOnce.Do(func() {
		file_grafeas_v1_discovery_proto_rawDescData = protoimpl.X.CompressGZIP(file_grafeas_v1_discovery_proto_rawDescData)
	})
	return file_grafeas_v1_discovery_proto_rawDescData
}

var file_grafeas_v1_discovery_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_grafeas_v1_discovery_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_grafeas_v1_discovery_proto_goTypes = []interface{}{
	(DiscoveryOccurrence_ContinuousAnalysis)(0),   // 0: grafeas.v1.DiscoveryOccurrence.ContinuousAnalysis
	(DiscoveryOccurrence_AnalysisStatus)(0),       // 1: grafeas.v1.DiscoveryOccurrence.AnalysisStatus
	(*DiscoveryNote)(nil),                         // 2: grafeas.v1.DiscoveryNote
	(*DiscoveryOccurrence)(nil),                   // 3: grafeas.v1.DiscoveryOccurrence
	(*DiscoveryOccurrence_AnalysisCompleted)(nil), // 4: grafeas.v1.DiscoveryOccurrence.AnalysisCompleted
	(NoteKind)(0),                 // 5: grafeas.v1.NoteKind
	(*status.Status)(nil),         // 6: google.rpc.Status
	(*timestamppb.Timestamp)(nil), // 7: google.protobuf.Timestamp
}
var file_grafeas_v1_discovery_proto_depIdxs = []int32{
	5, // 0: grafeas.v1.DiscoveryNote.analysis_kind:type_name -> grafeas.v1.NoteKind
	0, // 1: grafeas.v1.DiscoveryOccurrence.continuous_analysis:type_name -> grafeas.v1.DiscoveryOccurrence.ContinuousAnalysis
	1, // 2: grafeas.v1.DiscoveryOccurrence.analysis_status:type_name -> grafeas.v1.DiscoveryOccurrence.AnalysisStatus
	4, // 3: grafeas.v1.DiscoveryOccurrence.analysis_completed:type_name -> grafeas.v1.DiscoveryOccurrence.AnalysisCompleted
	6, // 4: grafeas.v1.DiscoveryOccurrence.analysis_error:type_name -> google.rpc.Status
	6, // 5: grafeas.v1.DiscoveryOccurrence.analysis_status_error:type_name -> google.rpc.Status
	7, // 6: grafeas.v1.DiscoveryOccurrence.last_scan_time:type_name -> google.protobuf.Timestamp
	7, // 7: grafeas.v1.DiscoveryOccurrence.archive_time:type_name -> google.protobuf.Timestamp
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_grafeas_v1_discovery_proto_init() }
func file_grafeas_v1_discovery_proto_init() {
	if File_grafeas_v1_discovery_proto != nil {
		return
	}
	file_grafeas_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_grafeas_v1_discovery_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiscoveryNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_discovery_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiscoveryOccurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_discovery_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiscoveryOccurrence_AnalysisCompleted); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_grafeas_v1_discovery_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_grafeas_v1_discovery_proto_goTypes,
		DependencyIndexes: file_grafeas_v1_discovery_proto_depIdxs,
		EnumInfos:         file_grafeas_v1_discovery_proto_enumTypes,
		MessageInfos:      file_grafeas_v1_discovery_proto_msgTypes,
	}.Build()
	File_grafeas_v1_discovery_proto = out.File
	file_grafeas_v1_discovery_proto_rawDesc = nil
	file_grafeas_v1_discovery_proto_goTypes = nil
	file_grafeas_v1_discovery_proto_depIdxs = nil
}
