// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointServiceListAddOnDefinitionsParams creates a new WaypointServiceListAddOnDefinitionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceListAddOnDefinitionsParams() *WaypointServiceListAddOnDefinitionsParams {
	return &WaypointServiceListAddOnDefinitionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceListAddOnDefinitionsParamsWithTimeout creates a new WaypointServiceListAddOnDefinitionsParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceListAddOnDefinitionsParamsWithTimeout(timeout time.Duration) *WaypointServiceListAddOnDefinitionsParams {
	return &WaypointServiceListAddOnDefinitionsParams{
		timeout: timeout,
	}
}

// NewWaypointServiceListAddOnDefinitionsParamsWithContext creates a new WaypointServiceListAddOnDefinitionsParams object
// with the ability to set a context for a request.
func NewWaypointServiceListAddOnDefinitionsParamsWithContext(ctx context.Context) *WaypointServiceListAddOnDefinitionsParams {
	return &WaypointServiceListAddOnDefinitionsParams{
		Context: ctx,
	}
}

// NewWaypointServiceListAddOnDefinitionsParamsWithHTTPClient creates a new WaypointServiceListAddOnDefinitionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceListAddOnDefinitionsParamsWithHTTPClient(client *http.Client) *WaypointServiceListAddOnDefinitionsParams {
	return &WaypointServiceListAddOnDefinitionsParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceListAddOnDefinitionsParams contains all the parameters to send to the API endpoint

	for the waypoint service list add on definitions operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceListAddOnDefinitionsParams struct {

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* WithTotalCount.

	   If set to false or not provided, response will not include a total_count value
	*/
	WithTotalCount *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service list add on definitions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListAddOnDefinitionsParams) WithDefaults() *WaypointServiceListAddOnDefinitionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service list add on definitions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListAddOnDefinitionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithTimeout(timeout time.Duration) *WaypointServiceListAddOnDefinitionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithContext(ctx context.Context) *WaypointServiceListAddOnDefinitionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithHTTPClient(client *http.Client) *WaypointServiceListAddOnDefinitionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithNamespaceID adds the namespaceID to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithNamespaceID(namespaceID string) *WaypointServiceListAddOnDefinitionsParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceListAddOnDefinitionsParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceListAddOnDefinitionsParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceListAddOnDefinitionsParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceListAddOnDefinitionsParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithPaginationNextPageToken(paginationNextPageToken *string) *WaypointServiceListAddOnDefinitionsParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithPaginationPageSize(paginationPageSize *int64) *WaypointServiceListAddOnDefinitionsParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *WaypointServiceListAddOnDefinitionsParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithWithTotalCount adds the withTotalCount to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) WithWithTotalCount(withTotalCount *bool) *WaypointServiceListAddOnDefinitionsParams {
	o.SetWithTotalCount(withTotalCount)
	return o
}

// SetWithTotalCount adds the withTotalCount to the waypoint service list add on definitions params
func (o *WaypointServiceListAddOnDefinitionsParams) SetWithTotalCount(withTotalCount *bool) {
	o.WithTotalCount = withTotalCount
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceListAddOnDefinitionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if o.WithTotalCount != nil {

		// query param with_total_count
		var qrWithTotalCount bool

		if o.WithTotalCount != nil {
			qrWithTotalCount = *o.WithTotalCount
		}
		qWithTotalCount := swag.FormatBool(qrWithTotalCount)
		if qWithTotalCount != "" {

			if err := r.SetQueryParam("with_total_count", qWithTotalCount); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
