// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceCreateActionConfigReader is a Reader for the WaypointServiceCreateActionConfig structure.
type WaypointServiceCreateActionConfigReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceCreateActionConfigReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceCreateActionConfigOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceCreateActionConfigDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceCreateActionConfigOK creates a WaypointServiceCreateActionConfigOK with default headers values
func NewWaypointServiceCreateActionConfigOK() *WaypointServiceCreateActionConfigOK {
	return &WaypointServiceCreateActionConfigOK{}
}

/*
WaypointServiceCreateActionConfigOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceCreateActionConfigOK struct {
	Payload *models.HashicorpCloudWaypointCreateActionConfigResponse
}

// IsSuccess returns true when this waypoint service create action config o k response has a 2xx status code
func (o *WaypointServiceCreateActionConfigOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service create action config o k response has a 3xx status code
func (o *WaypointServiceCreateActionConfigOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service create action config o k response has a 4xx status code
func (o *WaypointServiceCreateActionConfigOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service create action config o k response has a 5xx status code
func (o *WaypointServiceCreateActionConfigOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service create action config o k response a status code equal to that given
func (o *WaypointServiceCreateActionConfigOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service create action config o k response
func (o *WaypointServiceCreateActionConfigOK) Code() int {
	return 200
}

func (o *WaypointServiceCreateActionConfigOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/actionconfig][%d] waypointServiceCreateActionConfigOK %s", 200, payload)
}

func (o *WaypointServiceCreateActionConfigOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/actionconfig][%d] waypointServiceCreateActionConfigOK %s", 200, payload)
}

func (o *WaypointServiceCreateActionConfigOK) GetPayload() *models.HashicorpCloudWaypointCreateActionConfigResponse {
	return o.Payload
}

func (o *WaypointServiceCreateActionConfigOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointCreateActionConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceCreateActionConfigDefault creates a WaypointServiceCreateActionConfigDefault with default headers values
func NewWaypointServiceCreateActionConfigDefault(code int) *WaypointServiceCreateActionConfigDefault {
	return &WaypointServiceCreateActionConfigDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceCreateActionConfigDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceCreateActionConfigDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service create action config default response has a 2xx status code
func (o *WaypointServiceCreateActionConfigDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service create action config default response has a 3xx status code
func (o *WaypointServiceCreateActionConfigDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service create action config default response has a 4xx status code
func (o *WaypointServiceCreateActionConfigDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service create action config default response has a 5xx status code
func (o *WaypointServiceCreateActionConfigDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service create action config default response a status code equal to that given
func (o *WaypointServiceCreateActionConfigDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service create action config default response
func (o *WaypointServiceCreateActionConfigDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceCreateActionConfigDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/actionconfig][%d] WaypointService_CreateActionConfig default %s", o._statusCode, payload)
}

func (o *WaypointServiceCreateActionConfigDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/actionconfig][%d] WaypointService_CreateActionConfig default %s", o._statusCode, payload)
}

func (o *WaypointServiceCreateActionConfigDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceCreateActionConfigDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
