// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// ListGatewayPoolIntegrationsReader is a Reader for the ListGatewayPoolIntegrations structure.
type ListGatewayPoolIntegrationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListGatewayPoolIntegrationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListGatewayPoolIntegrationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListGatewayPoolIntegrationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListGatewayPoolIntegrationsOK creates a ListGatewayPoolIntegrationsOK with default headers values
func NewListGatewayPoolIntegrationsOK() *ListGatewayPoolIntegrationsOK {
	return &ListGatewayPoolIntegrationsOK{}
}

/*
ListGatewayPoolIntegrationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListGatewayPoolIntegrationsOK struct {
	Payload *models.Secrets20231128ListGatewayPoolIntegrationsResponse
}

// IsSuccess returns true when this list gateway pool integrations o k response has a 2xx status code
func (o *ListGatewayPoolIntegrationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list gateway pool integrations o k response has a 3xx status code
func (o *ListGatewayPoolIntegrationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list gateway pool integrations o k response has a 4xx status code
func (o *ListGatewayPoolIntegrationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list gateway pool integrations o k response has a 5xx status code
func (o *ListGatewayPoolIntegrationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list gateway pool integrations o k response a status code equal to that given
func (o *ListGatewayPoolIntegrationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list gateway pool integrations o k response
func (o *ListGatewayPoolIntegrationsOK) Code() int {
	return 200
}

func (o *ListGatewayPoolIntegrationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}/integrations][%d] listGatewayPoolIntegrationsOK %s", 200, payload)
}

func (o *ListGatewayPoolIntegrationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}/integrations][%d] listGatewayPoolIntegrationsOK %s", 200, payload)
}

func (o *ListGatewayPoolIntegrationsOK) GetPayload() *models.Secrets20231128ListGatewayPoolIntegrationsResponse {
	return o.Payload
}

func (o *ListGatewayPoolIntegrationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128ListGatewayPoolIntegrationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListGatewayPoolIntegrationsDefault creates a ListGatewayPoolIntegrationsDefault with default headers values
func NewListGatewayPoolIntegrationsDefault(code int) *ListGatewayPoolIntegrationsDefault {
	return &ListGatewayPoolIntegrationsDefault{
		_statusCode: code,
	}
}

/*
ListGatewayPoolIntegrationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListGatewayPoolIntegrationsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this list gateway pool integrations default response has a 2xx status code
func (o *ListGatewayPoolIntegrationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list gateway pool integrations default response has a 3xx status code
func (o *ListGatewayPoolIntegrationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list gateway pool integrations default response has a 4xx status code
func (o *ListGatewayPoolIntegrationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list gateway pool integrations default response has a 5xx status code
func (o *ListGatewayPoolIntegrationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list gateway pool integrations default response a status code equal to that given
func (o *ListGatewayPoolIntegrationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list gateway pool integrations default response
func (o *ListGatewayPoolIntegrationsDefault) Code() int {
	return o._statusCode
}

func (o *ListGatewayPoolIntegrationsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}/integrations][%d] ListGatewayPoolIntegrations default %s", o._statusCode, payload)
}

func (o *ListGatewayPoolIntegrationsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}/integrations][%d] ListGatewayPoolIntegrations default %s", o._statusCode, payload)
}

func (o *ListGatewayPoolIntegrationsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ListGatewayPoolIntegrationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
