// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// ListAwsIntegrationsReader is a Reader for the ListAwsIntegrations structure.
type ListAwsIntegrationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListAwsIntegrationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListAwsIntegrationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListAwsIntegrationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListAwsIntegrationsOK creates a ListAwsIntegrationsOK with default headers values
func NewListAwsIntegrationsOK() *ListAwsIntegrationsOK {
	return &ListAwsIntegrationsOK{}
}

/*
ListAwsIntegrationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListAwsIntegrationsOK struct {
	Payload *models.Secrets20231128ListAwsIntegrationsResponse
}

// IsSuccess returns true when this list aws integrations o k response has a 2xx status code
func (o *ListAwsIntegrationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list aws integrations o k response has a 3xx status code
func (o *ListAwsIntegrationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list aws integrations o k response has a 4xx status code
func (o *ListAwsIntegrationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list aws integrations o k response has a 5xx status code
func (o *ListAwsIntegrationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list aws integrations o k response a status code equal to that given
func (o *ListAwsIntegrationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list aws integrations o k response
func (o *ListAwsIntegrationsOK) Code() int {
	return 200
}

func (o *ListAwsIntegrationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config][%d] listAwsIntegrationsOK %s", 200, payload)
}

func (o *ListAwsIntegrationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config][%d] listAwsIntegrationsOK %s", 200, payload)
}

func (o *ListAwsIntegrationsOK) GetPayload() *models.Secrets20231128ListAwsIntegrationsResponse {
	return o.Payload
}

func (o *ListAwsIntegrationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128ListAwsIntegrationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListAwsIntegrationsDefault creates a ListAwsIntegrationsDefault with default headers values
func NewListAwsIntegrationsDefault(code int) *ListAwsIntegrationsDefault {
	return &ListAwsIntegrationsDefault{
		_statusCode: code,
	}
}

/*
ListAwsIntegrationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListAwsIntegrationsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this list aws integrations default response has a 2xx status code
func (o *ListAwsIntegrationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list aws integrations default response has a 3xx status code
func (o *ListAwsIntegrationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list aws integrations default response has a 4xx status code
func (o *ListAwsIntegrationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list aws integrations default response has a 5xx status code
func (o *ListAwsIntegrationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list aws integrations default response a status code equal to that given
func (o *ListAwsIntegrationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list aws integrations default response
func (o *ListAwsIntegrationsDefault) Code() int {
	return o._statusCode
}

func (o *ListAwsIntegrationsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config][%d] ListAwsIntegrations default %s", o._statusCode, payload)
}

func (o *ListAwsIntegrationsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config][%d] ListAwsIntegrations default %s", o._statusCode, payload)
}

func (o *ListAwsIntegrationsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ListAwsIntegrationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
