// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewListGitHubInstallationsParams creates a new ListGitHubInstallationsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListGitHubInstallationsParams() *ListGitHubInstallationsParams {
	return &ListGitHubInstallationsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListGitHubInstallationsParamsWithTimeout creates a new ListGitHubInstallationsParams object
// with the ability to set a timeout on a request.
func NewListGitHubInstallationsParamsWithTimeout(timeout time.Duration) *ListGitHubInstallationsParams {
	return &ListGitHubInstallationsParams{
		timeout: timeout,
	}
}

// NewListGitHubInstallationsParamsWithContext creates a new ListGitHubInstallationsParams object
// with the ability to set a context for a request.
func NewListGitHubInstallationsParamsWithContext(ctx context.Context) *ListGitHubInstallationsParams {
	return &ListGitHubInstallationsParams{
		Context: ctx,
	}
}

// NewListGitHubInstallationsParamsWithHTTPClient creates a new ListGitHubInstallationsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListGitHubInstallationsParamsWithHTTPClient(client *http.Client) *ListGitHubInstallationsParams {
	return &ListGitHubInstallationsParams{
		HTTPClient: client,
	}
}

/*
ListGitHubInstallationsParams contains all the parameters to send to the API endpoint

	for the list git hub installations operation.

	Typically these are written to a http.Request.
*/
type ListGitHubInstallationsParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	// State.
	State *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list git hub installations params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListGitHubInstallationsParams) WithDefaults() *ListGitHubInstallationsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list git hub installations params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListGitHubInstallationsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list git hub installations params
func (o *ListGitHubInstallationsParams) WithTimeout(timeout time.Duration) *ListGitHubInstallationsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list git hub installations params
func (o *ListGitHubInstallationsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list git hub installations params
func (o *ListGitHubInstallationsParams) WithContext(ctx context.Context) *ListGitHubInstallationsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list git hub installations params
func (o *ListGitHubInstallationsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list git hub installations params
func (o *ListGitHubInstallationsParams) WithHTTPClient(client *http.Client) *ListGitHubInstallationsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list git hub installations params
func (o *ListGitHubInstallationsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the list git hub installations params
func (o *ListGitHubInstallationsParams) WithLocationOrganizationID(locationOrganizationID string) *ListGitHubInstallationsParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the list git hub installations params
func (o *ListGitHubInstallationsParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the list git hub installations params
func (o *ListGitHubInstallationsParams) WithLocationProjectID(locationProjectID string) *ListGitHubInstallationsParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the list git hub installations params
func (o *ListGitHubInstallationsParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the list git hub installations params
func (o *ListGitHubInstallationsParams) WithLocationRegionProvider(locationRegionProvider *string) *ListGitHubInstallationsParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the list git hub installations params
func (o *ListGitHubInstallationsParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the list git hub installations params
func (o *ListGitHubInstallationsParams) WithLocationRegionRegion(locationRegionRegion *string) *ListGitHubInstallationsParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the list git hub installations params
func (o *ListGitHubInstallationsParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithState adds the state to the list git hub installations params
func (o *ListGitHubInstallationsParams) WithState(state *string) *ListGitHubInstallationsParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the list git hub installations params
func (o *ListGitHubInstallationsParams) SetState(state *string) {
	o.State = state
}

// WriteToRequest writes these params to a swagger request
func (o *ListGitHubInstallationsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
