// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// CreateGhRepoSyncIntegrationReader is a Reader for the CreateGhRepoSyncIntegration structure.
type CreateGhRepoSyncIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateGhRepoSyncIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateGhRepoSyncIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateGhRepoSyncIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateGhRepoSyncIntegrationOK creates a CreateGhRepoSyncIntegrationOK with default headers values
func NewCreateGhRepoSyncIntegrationOK() *CreateGhRepoSyncIntegrationOK {
	return &CreateGhRepoSyncIntegrationOK{}
}

/*
CreateGhRepoSyncIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateGhRepoSyncIntegrationOK struct {
	Payload *models.Secrets20230613CreateSyncIntegrationResponse
}

// IsSuccess returns true when this create gh repo sync integration o k response has a 2xx status code
func (o *CreateGhRepoSyncIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create gh repo sync integration o k response has a 3xx status code
func (o *CreateGhRepoSyncIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create gh repo sync integration o k response has a 4xx status code
func (o *CreateGhRepoSyncIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create gh repo sync integration o k response has a 5xx status code
func (o *CreateGhRepoSyncIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create gh repo sync integration o k response a status code equal to that given
func (o *CreateGhRepoSyncIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create gh repo sync integration o k response
func (o *CreateGhRepoSyncIntegrationOK) Code() int {
	return 200
}

func (o *CreateGhRepoSyncIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gh-repo][%d] createGhRepoSyncIntegrationOK %s", 200, payload)
}

func (o *CreateGhRepoSyncIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gh-repo][%d] createGhRepoSyncIntegrationOK %s", 200, payload)
}

func (o *CreateGhRepoSyncIntegrationOK) GetPayload() *models.Secrets20230613CreateSyncIntegrationResponse {
	return o.Payload
}

func (o *CreateGhRepoSyncIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613CreateSyncIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGhRepoSyncIntegrationDefault creates a CreateGhRepoSyncIntegrationDefault with default headers values
func NewCreateGhRepoSyncIntegrationDefault(code int) *CreateGhRepoSyncIntegrationDefault {
	return &CreateGhRepoSyncIntegrationDefault{
		_statusCode: code,
	}
}

/*
CreateGhRepoSyncIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateGhRepoSyncIntegrationDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this create gh repo sync integration default response has a 2xx status code
func (o *CreateGhRepoSyncIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create gh repo sync integration default response has a 3xx status code
func (o *CreateGhRepoSyncIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create gh repo sync integration default response has a 4xx status code
func (o *CreateGhRepoSyncIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create gh repo sync integration default response has a 5xx status code
func (o *CreateGhRepoSyncIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create gh repo sync integration default response a status code equal to that given
func (o *CreateGhRepoSyncIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create gh repo sync integration default response
func (o *CreateGhRepoSyncIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *CreateGhRepoSyncIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gh-repo][%d] CreateGhRepoSyncIntegration default %s", o._statusCode, payload)
}

func (o *CreateGhRepoSyncIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gh-repo][%d] CreateGhRepoSyncIntegration default %s", o._statusCode, payload)
}

func (o *CreateGhRepoSyncIntegrationDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *CreateGhRepoSyncIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CreateGhRepoSyncIntegrationBody create gh repo sync integration body
swagger:model CreateGhRepoSyncIntegrationBody
*/
type CreateGhRepoSyncIntegrationBody struct {

	// gh repo connection details
	GhRepoConnectionDetails *models.Secrets20230613GhRepoConnectionDetailsRequest `json:"gh_repo_connection_details,omitempty"`

	// location
	Location *CreateGhRepoSyncIntegrationParamsBodyLocation `json:"location,omitempty"`

	// name
	Name string `json:"name,omitempty"`
}

// Validate validates this create gh repo sync integration body
func (o *CreateGhRepoSyncIntegrationBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGhRepoConnectionDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGhRepoSyncIntegrationBody) validateGhRepoConnectionDetails(formats strfmt.Registry) error {
	if swag.IsZero(o.GhRepoConnectionDetails) { // not required
		return nil
	}

	if o.GhRepoConnectionDetails != nil {
		if err := o.GhRepoConnectionDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "gh_repo_connection_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "gh_repo_connection_details")
			}
			return err
		}
	}

	return nil
}

func (o *CreateGhRepoSyncIntegrationBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create gh repo sync integration body based on the context it is used
func (o *CreateGhRepoSyncIntegrationBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGhRepoConnectionDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGhRepoSyncIntegrationBody) contextValidateGhRepoConnectionDetails(ctx context.Context, formats strfmt.Registry) error {

	if o.GhRepoConnectionDetails != nil {

		if swag.IsZero(o.GhRepoConnectionDetails) { // not required
			return nil
		}

		if err := o.GhRepoConnectionDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "gh_repo_connection_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "gh_repo_connection_details")
			}
			return err
		}
	}

	return nil
}

func (o *CreateGhRepoSyncIntegrationBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateGhRepoSyncIntegrationBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateGhRepoSyncIntegrationBody) UnmarshalBinary(b []byte) error {
	var res CreateGhRepoSyncIntegrationBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CreateGhRepoSyncIntegrationParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model CreateGhRepoSyncIntegrationParamsBodyLocation
*/
type CreateGhRepoSyncIntegrationParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this create gh repo sync integration params body location
func (o *CreateGhRepoSyncIntegrationParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGhRepoSyncIntegrationParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create gh repo sync integration params body location based on the context it is used
func (o *CreateGhRepoSyncIntegrationParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGhRepoSyncIntegrationParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateGhRepoSyncIntegrationParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateGhRepoSyncIntegrationParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res CreateGhRepoSyncIntegrationParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
