// Code generated by go-swagger; DO NOT EDIT.

package integration_connection_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-radar/preview/2023-05-01/models"
)

// GetIntegrationConnectionByNameReader is a Reader for the GetIntegrationConnectionByName structure.
type GetIntegrationConnectionByNameReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetIntegrationConnectionByNameReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetIntegrationConnectionByNameOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetIntegrationConnectionByNameDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetIntegrationConnectionByNameOK creates a GetIntegrationConnectionByNameOK with default headers values
func NewGetIntegrationConnectionByNameOK() *GetIntegrationConnectionByNameOK {
	return &GetIntegrationConnectionByNameOK{}
}

/*
GetIntegrationConnectionByNameOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetIntegrationConnectionByNameOK struct {
	Payload *models.VaultRadar20230501IntegrationConnection
}

// IsSuccess returns true when this get integration connection by name o k response has a 2xx status code
func (o *GetIntegrationConnectionByNameOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get integration connection by name o k response has a 3xx status code
func (o *GetIntegrationConnectionByNameOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get integration connection by name o k response has a 4xx status code
func (o *GetIntegrationConnectionByNameOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get integration connection by name o k response has a 5xx status code
func (o *GetIntegrationConnectionByNameOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get integration connection by name o k response a status code equal to that given
func (o *GetIntegrationConnectionByNameOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get integration connection by name o k response
func (o *GetIntegrationConnectionByNameOK) Code() int {
	return 200
}

func (o *GetIntegrationConnectionByNameOK) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections/search-by-name][%d] getIntegrationConnectionByNameOK  %+v", 200, o.Payload)
}

func (o *GetIntegrationConnectionByNameOK) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections/search-by-name][%d] getIntegrationConnectionByNameOK  %+v", 200, o.Payload)
}

func (o *GetIntegrationConnectionByNameOK) GetPayload() *models.VaultRadar20230501IntegrationConnection {
	return o.Payload
}

func (o *GetIntegrationConnectionByNameOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VaultRadar20230501IntegrationConnection)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIntegrationConnectionByNameDefault creates a GetIntegrationConnectionByNameDefault with default headers values
func NewGetIntegrationConnectionByNameDefault(code int) *GetIntegrationConnectionByNameDefault {
	return &GetIntegrationConnectionByNameDefault{
		_statusCode: code,
	}
}

/*
GetIntegrationConnectionByNameDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetIntegrationConnectionByNameDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this get integration connection by name default response has a 2xx status code
func (o *GetIntegrationConnectionByNameDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get integration connection by name default response has a 3xx status code
func (o *GetIntegrationConnectionByNameDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get integration connection by name default response has a 4xx status code
func (o *GetIntegrationConnectionByNameDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get integration connection by name default response has a 5xx status code
func (o *GetIntegrationConnectionByNameDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get integration connection by name default response a status code equal to that given
func (o *GetIntegrationConnectionByNameDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get integration connection by name default response
func (o *GetIntegrationConnectionByNameDefault) Code() int {
	return o._statusCode
}

func (o *GetIntegrationConnectionByNameDefault) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections/search-by-name][%d] GetIntegrationConnectionByName default  %+v", o._statusCode, o.Payload)
}

func (o *GetIntegrationConnectionByNameDefault) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections/search-by-name][%d] GetIntegrationConnectionByName default  %+v", o._statusCode, o.Payload)
}

func (o *GetIntegrationConnectionByNameDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *GetIntegrationConnectionByNameDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GetIntegrationConnectionByNameBody get integration connection by name body
swagger:model GetIntegrationConnectionByNameBody
*/
type GetIntegrationConnectionByNameBody struct {

	// location
	Location *GetIntegrationConnectionByNameParamsBodyLocation `json:"location,omitempty"`

	// Name is the unique name of the integration connection to retrieve.
	Name string `json:"name,omitempty"`
}

// Validate validates this get integration connection by name body
func (o *GetIntegrationConnectionByNameBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetIntegrationConnectionByNameBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this get integration connection by name body based on the context it is used
func (o *GetIntegrationConnectionByNameBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetIntegrationConnectionByNameBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GetIntegrationConnectionByNameBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetIntegrationConnectionByNameBody) UnmarshalBinary(b []byte) error {
	var res GetIntegrationConnectionByNameBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GetIntegrationConnectionByNameParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model GetIntegrationConnectionByNameParamsBodyLocation
*/
type GetIntegrationConnectionByNameParamsBodyLocation struct {

	// organization_id is the id of the organization.
	OrganizationID string `json:"organization_id,omitempty"`

	// region
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this get integration connection by name params body location
func (o *GetIntegrationConnectionByNameParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetIntegrationConnectionByNameParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this get integration connection by name params body location based on the context it is used
func (o *GetIntegrationConnectionByNameParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetIntegrationConnectionByNameParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GetIntegrationConnectionByNameParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetIntegrationConnectionByNameParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res GetIntegrationConnectionByNameParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
