// Code generated by go-swagger; DO NOT EDIT.

package data_source_registration_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetDataSourceByIDParams creates a new GetDataSourceByIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetDataSourceByIDParams() *GetDataSourceByIDParams {
	return &GetDataSourceByIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetDataSourceByIDParamsWithTimeout creates a new GetDataSourceByIDParams object
// with the ability to set a timeout on a request.
func NewGetDataSourceByIDParamsWithTimeout(timeout time.Duration) *GetDataSourceByIDParams {
	return &GetDataSourceByIDParams{
		timeout: timeout,
	}
}

// NewGetDataSourceByIDParamsWithContext creates a new GetDataSourceByIDParams object
// with the ability to set a context for a request.
func NewGetDataSourceByIDParamsWithContext(ctx context.Context) *GetDataSourceByIDParams {
	return &GetDataSourceByIDParams{
		Context: ctx,
	}
}

// NewGetDataSourceByIDParamsWithHTTPClient creates a new GetDataSourceByIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetDataSourceByIDParamsWithHTTPClient(client *http.Client) *GetDataSourceByIDParams {
	return &GetDataSourceByIDParams{
		HTTPClient: client,
	}
}

/*
GetDataSourceByIDParams contains all the parameters to send to the API endpoint

	for the get data source by ID operation.

	Typically these are written to a http.Request.
*/
type GetDataSourceByIDParams struct {

	// ID.
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID *string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get data source by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDataSourceByIDParams) WithDefaults() *GetDataSourceByIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get data source by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDataSourceByIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get data source by ID params
func (o *GetDataSourceByIDParams) WithTimeout(timeout time.Duration) *GetDataSourceByIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get data source by ID params
func (o *GetDataSourceByIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get data source by ID params
func (o *GetDataSourceByIDParams) WithContext(ctx context.Context) *GetDataSourceByIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get data source by ID params
func (o *GetDataSourceByIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get data source by ID params
func (o *GetDataSourceByIDParams) WithHTTPClient(client *http.Client) *GetDataSourceByIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get data source by ID params
func (o *GetDataSourceByIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the get data source by ID params
func (o *GetDataSourceByIDParams) WithID(id string) *GetDataSourceByIDParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the get data source by ID params
func (o *GetDataSourceByIDParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the get data source by ID params
func (o *GetDataSourceByIDParams) WithLocationOrganizationID(locationOrganizationID *string) *GetDataSourceByIDParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get data source by ID params
func (o *GetDataSourceByIDParams) SetLocationOrganizationID(locationOrganizationID *string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get data source by ID params
func (o *GetDataSourceByIDParams) WithLocationProjectID(locationProjectID string) *GetDataSourceByIDParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get data source by ID params
func (o *GetDataSourceByIDParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get data source by ID params
func (o *GetDataSourceByIDParams) WithLocationRegionProvider(locationRegionProvider *string) *GetDataSourceByIDParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get data source by ID params
func (o *GetDataSourceByIDParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get data source by ID params
func (o *GetDataSourceByIDParams) WithLocationRegionRegion(locationRegionRegion *string) *GetDataSourceByIDParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get data source by ID params
func (o *GetDataSourceByIDParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *GetDataSourceByIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if o.LocationOrganizationID != nil {

		// query param location.organization_id
		var qrLocationOrganizationID string

		if o.LocationOrganizationID != nil {
			qrLocationOrganizationID = *o.LocationOrganizationID
		}
		qLocationOrganizationID := qrLocationOrganizationID
		if qLocationOrganizationID != "" {

			if err := r.SetQueryParam("location.organization_id", qLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
