// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// NewUpdateVersionParams creates a new UpdateVersionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateVersionParams() *UpdateVersionParams {
	return &UpdateVersionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateVersionParamsWithTimeout creates a new UpdateVersionParams object
// with the ability to set a timeout on a request.
func NewUpdateVersionParamsWithTimeout(timeout time.Duration) *UpdateVersionParams {
	return &UpdateVersionParams{
		timeout: timeout,
	}
}

// NewUpdateVersionParamsWithContext creates a new UpdateVersionParams object
// with the ability to set a context for a request.
func NewUpdateVersionParamsWithContext(ctx context.Context) *UpdateVersionParams {
	return &UpdateVersionParams{
		Context: ctx,
	}
}

// NewUpdateVersionParamsWithHTTPClient creates a new UpdateVersionParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateVersionParamsWithHTTPClient(client *http.Client) *UpdateVersionParams {
	return &UpdateVersionParams{
		HTTPClient: client,
	}
}

/*
UpdateVersionParams contains all the parameters to send to the API endpoint

	for the update version operation.

	Typically these are written to a http.Request.
*/
type UpdateVersionParams struct {

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Data.

	   Details of the Version to update.
	*/
	Data *models.HashicorpCloudVagrant20220930Version

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the version to update.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateVersionParams) WithDefaults() *UpdateVersionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateVersionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update version params
func (o *UpdateVersionParams) WithTimeout(timeout time.Duration) *UpdateVersionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update version params
func (o *UpdateVersionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update version params
func (o *UpdateVersionParams) WithContext(ctx context.Context) *UpdateVersionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update version params
func (o *UpdateVersionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update version params
func (o *UpdateVersionParams) WithHTTPClient(client *http.Client) *UpdateVersionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update version params
func (o *UpdateVersionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the update version params
func (o *UpdateVersionParams) WithBox(box string) *UpdateVersionParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the update version params
func (o *UpdateVersionParams) SetBox(box string) {
	o.Box = box
}

// WithData adds the data to the update version params
func (o *UpdateVersionParams) WithData(data *models.HashicorpCloudVagrant20220930Version) *UpdateVersionParams {
	o.SetData(data)
	return o
}

// SetData adds the data to the update version params
func (o *UpdateVersionParams) SetData(data *models.HashicorpCloudVagrant20220930Version) {
	o.Data = data
}

// WithRegistry adds the registry to the update version params
func (o *UpdateVersionParams) WithRegistry(registry string) *UpdateVersionParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the update version params
func (o *UpdateVersionParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the update version params
func (o *UpdateVersionParams) WithVersion(version string) *UpdateVersionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the update version params
func (o *UpdateVersionParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateVersionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}
	if o.Data != nil {
		if err := r.SetBodyParam(o.Data); err != nil {
			return err
		}
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
