// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// NewUpdateArchitectureParams creates a new UpdateArchitectureParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateArchitectureParams() *UpdateArchitectureParams {
	return &UpdateArchitectureParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateArchitectureParamsWithTimeout creates a new UpdateArchitectureParams object
// with the ability to set a timeout on a request.
func NewUpdateArchitectureParamsWithTimeout(timeout time.Duration) *UpdateArchitectureParams {
	return &UpdateArchitectureParams{
		timeout: timeout,
	}
}

// NewUpdateArchitectureParamsWithContext creates a new UpdateArchitectureParams object
// with the ability to set a context for a request.
func NewUpdateArchitectureParamsWithContext(ctx context.Context) *UpdateArchitectureParams {
	return &UpdateArchitectureParams{
		Context: ctx,
	}
}

// NewUpdateArchitectureParamsWithHTTPClient creates a new UpdateArchitectureParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateArchitectureParamsWithHTTPClient(client *http.Client) *UpdateArchitectureParams {
	return &UpdateArchitectureParams{
		HTTPClient: client,
	}
}

/*
UpdateArchitectureParams contains all the parameters to send to the API endpoint

	for the update architecture operation.

	Typically these are written to a http.Request.
*/
type UpdateArchitectureParams struct {

	/* Architecture.

	   The type of the Architecture.
	*/
	Architecture string

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Data.

	   Details of the Architecture to update.
	*/
	Data *models.HashicorpCloudVagrant20220930Architecture

	/* Provider.

	   The name of the Provider.
	*/
	Provider string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version for the Provider.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update architecture params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateArchitectureParams) WithDefaults() *UpdateArchitectureParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update architecture params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateArchitectureParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update architecture params
func (o *UpdateArchitectureParams) WithTimeout(timeout time.Duration) *UpdateArchitectureParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update architecture params
func (o *UpdateArchitectureParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update architecture params
func (o *UpdateArchitectureParams) WithContext(ctx context.Context) *UpdateArchitectureParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update architecture params
func (o *UpdateArchitectureParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update architecture params
func (o *UpdateArchitectureParams) WithHTTPClient(client *http.Client) *UpdateArchitectureParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update architecture params
func (o *UpdateArchitectureParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithArchitecture adds the architecture to the update architecture params
func (o *UpdateArchitectureParams) WithArchitecture(architecture string) *UpdateArchitectureParams {
	o.SetArchitecture(architecture)
	return o
}

// SetArchitecture adds the architecture to the update architecture params
func (o *UpdateArchitectureParams) SetArchitecture(architecture string) {
	o.Architecture = architecture
}

// WithBox adds the box to the update architecture params
func (o *UpdateArchitectureParams) WithBox(box string) *UpdateArchitectureParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the update architecture params
func (o *UpdateArchitectureParams) SetBox(box string) {
	o.Box = box
}

// WithData adds the data to the update architecture params
func (o *UpdateArchitectureParams) WithData(data *models.HashicorpCloudVagrant20220930Architecture) *UpdateArchitectureParams {
	o.SetData(data)
	return o
}

// SetData adds the data to the update architecture params
func (o *UpdateArchitectureParams) SetData(data *models.HashicorpCloudVagrant20220930Architecture) {
	o.Data = data
}

// WithProvider adds the provider to the update architecture params
func (o *UpdateArchitectureParams) WithProvider(provider string) *UpdateArchitectureParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the update architecture params
func (o *UpdateArchitectureParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithRegistry adds the registry to the update architecture params
func (o *UpdateArchitectureParams) WithRegistry(registry string) *UpdateArchitectureParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the update architecture params
func (o *UpdateArchitectureParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the update architecture params
func (o *UpdateArchitectureParams) WithVersion(version string) *UpdateArchitectureParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the update architecture params
func (o *UpdateArchitectureParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateArchitectureParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param architecture
	if err := r.SetPathParam("architecture", o.Architecture); err != nil {
		return err
	}

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}
	if o.Data != nil {
		if err := r.SetBodyParam(o.Data); err != nil {
			return err
		}
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
