// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// DirectUploadBoxReader is a Reader for the DirectUploadBox structure.
type DirectUploadBoxReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DirectUploadBoxReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDirectUploadBoxOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDirectUploadBoxDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDirectUploadBoxOK creates a DirectUploadBoxOK with default headers values
func NewDirectUploadBoxOK() *DirectUploadBoxOK {
	return &DirectUploadBoxOK{}
}

/*
DirectUploadBoxOK describes a response with status code 200, with default header values.

A successful response.
*/
type DirectUploadBoxOK struct {
	Payload *models.HashicorpCloudVagrant20220930DirectUploadBoxResponse
}

// IsSuccess returns true when this direct upload box o k response has a 2xx status code
func (o *DirectUploadBoxOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this direct upload box o k response has a 3xx status code
func (o *DirectUploadBoxOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this direct upload box o k response has a 4xx status code
func (o *DirectUploadBoxOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this direct upload box o k response has a 5xx status code
func (o *DirectUploadBoxOK) IsServerError() bool {
	return false
}

// IsCode returns true when this direct upload box o k response a status code equal to that given
func (o *DirectUploadBoxOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the direct upload box o k response
func (o *DirectUploadBoxOK) Code() int {
	return 200
}

func (o *DirectUploadBoxOK) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/direct/upload][%d] directUploadBoxOK  %+v", 200, o.Payload)
}

func (o *DirectUploadBoxOK) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/direct/upload][%d] directUploadBoxOK  %+v", 200, o.Payload)
}

func (o *DirectUploadBoxOK) GetPayload() *models.HashicorpCloudVagrant20220930DirectUploadBoxResponse {
	return o.Payload
}

func (o *DirectUploadBoxOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930DirectUploadBoxResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDirectUploadBoxDefault creates a DirectUploadBoxDefault with default headers values
func NewDirectUploadBoxDefault(code int) *DirectUploadBoxDefault {
	return &DirectUploadBoxDefault{
		_statusCode: code,
	}
}

/*
DirectUploadBoxDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DirectUploadBoxDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this direct upload box default response has a 2xx status code
func (o *DirectUploadBoxDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this direct upload box default response has a 3xx status code
func (o *DirectUploadBoxDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this direct upload box default response has a 4xx status code
func (o *DirectUploadBoxDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this direct upload box default response has a 5xx status code
func (o *DirectUploadBoxDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this direct upload box default response a status code equal to that given
func (o *DirectUploadBoxDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the direct upload box default response
func (o *DirectUploadBoxDefault) Code() int {
	return o._statusCode
}

func (o *DirectUploadBoxDefault) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/direct/upload][%d] DirectUploadBox default  %+v", o._statusCode, o.Payload)
}

func (o *DirectUploadBoxDefault) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/direct/upload][%d] DirectUploadBox default  %+v", o._statusCode, o.Payload)
}

func (o *DirectUploadBoxDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *DirectUploadBoxDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
