// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudPacker20230101RegistryConfig The HCP Packer Registry configuration.
//
// swagger:model hashicorp.cloud.packer_20230101.RegistryConfig
type HashicorpCloudPacker20230101RegistryConfig struct {

	// Current state of the registry. A registry is activated when the system
	// correctly starts billing for it.
	Activated bool `json:"activated,omitempty"`

	// Information about the billing deactivation.
	BillingDeprovision *HashicorpCloudPacker20230101RegistryBillingDeprovision `json:"billing_deprovision,omitempty"`

	// Feature tier for the registry.
	FeatureTier *HashicorpCloudPacker20230101RegistryConfigTier `json:"feature_tier,omitempty"`

	// Required configuration to run TFC run tasks for validation against this
	// registry.
	TfcRunTaskConfig *HashicorpCloudPacker20230101RegistryTFCRunTaskConfig `json:"tfc_run_task_config,omitempty"`
}

// Validate validates this hashicorp cloud packer 20230101 registry config
func (m *HashicorpCloudPacker20230101RegistryConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBillingDeprovision(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFeatureTier(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTfcRunTaskConfig(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20230101RegistryConfig) validateBillingDeprovision(formats strfmt.Registry) error {
	if swag.IsZero(m.BillingDeprovision) { // not required
		return nil
	}

	if m.BillingDeprovision != nil {
		if err := m.BillingDeprovision.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("billing_deprovision")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("billing_deprovision")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101RegistryConfig) validateFeatureTier(formats strfmt.Registry) error {
	if swag.IsZero(m.FeatureTier) { // not required
		return nil
	}

	if m.FeatureTier != nil {
		if err := m.FeatureTier.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("feature_tier")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("feature_tier")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101RegistryConfig) validateTfcRunTaskConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.TfcRunTaskConfig) { // not required
		return nil
	}

	if m.TfcRunTaskConfig != nil {
		if err := m.TfcRunTaskConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tfc_run_task_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tfc_run_task_config")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud packer 20230101 registry config based on the context it is used
func (m *HashicorpCloudPacker20230101RegistryConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBillingDeprovision(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFeatureTier(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTfcRunTaskConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20230101RegistryConfig) contextValidateBillingDeprovision(ctx context.Context, formats strfmt.Registry) error {

	if m.BillingDeprovision != nil {

		if swag.IsZero(m.BillingDeprovision) { // not required
			return nil
		}

		if err := m.BillingDeprovision.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("billing_deprovision")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("billing_deprovision")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101RegistryConfig) contextValidateFeatureTier(ctx context.Context, formats strfmt.Registry) error {

	if m.FeatureTier != nil {

		if swag.IsZero(m.FeatureTier) { // not required
			return nil
		}

		if err := m.FeatureTier.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("feature_tier")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("feature_tier")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101RegistryConfig) contextValidateTfcRunTaskConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.TfcRunTaskConfig != nil {

		if swag.IsZero(m.TfcRunTaskConfig) { // not required
			return nil
		}

		if err := m.TfcRunTaskConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tfc_run_task_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tfc_run_task_config")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudPacker20230101RegistryConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudPacker20230101RegistryConfig) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudPacker20230101RegistryConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
