// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewPackerServiceGetVersionParams creates a new PackerServiceGetVersionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceGetVersionParams() *PackerServiceGetVersionParams {
	return &PackerServiceGetVersionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceGetVersionParamsWithTimeout creates a new PackerServiceGetVersionParams object
// with the ability to set a timeout on a request.
func NewPackerServiceGetVersionParamsWithTimeout(timeout time.Duration) *PackerServiceGetVersionParams {
	return &PackerServiceGetVersionParams{
		timeout: timeout,
	}
}

// NewPackerServiceGetVersionParamsWithContext creates a new PackerServiceGetVersionParams object
// with the ability to set a context for a request.
func NewPackerServiceGetVersionParamsWithContext(ctx context.Context) *PackerServiceGetVersionParams {
	return &PackerServiceGetVersionParams{
		Context: ctx,
	}
}

// NewPackerServiceGetVersionParamsWithHTTPClient creates a new PackerServiceGetVersionParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceGetVersionParamsWithHTTPClient(client *http.Client) *PackerServiceGetVersionParams {
	return &PackerServiceGetVersionParams{
		HTTPClient: client,
	}
}

/*
PackerServiceGetVersionParams contains all the parameters to send to the API endpoint

	for the packer service get version operation.

	Typically these are written to a http.Request.
*/
type PackerServiceGetVersionParams struct {

	// BucketName.
	BucketName string

	// Fingerprint.
	Fingerprint string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service get version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetVersionParams) WithDefaults() *PackerServiceGetVersionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service get version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetVersionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service get version params
func (o *PackerServiceGetVersionParams) WithTimeout(timeout time.Duration) *PackerServiceGetVersionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service get version params
func (o *PackerServiceGetVersionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service get version params
func (o *PackerServiceGetVersionParams) WithContext(ctx context.Context) *PackerServiceGetVersionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service get version params
func (o *PackerServiceGetVersionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service get version params
func (o *PackerServiceGetVersionParams) WithHTTPClient(client *http.Client) *PackerServiceGetVersionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service get version params
func (o *PackerServiceGetVersionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBucketName adds the bucketName to the packer service get version params
func (o *PackerServiceGetVersionParams) WithBucketName(bucketName string) *PackerServiceGetVersionParams {
	o.SetBucketName(bucketName)
	return o
}

// SetBucketName adds the bucketName to the packer service get version params
func (o *PackerServiceGetVersionParams) SetBucketName(bucketName string) {
	o.BucketName = bucketName
}

// WithFingerprint adds the fingerprint to the packer service get version params
func (o *PackerServiceGetVersionParams) WithFingerprint(fingerprint string) *PackerServiceGetVersionParams {
	o.SetFingerprint(fingerprint)
	return o
}

// SetFingerprint adds the fingerprint to the packer service get version params
func (o *PackerServiceGetVersionParams) SetFingerprint(fingerprint string) {
	o.Fingerprint = fingerprint
}

// WithLocationOrganizationID adds the locationOrganizationID to the packer service get version params
func (o *PackerServiceGetVersionParams) WithLocationOrganizationID(locationOrganizationID string) *PackerServiceGetVersionParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the packer service get version params
func (o *PackerServiceGetVersionParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the packer service get version params
func (o *PackerServiceGetVersionParams) WithLocationProjectID(locationProjectID string) *PackerServiceGetVersionParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the packer service get version params
func (o *PackerServiceGetVersionParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the packer service get version params
func (o *PackerServiceGetVersionParams) WithLocationRegionProvider(locationRegionProvider *string) *PackerServiceGetVersionParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the packer service get version params
func (o *PackerServiceGetVersionParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the packer service get version params
func (o *PackerServiceGetVersionParams) WithLocationRegionRegion(locationRegionRegion *string) *PackerServiceGetVersionParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the packer service get version params
func (o *PackerServiceGetVersionParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceGetVersionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param bucket_name
	if err := r.SetPathParam("bucket_name", o.BucketName); err != nil {
		return err
	}

	// path param fingerprint
	if err := r.SetPathParam("fingerprint", o.Fingerprint); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
