// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewBoundaryServiceClusterUpdateDeadlineGetParams creates a new BoundaryServiceClusterUpdateDeadlineGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBoundaryServiceClusterUpdateDeadlineGetParams() *BoundaryServiceClusterUpdateDeadlineGetParams {
	return &BoundaryServiceClusterUpdateDeadlineGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBoundaryServiceClusterUpdateDeadlineGetParamsWithTimeout creates a new BoundaryServiceClusterUpdateDeadlineGetParams object
// with the ability to set a timeout on a request.
func NewBoundaryServiceClusterUpdateDeadlineGetParamsWithTimeout(timeout time.Duration) *BoundaryServiceClusterUpdateDeadlineGetParams {
	return &BoundaryServiceClusterUpdateDeadlineGetParams{
		timeout: timeout,
	}
}

// NewBoundaryServiceClusterUpdateDeadlineGetParamsWithContext creates a new BoundaryServiceClusterUpdateDeadlineGetParams object
// with the ability to set a context for a request.
func NewBoundaryServiceClusterUpdateDeadlineGetParamsWithContext(ctx context.Context) *BoundaryServiceClusterUpdateDeadlineGetParams {
	return &BoundaryServiceClusterUpdateDeadlineGetParams{
		Context: ctx,
	}
}

// NewBoundaryServiceClusterUpdateDeadlineGetParamsWithHTTPClient creates a new BoundaryServiceClusterUpdateDeadlineGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewBoundaryServiceClusterUpdateDeadlineGetParamsWithHTTPClient(client *http.Client) *BoundaryServiceClusterUpdateDeadlineGetParams {
	return &BoundaryServiceClusterUpdateDeadlineGetParams{
		HTTPClient: client,
	}
}

/*
BoundaryServiceClusterUpdateDeadlineGetParams contains all the parameters to send to the API endpoint

	for the boundary service cluster update deadline get operation.

	Typically these are written to a http.Request.
*/
type BoundaryServiceClusterUpdateDeadlineGetParams struct {

	/* ClusterID.

	   cluster_id is the id of the cluster set by user on creation.
	*/
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the boundary service cluster update deadline get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) WithDefaults() *BoundaryServiceClusterUpdateDeadlineGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the boundary service cluster update deadline get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) WithTimeout(timeout time.Duration) *BoundaryServiceClusterUpdateDeadlineGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) WithContext(ctx context.Context) *BoundaryServiceClusterUpdateDeadlineGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) WithHTTPClient(client *http.Client) *BoundaryServiceClusterUpdateDeadlineGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) WithClusterID(clusterID string) *BoundaryServiceClusterUpdateDeadlineGetParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) WithLocationOrganizationID(locationOrganizationID string) *BoundaryServiceClusterUpdateDeadlineGetParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) WithLocationProjectID(locationProjectID string) *BoundaryServiceClusterUpdateDeadlineGetParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) WithLocationRegionProvider(locationRegionProvider *string) *BoundaryServiceClusterUpdateDeadlineGetParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) WithLocationRegionRegion(locationRegionRegion *string) *BoundaryServiceClusterUpdateDeadlineGetParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the boundary service cluster update deadline get params
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *BoundaryServiceClusterUpdateDeadlineGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
