// Code generated by go-swagger; DO NOT EDIT.

package invoice_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewInvoiceServiceGetUsageParams creates a new InvoiceServiceGetUsageParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewInvoiceServiceGetUsageParams() *InvoiceServiceGetUsageParams {
	return &InvoiceServiceGetUsageParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewInvoiceServiceGetUsageParamsWithTimeout creates a new InvoiceServiceGetUsageParams object
// with the ability to set a timeout on a request.
func NewInvoiceServiceGetUsageParamsWithTimeout(timeout time.Duration) *InvoiceServiceGetUsageParams {
	return &InvoiceServiceGetUsageParams{
		timeout: timeout,
	}
}

// NewInvoiceServiceGetUsageParamsWithContext creates a new InvoiceServiceGetUsageParams object
// with the ability to set a context for a request.
func NewInvoiceServiceGetUsageParamsWithContext(ctx context.Context) *InvoiceServiceGetUsageParams {
	return &InvoiceServiceGetUsageParams{
		Context: ctx,
	}
}

// NewInvoiceServiceGetUsageParamsWithHTTPClient creates a new InvoiceServiceGetUsageParams object
// with the ability to set a custom HTTPClient for a request.
func NewInvoiceServiceGetUsageParamsWithHTTPClient(client *http.Client) *InvoiceServiceGetUsageParams {
	return &InvoiceServiceGetUsageParams{
		HTTPClient: client,
	}
}

/*
InvoiceServiceGetUsageParams contains all the parameters to send to the API endpoint

	for the invoice service get usage operation.

	Typically these are written to a http.Request.
*/
type InvoiceServiceGetUsageParams struct {

	/* BillingAccountID.

	     id is the user-settable ID that uniquely identifies the Billing Account
	within the organization.
	*/
	BillingAccountID string

	/* OrganizationID.

	     organization_id is the ID of the organization to which the Billing Account
	belongs.
	*/
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the invoice service get usage params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *InvoiceServiceGetUsageParams) WithDefaults() *InvoiceServiceGetUsageParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the invoice service get usage params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *InvoiceServiceGetUsageParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the invoice service get usage params
func (o *InvoiceServiceGetUsageParams) WithTimeout(timeout time.Duration) *InvoiceServiceGetUsageParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the invoice service get usage params
func (o *InvoiceServiceGetUsageParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the invoice service get usage params
func (o *InvoiceServiceGetUsageParams) WithContext(ctx context.Context) *InvoiceServiceGetUsageParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the invoice service get usage params
func (o *InvoiceServiceGetUsageParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the invoice service get usage params
func (o *InvoiceServiceGetUsageParams) WithHTTPClient(client *http.Client) *InvoiceServiceGetUsageParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the invoice service get usage params
func (o *InvoiceServiceGetUsageParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBillingAccountID adds the billingAccountID to the invoice service get usage params
func (o *InvoiceServiceGetUsageParams) WithBillingAccountID(billingAccountID string) *InvoiceServiceGetUsageParams {
	o.SetBillingAccountID(billingAccountID)
	return o
}

// SetBillingAccountID adds the billingAccountId to the invoice service get usage params
func (o *InvoiceServiceGetUsageParams) SetBillingAccountID(billingAccountID string) {
	o.BillingAccountID = billingAccountID
}

// WithOrganizationID adds the organizationID to the invoice service get usage params
func (o *InvoiceServiceGetUsageParams) WithOrganizationID(organizationID string) *InvoiceServiceGetUsageParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the invoice service get usage params
func (o *InvoiceServiceGetUsageParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *InvoiceServiceGetUsageParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param billing_account_id
	if err := r.SetPathParam("billing_account_id", o.BillingAccountID); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
