/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.BytesInputStream;
import net.wimpi.modbus.io.BytesOutputStream;
import net.wimpi.modbus.io.ModbusTCPTransport;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTCPRTUTransport
extends ModbusTCPTransport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusTCPRTUTransport.class);
    private byte[] m_InBuffer;
    private BytesOutputStream m_ByteOut;
    private BytesOutputStream m_ByteInOut;
    private byte[] lastRequest = null;

    public ModbusTCPRTUTransport(Socket socket) {
        super(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            BytesOutputStream bytesOutputStream = this.m_ByteOut;
            synchronized (bytesOutputStream) {
                this.m_ByteOut.reset();
                msg.setHeadless();
                msg.writeTo(this.m_ByteOut);
                int len = this.m_ByteOut.size();
                int[] crc = ModbusUtil.calculateCRC(this.m_ByteOut.getBuffer(), 0, len);
                this.m_ByteOut.writeByte(crc[0]);
                this.m_ByteOut.writeByte(crc[1]);
                len = this.m_ByteOut.size();
                byte[] buf = this.m_ByteOut.getBuffer();
                this.m_Output.write(buf, 0, len);
                this.m_Output.flush();
                logger.debug("Sent: {}", (Object)ModbusUtil.toHex(buf, 0, len));
                this.lastRequest = new byte[len];
                System.arraycopy(buf, 0, this.lastRequest, 0, len);
            }
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O failed to write");
        }
    }

    @Override
    public ModbusRequest readRequest() throws ModbusIOException {
        throw new RuntimeException("Operation not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        ModbusResponse response = null;
        int dlength = 0;
        try {
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                int uid = this.m_Input.read();
                logger.trace("Managed to read at least one byte");
                if (uid != -1) {
                    int fc = this.m_Input.read();
                    this.m_ByteInOut.reset();
                    this.m_ByteInOut.writeByte(uid);
                    this.m_ByteInOut.writeByte(fc);
                    response = ModbusResponse.createModbusResponse(fc);
                    response.setHeadless();
                    this.getResponse(fc, this.m_ByteInOut);
                    dlength = this.m_ByteInOut.size() - 2;
                    logger.debug("Response: {}", (Object)ModbusUtil.toHex(this.m_ByteInOut.getBuffer(), 0, dlength + 2));
                    this.m_ByteIn.reset(this.m_InBuffer, dlength);
                    int[] crc = ModbusUtil.calculateCRC(this.m_InBuffer, 0, dlength);
                    if (ModbusUtil.unsignedByteToInt(this.m_InBuffer[dlength]) != crc[0] || ModbusUtil.unsignedByteToInt(this.m_InBuffer[dlength + 1]) != crc[1]) {
                        throw new IOException("CRC Error in received frame: " + dlength + " bytes: " + ModbusUtil.toHex(this.m_ByteIn.getBuffer(), 0, dlength));
                    }
                } else {
                    throw new IOException("Error reading response (EOF)");
                }
                this.m_ByteIn.reset(this.m_InBuffer, dlength);
                response.readFrom(this.m_ByteIn);
            }
            return response;
        }
        catch (Exception ex) {
            String errMsg = "failed to read";
            logger.debug("Last request: {}", (Object)ModbusUtil.toHex(this.lastRequest));
            logger.debug("{}: {}", (Object)"failed to read", (Object)ex.getMessage());
            throw new ModbusIOException(String.format("I/O exception: %s %s", ex.getClass().getSimpleName(), ex.getMessage()));
        }
    }

    @Override
    protected void prepareStreams(Socket socket) throws IOException {
        this.m_Input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.m_Output = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.m_ByteOut = new BytesOutputStream(256);
        this.m_InBuffer = new byte[256];
        this.m_ByteIn = new BytesInputStream(this.m_InBuffer);
        this.m_ByteInOut = new BytesOutputStream(this.m_InBuffer);
    }

    private void getResponse(int fn, BytesOutputStream out) throws IOException {
        int bc = -1;
        int bc2 = -1;
        int bcw = -1;
        byte[] inpBuf = new byte[256];
        switch (fn) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 23: {
                bc = this.m_Input.read();
                out.write(bc);
                this.m_Input.readFully(inpBuf, 0, bc + 2);
                out.write(inpBuf, 0, bc + 2);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 15: 
            case 16: {
                this.m_Input.readFully(inpBuf, 0, 6);
                out.write(inpBuf, 0, 6);
                break;
            }
            case 7: 
            case 8: {
                this.m_Input.readFully(inpBuf, 0, 3);
                out.write(inpBuf, 0, 3);
                break;
            }
            case 22: {
                this.m_Input.readFully(inpBuf, 0, 8);
                out.write(inpBuf, 0, 8);
                break;
            }
            case 24: {
                bc = this.m_Input.read();
                out.write(bc);
                bc2 = this.m_Input.read();
                out.write(bc2);
                bcw = ModbusUtil.makeWord(bc, bc2);
                this.m_Input.readFully(inpBuf, 0, bcw + 2);
                out.write(inpBuf, 0, bcw + 2);
            }
        }
    }
}

