/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.iterative;

import java.net.InetAddress;
import org.minidns.MiniDnsException;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsqueryresult.DnsQueryResult;

public abstract class IterativeClientException
extends MiniDnsException {
    private static final long serialVersionUID = 1L;

    protected IterativeClientException(String message) {
        super(message);
    }

    public static class NotAuthoritativeNorGlueRrFound
    extends IterativeClientException {
        private static final long serialVersionUID = 1L;
        private final DnsMessage request;
        private final DnsQueryResult result;
        private final DnsName authoritativeZone;

        public NotAuthoritativeNorGlueRrFound(DnsMessage request, DnsQueryResult result, DnsName authoritativeZone) {
            super("Did not receive an authoritative answer, nor did the result contain any glue records");
            this.request = request;
            this.result = result;
            this.authoritativeZone = authoritativeZone;
        }

        public DnsMessage getRequest() {
            return this.request;
        }

        public DnsQueryResult getResult() {
            return this.result;
        }

        public DnsName getAuthoritativeZone() {
            return this.authoritativeZone;
        }
    }

    public static class MaxIterativeStepsReached
    extends IterativeClientException {
        private static final long serialVersionUID = 1L;

        public MaxIterativeStepsReached() {
            super("Maxmimum steps reached");
        }
    }

    public static class LoopDetected
    extends IterativeClientException {
        private static final long serialVersionUID = 1L;
        public final InetAddress address;
        public final Question question;

        public LoopDetected(InetAddress address, Question question) {
            super("Resolution loop detected: We already asked " + String.valueOf(address) + " about " + String.valueOf(question));
            this.address = address;
            this.question = question;
        }
    }
}

