/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hashes.element;

import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.hashes.HashManager;

public class HashElement
implements ExtensionElement {
    public static final String ELEMENT = "hash";
    public static final String ATTR_ALGO = "algo";
    public static final QName QNAME = new QName(HashManager.NAMESPACE.V2.toString(), "hash");
    private final HashManager.ALGORITHM algorithm;
    private final byte[] hash;
    private final String hashB64;

    public HashElement(HashManager.ALGORITHM algorithm, byte[] hash) {
        this.algorithm = Objects.requireNonNull(algorithm);
        this.hash = Objects.requireNonNull(hash);
        this.hashB64 = Base64.encodeToString(hash);
    }

    public HashElement(HashManager.ALGORITHM algorithm, String hashB64) {
        this.algorithm = algorithm;
        this.hash = Base64.decode(hashB64);
        this.hashB64 = hashB64;
    }

    public HashManager.ALGORITHM getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String getHashB64() {
        return this.hashB64;
    }

    @Override
    public String getElementName() {
        return QNAME.getLocalPart();
    }

    @Override
    public String getNamespace() {
        return QNAME.getNamespaceURI();
    }

    @Override
    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder sb = new XmlStringBuilder(this);
        sb.attribute(ATTR_ALGO, this.algorithm.toString());
        sb.rightAngleBracket();
        sb.append(this.hashB64);
        sb.closeElement(this);
        return sb;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof HashElement)) {
            return false;
        }
        HashElement otherHashElement = (HashElement)other;
        return this.getAlgorithm() == otherHashElement.getAlgorithm() && this.getHashB64().equals(otherHashElement.getHashB64());
    }

    public int hashCode() {
        return this.toXML().toString().hashCode();
    }
}

