/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.file_metadata.provider;

import java.io.IOException;
import java.text.ParseException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.file_metadata.element.FileMetadataElement;
import org.jivesoftware.smackx.hashes.provider.HashElementProvider;
import org.jivesoftware.smackx.thumbnails.provider.ThumbnailElementProvider;
import org.jxmpp.JxmppContext;

public class FileMetadataElementProvider
extends ExtensionElementProvider<FileMetadataElement> {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public FileMetadataElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException, ParseException {
        FileMetadataElement.Builder builder = FileMetadataElement.builder();
        while (true) {
            XmlPullParser.Event event = parser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "file": {
                            parser.next();
                            break block0;
                        }
                        case "date": {
                            builder.setModificationDate(ParserUtils.getDateFromNextText(parser));
                            break block0;
                        }
                        case "desc": {
                            String lang = ParserUtils.getXmlLang(parser);
                            builder.addDescription(ParserUtils.getRequiredNextText(parser), lang);
                            break block0;
                        }
                        case "dimensions": {
                            String dimensions = ParserUtils.getRequiredNextText(parser);
                            String[] split = dimensions.split("x");
                            if (split.length != 2) {
                                throw new IllegalArgumentException("Invalid dimensions.");
                            }
                            builder.setWidth(Integer.parseInt(split[0]));
                            builder.setHeight(Integer.parseInt(split[1]));
                            break block0;
                        }
                        case "width": {
                            builder.setWidth(Integer.parseInt(ParserUtils.getRequiredNextText(parser)));
                            break block0;
                        }
                        case "height": {
                            builder.setHeight(Integer.parseInt(ParserUtils.getRequiredNextText(parser)));
                            break block0;
                        }
                        case "length": {
                            builder.setLength(Long.parseLong(ParserUtils.getRequiredNextText(parser)));
                            break block0;
                        }
                        case "media-type": {
                            builder.setMediaType(ParserUtils.getRequiredNextText(parser));
                            break block0;
                        }
                        case "name": {
                            builder.setName(ParserUtils.getRequiredNextText(parser));
                            break block0;
                        }
                        case "size": {
                            builder.setSize(Long.parseLong(ParserUtils.getRequiredNextText(parser)));
                            break block0;
                        }
                        case "hash": {
                            builder.addHash(HashElementProvider.INSTANCE.parse(parser, parser.getDepth(), xmlEnvironment, null));
                            break block0;
                        }
                        case "thumbnail": {
                            ThumbnailElementProvider provider = new ThumbnailElementProvider();
                            builder.addThumbnail(provider.parse(parser, parser.getDepth(), xmlEnvironment, null));
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return builder.build();
                }
            }
        }
    }
}

