/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.math.BigDecimal;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.handler.BaseConditionModuleHandler;
import org.openhab.core.config.core.Configuration;

@NonNullByDefault
public class IntervalConditionHandler
extends BaseConditionModuleHandler {
    public static final String MODULE_TYPE_ID = "timer.IntervalCondition";
    public static final String CFG_MIN_INTERVAL = "minInterval";
    private long minInterval;
    private @Nullable Long lastAcceptedTime = null;

    public IntervalConditionHandler(Condition condition) {
        super(condition);
        Configuration configuration = ((Condition)this.module).getConfiguration();
        this.minInterval = ((BigDecimal)configuration.get(CFG_MIN_INTERVAL)).longValue() * 1000000L;
    }

    @Override
    public boolean isSatisfied(Map<String, Object> inputs) {
        long currentTime = System.nanoTime();
        if (this.lastAcceptedTime == null || currentTime - this.lastAcceptedTime >= this.minInterval) {
            this.lastAcceptedTime = currentTime;
            return true;
        }
        return false;
    }
}

