/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	gentype "k8s.io/client-go/gentype"
	monitoringv1 "kubevirt.io/client-go/prometheusoperator/typed/monitoring/v1"
)

// fakeServiceMonitors implements ServiceMonitorInterface
type fakeServiceMonitors struct {
	*gentype.FakeClientWithList[*v1.ServiceMonitor, *v1.ServiceMonitorList]
	Fake *FakeMonitoringV1
}

func newFakeServiceMonitors(fake *FakeMonitoringV1, namespace string) monitoringv1.ServiceMonitorInterface {
	return &fakeServiceMonitors{
		gentype.NewFakeClientWithList[*v1.ServiceMonitor, *v1.ServiceMonitorList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("servicemonitors"),
			v1.SchemeGroupVersion.WithKind("ServiceMonitor"),
			func() *v1.ServiceMonitor { return &v1.ServiceMonitor{} },
			func() *v1.ServiceMonitorList { return &v1.ServiceMonitorList{} },
			func(dst, src *v1.ServiceMonitorList) { dst.ListMeta = src.ListMeta },
			func(list *v1.ServiceMonitorList) []*v1.ServiceMonitor { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.ServiceMonitorList, items []*v1.ServiceMonitor) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
