/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	exportv1beta1 "kubevirt.io/api/export/v1beta1"
	scheme "kubevirt.io/client-go/kubevirt/scheme"
)

// VirtualMachineExportsGetter has a method to return a VirtualMachineExportInterface.
// A group's client should implement this interface.
type VirtualMachineExportsGetter interface {
	VirtualMachineExports(namespace string) VirtualMachineExportInterface
}

// VirtualMachineExportInterface has methods to work with VirtualMachineExport resources.
type VirtualMachineExportInterface interface {
	Create(ctx context.Context, virtualMachineExport *exportv1beta1.VirtualMachineExport, opts v1.CreateOptions) (*exportv1beta1.VirtualMachineExport, error)
	Update(ctx context.Context, virtualMachineExport *exportv1beta1.VirtualMachineExport, opts v1.UpdateOptions) (*exportv1beta1.VirtualMachineExport, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, virtualMachineExport *exportv1beta1.VirtualMachineExport, opts v1.UpdateOptions) (*exportv1beta1.VirtualMachineExport, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*exportv1beta1.VirtualMachineExport, error)
	List(ctx context.Context, opts v1.ListOptions) (*exportv1beta1.VirtualMachineExportList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *exportv1beta1.VirtualMachineExport, err error)
	VirtualMachineExportExpansion
}

// virtualMachineExports implements VirtualMachineExportInterface
type virtualMachineExports struct {
	*gentype.ClientWithList[*exportv1beta1.VirtualMachineExport, *exportv1beta1.VirtualMachineExportList]
}

// newVirtualMachineExports returns a VirtualMachineExports
func newVirtualMachineExports(c *ExportV1beta1Client, namespace string) *virtualMachineExports {
	return &virtualMachineExports{
		gentype.NewClientWithList[*exportv1beta1.VirtualMachineExport, *exportv1beta1.VirtualMachineExportList](
			"virtualmachineexports",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *exportv1beta1.VirtualMachineExport { return &exportv1beta1.VirtualMachineExport{} },
			func() *exportv1beta1.VirtualMachineExportList { return &exportv1beta1.VirtualMachineExportList{} },
		),
	}
}
