/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	volumesnapshotv1 "github.com/kubernetes-csi/external-snapshotter/client/v4/apis/volumesnapshot/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	scheme "kubevirt.io/client-go/externalsnapshotter/scheme"
)

// VolumeSnapshotsGetter has a method to return a VolumeSnapshotInterface.
// A group's client should implement this interface.
type VolumeSnapshotsGetter interface {
	VolumeSnapshots(namespace string) VolumeSnapshotInterface
}

// VolumeSnapshotInterface has methods to work with VolumeSnapshot resources.
type VolumeSnapshotInterface interface {
	Create(ctx context.Context, volumeSnapshot *volumesnapshotv1.VolumeSnapshot, opts metav1.CreateOptions) (*volumesnapshotv1.VolumeSnapshot, error)
	Update(ctx context.Context, volumeSnapshot *volumesnapshotv1.VolumeSnapshot, opts metav1.UpdateOptions) (*volumesnapshotv1.VolumeSnapshot, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, volumeSnapshot *volumesnapshotv1.VolumeSnapshot, opts metav1.UpdateOptions) (*volumesnapshotv1.VolumeSnapshot, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*volumesnapshotv1.VolumeSnapshot, error)
	List(ctx context.Context, opts metav1.ListOptions) (*volumesnapshotv1.VolumeSnapshotList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *volumesnapshotv1.VolumeSnapshot, err error)
	VolumeSnapshotExpansion
}

// volumeSnapshots implements VolumeSnapshotInterface
type volumeSnapshots struct {
	*gentype.ClientWithList[*volumesnapshotv1.VolumeSnapshot, *volumesnapshotv1.VolumeSnapshotList]
}

// newVolumeSnapshots returns a VolumeSnapshots
func newVolumeSnapshots(c *SnapshotV1Client, namespace string) *volumeSnapshots {
	return &volumeSnapshots{
		gentype.NewClientWithList[*volumesnapshotv1.VolumeSnapshot, *volumesnapshotv1.VolumeSnapshotList](
			"volumesnapshots",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *volumesnapshotv1.VolumeSnapshot { return &volumesnapshotv1.VolumeSnapshot{} },
			func() *volumesnapshotv1.VolumeSnapshotList { return &volumesnapshotv1.VolumeSnapshotList{} },
		),
	}
}
