/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	scheme "kubevirt.io/client-go/containerizeddataimporter/scheme"
	corev1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// VolumeUploadSourcesGetter has a method to return a VolumeUploadSourceInterface.
// A group's client should implement this interface.
type VolumeUploadSourcesGetter interface {
	VolumeUploadSources(namespace string) VolumeUploadSourceInterface
}

// VolumeUploadSourceInterface has methods to work with VolumeUploadSource resources.
type VolumeUploadSourceInterface interface {
	Create(ctx context.Context, volumeUploadSource *corev1beta1.VolumeUploadSource, opts v1.CreateOptions) (*corev1beta1.VolumeUploadSource, error)
	Update(ctx context.Context, volumeUploadSource *corev1beta1.VolumeUploadSource, opts v1.UpdateOptions) (*corev1beta1.VolumeUploadSource, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, volumeUploadSource *corev1beta1.VolumeUploadSource, opts v1.UpdateOptions) (*corev1beta1.VolumeUploadSource, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*corev1beta1.VolumeUploadSource, error)
	List(ctx context.Context, opts v1.ListOptions) (*corev1beta1.VolumeUploadSourceList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *corev1beta1.VolumeUploadSource, err error)
	VolumeUploadSourceExpansion
}

// volumeUploadSources implements VolumeUploadSourceInterface
type volumeUploadSources struct {
	*gentype.ClientWithList[*corev1beta1.VolumeUploadSource, *corev1beta1.VolumeUploadSourceList]
}

// newVolumeUploadSources returns a VolumeUploadSources
func newVolumeUploadSources(c *CdiV1beta1Client, namespace string) *volumeUploadSources {
	return &volumeUploadSources{
		gentype.NewClientWithList[*corev1beta1.VolumeUploadSource, *corev1beta1.VolumeUploadSourceList](
			"volumeuploadsources",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *corev1beta1.VolumeUploadSource { return &corev1beta1.VolumeUploadSource{} },
			func() *corev1beta1.VolumeUploadSourceList { return &corev1beta1.VolumeUploadSourceList{} },
		),
	}
}
